<?php
// Debug script for medicine selection issue
// Place this file in the root directory and access it via browser

// Include CodeIgniter bootstrap
require_once('index.php');

// Get CodeIgniter instance
$CI =& get_instance();

// Check if user is logged in
if (!$CI->ion_auth->logged_in()) {
    echo "User not logged in. Please login first.<br>";
    exit;
}

// Get hospital_id from session
$hospital_id = $CI->session->userdata('hospital_id');
echo "Hospital ID from session: " . $hospital_id . "<br>";

// Check if hospital_id is valid
if (empty($hospital_id) || $hospital_id == 'superadmin') {
    echo "Invalid hospital_id. Current user might be superadmin or session issue.<br>";
    exit;
}

// Load medicine model
$CI->load->model('medicine_model');

// Check total medicines in database
$CI->db->select('COUNT(*) as total');
$CI->db->from('medicine');
$total_medicines = $CI->db->get()->row()->total;
echo "Total medicines in database: " . $total_medicines . "<br>";

// Check medicines for current hospital
$CI->db->select('COUNT(*) as total');
$CI->db->from('medicine');
$CI->db->where('hospital_id', $hospital_id);
$hospital_medicines = $CI->db->get()->row()->total;
echo "Medicines for current hospital: " . $hospital_medicines . "<br>";

// Check medicines with stock > 0
$CI->db->select('COUNT(*) as total');
$CI->db->from('medicine');
$CI->db->where('hospital_id', $hospital_id);
$CI->db->where('quantity >', 0);
$available_medicines = $CI->db->get()->row()->total;
echo "Medicines with stock > 0: " . $available_medicines . "<br>";

// Get sample medicines
$CI->db->select('id, name, quantity, s_price, company');
$CI->db->from('medicine');
$CI->db->where('hospital_id', $hospital_id);
$CI->db->where('quantity >', 0);
$CI->db->limit(5);
$sample_medicines = $CI->db->get()->result();

echo "<br>Sample medicines:<br>";
foreach ($sample_medicines as $medicine) {
    echo "ID: " . $medicine->id . ", Name: " . $medicine->name . ", Stock: " . $medicine->quantity . ", Price: " . $medicine->s_price . "<br>";
}

// Test the actual method
echo "<br>Testing getMedicineInfoForPharmacySale method:<br>";
$response = $CI->medicine_model->getMedicineInfoForPharmacySale('');
echo "Response count: " . count($response) . "<br>";
echo "Response data: " . json_encode($response) . "<br>";

// Test with search term
echo "<br>Testing with search term 'a':<br>";
$response_search = $CI->medicine_model->getMedicineInfoForPharmacySale('a');
echo "Response count: " . count($response_search) . "<br>";
echo "Response data: " . json_encode($response_search) . "<br>";

// Check AJAX endpoint directly
echo "<br>Testing AJAX endpoint:<br>";
$CI->load->library('input');
$CI->input->set_post('searchTerm', '');
$CI->load->controller('medicine');
$CI->medicine->getMedicineForPharmacyMedicine();
?>
