<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Supplier_model extends CI_model {

    function __construct() {
        parent::__construct();
        $this->load->database();
    }

    function insertSupplier($data) {
        $this->db->insert('supplier', $data);
    }

    function getSupplier() {
        $query = $this->db->get('supplier');
        return $query->result();
    }

    function searchSupplier($search) {
        $this->db->like('name', $search);
        $query = $this->db->get('supplier');
        return $query;
    }

    function getSupplierById($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('supplier');
        return $query->row();
    }

    function updateSupplier($id, $data) {
        $this->db->where('id', $id);
        $this->db->update('supplier', $data);
    }

    function delete($id) {
        $this->db->where('id', $id);
        $this->db->delete('supplier');
    }

    function deletePurchaseAndPaymaneBySupplierId($id) {
        $this->db->where('supplier', $id);
        $query = $this->db->get('purchase')->result();

        foreach ($query as $purchase) {
            $this->db->where('purchase_id', $purchase->id);
            $this->db->delete('payment');
        }

        $this->db->where('supplier', $id);
        $this->db->delete('purchase');
    }

    function updateIonUser($username, $email, $password, $ion_user_id) {
        $uptade_ion_user = array(
            'username' => $username,
            'email' => $email,
            'password' => $password
        );
        $this->db->where('id', $ion_user_id);
        $this->db->update('users', $uptade_ion_user);
    }

    function getSupplierjason() {
        $this->db->order_by('id', 'desc');
        $query = $this->db->get('supplier');
        return $query->result();
    }

    function getSupplierBySearch($search) {
        $this->db->order_by('id', 'desc');
        $this->db->like('id', $search);
       $this->db->or_like('name', $search);
        $this->db->or_like('phone', $search);
        $this->db->or_like('address', $search);
        $this->db->or_like('company', $search);
        $query = $this->db->get('supplier');
        return $query->result();
    }

    function getSupplierByLimit($limit, $start) {
        $this->db->order_by('id', 'desc');
        $this->db->limit($limit, $start);
        $query = $this->db->get('supplier');
        return $query->result();
    }

    function getSupplierByLimitBySearch($limit, $start, $search) {

        $this->db->like('id', $search);

        $this->db->order_by('id', 'desc');

        $this->db->or_like('name', $search);
        $this->db->or_like('phone', $search);
        $this->db->or_like('address', $search);
        $this->db->or_like('company', $search);

        $this->db->limit($limit, $start);
        $query = $this->db->get('supplier');
        return $query->result();
    }
    function getPaymentByBatchId($batchid) {
        $this->db->where('batchid', $batchid);
        $query = $this->db->get('supplierpayment')->result();
        return $query;
    }

    function getSupplierPaymentBySupplierId($id) {
        $this->db->where('supplierid', $id);
        $query = $this->db->get('supplierpayment');
        return $query->result();
    }

    function insertSupplierPayment($data) {
        $this->db->insert('supplierpayment', $data);
    }

    function getSupplierPayment($supplierid, $batchid) {
        $this->db->order_by('id', 'desc');
        $this->db->where('supplierid', $supplierid);
        $this->db->where('batchid', $batchid);
        $query = $this->db->get('supplierpayment');
        return $query->result();
    }

    function getSupplierPaymentBySearch($supplierid, $batchid, $search) {
        $this->db->order_by('id', 'desc');
        $this->db->where('supplierid', $supplierid);
        $this->db->where('batchid', $batchid);
        $this->db->or_like('adddate', $search);
        $this->db->or_like('paidby', $search);
        $query = $this->db->get('supplierpayment');
        return $query->result();
    }

    function getSupplierPaymentByLimit($supplierid, $batchid, $limit, $start) {
        $this->db->order_by('id', 'desc');
        $this->db->where('supplierid', $supplierid);
        $this->db->where('batchid', $batchid);
        $this->db->limit($limit, $start);
        $query = $this->db->get('supplierpayment');
        return $query->result();
    }

    function getSupplierPaymentByLimitBySearch($supplierid, $batchid, $limit, $start, $search) {

        $this->db->like('id', $search);

        $this->db->order_by('id', 'desc');

        $this->db->where('supplierid', $supplierid);
        $this->db->where('batchid', $batchid);
        $this->db->or_like('adddate', $search);
        $this->db->or_like('paidby', $search);

        $this->db->limit($limit, $start);
        $query = $this->db->get('supplierpayment');
        return $query->result();
    }

    function getSupplierPaymentById($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('supplierpayment');
        return $query->row();
    }

    function updateSupplierPayment($data, $id) {
        $this->db->where('id', $id);
        $this->db->update('supplierpayment', $data);
    }
      function deleteSupplierPayment($id) {
        $this->db->where('id', $id);
        $this->db->delete('supplierpayment');
    }
    function deleteSupplierPaymentall($id) {
        $this->db->where('id', $id);
        $result=$this->db->delete('supplierpayment');
        return $result;
    }
    

}
