<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Settings_model extends CI_model {

    function __construct() {
        parent::__construct();
        $this->load->database();
    }

    function getSettings() {
        $query = $this->db->get('settings');
        return $query->row();
    }

    function updateSettings($id, $data) {
        $this->db->where('id', $id);
        $this->db->update('settings', $data);
    }

    function getStaffSelect2($search) {
        if (!empty($search)) {
            $this->db->order_by('id', 'desc');
            $this->db->like('name', $search);
            $this->db->or_like('phone', $search);
            $query = $this->db->get('accountant');
        } else {
            $this->db->order_by('id', 'desc');
            $this->db->limit(2);
            $query = $this->db->get('accountant');
        }
        return $query->result();
    }

    function getSupplierSelect2($search) {
        if (!empty($search)) {
            $this->db->order_by('id', 'desc');
            $this->db->like('name', $search);
            $this->db->or_like('phone', $search);
            $this->db->or_like('company', $search);
            $query = $this->db->get('supplier');
        } else {
            $this->db->order_by('id', 'desc');
            $this->db->limit(2);
            $query = $this->db->get('supplier');
        }
        return $query->result();
    }

    function getMedicineCategoryName($searchTerm) {
        if (!empty($searchTerm)) {
            $this->db->select('*');
            $this->db->where("category like '%" . $searchTerm . "%' ");
            $fetched_records = $this->db->get('medicine_category');
            $query = $fetched_records->result();
        } else {
            $this->db->select('*');
            $this->db->limit(10);
            $fetched_records = $this->db->get('medicine_category');
            $query = $fetched_records->result();
        }

        return $query;
    }

    function getMedicineName($category, $searchTerm) {
        if (!empty($searchTerm)) {
            $this->db->select('*');
            $this->db->where("name like '%" . $searchTerm . "%' ");
            $this->db->where('categoryid', $category);
            $fetched_records = $this->db->get('medicine');
            $query = $fetched_records->result();
        } else {
            $this->db->select('*');
            $this->db->where('categoryid', $category);
            $this->db->limit(10);
            $fetched_records = $this->db->get('medicine');
            $query = $fetched_records->result();
        }

        return $query;
    }
     function getExpenseCategorylistselect2($searchTerm) {
        if (!empty($searchTerm)) {
            $this->db->select('*');
            $this->db->where("category like '%" . $searchTerm . "%' ");
         
            $fetched_records = $this->db->get('expense_category');
            $query = $fetched_records->result();
        } else {
            $this->db->select('*');
         
            $this->db->limit(10);
            $fetched_records = $this->db->get('expense_category');
            $query = $fetched_records->result();
        }

        return $query;
    }
     function getBanklistselect2($searchTerm) {
        if (!empty($searchTerm)) {
            $this->db->select('*');
            $this->db->where("name like '%" . $searchTerm . "%' ");
         
            $fetched_records = $this->db->get('bank');
            $query = $fetched_records->result();
        } else {
            $this->db->select('*');
         
            $this->db->limit(10);
            $fetched_records = $this->db->get('bank');
            $query = $fetched_records->result();
        }

        return $query;
    }
}
