<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Purchase_model extends CI_model {

    function __construct() {
        parent::__construct();
        $this->load->database();
    }

    function insertPurchase($data) {
        $query = $this->db->insert('batchmedicine', $data);
        return $query;
    }

    function getPurchase() {
        $query = $this->db->get('batchmedicine');
        return $query->result();
    }

    function searchOrder($search) {
        $this->db->like('name', $search);
        $query = $this->db->get('orderphar');
        return $query;
    }

    function getPurchaseBymedId($id) {
        $this->db->where('mednameid', $id);
        $this->db->where('e_datetimestamp >', time());
        $this->db->order_by('e_datetimestamp', "asc");
        $query = $this->db->get('batchmedicine');
        return $query->result();
    }

    function getPurchaseBymedIdupdate($id) {
        $this->db->where('mednameid', $id);
        $this->db->where('e_datetimestamp >', time());
        //$this->db->where('quantity >',0);
        $this->db->order_by('e_datetimestamp', "asc");
        $query = $this->db->get('batchmedicine');
        return $query->result();
    }

    function getPurchaseById($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('batchmedicine');
        return $query->row();
    }

    function getPurchaseByMed($id) {
        $this->db->where('mednameid', $id);
        $query = $this->db->get('batchmedicine');
        return $query->result();
    }

    function updatePurchase($id, $data) {
        $this->db->where('id', $id);
        $query = $this->db->update('batchmedicine', $data);
        return $query;
    }

    function delete($id) {
        $this->db->where('id', $id);
        $this->db->delete('batchmedicine');
    }

    function deletePurchaseAndPaymaneByOrderId($id) {
        $this->db->where('orderphar', $id);
        $query = $this->db->get('purchase')->result();

        foreach ($query as $purchase) {
            $this->db->where('purchase_id', $purchase->id);
            $this->db->delete('payment');
        }

        $this->db->where('order', $id);
        $this->db->delete('purchase');
    }

    function updateIonUser($username, $email, $password, $ion_user_id) {
        $uptade_ion_user = array(
            'username' => $username,
            'email' => $email,
            'password' => $password
        );
        $this->db->where('id', $ion_user_id);
        $this->db->update('users', $uptade_ion_user);
    }

    function getPurchasejason() {
        $this->db->order_by('id', 'desc');
        $query = $this->db->get('batchmedicine');
        return $query->result();
    }

    function getPurchaseBySearch($search) {
        $this->db->order_by('id', 'desc');
        $this->db->like('medname', $search);
        $this->db->or_like('batchid', $search);
        $this->db->or_like('medcategory', $search);
        $this->db->or_like('e_date', $search);
        $this->db->or_like('suppliername', $search);
        $query = $this->db->get('batchmedicine');
        return $query->result();
    }

    function getPurchaseByLimit($limit, $start) {
        $this->db->order_by('id', 'desc');
        $this->db->limit($limit, $start);
        $query = $this->db->get('batchmedicine');
        return $query->result();
    }

    function getPurchaseByLimitBySearch($limit, $start, $search) {

        $this->db->like('id', $search);

        $this->db->order_by('id', 'desc');

        $this->db->or_like('medname', $search);
        $this->db->or_like('batchid', $search);
        $this->db->or_like('medcategory', $search);
        $this->db->or_like('e_date', $search);
        $this->db->or_like('suppliername', $search);

        $this->db->limit($limit, $start);
        $query = $this->db->get('batchmedicine');
        return $query->result();
    }

    //new details buton modal in medicine controller
    function getBatchjason($medname) {
        $this->db->order_by('e_datetimestamp', 'ASC');
        $this->db->where('mednameid', $medname);
        $this->db->where('e_datetimestamp >', time());
        $query = $this->db->get('batchmedicine');
        return $query->result();
    }

    function getBatchMedBysearch($medname, $search) {
        $this->db->order_by('e_datetimestamp', 'ASC');
        $this->db->like('batchid', $search);
        //  $this->db->or_like('medcategory', $search);
        $this->db->or_like('e_date', $search);
        // $this->db->or_like('suppliername', $search);
        $this->db->where('mednameid', $medname);
        $this->db->where('e_datetimestamp >', time());
        $query = $this->db->get('batchmedicine');
        return $query->result();
    }

    function getBatchMedByLimitBySearch($limit, $start, $search, $medname) {
        //   $this->db->like('id', $search);

        $this->db->order_by('e_datetimestamp', 'ASC ');

        // $this->db->like('medname', $search);
        $this->db->like('batchid', $search);
        // $this->db->or_like('medcategory', $search);
        $this->db->or_like('e_date', $search);
        // $this->db->or_like('suppliername', $search);
        $this->db->where('e_datetimestamp >', time());
        $this->db->where('mednameid', $medname);
        $this->db->limit($limit, $start);
        $query = $this->db->get('batchmedicine');
        return $query->result();
    }

    function getBatchMedicineByLimit($medname, $limit, $start) {
        $this->db->order_by('e_datetimestamp', 'ASC ');
        $this->db->where('e_datetimestamp >', time());
        $this->db->where('mednameid', $medname);
        $this->db->limit($limit, $start);
        $query = $this->db->get('batchmedicine');
        return $query->result();
    }

    function getBatchexjason($medname) {
        $this->db->order_by('e_datetimestamp', 'ASC');
        $this->db->where('mednameid', $medname);
        //   $this->db->where('e_datetimestamp >', time());
        $query = $this->db->get('batchmedicine');
        return $query->result();
    }

    function getBatchMedexBysearch($medname, $search) {
        $this->db->order_by('e_datetimestamp', 'ASC');
        $this->db->like('batchid', $search);
        //  $this->db->or_like('medcategory', $search);
        $this->db->or_like('e_date', $search);
        // $this->db->or_like('suppliername', $search);
        $this->db->where('mednameid', $medname);
        // $this->db->where('e_datetimestamp >', time());
        $query = $this->db->get('batchmedicine');
        return $query->result();
    }

    function getBatchMedexByLimitBySearch($limit, $start, $search, $medname) {
        //   $this->db->like('id', $search);

        $this->db->order_by('e_datetimestamp', 'ASC ');

        // $this->db->like('medname', $search);
        $this->db->like('batchid', $search);
        // $this->db->or_like('medcategory', $search);
        $this->db->or_like('e_date', $search);
        // $this->db->or_like('suppliername', $search);
        //  $this->db->where('e_datetimestamp >', time());
        $this->db->where('mednameid', $medname);
        $this->db->limit($limit, $start);
        $query = $this->db->get('batchmedicine');
        return $query->result();
    }

    function getBatchMedicineexByLimit($medname, $limit, $start) {
        $this->db->order_by('e_datetimestamp', 'ASC ');
        // $this->db->where('e_datetimestamp >', time());
        $this->db->where('mednameid', $medname);
        $this->db->limit($limit, $start);
        $query = $this->db->get('batchmedicine');
        return $query->result();
    }

    function getBatchBySupplierId($id) {
        $this->db->where('supplierid', $id);
        $query = $this->db->get('batchmedicine');
        return $query->result();
    }

    function getPurchaseBySupplier($supplier) {
        $this->db->where('supplierid', $supplier);
        $this->db->order_by('id', 'desc');
        $query = $this->db->get('batchmedicine');
        return $query->result();
    }

    function getPurchaseBySearchBySupplier($supplier, $search) {
        $this->db->order_by('id', 'desc');
        $this->db->where('supplierid', $supplier);
        $this->db->like('medname', $search);
        $this->db->or_like('batchid', $search);
        $this->db->or_like('add_date', $search);
        $query = $this->db->get('batchmedicine');
        return $query->result();
    }

    function getPurchaseByLimitBySupplier($supplier, $limit, $start) {
        $this->db->order_by('id', 'desc');
        $this->db->where('supplierid', $supplier);
        $this->db->limit($limit, $start);
        $query = $this->db->get('batchmedicine');
        return $query->result();
    }

    function getPurchaseByLimitBySearchBySupplier($supplier, $limit, $start, $search) {

        $this->db->like('id', $search);

        $this->db->order_by('id', 'desc');
        $this->db->where('supplierid', $supplier);
        $this->db->like('medname', $search);
        $this->db->or_like('batchid', $search);
        $this->db->or_like('add_date', $search);
   

        $this->db->limit($limit, $start);
        $query = $this->db->get('batchmedicine');
        return $query->result();
    }
    
    
    
    function getPurchaseByDate($date_from, $date_to) {
        $this->db->select('*');
        $this->db->from('batchmedicine');
        $this->db->where('add_datetimestamp >=', $date_from);
        $this->db->where('add_datetimestamp <=', $date_to);
        $query = $this->db->get();
        return $query->result();
    }
    

}
