<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Purchase extends MX_Controller {

    function __construct() {
        parent::__construct();

        $this->load->model('order/order_model');
        $this->load->model('supplier/supplier_model');
        $this->load->model('medicine/medicine_model');
        $this->load->model('email/email_model');
        $this->load->model('purchase_model');
        if (!$this->ion_auth->in_group(array('admin', 'Accountant'))) {
            redirect('home/permission');
        }
    }

    public function index() {

        $data['medcat'] = $this->medicine_model->getMedicineCategory();
        $data['medcats'] = $this->medicine_model->getMedicineCategory();
        $data['supplier'] = $this->supplier_model->getSupplier();
        $data['supplierupdate'] = $this->supplier_model->getSupplier();
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('purchase', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function batch() {

        $data['medcat'] = $this->medicine_model->getMedicineCategory();
        $data['medcats'] = $this->medicine_model->getMedicineCategory();
        $data['supplier'] = $this->supplier_model->getSupplier();
        $data['supplierupdate'] = $this->supplier_model->getSupplier();
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('batch', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function addNewViewpurchase() {
        //  echo 'hi';
        $data['medcat'] = $this->medicine_model->getMedicineCategory();
        $data['supplier'] = $this->supplier_model->getSupplier();
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('add_new', $data);
        $this->load->view('home/footer', $data); // just the header file*/
    }

    public function catgoryMed() {

        $catidseparate = $this->input->get('id');
        $med_id = $this->input->get('med_id');
        $catmed_ids = explode(',', $med_id);




        $data = array();
        $data2 = array();

        $i = 0;


        $catname = $this->medicine_model->getMedicineCategoryById($catidseparate);

        $medicineNames = $this->medicine_model->getMedicineByCategory($catname->category);
        foreach ($medicineNames as $medicineName) {
            $data[] = '<option data-cat_name="' . $medicineName->category . '" data-iid="' . $medicineName->company . '" data-id="' . $medicineName->name . '"data-cat_id="' . $medicineName->id . '"value="' . $medicineName->id . '">' . $medicineName->name . '</option>';
        }

        array_unique($data);
        $data1['user1'] = implode(' ', $data);
        echo json_encode($data1);
    }

    public function addNew() {

        if (!$this->ion_auth->in_group(array('admin', 'Accountant'))) {
            redirect('home/permission');
        }


        $id = $this->input->post('id');
        $medcat = $this->input->post('medcat');
        $medname = $this->input->post('med');
        $batchno = $this->input->post('batchno');
        $p_price = $this->input->post('p_price');
        $quantity = $this->input->post('quantity');
        $supplier = $this->input->post('supplier1');

        $e_date = $this->input->post('e_date');



        if (!empty($e_date)) {
            $e_date = strtotime($e_date);
        }



        if ((empty($id))) {
            $add_date = date('m/d/y');
        } else {
            $add_date = $this->db->get_where('batchmedicine', array('id' => $id))->row()->add_date;
        }

        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        // Validating batch no Field
        $this->form_validation->set_rules('batchno', 'batchno', 'trim|required|min_length[1]|max_length[100]|xss_clean');
        // Validating Category Field
        $this->form_validation->set_rules('medcat', 'Medicine Category', 'trim|required|min_length[1]|max_length[100]|xss_clean');
        // Validating Purchase Price Field
        $this->form_validation->set_rules('p_price', 'Purchase Price', 'trim|required|min_length[1]|max_length[100]|xss_clean');
        // Validating Store Box Field
        // Validating Selling Price Field
        // Validating Quantity Field
        $this->form_validation->set_rules('quantity', 'Quantity', 'trim|required|min_length[1]|max_length[100]|xss_clean');
        // Validating Generic Name Field
        $this->form_validation->set_rules('supplier1', 'Supplier Name', 'trim|required|max_length[100]|xss_clean');
        // Validating Company Name Field
        // Validating Effects Field
        // Validating Expire Date Field
        $this->form_validation->set_rules('e_date', 'Expire Date', 'trim|required|min_length[1]|max_length[100]|xss_clean');


        if ($this->form_validation->run() == FALSE) {
            $data = array();
            $data['medcat'] = $this->medicine_model->getMedicineCategory();
            $data['supplier'] = $this->supplier_model->getSupplier();
            $data['settings'] = $this->settings_model->getSettings();
            $this->load->view('home/dashboard', $data); // just the header file
            $this->load->view('add_new', $data);
            $this->load->view('home/footer'); // just the header file
        } else {
            $data = array();
            $medcatname = $this->medicine_model->getMedicineCategoryById($medcat)->category;
            $medicinename = $this->medicine_model->getMedicineById($medname)->name;
            $medicinenamecompany = $this->medicine_model->getMedicineById($medname)->company;
            $suppliername = $this->supplier_model->getSupplierById($supplier);
            $data = array('batchid' => $batchno,
                'medcategory' => $medcatname,
                'medcategoryid' => $medcat,
                'medname' => $medicinename,
                'mednameid' => $medname,
                'p_price' => $p_price,
                'quantity' => $quantity,
                'e_datetimestamp' => $e_date,
                'e_date' => date('d-m-y', $e_date),
                'add_date' => $add_date,
                'add_datetimestamp' => strtotime($add_date),
                'suppliername' => $suppliername->name,
                'supplierid' => $supplier,
                'company' => $medicinenamecompany,
            );
            if (empty($id)) {
                $query = $this->purchase_model->insertPurchase($data);
               

                $this->session->set_flashdata('feedback', 'Added');
            } else {
              
                $query = $this->purchase_model->updatePurchase($id, $data);
                
                $this->session->set_flashdata('feedback', 'Updated');
            }
            $redirid = $this->input->post('redirid');
            if (!empty($redirid)) {
                redirect('supplier/purchaseDetailsBySupplier?id=' . $supplier);
            } else {
                redirect('purchase');
            }
        }
    }

    public function getPurchase() {
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];
        if ($limit == -1) {
            if (!empty($search)) {
                $data['purchases'] = $this->purchase_model->getPurchaseBysearch($search); //done
            } else {
                $data['purchases'] = $this->purchase_model->getPurchasejason(); //done
            }
        } else {
            if (!empty($search)) {
                $data['purchases'] = $this->purchase_model->getPurchaseByLimitBySearch($limit, $start, $search); //done
            } else {
                $data['purchases'] = $this->purchase_model->getPurchaseByLimit($limit, $start); //done
            }
        }
        foreach ($data['purchases'] as $purchase) {

            if ($this->ion_auth->in_group(array('admin'))) {
                $options1 = ' <a type="button" class="btn btn-xs editbutton" title="' . lang('edit') . '" data-toggle = "modal" data-id="' . $purchase->id . '"><i class="fa fa-edit"> </i> ' . lang('edit') . '</a>';
            }

            if ($this->ion_auth->in_group(array('admin'))) {
                $options5 = '<a class="btn btn-xs delete_button" title="' . lang('delete') . '" href="purchase/delete?id=' . $purchase->id . '" onclick="return confirm(\'Are you sure you want to delete this item?\');"><i class="fa fa-trash"></i> ' . lang('delete') . '</a>';
            }

            $stock = $this->medicine_model->getMedicineById($purchase->mednameid)->box;
            if ($this->ion_auth->in_group(array('admin'))) {
                $currencytype = $this->settings_model->getSettings()->currency;
                $info[] = array(
                    date('d-m-Y', $purchase->add_datetimestamp),
                    $purchase->medname,
                    $purchase->medcategory,
                    $purchase->batchid,
                    $stock,
                    $currencytype . '' . number_format($purchase->p_price, 2, '.', ','),
                    $purchase->quantity,
                    $purchase->suppliername,
                    $purchase->e_date,
                    $options1 . ' ' . $options5,
                );
            }
            if ($this->ion_auth->in_group(array('Accountant'))) {
                $currencytype = $this->settings_model->getSettings()->currency;
                $info[] = array(
                    date('d-m-Y', $purchase->add_datetimestamp),
                    $purchase->batchid,
                    $purchase->medcategory,
                    $purchase->medname,
                    $stock,
                    $currencytype . '' . number_format($purchase->p_price, 2, '.', ','),
                    $purchase->quantity,
                    $purchase->suppliername,
                    $purchase->e_date,
                );
            }
        }

        if (!empty($data['purchases'])) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => $this->db->get('batchmedicine')->num_rows(),
                "recordsFiltered" => $this->db->get('batchmedicine')->num_rows(),
                "data" => $info
            );
        } else {
            $output = array(
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }

    public function getBatch() {
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];
        if ($limit == -1) {
            if (!empty($search)) {
                $data['purchases'] = $this->purchase_model->getPurchaseBysearch($search); //done
            } else {
                $data['purchases'] = $this->purchase_model->getPurchasejason(); //done
            }
        } else {
            if (!empty($search)) {
                $data['purchases'] = $this->purchase_model->getPurchaseByLimitBySearch($limit, $start, $search); //done
            } else {
                $data['purchases'] = $this->purchase_model->getPurchaseByLimit($limit, $start); //done
            }
        }
        foreach ($data['purchases'] as $purchase) {

            if ($this->ion_auth->in_group(array('admin'))) {
                $options1 = ' <a type="button" class="btn btn-xs editbutton" title="' . lang('edit') . '" data-toggle = "modal" data-id="' . $purchase->id . '"><i class="fa fa-edit"> </i> ' . lang('edit') . '</a>';
            }

            if ($this->ion_auth->in_group(array('admin'))) {
                $options5 = '<a class="btn btn-xs delete_button" title="' . lang('delete') . '" href="purchase/delete?id=' . $purchase->id . '" onclick="return confirm(\'Are you sure you want to delete this item?\');"><i class="fa fa-trash"></i> ' . lang('delete') . '</a>';
            }

            $stock = $this->medicine_model->getMedicineById($purchase->mednameid)->box;
            if ($this->ion_auth->in_group(array('admin'))) {
                $currencytype = $this->settings_model->getSettings()->currency;
                $info[] = array(
                    $purchase->batchid,
                    $purchase->medname,
                    $purchase->e_date,
                );
            }
            if ($this->ion_auth->in_group(array('Accountant'))) {
                $currencytype = $this->settings_model->getSettings()->currency;
                $info[] = array(
                    $purchase->batchid,
                    $purchase->medname,
                    $purchase->e_date,
                );
            }
        }

        if (!empty($data['purchases'])) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => $this->db->get('batchmedicine')->num_rows(),
                "recordsFiltered" => $this->db->get('batchmedicine')->num_rows(),
                "data" => $info
            );
        } else {
            $output = array(
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }
    
    
    
    
    function dailyPurchase() {
        $data = array();
        $year = $this->input->get('year');
        $month = $this->input->get('month');

        if (empty($year)) {
            $year = date('Y');
        }
        if (empty($month)) {
            $month = date('m');
        }

        $first_minute = mktime(0, 0, 0, $month, 1, $year);
        $last_minute = mktime(23, 59, 59, $month, date("t", $first_minute), $year);

        $purchases = $this->purchase_model->getPurchaseByDate($first_minute, $last_minute);
        $all_purchases = array();
        foreach ($purchases as $purchase) {
            $date = date('D d-m-y', $purchase->add_datetimestamp);
            if (array_key_exists($date, $all_purchases)) {
                $all_purchases[$date] = $all_purchases[$date] + ($purchase->p_price * $purchase->quantity);
            } else {
                $all_purchases[$date] = $purchase->p_price * $purchase->quantity;
            }
        }
        
        $data['year'] = $year;
        $data['month'] = $month;
        $data['first_minute'] = $first_minute;
        $data['last_minute'] = $last_minute;
        $data['all_purchases'] = $all_purchases;
        
        
        
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('daily_purchase', $data);
        $this->load->view('home/footer'); // just the header file
    }
    
    
     function monthlyPurchase() {
        $data = array();
        $year = $this->input->get('year');

        if (empty($year)) {
            $year = date('Y');
        }


        $first_minute = mktime(0, 0, 0, 1, 1, $year);
        $last_minute = mktime(23, 59, 59, 12, 31, $year);

        $purchases = $this->purchase_model->getPurchaseByDate($first_minute, $last_minute);
        $all_purchases = array();
        foreach ($purchases as $purchase) {
            $month = date('m-Y', $purchase->add_datetimestamp);
            if (array_key_exists($month, $all_purchases)) {
                $all_purchases[$month] = $all_purchases[$month] + ($purchase->p_price * $purchase->quantity);
            } else {
                $all_purchases[$month] = $purchase->p_price * $purchase->quantity;
            }
        }
        
        $data['year'] = $year;
        $data['first_minute'] = $first_minute;
        $data['last_minute'] = $last_minute;
        $data['all_purchases'] = $all_purchases;
        
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('monthly_purchase', $data);
        $this->load->view('home/footer'); // just the header file
    }
    
    

    function editPurchaseByJason() {
        $id = $this->input->get('id');
        $data['purchase'] = $this->purchase_model->getPurchaseById($id);
        $data['supplier'] = $this->supplier_model->getSupplierById($data['purchase']->supplierid);
        echo json_encode($data);
    }

    function delete() {
        $data = array();
        $id = $this->input->get('id');
      
        $this->purchase_model->delete($id);

      

        $this->session->set_flashdata('feedback', 'Deleted');
        redirect('purchase');
    }

  
}

/* End of file order.php */
/* Location: ./application/modules/order/controllers/order.php */
