<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');
use Omnipay\Omnipay;
class Pgateway extends MX_Controller {

    
    public function __construct() {
        parent::__construct();
        $this->load->model('pgateway_model');
        require APPPATH . 'third_party/stripe/stripe-php/init.php';
        $this->load->module('payu');
    }

    function index() {
        $data['gateways'] = $this->pgateway_model->getGateway();
        $data['settings'] = $this->db->get('settings')->row();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('settings', $data);
        $this->load->view('home/footer'); // just the header file
    }

    function gateway() {
        $id = $this->input->get('id');
        $data['gateway'] = $this->pgateway_model->getGatewayById($id);
        $data['settings'] = $this->db->get('settings')->row();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('pgateway', $data);
        $this->load->view('home/footer'); // just the header file
    }

    function addNewSetting() {
        $id = $this->input->post('id');
        $this->load->library('form_validation');
        if ($id == 1) {
            $username = $this->input->post('username');
            $password = $this->input->post('password');
            $signature = $this->input->post('signature');
            $this->form_validation->set_rules('username', 'API Username', 'required|trim|xss_clean');
            $this->form_validation->set_rules('password', 'API Password', 'required|trim|xss_clean');
            $this->form_validation->set_rules('signature', 'API Signature', 'required|trim|xss_clean');
            $data = array(
                'username' => $username,
                'password' => $password,
                'signature' => $signature
            );
        }
        if ($id == 2) {
            $secret = $this->input->post('secret');
            $publish = $this->input->post('publish');
            $this->form_validation->set_rules('secret', 'API Secret Key', 'required|trim|xss_clean');
            $this->form_validation->set_rules('publish', 'API Publish Key', 'required|trim|xss_clean');
            $data = array(
                'secret_key' => $secret,
                'publish_key' => $publish
            );
        }
        if ($id == 3) {
            $merchant = $this->input->post('merchant');
            $salt = $this->input->post('salt');
            $this->form_validation->set_rules('merchant', 'API Merchant Key', 'required|trim|xss_clean');
            $this->form_validation->set_rules('salt', 'API Salt', 'required|trim|xss_clean');
            $data = array(
                'merchant_key' => $merchant,
                'salt' => $salt
            );
        }
        if ($this->form_validation->run() == false) {
            $this->session->set_flashdata('feedback', 'All Fields are required');
            redirect('pgateway/gateway?id=' . $id);
        } else {
            $this->pgateway_model->updateSetting($id, $data);
            $this->session->set_flashdata('feedback', 'Updated!');
            redirect('pgateway/gateway?id=' . $id);
        }
    }

    function gatewaySetting() {
        $gateway = $this->input->post('gateway');
        $this->form_validation->set_rules('gateway', 'Gateway', 'required|trim|xss_clean');
        $data = array(
            'payment_gateway' => $gateway
        );

        if ($this->form_validation->run() == false) {
            $this->session->set_flashdata('feedback', 'Select One!');
            redirect('pgateway');
        } else {
            $this->pgateway_model->updateGateway($data);
            redirect('pgateway');
        }
    }

    function doPaymentStripe($data) {
        
        $stripe = $this->db->get_where('pgateway', array('id =' => 2))->row();
        \Stripe\Stripe::setApiKey($stripe->secret_key);
        $charge = \Stripe\Charge::create(array(
                "amount" => $data['amount']*100,
                "currency" => $data['currency'],
                "source" => $data['source'],
                "metadata" => ["order_id" => $data['batchid']]
        ));
        return $charge;
    }
    
    function doPaymentPayPal($data) {
        $paypal = $this->db->get_where('pgateway', array('gateway =' => 'PayPal'))->row();
        $gateway = Omnipay::create('PayPal_Pro');
        $gateway->setUsername($paypal->username);
        $gateway->setPassword($paypal->password);
        $gateway->setSignature($paypal->signature);
        $gateway->setTestMode(true);
        $arr_expiry = explode("/", $data['expire']);
        $name = explode(' ', $data['client']);
        $formData = array(
            'firstName' => $name[0],
            'lastName' => $name[1],
            'number' => $data['card'],
            'expiryMonth' => trim($arr_expiry[0]),
            'expiryYear' => trim($arr_expiry[1]),
            'cvv' => $data['cvv']
        );
        try {
            // Send purchase request
            $response = $gateway->purchase(
                            [
                                'amount' => $data['amount'],
                                'currency' => 'USD',
                                'card' => $formData
                            ]
                    )->send();

            // Process response
            if ($response->isSuccessful()) {
                // Payment was successful
                return $response->getTransactionReference();
            } else {
                // Payment failed
                return $response->getMessage();
            }
        } catch (Exception $e) {
            return $e->getMessage();
        }
    }

}
