<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Payu extends MX_Controller {

    function __construct() {
        parent::__construct();
        $this->load->library('upload');
        $this->load->model('client/client_model');
        $this->load->model('finance/finance_model');
        $this->load->model('pgateway/pgateway_model');
        if (!$this->ion_auth->logged_in()) {
            redirect('auth/login', 'refresh');
        }
        if (!$this->ion_auth->in_group(array('admin', 'Accountant', 'Employee', 'Supplier'))) {
            redirect('home/permission');
        }
    }

    public function index() {
        redirect('home');
    }

    public function check() {

        $amount = $this->input->get('deposited_amount');
        $invoice_id = $this->input->get('payment_id');


        $payment = $this->finance_model->getPaymentById($invoice_id);

        $client_info = $this->customer_model->getCustomerById($payment->customer);

        $product_info = $invoice_id;
        $customer_name = $client_info->name;
        $customer_emial = $client_info->email;
        $customer_mobile = $client_info->phone;
        $customer_address = $client_info->address;



        //payumoney details

        $payumoney = $this->pgateway_model->getGatewayById('3');

        if ($payumoney->status == 'live') {
            $action = "https://secure.payu.in";
        } else {
            $action = "https://sandboxsecure.payu.in";
        }

        $MERCHANT_KEY = $payumoney->merchant_key; //change  merchant with yours
        $SALT = $payumoney->salt;  //change salt with yours 

        $txnid = substr(hash('sha256', mt_rand() . microtime()), 0, 20);
        //optional udf values 
        $udf1 = '';
        $udf2 = '';
        $udf3 = '';
        $udf4 = '';
        $udf5 = '';

        $hashstring = $MERCHANT_KEY . '|' . $txnid . '|' . $amount . '|' . $product_info . '|' . $customer_name . '|' . $customer_emial . '|' . $udf1 . '|' . $udf2 . '|' . $udf3 . '|' . $udf4 . '|' . $udf5 . '||||||' . $SALT;
        $hash = strtolower(hash('sha512', $hashstring));

        $success = base_url() . 'payu/Status';
        $fail = base_url() . 'payu/Status';
        $cancel = base_url() . 'payu/Status';


        $data = array(
            'mkey' => $MERCHANT_KEY,
            'tid' => $txnid,
            'hash' => $hash,
            'amount' => $amount,
            'name' => $customer_name,
            'productinfo' => $product_info,
            'mailid' => $customer_emial,
            'phoneno' => $customer_mobile,
            'address' => $customer_address,
            'action' => $action, //for live change action  https://secure.payu.in  
            'sucess' => $success,
            'failure' => $fail,
            'cancel' => $cancel
        );



        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('confirmation', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function check1($received, $data2) {

        $amount = $received;
        // $invoice_id = $this->input->get('payment_id');
        //   $payment = $this->finance_model->getPaymentById($invoice_id);
        //  $client_info = $this->customer_model->getCustomerById($payment->customer);
        if($data2['client'] != 'Walking Customer') {
            $client = $this->client_model->getClientById($data2['client']);
            $product_info = $data2['insertid'].'-'.$received;
            $customer_id = $client->id;
            $customer_name = $client->name;
            $customer_emial = $client->email;
            $customer_mobile = $client->phone;
            $customer_address = $client->address;
        } else {
            $product_info = $data2['insertid'].'-'.$received;
            $customer_id = $data2['insertid'];
            $customer_name = 'Walking Customer';
            $customer_emial = 'Walking Customer';
            $customer_mobile = '';
            $customer_address = 'Walking Customer';
        }
        
        $amountactual = $data2['amount'];
        //payumoney details


        $payumoney = $this->pgateway_model->getGatewayById('3');

        if ($payumoney->type == 'live') {
            $action = "https://secure.payu.in";
        } else {
            $action = "https://sandboxsecure.payu.in";
        }


        $MERCHANT_KEY = $payumoney->merchant_key; //change  merchant with yours
        $SALT = $payumoney->salt;  //change salt with yours 

        $txnid = substr(hash('sha256', mt_rand() . microtime()), 0, 20);
        //optional udf values 
        $udf1 = '';
        $udf2 = '';
        $udf3 = '';
        $udf4 = '';
        $udf5 = '';

        $hashstring = $MERCHANT_KEY . '|' . $txnid . '|' . $amount . '|' . $product_info . '|' . $customer_name . '|' . $customer_emial . '|' . $udf1 . '|' . $udf2 . '|' . $udf3 . '|' . $udf4 . '|' . $udf5 . '||||||' . $SALT;
        $hash = strtolower(hash('sha512', $hashstring));

        $success = base_url() . 'payu/Status/index1';
        $fail = base_url() . 'payu/Status/index1';
        $cancel = base_url() . 'payu/Status/index1';


        $data = array(
            'mkey' => $MERCHANT_KEY,
            'tid' => $txnid,
            'hash' => $hash,
            'amount' => $amount,
            'name' => $customer_name,
            'productinfo' => $product_info,
            'mailid' => $customer_emial,
            'phoneno' => $customer_mobile,
            'address' => $customer_address,
            'action' => $action, //for live change action  https://secure.payu.in  
            'sucess' => $success,
            'failure' => $fail,
            'cancel' => $cancel,
            'customerid' => $customer_id,
            'discount' =>  $data2['discount'],
            'amountactual' => $amountactual
        );


        $data1['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data1); // just the header file
        $this->load->view('confirmation', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function check2($received, $data2) {

         $amount = $received;
        // $invoice_id = $this->input->get('payment_id');
        //   $payment = $this->finance_model->getPaymentById($invoice_id);
        //  $client_info = $this->customer_model->getCustomerById($payment->customer);
   
            $client = $this->client_model->getClientById($data2['client']);
            $product_info = $data2['paymentid'].'-'.$received;
            $customer_id = $client->id;
            $customer_name = $client->name;
            $customer_emial = $client->email;
            $customer_mobile = $client->phone;
            $customer_address = $client->address;
    
        
        $amountactual = $data2['amount'];
        //payumoney details


        $payumoney = $this->pgateway_model->getGatewayById('3');

        if ($payumoney->type == 'live') {
            $action = "https://secure.payu.in";
        } else {
            $action = "https://sandboxsecure.payu.in";
        }


        $MERCHANT_KEY = $payumoney->merchant_key; //change  merchant with yours
        $SALT = $payumoney->salt;  //change salt with yours 

        $txnid = substr(hash('sha256', mt_rand() . microtime()), 0, 20);
        //optional udf values 
        $udf1 = '';
        $udf2 = '';
        $udf3 = '';
        $udf4 = '';
        $udf5 = '';

        $hashstring = $MERCHANT_KEY . '|' . $txnid . '|' . $amount . '|' . $product_info . '|' . $customer_name . '|' . $customer_emial . '|' . $udf1 . '|' . $udf2 . '|' . $udf3 . '|' . $udf4 . '|' . $udf5 . '||||||' . $SALT;
        $hash = strtolower(hash('sha512', $hashstring));

        $success = base_url() . 'payu/Status/index2';
        $fail = base_url() . 'payu/Status/index2';
        $cancel = base_url() . 'payu/Status/index2';


        $data = array(
            'mkey' => $MERCHANT_KEY,
            'tid' => $txnid,
            'hash' => $hash,
            'amount' => $amount,
            'name' => $customer_name,
            'productinfo' => $product_info,
            'mailid' => $customer_emial,
            'phoneno' => $customer_mobile,
            'address' => $customer_address,
            'action' => $action, //for live change action  https://secure.payu.in  
            'sucess' => $success,
            'failure' => $fail,
            'cancel' => $cancel,
            'customerid' => $customer_id,
          
            'amountactual' => $amountactual
        );


        $data1['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data1); // just the header file
        $this->load->view('confirmation', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function help() {
        $this->load->view('help');
    }

}
