<!DOCTYPE html>
<html lang="en" <?php if ($this->db->get('settings')->row()->language == 'arabic') { ?> dir="rtl" <?php } ?>> 
    <head>
        <base href="<?php echo base_url(); ?>">
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta name="description" content="">
        <meta name="author" content="Rizvi">
        <meta name="keyword" content="Php, Hospital, Clinic, Management, Software, Php, CodeIgniter, Hms, Accounting">
        <link rel="shortcut icon" href="uploads/favicon.png">
        <title><?php echo $this->router->fetch_class(); ?> | Pharmacy Management System</title>
        <!-- Bootstrap core CSS -->
        <link href="common/css/bootstrap.min.css" rel="stylesheet">
        <link href="common/css/bootstrap-reset.css" rel="stylesheet">
        <!--external css-->
        <link href="common/fontawesome/css/all.css" rel="stylesheet" />
        <link href="common/assets/DataTables/datatables.min.css" rel="stylesheet" />
        <!--  <link href="common/assets/jquery-ui/jquery-ui-1.10.1.custom.css" rel="stylesheet" />
        <!-- Custom styles for this template -->
        <link href="common/css/style.css" rel="stylesheet">
        <link href="common/css/style-responsive.css" rel="stylesheet" />
        <link rel="stylesheet" href="common/assets/bootstrap-datepicker/css/datepicker.css" />
        <link rel="stylesheet" type="text/css" href="common/assets/bootstrap-daterangepicker/daterangepicker-bs3.css" />
        <link rel="stylesheet" type="text/css" href="common/assets/bootstrap-datetimepicker/css/datetimepicker.css" />
        <link rel="stylesheet" type="text/css" href="common/assets/jquery-multi-select/css/multi-select.css" />
        <link href="common/css/invoice-print.css" rel="stylesheet" media="print">
        <link href="common/assets/fullcalendar/fullcalendar.css" rel="stylesheet">
        <link rel="stylesheet" type="text/css" href="common/assets/bootstrap-fileupload/bootstrap-fileupload.css" />
        <link rel="stylesheet" type="text/css" href="common/assets/bootstrap-wysihtml5/bootstrap-wysihtml5.css" />
        <link rel="stylesheet" type="text/css" href="common/assets/select2/css/select2.min.css"/>


        <!-- HTML5 shim and Respond.js IE8 support of HTML5 tooltipss and media queries -->
        <!--[if lt IE 9]>
          <script src="js/html5shiv.js"></script>
          <script src="js/respond.min.js"></script>
        <![endif]-->


        <?php if ($this->language == 'arabic') { ?>
            <style>

                #main-content {
                    margin-right: 211px;
                    margin-left: 0px; 
                }

                body {
                    background: #f1f1f1;

                }

                ul.sidebar-menu li a i {
                    margin-left: 5px;
                }



            </style>

        <?php } ?>



    </head>  
    <?php $settings_title = explode(' ', $this->db->get('settings')->row()->title) ?>
    <body>
        <section id="container" class="">
            <!--header start-->
            <header class="header white-bg">
                <div class="sidebar-toggle-box">
                    <div data-original-title="Toggle Navigation" data-placement="right" class="fa fa-dedent fa-bars"></div>
                </div>
                <!--logo start-->
                <a href="" class="logo"><strong><?php echo $settings_title[0]; ?><span><?php
                            if (!empty($settings_title[1])) {
                                echo $settings_title[1];
                            }
                            ?></strong></span></a>
                <!--logo end-->
                <div class="nav notify-row" id="top_menu">
                    <!--  notification start -->
                    <ul class="nav top-menu">

                        <!-- Payment notification start-->
                        <?php if ($this->ion_auth->in_group(array('admin', 'Accountant'))) { ?> 
                            <li id="header_inbox_bar" class="dropdown">
                                <a data-toggle="dropdown" class="dropdown-toggle" href="#">
                                    <i class="fas fa-money-bill-alt"></i>
                                    <span class="badge bg-important"> 
                                        <?php
                                        $query = $this->db->get('payment');
                                        $query = $query->result();
                                        foreach ($query as $payment) {
                                            $payment_date = date('y/m/d', $payment->date);
                                            if ($payment_date == date('y/m/d')) {
                                                $payment_number[] = '1';
                                            }
                                        }
                                        if (!empty($payment_number)) {
                                            echo $payment_number = array_sum($payment_number);
                                        } else {
                                            $payment_number = 0;
                                            echo $payment_number;
                                        }
                                        ?>        
                                    </span>
                                </a>

                                <ul class="dropdown-menu extended inbox">
                                    <div class="notify-arrow notify-arrow-red"></div>
                                    <li>
                                        <p class="red"> <?php
                                            echo $payment_number . ' ';
                                            if ($payment_number <= 1) {
                                                echo lang('payment_today');
                                            } else {
                                                echo lang('payments_today');
                                            }
                                            ?></p>
                                    </li>
                                    <li>
                                        <a href="finance/payment"><p class="green"> <?php echo lang('see_all_payments'); ?> </p></a>
                                    </li>
                                </ul>
                            </li>
                        <?php } ?>
                        <!-- payment notification end -->  
                        <!-- patient notification start-->

                        <!-- patient notification end -->  

                        <!-- medicine notification start-->
                        <?php if ($this->ion_auth->in_group(array('admin', 'Pharmacist', 'Doctor', 'Accountant'))) { ?> 
                            <li id="header_notification_bar" class="dropdown">
                                <a data-toggle="dropdown" class="dropdown-toggle" href="#">
                                    <i class="fa fa-medkit"></i>
                                    <span class="badge bg-success">                          
                                        <?php
                                        $this->db->where('add_date', date('m/d/y'));
                                        $query = $this->db->get('medicine');
                                        $query = $query->result();
                                        foreach ($query as $medicine) {
                                            $medicine_number[] = '1';
                                        }
                                        if (!empty($medicine_number)) {
                                            echo $medicine_number = array_sum($medicine_number);
                                        } else {
                                            $medicine_number = 0;
                                            echo $medicine_number;
                                        }
                                        ?>
                                    </span>
                                </a>
                                <ul class="dropdown-menu extended notification">
                                    <div class="notify-arrow notify-arrow-yellow"></div>
                                    <li>
                                        <p class="yellow"><?php
                                            echo $medicine_number . ' ';
                                            if ($medicine_number <= 1) {
                                                echo lang('medicine_registered_today');
                                            } else {
                                                echo lang('medicines_registered_today');
                                            }
                                            ?> </p>
                                    </li>
                                    <li>
                                    <li <a href="medicine"><p class="green"> <?php echo lang('see_all_medicines'); ?> </p></a>
                                    </li>
                                </ul>


                            </li>
                            <li id="header_notification_bar" class="dropdown">
                                <a data-toggle="dropdown" class="dropdown-toggle" href="#">
                                    <?php
                                    ?>
                                    <i class="fas fa-bell"></i>
                                    <span class="badge bg-important"><?php
                                        $medicinelist = $this->db->get('batchmedicine')->result();
                                        $count = 0;
                                        $todayDate = date('d-m-y');
                                        $today = strtotime($todayDate);
                                        $settings1123 = $this->db->get('settings')->result();
                                        if (empty($settings1123->expire)) {
                                            $settings112312 = 5;
                                        } else {
                                            $settings112312 = $settings1123->expire;
                                        }
                                        foreach ($medicinelist as $medicinelists) {

                                            if (($medicinelists->e_datetimestamp - (time() + $settings112312 * 24 * 60 * 60)) <= 0 && $medicinelists->e_datetimestamp >= time()) {
                                                $count = $count + 1;
                                            }
                                        }
                                        echo $count;
                                        ?></span>
                                </a>
                                <ul class="dropdown-menu extended notification">
                                    <div class="notify-arrow notify-arrow-yellow"></div>

                                    <?php
                                    $medicinelist1 = $this->db->get('batchmedicine')->result();
                                    $todayDate1 = date('d-m-y');
                                    $today1 = strtotime($todayDate1);
                                    foreach ($medicinelist1 as $medicinelists1) {
                                        $settings11231 = $this->db->get('settings')->result();
                                        if (empty($settings11231->expire)) {
                                            $settings112311 = 5;
                                        } else {
                                            $settings112311 = $settings11231->expire;
                                        }
                                        if (($medicinelists1->e_datetimestamp - (time() + $settings112311 * 24 * 60 * 60)) <= 0 && $medicinelists1->e_datetimestamp >= time()) {
                                            ?>
                                            <li>
                                                <p class = "yellow">
                                                    <?php echo $medicinelists1->medname . ' - ' . lang('batch') . ' (' . $medicinelists1->batchid . ') ' . lang('will_expire_on') . ' ' . date('d-m-y', $medicinelists1->e_datetimestamp); ?>
                                                </p>
                                            </li>
                                            <?php
                                        }
                                    }
                                    ?>
                                    <li> <a href="medicine/medicineExpireAlert"><p class="green"> <?php echo lang('expire_alert_list'); ?> </p>

                                        </a>

                                    </li>
                                </ul>
                            </li>
                            <li id="header_notification_bar" class="dropdown">
                                <a data-toggle="dropdown" class="dropdown-toggle" href="#">
                                    <?php ?>
                                    <i class="fas fa-exclamation-triangle"></i>
                                    <span class="badge badge-warning"><?php
                                        $medicinelist2 = $this->db->get('batchmedicine')->result();
                                        $count2 = 0;
                                        $todayDate2 = date('d-m-y');
                                        $today2 = strtotime($todayDate2);
                                        foreach ($medicinelist2 as $medicinelists2) {

                                            if ($medicinelists2->e_datetimestamp < time() && date("m", strtotime($medicinelists2->e_date)) == date("m", time())) {
                                                $count2 = $count2 + 1;
                                            }
                                        }
                                        echo $count2;
                                        ?></span>
                                </a>
                                <ul class="dropdown-menu extended notification">
                                    <div class="notify-arrow notify-arrow-yellow"></div>

                                    <?php
                                    $medicinelist3 = $this->db->get('batchmedicine')->result();
                                    $todayDate3 = date('d-m-y');
                                    $today3 = strtotime($todayDate3);
                                    foreach ($medicinelist3 as $medicinelists3) {

                                        if ($medicinelists3->e_datetimestamp < time() && date("m", strtotime($medicinelists3->e_date)) == date("m", time())) {
                                            ?>
                                            <li>
                                                <p class = "red">
                                                    <?php echo $medicinelists3->medname . ' - ' . lang('batch') . ' (' . $medicinelists3->batchid . ')  ' . lang('has_expired_on') . ' ' . date('d-m-y', $medicinelists3->e_datetimestamp); ?>
                                                </p>
                                            </li>
                                            <?php
                                        }
                                    }
                                    ?>
                                    <li> <a href="medicine/medicineExpire"><p class="green"> <?php echo lang('expire_list'); ?> </p></a>
                                    </li>
                                </ul>
                            </li>
                        <?php } ?> 
                        <!-- medicine notification end -->  

                    </ul>
                </div>
                <div class="top-nav ">

                    <?php
                    $message = $this->session->flashdata('quantity_check');
                    if (!empty($message)) {
                        ?>
                        <div class="quantity_check pull-left"> <?php echo $message; ?></div>
                    <?php }
                    ?> 
                    <?php
                    $message = $this->session->flashdata('feedback');
                    if (!empty($message)) {
                        ?>
                        <div class="flashmessage pull-left"><i class="fa fa-check"></i> <?php echo $message; ?></div>
                    <?php } ?> 
                    <ul class="nav pull-right top-menu">
                        <!-- user login dropdown start-->
                        <li class="dropdown">
                            <a data-toggle="dropdown" class="dropdown-toggle" href="#">
                                <img alt="" src="uploads/favicon.png" width="21" height="23">
                                <span class="username"><?php echo $this->ion_auth->user()->row()->username; ?></span>
                                <b class="caret"></b>
                            </a>
                            <ul class="dropdown-menu extended logout">
                                <div class="log-arrow-up"></div>
                                <?php if (!$this->ion_auth->in_group('admin')) { ?> 
                                    <li><a href=""><i class="fa fa-dashboard"></i>  <?php echo lang('dashboard'); ?> </a></li>
                                <?php } ?>
                                <li><a href="profile"><i class=" fa fa-suitcase"></i> <?php echo lang('profile'); ?> </a></li>
                                <?php if ($this->ion_auth->in_group('admin')) { ?> 
                                    <li><a href="settings"><i class="fa fa-cog"></i>  <?php echo lang('settings'); ?> </a></li>
                                <?php } ?>

                                <li><a><i class="fa fa-user"></i> <?php echo $this->ion_auth->get_users_groups()->row()->name ?></a></li>
                                <li><a href="auth/logout"><i class="fa fa-key"></i>  <?php echo lang('log_out'); ?> </a></li>
                            </ul>
                        </li>
                        <!-- user login dropdown end -->
                    </ul>
                </div>
            </header>
            <!--header end-->
            <!--sidebar start-->

            <!--sidebar start-->
            <aside>
                <div id="sidebar"  class="nav-collapse ">
                    <!-- sidebar menu start-->
                    <ul class="sidebar-menu" id="nav-accordion">
                        <li>
                            <a href="home">
                                <i class="fas fa-home"></i>
                                <span> <?php echo lang('dashboard'); ?> </span>
                            </a>
                        </li>

                        <li>
                            <a href="finance/addPaymentView">
                                <i class="fa fa-money-bill-alt"></i>
                                <span> <?php echo lang('pos'); ?> </span>
                            </a>
                        </li>


                        <?php if ($this->ion_auth->in_group(array('admin'))) { ?>
                            <li class="sub-menu">
                                <a href="javascript:;" >
                                    <i class="fa  fa-medkit"></i>
                                    <span> <?php echo lang('medicine'); ?> </span>
                                </a>
                                <ul class="sub">
                                    <li><a  href="medicine"><i class="fa fa-medkit"></i> <?php echo lang('medicine_list'); ?> </a></li>
                                    <li><a  href="purchase/batch"><i class="fa fa-plus-circle"></i> <?php echo lang('batch_list'); ?> </a></li>
                                    <li><a  href="medicine/addMedicineView"><i class="fa fa-plus-circle"></i> <?php echo lang('add_medicine'); ?> </a></li>
                                    <li><a  href="medicine/medicineCategory"><i class="fa fa-edit"></i> <?php echo lang('medicine_category'); ?> </a></li>
                                    <li><a  href="medicine/addCategoryView"><i class="fa fa-plus-circle"></i> <?php echo lang('add_medicine_category'); ?> </a></li>


                                </ul>
                            </li>
                        <?php } ?>


                        <?php if ($this->ion_auth->in_group(array('admin'))) { ?>
                            <li class="sub-menu">
                                <a href="javascript:;" >
                                    <i class="fa fa-shopping-cart"></i>
                                    <span><?php echo lang('purchase'); ?></span>
                                </a>
                                <ul class="sub">
                                    <li><a href="purchase"><i class="fa fa-shopping-cart"></i><?php echo lang('purchase'); ?></a></li>
                                    <li><a href="purchase/addNewViewpurchase"><i class="fa fa-plus-circle"></i><?php echo lang('add_purchase'); ?></a></li>
                                    <li><a href="order"><i class="fa fa-plus"></i><?php echo lang('order'); ?></a></li>
                                </ul>
                            </li>

                        <?php } ?>
                        <?php if ($this->ion_auth->in_group(array('Accountant'))) { ?>
                            <li>
                                <a href="purchase" >
                                    <i class="fa fa-shopping-cart"></i>
                                    <span>  <?php echo lang('purchase'); ?>  </span>
                                </a>
                            </li>
                        <?php } ?>


                        <?php if ($this->ion_auth->in_group(array('admin'))) { ?>
                            <li class="sub-menu">
                                <a href="javascript:;" >
                                    <i class="fa fa-money-check"></i>
                                    <span><?php echo lang('all_sales'); ?></span>
                                </a>
                                <ul class="sub">
                                    <li><a href="finance/payment"><i class="fa fa-money-check"></i><?php echo lang('all_sales'); ?></a></li>
                                    <li><a href="finance/paid"><i class="fa fa-money-check"></i><?php echo lang('paid'); ?></a></li>
                                    <li><a href="finance/partial"><i class="fa fa-money-check"></i><?php echo lang('partially_paid'); ?></a></li>
                                    <li><a href="finance/unpaid"><i class="fa fa-money-check"></i><?php echo lang('unpaid'); ?></a></li>
                                </ul>
                            </li>

                        <?php } ?>



                        <?php if ($this->ion_auth->in_group('Accountant')) { ?>
                            <li class="sub-menu">
                                <a href="javascript:;" >
                                    <i class="fas fa-funnel-dollar"></i>
                                    <span> <?php echo lang('expenses'); ?> </span>
                                </a>
                                <ul class="sub">
                                    <li>
                                        <a href="finance/expense" >
                                            <i class="fa fa-money-bill-alt"></i>
                                            <span>  <?php echo lang('expense'); ?>  </span>
                                        </a>
                                    </li>
                                    <li>
                                        <a href="finance/addExpenseView" >
                                            <i class="fa fa-plus-circle"></i>
                                            <span>  <?php echo lang('add_expense'); ?>  </span>
                                        </a>
                                    </li>
                                </ul>
                            </li>
                        <?php } ?>



                        <?php if ($this->ion_auth->in_group('admin')) { ?>
                            <li class="sub-menu">
                                <a href="javascript:;" >
                                    <i class="fas fa-money-check"></i>
                                    <span> <?php echo lang('expenses'); ?> </span>
                                </a>
                                <ul class="sub">

                                    <li><a  href="finance/expense"><i class="fa fa-money-bill-alt"></i> <?php echo lang('expense'); ?> </a></li>
                                    <li><a  href="finance/addExpenseView"><i class="fa fa-plus-circle"></i> <?php echo lang('add_expense'); ?> </a></li>
                                    <li><a  href="finance/expenseCategory"><i class="fa fa-edit"></i> <?php echo lang('expense'); ?>   <?php echo lang('category'); ?>  </a></li>

                                </ul>
                            </li> 
                        <?php } ?>






                        <?php if ($this->ion_auth->in_group('admin')) { ?>
                            <li class="sub-menu">
                                <a href="javascript:;" >
                                    <i class="fas fa-university"></i>
                                    <span> <?php echo lang('accounts'); ?> </span>
                                </a>
                                <ul class="sub">

                                    <li><a  href="bank"><i class="fa fa-money-bill-alt"></i> <?php echo lang('bank'); ?> </a></li>
                                    <li><a  href="bank/transaction"><i class="fa fa-plus-circle"></i> <?php echo lang('transaction'); ?> </a></li>
                                   <!--    <li><a  href="finance/expenseCategory"><i class="fa fa-edit"></i> <?php echo lang('expense'); ?>   <?php echo lang('category'); ?>  </a></li>-->

                                </ul>
                            </li> 
                        <?php } ?>




                        <?php if ($this->ion_auth->in_group('admin')) { ?>
                            <li class="sub-menu">
                                <a href="javascript:;" >
                                    <i class="fas fa-briefcase"></i>
                                    <span> <?php echo lang('reports'); ?> </span>
                                </a>
                                <ul class="sub">

                                    <li><a  href="finance/financialReport"><i class="fa fa-money-bill-alt"></i> <?php echo lang('financial_report'); ?> </a></li>
                                    <li><a  href="finance/daily"><i class="fa fa-chart-bar"></i> <?php echo lang('daily_sales'); ?> </a></li>
                                    <li><a  href="finance/dailyExpense"><i class="fa fa-chart-area"></i> <?php echo lang('daily_expense'); ?> </a></li>
                                    <li><a  href="purchase/dailyPurchase"><i class="fa fa-shopping-cart"></i> <?php echo lang('daily_purchase'); ?> </a></li>

                                    <li><a  href="finance/monthly"><i class="fa fa-chart-bar"></i> <?php echo lang('monthly_sales'); ?> </a></li>
                                    <li><a  href="finance/monthlyExpense"><i class="fa fa-chart-area"></i> <?php echo lang('monthly_expense'); ?> </a></li>
                                    <li><a  href="purchase/monthlyPurchase"><i class="fa fa-shopping-cart"></i> <?php echo lang('monthly_purchase'); ?> </a></li>
                                    <li><a  href="medicine/stockReport"><i class="fa fa-shopping-cart"></i> <?php echo lang('stock_report'); ?> </a></li>

                                </ul>
                            </li> 
                        <?php } ?>

                        <?php if ($this->ion_auth->in_group(array('admin', 'Accountant'))) { ?>
                            <li class="sub-menu">
                                <a href="javascript:;" >
                                    <i class="fa fa-exclamation-triangle"></i>
                                    <span> <?php echo lang('alert'); ?> </span>
                                </a>
                                <ul class="sub">
                                    <li>
                                        <a href="medicine/medicineStockAlert">
                                            <i class="fa fa-medkit"></i>
                                            <span> <?php echo lang('stock_alert'); ?> </span>
                                        </a>
                                    </li>
                                    <li>
                                        <a href="medicine/medicineExpireAlert">
                                            <i class="fa fa-medkit"></i>
                                            <span> <?php echo lang('expire_alert'); ?> </span>
                                        </a>
                                    </li>
                                    <li>
                                        <a href="medicine/medicineExpire">
                                            <i class="fa fa-medkit"></i>
                                            <span> <?php echo lang('expire_medcine'); ?> </span>
                                        </a>
                                    </li>
                                </ul>
                            </li>
                        <?php } ?>



                        <?php if ($this->ion_auth->in_group(array('admin', 'Accountant'))) { ?>

                            <li class="sub-menu">
                                <a href="javascript:;" >
                                    <i class="fa fa-user"></i>
                                    <span><?php echo lang('client'); ?></span>
                                </a>
                                <ul class="sub">
                                    <li><a  href="client"><i class="fa fa-user"></i><?php echo lang('client'); ?> <?php echo lang('database'); ?></a></li>                                                                                                                                                                                                                                                                                                                                                <!--   <li><a  href="employee/employeeCategory"><i class="fa fa-list-alt"></i><?php //echo lang('employee');                                                             ?> <?php //echo lang('category');                                                             ?></a></li>-->
                                    <li><a href="client/addNewView"><i class="fa fa-arrow-right"></i><?php echo lang('add'); ?> <?php echo lang('client'); ?></a></li>
                                </ul>
                            </li>
                        <?php } ?>





                        <?php if ($this->ion_auth->in_group(array('admin', 'Accountant'))) { ?>
                            <li class="sub-menu">
                                <a href="javascript:;" >
                                    <i class="fa fa-user"></i>
                                    <span><?php echo lang('supplier'); ?></span>
                                </a>
                                <ul class="sub">
                                    <li><a  href="supplier"><i class="fa fa-user"></i><?php echo lang('supplier'); ?> <?php echo lang('database'); ?></a></li>

                                    <?php if ($this->ion_auth->in_group(array('admin', 'Accountant'))) { ?>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         <!--   <li><a  href="employee/employeeCategory"><i class="fa fa-list-alt"></i><?php //echo lang('employee');                                                             ?> <?php //echo lang('category');                                                             ?></a></li>-->
                                        <li><a href="supplier/addNewView"><i class="fa fa-arrow-right"></i><?php echo lang('add'); ?> <?php echo lang('supplier'); ?></a></li>
                                    <?php } ?>
                                </ul>
                            </li>

                        <?php } ?>

                        <?php if ($this->ion_auth->in_group('admin')) { ?>
                            <li>
                                <a href="accountant">
                                    <i class="fa fa-user"></i>
                                    <span> <?php echo lang('staff'); ?> </span>
                                </a>
                            </li>
                        <?php } ?>


                        <?php if ($this->ion_auth->in_group(array('admin'))) { ?>
                            <li class="sub-menu">
                                <a href="javascript:;" >
                                    <i class="fa fa-mail-bulk"></i>
                                    <span><?php echo lang('email'); ?></span>
                                </a>
                                <ul class="sub">
                                    <li><a  href="email/emailTemplate"><i class="fa fa-robot"></i>&nbsp;<?php echo lang('autoemailtemplate'); ?></a></li>
                                    <li><a  href="email/sendView"><i class="fa fa-location-arrow"></i>&nbsp;<?php echo lang('new'); ?></a></li>
                                    <li><a  href="email/sent"><i class="fa fa-list-alt"></i>&nbsp;<?php echo lang('sent'); ?></a></li>
                                    <?php if ($this->ion_auth->in_group(array('admin'))) { ?>
                                        <li><a  href="email/settings"><i class="fas fa-cog"></i>&nbsp;<?php echo lang('settings'); ?></a></li>
                                    <?php } ?>
                                </ul>
                            </li> 
                        <?php } ?>

                        <?php if ($this->ion_auth->in_group(array('admin'))) { ?>
                            <li class="sub-menu">
                                <a href="javascript:;" >
                                    <i class="fa fa-sms"></i>
                                    <span><?php echo lang('sms'); ?></span>
                                </a>
                                <ul class="sub">
                                    <li><a  href="sms/smsTemplate"><i class="fa fa-robot"></i>&nbsp;<?php echo lang('autosmstemplate'); ?></a></li>
                                    <li><a  href="sms/sendView"><i class="fa fa-location-arrow"></i>&nbsp;<?php echo lang('write_message'); ?></a></li>
                                    <li><a  href="sms/sent"><i class="fa fa-list-alt"></i>&nbsp;<?php echo lang('sent_messages'); ?></a></li>
                                    <?php if ($this->ion_auth->in_group(array('admin'))) { ?>
                                        <li><a  href="sms"><i class="fas fa-cog"></i>&nbsp;<?php echo lang('sms_settings'); ?></a></li>
                                    <?php } ?>
                                </ul>
                            </li> 
                        <?php } ?>
 
                        <!--
                        <?php if ($this->ion_auth->in_group('admin')) { ?>
                                                        <li class="sub-menu">
                                                            <a href="javascript:;" >
                                                                <i class="fa fa-globe"></i>
                                                                <span><?php echo lang('website'); ?></span>
                                                            </a>
                                                            <ul class="sub">
                                                                <li><a href="frontend" target="_blank" ><i class="fas fa-cog"></i>&nbsp;<?php echo lang('visit_site'); ?></a></li>
                                                                <li><a href="frontend/settings"><i class="fas fa-cog"></i>&nbsp;<?php echo lang('website_settings'); ?></a></li>
                                                                <li><a href="slide"><i class="fa fa-wrench"></i>&nbsp;<?php echo lang('slides'); ?></a></li>
                                                                <li><a href="service"><i class="fa fa-smile"></i>&nbsp;<?php echo lang('services'); ?></a></li>
                                                                <li><a href="featured"><i class="fa fa-smile"></i>&nbsp;<?php echo lang('featured_products'); ?></a></li>
                                                            </ul>
                                                        </li>
                        <?php } ?>
                        -->
                        


                        <?php if ($this->ion_auth->in_group('admin')) { ?>


                            <li> <li class="sub-menu">
                                <a href="javascript:;" >
                                    <i class="fa fa-cogs"></i>
                                    <span><?php echo lang('settings'); ?></span>
                                </a>
                                <ul class="sub">
                                    <li><a href="settings"><i class="fas fa-cog"></i>&nbsp;<?php echo lang('system_settings'); ?></a></li>
                                    <li><a href="pgateway"><i class="fa fa-credit-card"></i>&nbsp;<?php echo lang('pgateway_setting'); ?></a></li>
                                    <li><a href="settings/language"><i class="fa fa-language"></i>&nbsp;<?php echo lang('language'); ?></a></li>
                                    <li><a href="settings/backups"><i class="fa fa-database"></i>&nbsp;<?php echo lang('backup_database'); ?></a></li>
                                </ul>
                            </li>

                        <?php } ?>
                        <li>
                            <a href="profile" >
                                <i class="fa fa-user"></i>
                                <span>  <?php echo lang('profile'); ?>  </span>
                            </a>
                        </li>

                        <!--multi level menu start-->

                        <!--multi level menu end-->

                    </ul>
                    <!-- sidebar menu end-->
                </div>
            </aside>
            <!--sidebar end-->  




