<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Finance extends MX_Controller {

    function __construct() {
        parent::__construct();

        $this->load->model('finance_model');
        $this->load->model('client/client_model');
        $this->load->model('medicine/medicine_model');
        $this->load->model('purchase/purchase_model');
        $this->load->model('home/home_model');
        $this->load->module('sms');
        $this->load->module('pgateway');
        $this->load->model('pgateway/pgateway_model');
        $this->load->module('payu');
        $data['settings'] = $this->settings_model->getSettings();
        if (!$this->ion_auth->in_group(array('admin', 'Accountant'))) {
            redirect('home/permission');
        }
    }

    public function index() {
        redirect('finance/financial_report');
    }

    public function payment() {
        if (!$this->ion_auth->logged_in()) {
            redirect('auth/login', 'refresh');
        }
        $page_number = $this->input->get('page_number');
        if (empty($page_number)) {
            $page_number = 0;
        }
        $data['settings'] = $this->settings_model->getSettings();
        $data['payments'] = $this->finance_model->getPayment();


        $data['pagee_number'] = $page_number;
        $data['p_n'] = '0';

        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('payment', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function paid() {
        if (!$this->ion_auth->logged_in()) {
            redirect('auth/login', 'refresh');
        }
        $page_number = $this->input->get('page_number');
        if (empty($page_number)) {
            $page_number = 0;
        }
        $data['settings'] = $this->settings_model->getSettings();
        $data['payments'] = $this->finance_model->getPayment();
// $data['payments'] = $this->finance_model->getPaymentByPageNumber($page_number);


        $data['pagee_number'] = $page_number;
        $data['p_n'] = '0';

        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('paid', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function partial() {
        if (!$this->ion_auth->logged_in()) {
            redirect('auth/login', 'refresh');
        }
        $page_number = $this->input->get('page_number');
        if (empty($page_number)) {
            $page_number = 0;
        }
        $data['settings'] = $this->settings_model->getSettings();
        $data['payments'] = $this->finance_model->getPayment();
// $data['payments'] = $this->finance_model->getPaymentByPageNumber($page_number);


        $data['pagee_number'] = $page_number;
        $data['p_n'] = '0';

        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('partial', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function unpaid() {
        if (!$this->ion_auth->logged_in()) {
            redirect('auth/login', 'refresh');
        }
        $page_number = $this->input->get('page_number');
        if (empty($page_number)) {
            $page_number = 0;
        }
        $data['settings'] = $this->settings_model->getSettings();
        $data['payments'] = $this->finance_model->getPayment();
// $data['payments'] = $this->finance_model->getPaymentByPageNumber($page_number);


        $data['pagee_number'] = $page_number;
        $data['p_n'] = '0';

        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('unpaid', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function paymentByPageNumber() {
        $page_number = $this->input->get('page_number');
        if (empty($page_number)) {
            $page_number = 0;
        }
        $data['payments'] = $this->finance_model->getPaymentByPageNumber($page_number);
        $data['pagee_number'] = $page_number;
        $data['p_n'] = $page_number;
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('payment', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function addPaymentView() {
        $data = array();
        $data['clientid'] = $this->input->get('id');
        if (!empty($data['clientid'])) {
            $data['clientinfo'] = $this->client_model->getClientById($data['clientid']);
        }
        $data['clients'] = $this->client_model->getClient();
        $data['discount_type'] = $this->finance_model->getDiscountType();
        $data['settings'] = $this->settings_model->getSettings();
        $data['medicines'] = $this->medicine_model->getMedicine();
        $data['purchases'] = $this->purchase_model->getPurchase();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('add_payment_view', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function batchRemainingQuantity($batchid) {
        $quantitytrack = array();
        $j = 0;
        $paymentlist2 = $this->finance_model->getPayment();
        //  print_r($paymentlist2);
        foreach ($paymentlist2 as $paymentlist3) {
            $category_name9 = $paymentlist3->category_name;
            $category_name10 = explode(',', $category_name9);
            foreach ($category_name10 as $category_name11) {
                $category_name12 = explode('*', $category_name11);
                if ($category_name12[0] == $batchid) {
                    $quantitytrack[$j] = $category_name12[2];
                    $j = $j + 1;
                }
            }
            $j = $j + 1;
        }
        $totalbatch = array_sum($quantitytrack);
        return $totalbatch;
    }

    public function getMedcinebatch() {
        $medidseparates1 = $this->input->get('id');
        $catidseparates = explode(',', $medidseparates1);
        $med_id = $this->input->get('med_id');
        $catmed_ids = explode(',', $med_id);
        $qtitys = $this->input->get('qtity');
        $qtity = explode(',', $qtitys);
        $payments = $this->input->get('payment');
        $payment = explode(',', $payments);

        if (!empty($payment[0])) {
            $paymentlist = $this->finance_model->getPaymentById($payment[0]);
            $category_name = $paymentlist->category_name;
            $category_name1 = explode(',', $category_name);
            foreach ($category_name1 as $category_name2) {
                $category_name3 = explode('*', $category_name2);
                //  array_push($quantitypurchase, $category_name3[2]);
                if (in_array($category_name3[0], $catmed_ids)) {
                    $count = 0;
                } else {
                    array_push($catmed_ids, $category_name3[0]);
                }
            }
        }

        $data = array();
        $data2 = array();
        $option67 = '';
        $i = 0;
        $j = 0;
        foreach ($catidseparates as $catidseparate) {

            if (empty($payment[0])) {
                $catnames = $this->purchase_model->getPurchaseBymedIdupdate($catidseparate);
                $catnames1 = $this->purchase_model->getPurchaseBymedIdupdate($catidseparate);
            } else {
                $catnames = $this->purchase_model->getPurchaseBymedId($catidseparate);
                $catnames1 = $this->purchase_model->getPurchaseBymedId($catidseparate);
            }
            $total = array();
            $k = 0;
            foreach ($catnames1 as $catname) {
                $total[$k] = $catname->quantity;
                $k = $k + 1;
            }
            $totalpurchase = array_sum($total);
            //  echo $totalpurchase;
            foreach ($catnames as $medicineName) {
                $quantitypurchase = '';
                if (in_array($medicineName->id, $catmed_ids)) {
                    if (empty($payment[0])) {
                        $totalbatch = $this->batchRemainingQuantity($medicineName->id);
                        if (($medicineName->quantity - $totalbatch) > 0) {
                            $medicineselling = $this->medicine_model->getMedicineById($catidseparate)->s_price;
                            $data[] = '<option data-medquan="' . $medicineName->quantity . '"data-e_date="' . $medicineName->e_date . '"data-qtity="' . $quantitypurchase . '"data-e_datetimestamp="' . $medicineName->e_datetimestamp . '"data-id="' . $medicineName->id . '"data-batchno="' . $medicineName->batchid . '"data-p_price="' . $medicineName->p_price . '"data-s_price="' . $medicineselling . '"data-m_name="' . $medicineName->medname . '"data-c_name="' . $medicineName->company . '"data-cs="' . ($medicineName->quantity - $totalbatch) . '" value="' . $medicineName->id . '"selected><p class="myselectspana">' . $medicineName->medname . '</p>  -' . '<p class="myselectspanb">batch no' . ' ' . $medicineName->batchid . '</p> ' . 'ex (' . $medicineName->e_date . ')' . '</option>';
                            $data2[$i] = $medicineName->id;
                            $i = $i + 1;
                        }
                    } else {
                        $j = 0;
                        $quantitytrack = array();
                        $paymentlist1 = $this->finance_model->getPaymentById($payment[0]);

                        $totalbatch = $this->batchRemainingQuantity($medicineName->id);
                        $category_name4 = $paymentlist1->category_name;
                        $category_name5 = explode(',', $category_name4);
                        foreach ($category_name5 as $category_name6) {
                            $category_name7 = explode('*', $category_name6);
                            if ($category_name7[0] == $medicineName->id) {
                                if (($totalpurchase - $totalbatch) > 0) {
                                    $quantitypurchase = $category_name7[2];
                                    $medicineselling = $this->medicine_model->getMedicineById($catidseparate);

                                    $data[] = '<option data-medquan="' . $medicineName->quantity . '"data-e_date="' . $medicineName->e_date . '"data-qtity="' . $quantitypurchase . '"data-e_datetimestamp="' . $medicineName->e_datetimestamp . '"data-id="' . $medicineName->id . '"data-batchno="' . $medicineName->batchid . '"data-p_price="' . $medicineName->p_price . '"data-s_price="' . $medicineselling->s_price . '"data-m_name="' . $medicineName->medname . '"data-c_name="' . $medicineName->company . '"data-cs="' . ($medicineName->quantity - $totalbatch) . '" value="' . $medicineName->id . '"selected><div class="myselect"><p class="myselectspana">' . $medicineName->medname . '</p>  -' . '<p class="myselectspanb">batch no' . ' ' . $medicineName->batchid . '</p> ' . 'ex (' . $medicineName->e_date . ')' . '</option>';
                                    if (!empty($payments)) {
                                        $option67 .= '<div class="remove1" id="id-div' . $medicineName->id . '"><div class="name pos_element"> Name: ' . $medicineName->medname . '</div><br><div class="company pos_element">Company: ' . $medicineName->company . '</div><br><div class="price pos_element">price: ' . $medicineselling->s_price . '</div><br><div class="current_stock pos_element">Current Stock: ' . ($medicineName->quantity - $totalbatch) . '</div><br><div class="quantity pos_element">quantity:<div></div></div></div><input type="text" class="remove" id="idinput-' . $medicineName->id . '" name="quantity[]" value="' . $quantitypurchase . '"><input type="hidden" class="remove" id="mediidinput-' . $medicineName->id . '" name="medicine_id[]" value="' . $medicineName->id . '">';
                                    }
                                }
                            }
                        }
                        $data2[$i] = $medicineName->id;
                        $i = $i + 1;
                    }
                } else {

                    $totalbatch = $this->batchRemainingQuantity($medicineName->id);
                    //  echo $totalbatch;
                    if (($medicineName->quantity - $totalbatch) > 0) {
                        $medicineselling = $this->medicine_model->getMedicineById($catidseparate)->s_price;
                        $data[] = '<option data-medquan="' . $medicineName->quantity . '"data-e_date="' . $medicineName->e_date . '"data-e_datetimestamp="' . $medicineName->e_datetimestamp . '"data-id="' . $medicineName->id . '"data-batchno="' . $medicineName->batchid . '"data-p_price="' . $medicineName->p_price . '"data-s_price="' . $medicineselling . '"data-m_name="' . $medicineName->medname . '"data-cs="' . ($medicineName->quantity - $totalbatch) . '"data-c_name="' . $medicineName->company . '" value="' . $medicineName->id . '"><p class="myselectspana">' . $medicineName->medname . '</p>  -' . '<p class="myselectspanb">batch no' . ' ' . $medicineName->batchid . '</p> ' . 'ex (' . $medicineName->e_date . ')' . '</option>';
                    }
                }
            }

            $j = $j + 1;
        }
        array_unique($data);
        $data1['user1'] = implode(' ', $data);
        $data1['user2'] = $option67;
        $data1['user'] = $data2;
        $data = NULL;
        echo json_encode($data1);
    }

    public function addPaymentViewDebug() {
        $data = array();
        $data['discount_type'] = $this->finance_model->getDiscountType();
        $data['settings'] = $this->settings_model->getSettings();
        $data['medicines'] = $this->medicine_model->getMedicine();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('add_payment_view_new', $data);
        $this->load->view('home/footer'); // just the header file
    }

    function getMedicineByKeyJason() {
        $key = $this->input->get('keyword');
        $medicines = $this->medicine_model->getMedicineByKeyForPos($key);

        $data[] = array();
        $lists = array();
        $options = array();
        $selected = array();
        foreach ($medicines as $medicine) {
            if ($medicine->quantity > 0) {
                $lists[] = '<li class="ooppttiioonn ms-elem-selectable" data-id="' . $medicine->id . '" data-s_price="' . (float) $medicine->s_price . '" data-m_name="' . $medicine->name . '" data-c_name="' . trim($medicine->company) . '" id="' . $medicine->id . '-selectable"><span>' . $medicine->name . '</span></li>';
                $options[] = '<option class="ooppttiioonn" data-id="' . $medicine->id . '" data-s_price="' . (float) $medicine->s_price . '" data-m_name="' . $medicine->name . '" data-c_name="' . trim($medicine->company) . '" value="' . $medicine->id . '">' . $medicine->name . '</option>';
                $selected[] = '<li class="ooppttiioonn ms-elem-selection" data-id="' . $medicine->id . '" data-s_price="' . (float) $medicine->s_price . '"data-m_name="' . $medicine->name . '"data-c_name="' . trim($medicine->company) . '" id="' . $medicine->id . '-selection" style="display: none;"><span> ' . $medicine->name . '  </span></li>';
            }
        }
        $data['ltst'] = $lists;
        $data['opp'] = $options;
        $data['slt'] = $selected;

        $lists = NULL;
        $options = NULL;
        $selected = NULL;

        echo json_encode($data);
    }

    function searchPayment() {
        $page_number = $this->input->get('page_number');
        if (empty($page_number)) {
            $page_number = 0;
        }
        $data['p_n'] = $page_number;
        $key = $this->input->get('key');
        $data['payments'] = $this->finance_model->getPaymentByKey($page_number, $key);
        $data['settings'] = $this->settings_model->getSettings();
        $data['pagee_number'] = $page_number;
        $data['key'] = $key;
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('payment', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function addPayment() {
        $type = $this->input->post('type');
        $gateway = $this->db->get_where('settings', array('id =' => 1))->row()->payment_gateway;
        $id = $this->input->post('id');

        $client = $this->input->post('client');
        $item_selected = array();
        $quantity = array();
        $item_selected = $this->input->post('medicine_id'); //batchid
        $quantity = $this->input->post('quantity');
        $user = $this->ion_auth->get_user_id();
        $received = $this->input->post('received');

        if (empty($received)) {
            $received = 0;
        }

        if (empty($id)) {
            $this->form_validation->set_rules('received', 'Received Amount', 'trim|xss_clean');
        }
        if (empty($item_selected)) {

            $this->session->set_flashdata('feedback', 'Select a Item');
            redirect('finance/addPaymentView');
        } else {
            $item_quantity_array = array();
            $item_quantity_array = array_combine($item_selected, $quantity);
        }
        foreach ($item_quantity_array as $key => $value) {
            $current_medicine = $this->db->get_where('batchmedicine', array('id' => $key))->row();
            $current_medicine1 = $this->db->get_where('medicine', array('id' => $current_medicine->mednameid))->row();
            $unit_price = $current_medicine1->s_price;
            $mednameidupdate = $current_medicine->mednameid;
            $cost = $current_medicine->p_price;
            $current_stock = (string) $current_medicine->quantity;
            $qty = $value;
            if ($current_stock < $qty) {
                $this->session->set_flashdata('quantity_check', 'Unsufficient Quantity selected for Medicine ' . $current_medicine->name);
                redirect('finance/addPaymentView');
            }
            $item_price[] = $unit_price * $value;
            $category_name[] = $key . '*' . $unit_price . '*' . $qty . '*' . $cost . '*' . $mednameidupdate;
        }

        $category_name = implode(',', $category_name);

        $date = time();
        $date_string = date('d-m-y', $date);
        $discount = $this->input->post('discount');
// $amount_received = $this->input->post('amount_received');

        $this->load->library('form_validation');
        //   $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
// Validating Client Field

        $this->form_validation->set_rules('client', 'Client', 'trim|min_length[1]|max_length[100]|xss_clean');

// Validating Discount Field
        $this->form_validation->set_rules('discount', 'Discount', 'trim|min_length[1]|max_length[100]|xss_clean');


        if ($this->form_validation->run() == FALSE) {

            $data = array();
            $data['clients'] = $this->client_model->getClient();
            $data['discount_type'] = $this->finance_model->getDiscountType();
            $data['settings'] = $this->settings_model->getSettings();
            $data['medicines'] = $this->medicine_model->getMedicine();
            $data['purchases'] = $this->purchase_model->getPurchase();
            $this->load->view('home/dashboard', $data); // just the header file
            $this->load->view('add_payment_view', $data);
            $this->load->view('home/footer'); // just the header file
        } else {
            $amount = array_sum($item_price);
            $sub_total = $amount;
            $discount_type = $this->finance_model->getDiscountType();
            if (!empty($discount)) {
                $discount = $discount;
            } else {
                $discount = 0;
            }
            if ($discount_type == 'flat') {
                $flat_discount = $discount;
                $gross_total = $sub_total - $flat_discount;
            } else {
                $flat_discount = $amount * ($discount / 100);
                $gross_total = $sub_total - $flat_discount;
            }

            $data = array();
            if (empty($id)) {
                if ($client == 'Walking Customer') {
                    $clientid = 'Walking Customer';
                    $name = 'Walking Customer';
                } else {
                    $client1 = $this->db->get_where('client', array('id =' => $client))->row();
                    $clientid = $client1->id;
                    $name = $client1->name;
                }
                $data = array(
                    'category_name' => $category_name,
                    'client' => $clientid,
                    'date' => $date,
                    'date_string' => $date_string,
                    'amount' => $sub_total,
                    'discount' => $discount,
                    'flat_discount' => $flat_discount,
                    'gross_total' => $gross_total,
                    'status' => 'unpaid',
                    'user' => $user
                );

                if ($type == 'cash') {

                    $paid_by = 'Cash';

                    $this->finance_model->insertPayment($data);
                    $insert_id11 = $this->db->insert_id('payment');
                    if ($clientid != 'Walking Customer') {
                        $data1 = array(
                            'clientid' => $client,
                            'amount' => $gross_total
                        );
                        $this->sendingSmsEmail($data1);
                    }
                    $transaction = array(
                        'client_id' => $clientid,
                        'paid_amount' => $received,
                        'date' => strtotime(date('d-m-Y')),
                        'date_string' => date('d-m-Y'),
                        'paid_by' => $paid_by,
                        'paidtype' => $type,
                        'invoice' => $insert_id11
                    );
                    $this->finance_model->addTransaction($transaction);
                    $this->session->set_flashdata('feedback', 'Added');
                    // $inserted_id = $this->db->insert_id('payment');
                    redirect("finance/invoice?id=" . $insert_id11);
                }
                if ($type == 'card' && $gateway == 'Stripe') {
                    $token = $this->input->post('token');
                    $this->finance_model->insertPayment($data);
                    $stripe = array(
                        'amount' => $received,
                        'currency' => "USD",
                        'source' => $token,
                        'batchid' => ""
                    );
                    if ($clientid != 'Walking Customer') {
                        $data1 = array(
                            'clientid' => $client,
                            'amount' => $gross_total
                        );
                        $this->sendingSmsEmail($data1);
                    }
                    $charge = $this->pgateway->doPaymentStripe($stripe);
                    $chargeJson = $charge->jsonSerialize();
                    if ($chargeJson['amount_refunded'] == 0 && empty($chargeJson['failure_code']) && $chargeJson['paid'] == 1 && $chargeJson['captured'] == 1) {
                        $payment_status = $chargeJson['status'];
                    }
                    if ($payment_status == 'succeeded') {

                        $transaction_id = $charge['id'];
                        $paid_by = 'Stripe';
                        $transaction = array(
                            'client_id' => $clientid,
                            'paid_amount' => $received,
                            'date' => strtotime(date('d-m-Y')),
                            'date_string' => date('d-m-Y'),
                            'transaction_id' => $transaction_id,
                            'paid_by' => $paid_by,
                            'paidtype' => $type,
                            'invoice' => $this->db->insert_id('payment')
                        );
                        $this->finance_model->addTransaction($transaction);
                        $this->session->set_flashdata('feedback', 'Added');
                        $inserted_id = $this->db->insert_id('payment');
                        redirect("finance/invoice?id=" . $inserted_id);
                    }
                } if ($type == 'card' && $gateway == 'PayPal') {
                    $cardtype = $this->input->post('cardtype');
                    $card = $this->input->post('card');
                    $expire = $this->input->post('expire');
                    $cvv = $this->input->post('cvv');
                    $this->form_validation->set_rules('cardtype', 'Card Type', 'required|trim|xss_clean');
                    $this->form_validation->set_rules('card', 'Card', 'required|trim|xss_clean');
                    $this->form_validation->set_rules('expire', 'Expire', 'required|trim|xss_clean');
                    $this->form_validation->set_rules('cvv', 'CVV', 'required|trim|xss_clean');
                    if ($this->form_validation->run() == true) {
                        
                    } else {

                        $paypal = array(
                            'client' => $name,
                            'card' => $card,
                            'expire' => $expire,
                            'cvv' => $cvv,
                            'amount' => $received,
                            'currency' => 'USD'
                        );
                        $charge = $this->pgateway->doPaymentPayPal($paypal);
                        $transaction_id = $charge;
                        $paid_by = 'PayPal';
                        $this->finance_model->insertPayment($data);
                        if ($clientid != 'Walking Customer') {
                            $data1 = array(
                                'clientid' => $client,
                                'amount' => $gross_total
                            );
                            $this->sendingSmsEmail($data1);
                        }
                        $inserted_id = $this->db->insert_id('payment');
                        $transaction = array(
                            'client_id' => $clientid,
                            'paid_amount' => $received,
                            'date' => strtotime(date('d-m-Y')),
                            'date_string' => date('d-m-Y'),
                            'transaction_id' => $transaction_id,
                            'paid_by' => $paid_by,
                            'paidtype' => $type,
                            'invoice' => $inserted_id
                        );
                        $this->finance_model->addTransaction($transaction);
                        $this->session->set_flashdata('feedback', 'Added');

                        redirect("finance/invoice?id=" . $inserted_id);
                    }
                } if ($type == 'card' && $gateway == 'PayU Money') {
                    $this->finance_model->insertPayment($data);
                    $inserted_id = $this->db->insert_id();
                    $payu = array(
                        'client' => $clientid,
                        'amount' => $gross_total,
                        'insertid' => $inserted_id,
                        'discount' => $discount
                    );

                    $this->payu->check1($received, $payu);
                }

                //
            } else {

                $data = array(
                    'category_name' => $category_name,
                    'client' => $client,
                    'amount' => $sub_total,
                    'discount' => $discount,
                    'flat_discount' => $flat_discount,
                    'gross_total' => $gross_total,
                    'user' => $user
                );
                $initialdeposit = $this->input->post('initialdeposit');

                $initialdepositid = $this->input->post('initialdepositid');
                $datainitialdeposit = array(
                    'paid_amount' => $initialdeposit);
                $update = $this->finance_model->updateTransaction($initialdepositid, $datainitialdeposit);
                $othersdeposits = $this->input->post('othersdeposit');

                $othersdepositids = $this->input->post('othersdepositid');
                if (!empty($othersdepositids)) {
                    $i = 0;
                    foreach ($othersdeposits as $othersdeposit) {
                        $dataupdatewhere = array(
                            'othersdeposit' => $othersdeposit
                        );
                        $update = $this->finance_model->updateTransaction($othersdepositids[$i], $dataupdatewhere);
                        $i = $i + 1;
                    }
                }

                $this->finance_model->updatePayment($id, $data);

                $this->session->set_flashdata('feedback', 'Updated');
                redirect("finance/invoice?id=" . "$id");
            }
        }
    }

    public function sendingSmsEmail($data1) {
        $send_email = $this->db->get_where('autoEmailTemplate', array('id =' => 4))->row();
        $send_sms = $this->db->get_where('autoSmsTemplate', array('id =' => 4))->row();
        $setings11 = $this->settings_model->getSettings();
        $clientdetails = $this->db->get_where('client', array('id =' => $data1['clientid']))->row();
        $dataupdate = array(
            'name' => $clientdetails->name,
            'amount' => $data1['amount'],
            'companyname' => $setings11->system_vendor
        );
        if ($send_sms->status == 'Active') {


            $message = $this->parser->parse_string($send_sms->message, $dataupdate);
            $data3[] = array($clientdetails->phone => $message);
            $this->sms->sendSms($clientdetails->phone, $message, $data3);
        }
        if ($send_email->status == 'Active') {
            $message = $this->parser->parse_string($send_email->message, $dataupdate);
            $emailSettings = $this->db->get_where('email_settings', array('id =' => 1))->row();
            $this->email->from($emailSettings->admin_email);
            $this->email->to($clientdetails->email);
            $this->email->subject('Payment Notification');
            $this->email->message($message);
            $this->email->send();
        }
    }

    function editPayment() {
//    if ($this->ion_auth->in_group(array('admin', 'Accountant'))) {
        $data = array();
        $data['discount_type'] = $this->finance_model->getDiscountType();
        $data['settings'] = $this->settings_model->getSettings();
        $data['medicinesname'] = $this->medicine_model->getMedicine();
        $data['medicines'] = $this->purchase_model->getPurchase();
        $id = $this->input->get('id');
        $data['clientpayments'] = $this->finance_model->getClientPaymentByPaymentId($id);
        $data['payment'] = $this->finance_model->getPaymentById($id);
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('paymentview', $data);
        $this->load->view('home/footer'); // just the footer file
//   }
    }

    function delete() {
        if ($this->ion_auth->in_group('admin')) {
            $id = $this->input->get('id');
            $category_name = $this->finance_model->getPaymentById($id)->category_name;
            $all_product_details = array();
            $all_product_details = explode(',', $category_name);

            foreach ($all_product_details as $key => $value) {
                $product_details = array();
                $product_details = explode('*', $value);
                $product_id = $product_details[0];
                $qty = $product_details[2];
                $previous_qty = $this->medicine_model->getMedicineById($product_details[0])->quantity;
                $new_qty = $previous_qty + $qty;
                $data = array();
                $data = array('quantity' => $new_qty);
                $this->medicine_model->updateMedicine($product_id, $data);
            }

            $this->finance_model->deletePayment($id);
            $this->session->set_flashdata('feedback', 'Deleted');
            redirect('finance/payment');
        }
    }

    public function expense() {
        if (!$this->ion_auth->logged_in()) {
            redirect('auth/login', 'refresh');
        }
        $data['settings'] = $this->settings_model->getSettings();
        $data['categories'] = $this->finance_model->getExpenseCategory();
//   $data['expenses'] = $this->finance_model->getExpense();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('expense', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function addExpenseView() {
        $data = array();
        $data['settings'] = $this->settings_model->getSettings();
        $data['categories'] = $this->finance_model->getExpenseCategory();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('add_expense_view', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function addExpense() {
        $id = $this->input->post('id');
        $category = $this->input->post('category');
        $date = strtotime($this->input->post('date'));
        if (empty($date)) {
            $date = time();
        }

        $amount = $this->input->post('amount');
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
// Validating Category Field
        $this->form_validation->set_rules('category', 'Category', 'trim|required|min_length[1]|max_length[100]|xss_clean');
// Validating Generic Name Field
        $this->form_validation->set_rules('amount', 'Amount', 'trim|required|min_length[1]|max_length[100]|xss_clean');
// Validating Company Name Field
        if ($this->form_validation->run() == FALSE) {
            $data = array();
            $data['settings'] = $this->settings_model->getSettings();
            $data['categories'] = $this->finance_model->getExpenseCategory();
            $this->load->view('home/dashboard', $data); // just the header file
            $this->load->view('add_expense_view', $data);
            $this->load->view('home/footer'); // just the header file
        } else {
            $data = array();
            if (empty($id)) {
                $data = array(
                    'category' => $category,
                    'date' => $date,
                    'amount' => $amount,
                    'datestring' => $this->input->post('date')
                );
            } else {
                $data = array(
                    'category' => $category,
                    'amount' => $amount,
                    'datestring' => $this->input->post('date')
                );
            }
            if (empty($id)) {
                $this->finance_model->insertExpense($data);
                $this->session->set_flashdata('feedback', 'Added');
            } else {
                $this->finance_model->updateExpense($id, $data);
                $this->session->set_flashdata('feedback', 'Updated');
            }
            redirect('finance/expense');
        }
    }

    function editExpense() {
        $data = array();
        $data['categories'] = $this->finance_model->getExpenseCategory();
        $data['settings'] = $this->settings_model->getSettings();
        $id = $this->input->get('id');
        $data['expense'] = $this->finance_model->getExpenseById($id);
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('add_expense_view', $data);
        $this->load->view('home/footer'); // just the footer file
    }

    function deleteExpense() {
        $id = $this->input->get('id');
        $this->finance_model->deleteExpense($id);
        redirect('finance/expense');
    }

    public function expenseCategory() {
        if (!$this->ion_auth->logged_in()) {
            redirect('auth/login', 'refresh');
        }
        $data['settings'] = $this->settings_model->getSettings();
        $data['categories'] = $this->finance_model->getExpenseCategory();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('expense_category', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function addExpenseCategoryView() {
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('add_expense_category');
        $this->load->view('home/footer'); // just the header file
    }

    public function addExpenseCategory() {
        $id = $this->input->post('id');
        $category = $this->input->post('category');
        $description = $this->input->post('description');

        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
// Validating Category Name Field
        $this->form_validation->set_rules('category', 'Category', 'trim|required|min_length[2]|max_length[100]|xss_clean');
// Validating Description Field
        $data['settings'] = $this->settings_model->getSettings();
        $this->form_validation->set_rules('description', 'Description', 'trim|required|min_length[5]|max_length[100]|xss_clean');
        if ($this->form_validation->run() == FALSE) {
            $this->load->view('home/dashboard', $data); // just the header file
            $this->load->view('add_expense_category');
            $this->load->view('home/footer'); // just the header file
        } else {
            $data = array();
            $data = array('category' => $category,
                'description' => $description
            );
            if (empty($id)) {
                $this->finance_model->insertExpenseCategory($data);
                $this->session->set_flashdata('feedback', 'Added');
            } else {
                $this->finance_model->updateExpenseCategory($id, $data);
                $this->session->set_flashdata('feedback', 'Updated');
            }
            redirect('finance/expenseCategory');
        }
    }

    function editExpenseCategory() {
        $data = array();
        $id = $this->input->get('id');
        $data['settings'] = $this->settings_model->getSettings();
        $data['category'] = $this->finance_model->getExpenseCategoryById($id);
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('add_expense_category', $data);
        $this->load->view('home/footer'); // just the footer file
    }

    function deleteExpenseCategory() {
        $id = $this->input->get('id');
        $this->finance_model->deleteExpenseCategory($id);
        $this->session->set_flashdata('feedback', 'Deleted');
        redirect('finance/expenseCategory');
    }

    function invoice() {
        $id = $this->input->get('id');
        $clientpayments = $this->finance_model->getClientPaymentByPaymentId($id);
        $received = 0;
        foreach ($clientpayments as $clientpayment) {
            if (!empty($clientpayment->paid_amount)) {
                $received = $received + $clientpayment->paid_amount;
            } else {
                $received = $received + $clientpayment->othersdeposit;
            }
        }
        $data['received'] = $received;
        $data['settings'] = $this->settings_model->getSettings();
        $data['discount_type'] = $this->finance_model->getDiscountType();
        $data['payment'] = $this->finance_model->getPaymentById($id);
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('invoice', $data);
        $this->load->view('home/footer'); // just the footer fi
    }

    function amountReceived() {
        $id = $this->input->post('id');
        $amount_received = $this->input->post('amount_received');
        $previous_amount_received = $this->db->get_where('payment', array('id' => $id))->row()->amount_received;
        $amount_received = $amount_received + $previous_amount_received;
        $data = array();
        $data = array('amount_received' => $amount_received);
        $this->finance_model->amountReceived($id, $data);
        redirect('finance/invoice?id=' . $id);
    }

    function amountReceivedFromPT() {
        $id = $this->input->post('id');
        $amount_received = $this->input->post('amount_received');
        $payments = $this->finance_model->getPaymentByPatientId($id);
        foreach ($payments as $payment) {
            if ($payment->gross_total != $payment->amount_received) {
                $due_balance = $payment->gross_total - $payment->amount_received;
                if ($amount_received <= $due_balance) {
                    $data = array();
                    $new_amount_received = $amount_received + $payment->amount_received;
                    $data = array('amount_received' => $new_amount_received);
                    $this->finance_model->amountReceived($payment->id, $data);
                    break;
                } else {
                    $data = array();
                    $new_amount_received = $due_balance + $payment->amount_received;
                    $data = array('amount_received' => $new_amount_received);
                    $this->finance_model->amountReceived($payment->id, $data);
                    $amount_received = $amount_received - $due_balance;
                }
            }
        }
        redirect('finance/invoicePatientTotal?id=' . $id);
    }

    function todaySales() {
        if (!$this->ion_auth->logged_in()) {
            redirect('auth/login', 'refresh');
        }
        $hour = 0;
        $today = strtotime($hour . ':00:00');
        $today_last = strtotime($hour . ':00:00') + 24 * 60 * 60;
        $data['settings'] = $this->settings_model->getSettings();
        $data['payments'] = $this->finance_model->getPaymentByDate($today, $today_last);

        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('today_sales', $data);
        $this->load->view('home/footer'); // just the header file
    }

    function todayExpense() {
        if (!$this->ion_auth->logged_in()) {
            redirect('auth/login', 'refresh');
        }
        $hour = 0;
        $today = strtotime($hour . ':00:00');
        $today_last = strtotime($hour . ':00:00') + 24 * 60 * 60;
        $data['settings'] = $this->settings_model->getSettings();
        $data['expenses'] = $this->finance_model->getExpenseByDate($today, $today_last);

        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('today_expenses', $data);
        $this->load->view('home/footer'); // just the header file
    }

    function todayNetCash() {
        $data['today_sales_amount'] = $this->finance_model->todaySalesAmount();
        $data['today_expenses_amount'] = $this->finance_model->todayExpensesAmount();
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('today_net_cash', $data);
        $this->load->view('home/footer'); // just the header file
    }

    function daily() {
        $data = array();
        $year = $this->input->get('year');
        $month = $this->input->get('month');

        if (empty($year)) {
            $year = date('Y');
        }
        if (empty($month)) {
            $month = date('m');
        }

        $first_minute = mktime(0, 0, 0, $month, 1, $year);
        $last_minute = mktime(23, 59, 59, $month, date("t", $first_minute), $year);

        $payments = $this->finance_model->getPaymentByDate($first_minute, $last_minute);
        $all_payments = array();
        foreach ($payments as $payment) {
            $date = date('D d-m-y', $payment->date);
            if (array_key_exists($date, $all_payments)) {
                $all_payments[$date] = $all_payments[$date] + $payment->gross_total;
            } else {
                $all_payments[$date] = $payment->gross_total;
            }
        }

        $data['year'] = $year;
        $data['month'] = $month;
        $data['first_minute'] = $first_minute;
        $data['last_minute'] = $last_minute;
        $data['all_payments'] = $all_payments;

        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('daily', $data);
        $this->load->view('home/footer'); // just the header file
    }

    function monthly() {
        $data = array();
        $year = $this->input->get('year');

        if (empty($year)) {
            $year = date('Y');
        }


        $first_minute = mktime(0, 0, 0, 1, 1, $year);
        $last_minute = mktime(23, 59, 59, 12, 31, $year);

        $payments = $this->finance_model->getPaymentByDate($first_minute, $last_minute);
        $all_payments = array();
        foreach ($payments as $payment) {
            $month = date('m-Y', $payment->date);
            if (array_key_exists($month, $all_payments)) {
                $all_payments[$month] = $all_payments[$month] + $payment->gross_total;
            } else {
                $all_payments[$month] = $payment->gross_total;
            }
        }

        $data['year'] = $year;
        $data['first_minute'] = $first_minute;
        $data['last_minute'] = $last_minute;
        $data['all_payments'] = $all_payments;

        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('monthly', $data);
        $this->load->view('home/footer'); // just the header file
    }

    function dailyExpense() {
        $data = array();
        $year = $this->input->get('year');
        $month = $this->input->get('month');

        if (empty($year)) {
            $year = date('Y');
        }
        if (empty($month)) {
            $month = date('m');
        }

        $first_minute = mktime(0, 0, 0, $month, 1, $year);
        $last_minute = mktime(23, 59, 59, $month, date("t", $first_minute), $year);

        $expenses = $this->finance_model->getExpenseByDate($first_minute, $last_minute);
        $all_expenses = array();
        foreach ($expenses as $expense) {
            $date = date('D d-m-y', $expense->date);
            if (array_key_exists($date, $all_expenses)) {
                $all_expenses[$date] = $all_expenses[$date] + $expense->amount;
            } else {
                $all_expenses[$date] = $expense->amount;
            }
        }

        $data['year'] = $year;
        $data['month'] = $month;
        $data['first_minute'] = $first_minute;
        $data['last_minute'] = $last_minute;
        $data['all_expenses'] = $all_expenses;



        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('daily_expense', $data);
        $this->load->view('home/footer'); // just the header file
    }

    function monthlyExpense() {
        $data = array();
        $year = $this->input->get('year');

        if (empty($year)) {
            $year = date('Y');
        }


        $first_minute = mktime(0, 0, 0, 1, 1, $year);
        $last_minute = mktime(23, 59, 59, 12, 31, $year);

        $expenses = $this->finance_model->getExpenseByDate($first_minute, $last_minute);
        $all_expenses = array();
        foreach ($expenses as $expense) {
            $month = date('m-Y', $expense->date);
            if (array_key_exists($month, $all_expenses)) {
                $all_expenses[$month] = $all_expenses[$month] + $expense->amount;
            } else {
                $all_expenses[$month] = $expense->amount;
            }
        }

        $data['year'] = $year;
        $data['first_minute'] = $first_minute;
        $data['last_minute'] = $last_minute;
        $data['all_expenses'] = $all_expenses;

        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('monthly_expense', $data);
        $this->load->view('home/footer'); // just the header file
    }

    function salesPerMonth() {

        $payments = $this->finance_model->getPayment();
        foreach ($payments as $payment) {
            $date = $payment->date;
            $month = date('m', $date);
            $year = date('y', $date);
            if ($month = '01') {
                
            }
        }
    }

    function financialReport() {
        $date_from = strtotime($this->input->post('date_from'));
        $date_to = strtotime($this->input->post('date_to'));
        if (!empty($date_to)) {
            $date_to = $date_to + 24 * 60 * 60;
        }
        $data = array();
        $data['medicines'] = $this->medicine_model->getMedicine();
        $data['expense_categories'] = $this->finance_model->getExpenseCategory();




        $data['payments'] = $this->finance_model->getPaymentByDate($date_from, $date_to);
        $data['expenses'] = $this->finance_model->getExpenseByDate($date_from, $date_to);
        $data['from'] = $this->input->post('date_from');
        $data['to'] = $this->input->post('date_to');
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('financial_report', $data);
        $this->load->view('home/footer'); // just the footer fi
    }

    function getExpense() {
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];
        if ($limit == -1) {
            if (!empty($search)) {
                $data['finances'] = $this->finance_model->getFinanceBysearch($search); //done
            } else {
                $data['finances'] = $this->finance_model->getFinancejason(); //done
            }
        } else {
            if (!empty($search)) {
                $data['finances'] = $this->finance_model->getFinanceByLimitBySearch($limit, $start, $search); //done
            } else {
                $data['finances'] = $this->finance_model->getFinanceByLimit($limit, $start); //done
            }
        }
        $data3 = $this->settings_model->getSettings();
        foreach ($data['finances'] as $finance) {
            if ($this->ion_auth->in_group(array('admin', 'Accountant'))) {
                $options1 = ' <a type="button" class="btn btn-xs editbutton" title="' . lang('edit') . '" data-toggle = "modal" data-id="' . $finance->id . '"><i class="fa fa-edit"> </i> ' . lang('edit') . '</a>';
            }

            if ($this->ion_auth->in_group(array('admin', 'Accountant'))) {
                $options5 = '<a class="btn btn-xs delete_button" title="' . lang('delete') . '" href="finance/deleteExpense?id=' . $finance->id . '" onclick="return confirm(\'Are you sure you want to delete this item?\');"><i class="fa fa-trash"></i> ' . lang('delete') . '</a>';
            }


            if ($this->ion_auth->in_group(array('admin', 'Accountant'))) {
                $info[] = array(
                    $finance->category,
                    date('d-m-y', $finance->date),
                    $this->currency.number_format($finance->amount, 2, '.', ','),
                    $options1 . ' ' . $options5,
                        //  $options2
                );
            }
        }

        if (!empty($data['finances'])) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => $this->db->get('expense')->num_rows(),
                "recordsFiltered" => $this->db->get('expense')->num_rows(),
                "data" => $info
            );
        } else {
            $output = array(
                "draw" => 1,
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }

    public function editFinanceByJason() {
        $id = $this->input->get('id');
        $data['medicine'] = $this->finance_model->getExpenseById($id);
        echo json_encode($data);
    }

    function getPayment() {
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];
        if ($limit == -1) {
            if (!empty($search)) {
                $data['finances'] = $this->finance_model->getPaymentBysearch($search); //done
            } else {
                $data['finances'] = $this->finance_model->getPaymentjason(); //done
            }
        } else {
            if (!empty($search)) {
                $data['finances'] = $this->finance_model->getPaymentByLimitBySearch($limit, $start, $search); //done
            } else {
                $data['finances'] = $this->finance_model->getPaymentByLimit($limit, $start); //done
            }
        }

        $data3 = $this->settings_model->getSettings();
        foreach ($data['finances'] as $finance) {
            if (!empty($finance->flat_discount)) {
                $flatdiscount = number_format($finance->flat_discount, 2, '.', ',');
            } else {
                $flatdiscount = '0';
            }
            if ($this->ion_auth->in_group(array('admin'))) {

                $option2 = '  <a class="btn btn-xs editbutton" href="finance/editPayment?id=' . $finance->id . '"><i class="fa fa-edit"> </i> ' . lang('edit') . '</a>';
                $option4 = ' <a class="btn btn-xs delete_button" href="finance/delete?id=' . $finance->id . '" onclick="return confirm(\'Are you sure you want to delete this item?\');"><i class="fa fa-trash"></i>  ' . lang('delete') . '</a>';
            }
            $option3 = '<a class="btn btn-xs invoicebutton" style="color: #fff;" href="finance/invoice?id=' . $finance->id . '"><i class="fas fa-file-alt"></i>' . ' ' . lang('invoice') . '</a>';

            if ($this->ion_auth->in_group(array('admin'))) {
                $info[] = array(
                    $finance->id,
                    date('d-m-y', $finance->date),
                    $data3->currency . '' . number_format($finance->amount, 2, '.', ','),
                    $flatdiscount,
                    $data3->currency . '' . number_format($finance->gross_total, 2, '.', ','),
                    $option2 . ' ' . $option3 . ' ' . $option4,
                );
            }
            if ($this->ion_auth->in_group(array('Accountant'))) {
                $info[] = array(
                    $finance->id,
                    date('d-m-y', $finance->date),
                    $data3->currency . '' . number_format($finance->amount, 2, '.', ','),
                    $flatdiscount,
                    $data3->currency . '' . number_format($finance->gross_total, 2, '.', ','),
                    $option3
                );
            }
        }

        if (!empty($data['finances'])) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => $this->db->get('payment')->num_rows(),
                "recordsFiltered" => $this->db->get('payment')->num_rows(),
                "data" => $info
            );
        } else {
            $output = array(
                //  "draw" => 1,
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }

    function getPaidPayment() {
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];
        if ($limit == -1) {
            if (!empty($search)) {
                $data['finances'] = $this->finance_model->getPaymentBysearch($search); //done
            } else {
                $data['finances'] = $this->finance_model->getPaymentjason(); //done
            }
        } else {
            if (!empty($search)) {
                $data['finances'] = $this->finance_model->getPaymentByLimitBySearch($limit, $start, $search); //done
            } else {
                $data['finances'] = $this->finance_model->getPaymentByLimit($limit, $start); //done
            }
        }
        $data3 = $this->settings_model->getSettings();
        $i = 0;
        foreach ($data['finances'] as $finance) {

            $bill_amount = $finance->gross_total;
            $deposited_amount = $this->finance_model->getDepositedAmountByInvoiceId($finance->id);

            $due = $bill_amount - $deposited_amount;


            if ($due <= 0) {

                $i = $i + 1;


                if (!empty($finance->flat_discount)) {
                    $flatdiscount = number_format($finance->flat_discount, 2, '.', ',');
                } else {
                    $flatdiscount = '0';
                }
                if ($this->ion_auth->in_group(array('admin'))) {

                    $option2 = '  <a class="btn btn-xs editbutton" href="finance/editPayment?id=' . $finance->id . '"><i class="fa fa-edit"> </i> ' . lang('edit') . '</a>';
                    $option4 = ' <a class="btn btn-xs delete_button" href="finance/delete?id=' . $finance->id . '" onclick="return confirm(\'Are you sure you want to delete this item?\');"><i class="fa fa-trash"></i>  ' . lang('delete') . '</a>';
                }
                $option3 = '<a class="btn btn-xs invoicebutton" style="color: #fff;" href="finance/invoice?id=' . $finance->id . '"><i class="fas fa-file-alt"></i>' . ' ' . lang('invoice') . '</a>';

                if ($this->ion_auth->in_group(array('admin'))) {
                    $info[] = array(
                        $finance->id,
                        date('d-m-y', $finance->date),
                        $data3->currency . '' . number_format($finance->amount, 2, '.', ','),
                        $flatdiscount,
                        $data3->currency . '' . number_format($finance->gross_total, 2, '.', ','),
                        $option2 . ' ' . $option3 . ' ' . $option4,
                    );
                }
                if ($this->ion_auth->in_group(array('Accountant'))) {
                    $info[] = array(
                        $finance->id,
                        date('d-m-y', $finance->date),
                        $data3->currency . '' . number_format($finance->amount, 2, '.', ','),
                        $flatdiscount,
                        $data3->currency . '' . number_format($finance->gross_total, 2, '.', ','),
                        $option3
                    );
                }
            }
        }

        if ($i > 0) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => $i,
                "recordsFiltered" => $i,
                "data" => $info
            );
        } else {
            $output = array(
                //  "draw" => 1,
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }

    function getPartiallyPaidPayment() {
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];
        if ($limit == -1) {
            if (!empty($search)) {
                $data['finances'] = $this->finance_model->getPaymentBysearch($search); //done
            } else {
                $data['finances'] = $this->finance_model->getPaymentjason(); //done
            }
        } else {
            if (!empty($search)) {
                $data['finances'] = $this->finance_model->getPaymentByLimitBySearch($limit, $start, $search); //done
            } else {
                $data['finances'] = $this->finance_model->getPaymentByLimit($limit, $start); //done
            }
        }
        $data3 = $this->settings_model->getSettings();
        $i = 0;

        foreach ($data['finances'] as $finance) {
            $bill_amount = $finance->gross_total;
            $deposited_amount = $this->finance_model->getDepositedAmountByInvoiceId($finance->id);
            $due = $bill_amount - $deposited_amount;
            if ($due > 0 && $due < $finance->gross_total) {
                $i = $i + 1;
                if (!empty($finance->flat_discount)) {
                    $flatdiscount = number_format($finance->flat_discount, 2, '.', ',');
                } else {
                    $flatdiscount = '0';
                }
                if ($this->ion_auth->in_group(array('admin'))) {

                    $option2 = '  <a class="btn btn-xs editbutton" href="finance/editPayment?id=' . $finance->id . '"><i class="fa fa-edit"> </i> ' . lang('edit') . '</a>';
                    $option4 = ' <a class="btn btn-xs delete_button" href="finance/delete?id=' . $finance->id . '" onclick="return confirm(\'Are you sure you want to delete this item?\');"><i class="fa fa-trash"></i>  ' . lang('delete') . '</a>';
                }
                $option3 = '<a class="btn btn-xs invoicebutton" style="color: #fff;" href="finance/invoice?id=' . $finance->id . '"><i class="fas fa-file-alt"></i>' . ' ' . lang('invoice') . '</a>';

                if ($this->ion_auth->in_group(array('admin'))) {
                    $info[] = array(
                        $finance->id,
                        date('d-m-y', $finance->date),
                        $data3->currency . '' . number_format($finance->amount, 2, '.', ','),
                        $flatdiscount,
                        $data3->currency . '' . number_format($finance->gross_total, 2, '.', ','),
                        $option2 . ' ' . $option3 . ' ' . $option4,
                    );
                }
                if ($this->ion_auth->in_group(array('Accountant'))) {
                    $info[] = array(
                        $finance->id,
                        date('d-m-y', $finance->date),
                        $data3->currency . '' . number_format($finance->amount, 2, '.', ','),
                        $flatdiscount,
                        $data3->currency . '' . number_format($finance->gross_total, 2, '.', ','),
                        $option3
                    );
                }
            }
        }

        if ($i > 0) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => $i,
                "recordsFiltered" => $i,
                "data" => $info
            );
        } else {
            $output = array(
                //  "draw" => 1,
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }

    function getUnpaidPayment() {
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];
        if ($limit == -1) {
            if (!empty($search)) {
                $data['finances'] = $this->finance_model->getPaymentBysearch($search); //done
            } else {
                $data['finances'] = $this->finance_model->getPaymentjason(); //done
            }
        } else {
            if (!empty($search)) {
                $data['finances'] = $this->finance_model->getPaymentByLimitBySearch($limit, $start, $search); //done
            } else {
                $data['finances'] = $this->finance_model->getPaymentByLimit($limit, $start); //done
            }
        }
        $data3 = $this->settings_model->getSettings();

        $i = 0;

        foreach ($data['finances'] as $finance) {


            $bill_amount = $finance->gross_total;
            $deposited_amount = $this->finance_model->getDepositedAmountByInvoiceId($finance->id);

            $due = $bill_amount - $deposited_amount;

            if ($due > 0 && $due == $finance->gross_total) {

                $i = $i + 1;

                if (!empty($finance->flat_discount)) {
                    $flatdiscount = number_format($finance->flat_discount, 2, '.', ',');
                } else {
                    $flatdiscount = '0';
                }
                if ($this->ion_auth->in_group(array('admin'))) {

                    $option2 = '  <a class="btn btn-xs editbutton" href="finance/editPayment?id=' . $finance->id . '"><i class="fa fa-edit"> </i> ' . lang('edit') . '</a>';
                    $option4 = ' <a class="btn btn-xs delete_button" href="finance/delete?id=' . $finance->id . '" onclick="return confirm(\'Are you sure you want to delete this item?\');"><i class="fa fa-trash"></i>  ' . lang('delete') . '</a>';
                }
                $option3 = '<a class="btn btn-xs invoicebutton" style="color: #fff;" href="finance/invoice?id=' . $finance->id . '"><i class="fas fa-file-alt"></i>' . ' ' . lang('invoice') . '</a>';

                if ($this->ion_auth->in_group(array('admin'))) {
                    $info[] = array(
                        $finance->id,
                        date('d-m-y', $finance->date),
                        $data3->currency . '' . number_format($finance->amount, 2, '.', ','),
                        $flatdiscount,
                        $data3->currency . '' . number_format($finance->gross_total, 2, '.', ','),
                        $option2 . ' ' . $option3 . ' ' . $option4,
                    );
                }
                if ($this->ion_auth->in_group(array('Accountant'))) {
                    $info[] = array(
                        $finance->id,
                        date('d-m-y', $finance->date),
                        $data3->currency . '' . number_format($finance->amount, 2, '.', ','),
                        $flatdiscount,
                        $data3->currency . '' . number_format($finance->gross_total, 2, '.', ','),
                        $option3
                    );
                }
            }
        }

        if ($i > 0) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => $i,
                "recordsFiltered" => $i,
                "data" => $info
            );
        } else {
            $output = array(
                //  "draw" => 1,
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }

    public function getMedicinenamelist() {
        $searchTerm = $this->input->post('searchTerm');

        $response = $this->finance_model->getMedicineNameByAvailablity($searchTerm);
        $data = array();
        foreach ($response as $responses) {
            $data[] = array("id" => $responses->id, "text" => $responses->name);
        }
       

        echo json_encode($data);
    }

    public function getTodayssaleList() {
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];
        $hour = 0;
        $today = strtotime($hour . ':00:00');
        $today_last = strtotime($hour . ':00:00') + 24 * 60 * 60;
        if ($limit == -1) {
            if (!empty($search)) {
                $data['todayssale'] = $this->finance_model->getPaymentByDateBySearch($today, $today_last, $search); //done
            } else {
                $data['todayssale'] = $this->finance_model->getPaymentByDate($today, $today_last); //done
            }
        } else {
            if (!empty($search)) {
                $data['todayssale'] = $this->finance_model->getPaymentByDateByLimitBySearch($today, $today_last, $limit, $start, $search); //done
            } else {
                $data['todayssale'] = $this->finance_model->getPaymentByDateByLimit($today, $today_last, $limit, $start); //done
            }
        }
        $count = 0;
        $options1 = '';
        $options5 = '';
        foreach ($data['todayssale'] as $todayssales) {

            if ($this->ion_auth->in_group(array('admin'))) {
                $options1 = '<a class="btn btn-xs editbutton" href="finance/editPayment?id=' . $todayssales->id . '"><i class="fa fa-edit"> </i>' . lang('edit') . '</a>';
            }

            $options2 = '<a class="btn btn-xs invoicebutton" style="color: #fff;" href="finance/invoice?id=' . $todayssales->id . '"><i class="fa fa-file-text"></i>' . lang('invoice') . '</a>';
            if ($this->ion_auth->in_group(array('admin'))) {
                $options5 = '<a class="btn btn-xs delete_button" title="' . lang('delete') . '" href="finance/delete?id=' . $todayssales->id . '" onclick="return confirm(\'Are you sure you want to delete this item?\');"><i class="fa fa-trash"></i> ' . lang('delete') . '</a>';
            }
            $settings = $this->settings_model->getSettings();
            if (!empty($todayssales->flat_discount)) {
                $dis = $todayssales->flat_discount;
            } else {
                $dis = '0';
            }
            $info[] = array(
                '00' . $todayssales->id,
                date('d/m/y', $todayssales->date),
                $settings->currency . $todayssales->amount,
                $settings->currency . $dis,
                $settings->currency . $todayssales->gross_total,
                $options1 . ' ' . $options2 . ' ' . $options5,
                    //  $options2
            );
            $count = $count + 1;
        }

        if ($count !== 0) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => $count,
                "recordsFiltered" => $count,
                "data" => $info
            );
        } else {
            $output = array(
                // "draw" => 1,
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }

    public function getTodaysExpenseList() {
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];
        $hour = 0;
        $today = strtotime($hour . ':00:00');
        $today_last = strtotime($hour . ':00:00') + 24 * 60 * 60;
        if ($limit == -1) {
            if (!empty($search)) {
                $data['todaysexpense'] = $this->finance_model->getExpenseByDateBySearch($today, $today_last, $search); //done
            } else {
                $data['todaysexpense'] = $this->finance_model->getExpenseByDate($today, $today_last); //done
            }
        } else {
            if (!empty($search)) {
                $data['todaysexpense'] = $this->finance_model->getExpenseByDateByLimitBySearch($today, $today_last, $limit, $start, $search); //done
            } else {
                $data['todaysexpense'] = $this->finance_model->getExpenseByDateByLimit($today, $today_last, $limit, $start); //done
            }
        }
        $count = 0;
        $options1 = '';
        $options5 = '';
        foreach ($data['todaysexpense'] as $todaysexpenses) {

            if ($this->ion_auth->in_group(array('admin'))) {
                $options1 = '<a class="btn btn-xs editbutton" href="finance/editExpense?id=' . $todaysexpenses->id . '"><i class="fa fa-edit"> </i>' . lang('edit') . '</a>';
            }

            if ($this->ion_auth->in_group(array('admin'))) {
                $options5 = '<a class="btn btn-xs delete_button" title="' . lang('delete') . '" href="finance/deleteExpense?id=' . $todaysexpenses->id . '" onclick="return confirm(\'Are you sure you want to delete this item?\');"><i class="fa fa-trash"></i> ' . lang('delete') . '</a>';
            }
            $settings = $this->settings_model->getSettings();

            $info[] = array(
                $todaysexpenses->category,
                date('d/m/y', $todaysexpenses->date),
                $settings->currency . $todaysexpenses->amount,
                $options1 . ' ' . $options5,
            );
            $count = $count + 1;
        }

        if ($count !== 0) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => $count,
                "recordsFiltered" => $count,
                "data" => $info
            );
        } else {
            $output = array(
                // "draw" => 1,
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }

    public function paymentDetailsByClient() {
        $client_id = $this->input->get('id');
        $client = $this->input->post('client');
        $datefrom = $this->input->post('date_from');
        $dateto = $this->input->post('date_to');

        if (!empty($datefrom) && !empty($dateto)) {
            $data['client_details'] = $this->client_model->getClientById($client);
            $data['paymentdone'] = $this->finance_model->getClientPaymentByIdBydate($client, $datefrom, $dateto);
            $paymentdetails = $this->finance_model->getPaymentByClientIdBydate($client, $datefrom, $dateto);

            $data['date_from'] = $datefrom;
            $data['date_to'] = $dateto;
        } else {
            $data['client_details'] = $this->client_model->getClientById($client_id);
            $paymentdetails = $this->finance_model->getPaymentByClientId($client_id);
            $data['paymentdone'] = $this->finance_model->getClientPaymentById($client_id);
        }

        $data['paymentlist'] = $this->finance_model->getPayment();
        $paymentarray = array();
        $paymentdonearray = array();
        if (!empty($paymentdetails)) {
            foreach ($paymentdetails as $payment) {
                $paymentarray[] = $payment->amount;
            }
            $data['total'] = array_sum($paymentarray);
        } else {
            $data['total'] = 0;
        }

        if (!empty($data['paymentdone'])) {
            foreach ($data['paymentdone'] as $paymentdo) {
                if (!empty($paymentdo->paid_amount)) {
                    $paymentdonearray[] = $paymentdo->paid_amount;
                } else {
                    $paymentdonearray[] = $paymentdo->othersdeposit;
                }
            }
            $data['paid'] = array_sum($paymentdonearray);
        } else {
            $data['paid'] = 0;
        }

        $data['due'] = $data['total'] - $data['paid'];
        $data['settings'] = $this->settings_model->getSettings();
        $data['gateway'] = $this->db->get_where('pgateway', array('gateway' => $data['settings']->payment_gateway))->row();

        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('payment_details_by_client', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function addDeposit() {
        $type = $this->input->post('type');
        $gateway = $this->db->get_where('settings', array('id =' => 1))->row()->payment_gateway;
        $id = $this->input->post('id');

        $client = $this->input->post('client');
        $amount = $this->input->post('deposited_amount');
        $paymentid = $this->input->post('payment_id');
        $this->load->library('form_validation');

        $this->form_validation->set_rules('client', 'client', 'trim|min_length[1]|max_length[100]|xss_clean');

        if ($this->form_validation->run() == FALSE) {
            redirect('paymentDetailsByClient?id=' . $client);
        } else {

            if (empty($id)) {
                if ($type == 'cash') {

                    $paid_by = 'Cash';


                    $transaction = array(
                        'client_id' => $client,
                        'othersdeposit' => $amount,
                        'date' => strtotime(date('d-m-Y')),
                        'date_string' => date('d-m-Y'),
                        'paid_by' => $paid_by,
                        'paidtype' => $type,
                        'invoice' => $paymentid
                    );
                    $this->finance_model->addTransaction($transaction);
                    $this->session->set_flashdata('feedback', 'Added');
                    redirect('finance/paymentDetailsByClient?id=' . $client);
                }
                if ($type == 'card' && $gateway == 'Stripe') {
                    $token = $this->input->post('token');

                    $stripe = array(
                        'amount' => $amount,
                        'currency' => "USD",
                        'source' => $token,
                        'batchid' => ""
                    );
                    $charge = $this->pgateway->doPaymentStripe($stripe);
                    $chargeJson = $charge->jsonSerialize();
                    if ($chargeJson['amount_refunded'] == 0 && empty($chargeJson['failure_code']) && $chargeJson['paid'] == 1 && $chargeJson['captured'] == 1) {
                        $payment_status = $chargeJson['status'];
                    }
                    if ($payment_status == 'succeeded') {

                        $transaction_id = $charge['id'];
                        $paid_by = 'Stripe';
                        $transaction = array(
                            'client_id' => $client,
                            'othersdeposit' => $amount,
                            'date' => strtotime(date('d-m-Y')),
                            'date_string' => date('d-m-Y'),
                            'paid_by' => $paid_by,
                            'paidtype' => $type,
                            'invoice' => $paymentid,
                            'transaction_id' => $transaction_id,
                        );

                        $this->finance_model->addTransaction($transaction);
                        $this->session->set_flashdata('feedback', 'Added');
                        redirect('finance/paymentDetailsByClient?id=' . $client);
                    }
                } if ($type == 'card' && $gateway == 'PayPal') {
                    $cardtype = $this->input->post('cardtype');
                    $card = $this->input->post('card');
                    $expire = $this->input->post('expire');
                    $cvv = $this->input->post('cvv');
                    $this->form_validation->set_rules('cardtype', 'Card Type', 'required|trim|xss_clean');
                    $this->form_validation->set_rules('card', 'Card', 'required|trim|xss_clean');
                    $this->form_validation->set_rules('expire', 'Expire', 'required|trim|xss_clean');
                    $this->form_validation->set_rules('cvv', 'CVV', 'required|trim|xss_clean');
                    if ($this->form_validation->run() == true) {
                        
                    } else {
                        $clientdetails = $this->client_model->getClientById($client);
                        $paypal = array(
                            'client' => $clientdetails->name,
                            'card' => $card,
                            'expire' => $expire,
                            'cvv' => $cvv,
                            'amount' => $amount,
                            'currency' => 'USD'
                        );
                        $charge = $this->pgateway->doPaymentPayPal($paypal);
                        $transaction_id = $charge;
                        $paid_by = 'PayPal';

                        $transaction = array(
                            'client_id' => $client,
                            'othersdeposit' => $amount,
                            'date' => strtotime(date('d-m-Y')),
                            'date_string' => date('d-m-Y'),
                            'paid_by' => $paid_by,
                            'paidtype' => $type,
                            'invoice' => $paymentid,
                            'transaction_id' => $transaction_id,
                        );
                        $this->finance_model->addTransaction($transaction);
                        $this->session->set_flashdata('feedback', 'Added');

                        redirect('finance/paymentDetailsByClient?id=' . $client);
                    }
                } if ($type == 'card' && $gateway == 'PayU Money') {
                    $this->finance_model->insertPayment($data);
                    $inserted_id = $this->db->insert_id();
                    $payu = array(
                        'client' => $client,
                        'amount' => $amount,
                        'paymentid' => $paymentid,
                    );

                    $this->payu->check2($amount, $payu);
                }

                //
            } else {

                $data = array(
                    'category_name' => $category_name,
                    'client' => $client,
                    'amount' => $sub_total,
                    'discount' => $discount,
                    'flat_discount' => $flat_discount,
                    'gross_total' => $gross_total,
                    'user' => $user
                );
                $initialdeposit = $this->input->post('initialdeposit');

                $initialdepositid = $this->input->post('initialdepositid');
                $datainitialdeposit = array(
                    'paid_amount' => $initialdeposit);
                $update = $this->finance_model->updateTransaction($initialdepositid, $datainitialdeposit);
                $othersdeposits = $this->input->post('othersdeposit');

                $othersdepositids = $this->input->post('othersdepositid');
                if (!empty($othersdepositids)) {
                    $i = 0;
                    foreach ($othersdeposits as $othersdeposit) {
                        $dataupdatewhere = array(
                            'othersdeposit' => $othersdeposit
                        );
                        $update = $this->finance_model->updateTransaction($othersdepositids[$i], $dataupdatewhere);
                        $i = $i + 1;
                    }
                }

                $this->finance_model->updatePayment($id, $data);

                $this->session->set_flashdata('feedback', 'Updated');
                redirect("finance/invoice?id=" . "$id");
            }
        }
    }

    function deleteTransaction() {
        $id = $this->input->get('id');
        $clientid = $this->input->get('clientid');

        $this->finance_model->deleteTransaction($id);
        redirect('finance/paymentDetailsByClient?id=' . $clientid);
    }

}

/* End of file finance.php */
/* Location: ./application/modules/finance/controllers/finance.php */