<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Email extends MX_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('supplier/supplier_model');
        $this->load->model('accountant/accountant_model');
        $this->load->model('email/email_model');
        if (!$this->ion_auth->in_group(array('admin', 'Accountant'))) {
            redirect('home/permission');
        }
    }

    public function index() {
        $data = array();
        $id = $this->ion_auth->get_user_id();
        $data['email'] = $this->email_model->getProfileById($id);
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('profile', $data);
        $this->load->view('home/footer'); // just the footer file
    }

    public function sendView() {
        $data = array();
        $id = $this->ion_auth->get_user_id();
        $data['settings'] = $this->settings_model->getSettings();
        $type = 'email';
        $data['templates'] = $this->email_model->getTemplate($type);
        $data['shortcode'] = $this->email_model->getTag();
        $data['email'] = $this->email_model->getEmailSettingsById($id);
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('sendview', $data);
        $this->load->view('home/footer', $data); // just the footer file
    }

    public function settings() {
        $data = array();
        $id = $this->ion_auth->get_user_id();
        $data['settings'] = $this->settings_model->getSettings();
        $data['settings1'] = $this->email_model->getEmailSettingsById($id);

        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('settings', $data);
        $this->load->view('home/footer', $data); // just the footer file // just the footer file
    }

    public function addNewSettings() {

        $id = $this->input->post('id');
        $email = $this->input->post('email');

        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        // Validating Name Field
        $this->form_validation->set_rules('email', 'Admin Email', 'trim|required|min_length[1]|max_length[100]|xss_clean');
        // Validating Password Field
        $this->form_validation->set_rules('password', 'Password', 'trim|min_length[1]|max_length[100]|xss_clean');
        // Validating Email Field
        $this->form_validation->set_rules('api_id', 'Api Id', 'trim|min_length[1]|max_length[100]|xss_clean');

        if ($this->form_validation->run() == FALSE) {
            $data = array();
            $id = $this->ion_auth->get_user_id();
            $data['settings'] = $this->settings_model->getSettings();
            $data['email'] = $this->email_model->getEmailSettingsById($id);
            $this->load->view('home/dashboard', $data); // just the header file
            $this->load->view('settings', $data);
            $this->load->view('home/footer', $data); // just the footer file
        } else {
            $data = array();
            $data = array(
                'admin_email' => $email,
            );
            if (empty($this->email_model->getEmailSettingsById($id)->admin_email)) {
                $this->email_model->addEmailSettings($data);
                $this->session->set_flashdata('feedback', 'Added');
            } else {
                $this->email_model->updateEmailSettings($data);
                $this->session->set_flashdata('feedback', 'Updated');
            }
            redirect('email/settings');
        }
    }

    function send() {
        $countfiles = count($_FILES['files']['name']);
        if ($_FILES['files']['name'] != NULL) {
            // Looping all files
            for ($i = 0; $i < $countfiles; $i++) {

                if (!empty($_FILES['files']['name'][$i])) {

                    // Define new $_FILES array - $_FILES['file']
                    $_FILES['file']['name'] = $_FILES['files']['name'][$i];
                    $_FILES['file']['type'] = $_FILES['files']['type'][$i];
                    $_FILES['file']['tmp_name'] = $_FILES['files']['tmp_name'][$i];
                    $_FILES['file']['error'] = $_FILES['files']['error'][$i];
                    $_FILES['file']['size'] = $_FILES['files']['size'][$i];
                    $file_name_pieces = explode('_', $_FILES['file']['name']);
                    $new_file_name = '';
                    $count = 1;
                    foreach ($file_name_pieces as $piece) {
                        if ($count !== 1) {
                            $piece = ucfirst($piece);
                        }

                        $new_file_name .= $piece;
                        $count++;
                    }
                    $config = array();
                    $config = array(
                        'file_name' => $new_file_name,
                        'upload_path' => "./uploads/",
                        'allowed_types' => "gif|jpg|jpeg|png|iso|dmg|zip|rar|doc|docx|xls|xlsx|ppt|pptx|csv|ods|odt|odp|pdf|rtf|sxc|sxi|txt",
                        'overwrite' => False,
                        'max_size' => "200000000", // Can be set to particular file size , here it is 2 MB(2048 Kb)
                    );

                    //Load upload library
                    $this->load->library('upload', $config);
                    $this->upload->initialize($config);
                    // File upload
                    if ($this->upload->do_upload('file')) {
                        // Get data about the file
                        $uploadData = $this->upload->data();
                        $filename = "uploads/" . $uploadData['file_name'];

                        // Initialize array
                        $updateData[$i] = $filename;
                    }
                }
            }
        }

        if ($countfiles > 1) {
            $upload = implode(',', $updateData);
        } else {
            $upload = $updateData[0];
        }
        $userId = $this->ion_auth->get_user_id();
        $is_v_v = $this->input->post('radio');
        $emailSettings = $this->email_model->getEmailSettings();
        $settings = $this->settings_model->getSettings();
        if ($is_v_v == 'allsupplier') {
            $suppliers = $this->supplier_model->getSupplier();
            foreach ($suppliers as $supplier) {
                $to[] = $supplier->email;
                $message = $this->input->post('message');
                $name = explode(' ', $supplier->name);
                if (!isset($name[1])) {
                    $name[1] = null;
                }
                $data1 = array(
                    'firstname' => $name[0],
                    'lastname' => $name[1],
                    'name' => $supplier->name,
                    'phone' => $supplier->phone,
                    'email' => $supplier->email,
                    'address' => $supplier->address,
                    'companyname' => $settings->system_vendor
                );
                $messageprint = $this->parser->parse_string($message, $data1);
                $data2[] = array($supplier->email => $messageprint);
            }
            $recipient = 'All Supplier';
        }

        if ($is_v_v == 'allstaff') {
            $staffs = $this->accountant_model->getAccountant();

            foreach ($staffs as $staff) {
                $to[] = $staff->email;
                $message = $this->input->post('message');
                $name = explode(' ', $staff->name);
                if (!isset($name[1])) {
                    $name[1] = null;
                }
                $data1 = array(
                    'firstname' => $name[0],
                    'lastname' => $name[1],
                    'name' => $staff->name,
                    'phone' => $staff->phone,
                    'email' => $staff->email,
                    'address' => $staff->address,
                    'companyname' => $settings->system_vendor
                );
                $messageprint = $this->parser->parse_string($message, $data1);
                $data2[] = array($staff->email => $messageprint);
            }
            $recipient = 'All Staff';
        }

        if ($is_v_v == 'single_supplier') {

            $supplier = $this->input->post('supplier');

            $supplier_detail = $this->supplier_model->getSupplierById($supplier);
            $single_supplier_email = $supplier_detail->email;

            $message = $this->input->post('message');
            $name = array();
            $name = explode(' ', $supplier_detail->name);
            if (!isset($name[1])) {
                $name[1] = null;
            }
            $data1 = array();
            $data1 = array(
                'firstname' => $name[0],
                'lastname' => $name[1],
                'name' => $supplier_detail->name,
                'phone' => $supplier_detail->phone,
                'email' => $supplier_detail->email,
                'address' => $supplier_detail->address,
                'companyname' => $settings->system_vendor
            );
            $messageprint = $this->parser->parse_string($message, $data1);
            $data2[] = array($supplier_detail->email => $messageprint);
            $recipient = 'Supplier Id: ' . $supplier_detail->id . '<br> Supplier Name: ' . $supplier_detail->name . '<br> Supplier Email: ' . $supplier_detail->email;
        }
        if ($is_v_v == 'single_staff') {

            $staff = $this->input->post('staff');

            $staff_detail = $this->accountant_model->getAccountantById($staff);
            $single_staff_email = $staff_detail->email;
            $message = $this->input->post('message');
            $name = array();
            $name = explode(' ', $staff_detail->name);
            if (!isset($name[1])) {
                $name[1] = null;
            }
            $data1 = array();
            $data1 = array(
                'firstname' => $name[0],
                'lastname' => $name[1],
                'name' => $staff_detail->name,
                'phone' => $staff_detail->phone,
                'email' => $staff_detail->email,
                'address' => $staff_detail->address,
                'companyname' => $settings->system_vendor
            );
            $messageprint = $this->parser->parse_string($message, $data1);
            $data2[] = array($staff_detail->email => $messageprint);
            $recipient = 'Employee Id: ' . $staff_detail->id . '<br> Employee Name: ' . $staff_detail->name . '<br> Employee Email: ' . $staff_detail->email;
        }

        if (!empty($single_supplier_email)) {
            $to1 = $single_supplier_email;
        }  else {
            if (!empty($to)) {
                $to1 = implode(',', $to);
            }
        }
        if (!empty($single_staff_email)) {
            $to1 = $single_staff_email;
        } else {
            if (!empty($to1)) {
                $to1 = implode(',', $to);
            }
        }

        if (!empty($to1)) {
           
            $subject = $this->input->post('subject');


            foreach ($data2 as $key => $value) {
                foreach ($value as $key2 => $value2) {


                    if ($upload != NULL) {
                        $this->email->from($emailSettings->admin_email);
                        $this->email->to($key2);
                        $this->email->subject($subject);
                        $this->email->message($value2);

                        $uploadExtract = explode(',', $upload);
                        foreach ($uploadExtract as $uploads) {
                            $this->email->attach($uploads);
                        }
                    } else {
                        $this->email->from($emailSettings->admin_email);
                        $this->email->to($key2);
                        $this->email->subject($subject);
                        $this->email->message($value2);
                    }

                    $this->email->send();
                    $data = array();
                    $date = time();
                    if (!empty($_FILES['files']['name'])) {

                        $dateinformat = date('h:i:s a m/d/y', $date);
                        $data = array(
                            'subject' => $subject,
                            'message' => $message,
                            'date' => $date,
                            'dateformat' => $dateinformat,
                            'reciepient' => $recipient,
                            'user' => $this->ion_auth->get_user_id(),
                            'path' => $upload
                        );
                    } else {
                        $data = array(
                            'subject' => $subject,
                            'message' => $message,
                            'date' => $date,
                           
                            'reciepient' => $recipient,
                            'user' => $this->ion_auth->get_user_id(),
                        );
                    }
                    $this->email_model->insertEmail($data);
                }
            }
            $this->session->set_flashdata('feedback', 'Message Sent');
            //array end here
        } else {
            $this->session->set_flashdata('feedback', 'Not Sent');
        }
        redirect('email/sendView');
    }



    function getEmailList() {
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];

        if ($limit == -1) {
            if (!empty($search)) {
                $data['cases'] = $this->email_model->getEmailBySearch($search);
            } else {
                $data['cases'] = $this->email_model->getEmail();
            }
        } else {
            if (!empty($search)) {
                $data['cases'] = $this->email_model->getEmailByLimitBySearch($limit, $start, $search);
            } else {
                $data['cases'] = $this->email_model->getEmailByLimit($limit, $start);
            }
        }
        $i = 0;
        foreach ($data['cases'] as $case) {
            $i = $i + 1;
            if ($this->ion_auth->in_group(array('admin'))) {

                $options2 = '<a class="btn btn-info btn-xs btn_width delete_button" title="' . lang('delete') . '" href="email/delete?id=' . $case->id . '&redirect=email" onclick="return confirm(\'Are you sure you want to delete this item?\');"><i class="fa fa-trash"></i></a>';
            }


            $info[] = array(
                $i,
                date('h:i:s a m/d/y', $case->date),
                $case->message,
                $case->reciepient,
                $options2
            );
        }

        if (!empty($data['cases'])) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => $this->db->get('email')->num_rows(),
                "recordsFiltered" => $this->db->get('email')->num_rows(),
                "data" => $info
            );
        } else {
            $output = array(
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }

    function sent() {
        if ($this->ion_auth->in_group(array('admin'))) {
            $data['sents'] = $this->email_model->getEmail();
        } else {
            $current_user_id = $this->ion_auth->user()->row()->id;
            $data['sents'] = $this->email_model->getEmailByUser($current_user_id);
        }
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data);
        $this->load->view('email', $data);
        $this->load->view('home/footer', $data);
    }

    function delete() {
        $id = $this->input->get('id');
        $this->email_model->delete($id);
        $this->session->set_flashdata('feedback', 'Deleted');
        redirect('email/sent');
    }

    function emailTemplate() {
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data);
        $this->load->view('addEmailTemplate');
        $this->load->view('home/footer');
    }

    function editAutoEmailTemplate() {
        $id = $this->input->get('id');
        $data['autotemplatename'] = $this->email_model->getAutoEmailTemplatebyId($id);
        $type = $data['autotemplatename']->type;
        $data['autotag'] = $this->email_model->getShortCodebyType($type);
        echo json_encode($data);
    }

    function getAutoTemplateList() {
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];

        if ($limit == -1) {
            if (!empty($search)) {
                $data['cases'] = $this->email_model->getAutoTemplateBySearch($search);
            } else {
                $data['cases'] = $this->email_model->getAutoTemplate();
            }
        } else {
            if (!empty($search)) {
                $data['cases'] = $this->email_model->getAutoTemplateByLimitBySearch($limit, $start, $search);
            } else {
                $data['cases'] = $this->email_model->getAutoTemplateByLimit($limit, $start);
            }
        }
        $i = 0;
        $count = 0;
        foreach ($data['cases'] as $case) {
            $i = $i + 1;
            if ($this->ion_auth->in_group(array('admin'))) {

                $options1 = ' <a type="button" class="btn btn-success btn-xs btn_width editbutton1" title="' . lang('edit') . '" data-toggle = "modal" data-id="' . $case->id . '"><i class="fa fa-edit"> </i></a>';
            }
            $info[] = array(
                '<i class="fa fa-check-circle"></i> ' . $case->name,
                $case->message,
                $case->status,
                $options1
            );
            $count = $count + 1;
        }

        if (!empty($data['cases'])) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => $count,
                "recordsFiltered" => $count,
                "data" => $info
            );
        } else {
            $output = array(
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }

    public function addNewAutoTemplate() {
        $message = $this->input->post('message');
        $name = $this->input->post('category');
        $status = $this->input->post('status');
        $id = $this->input->post('id');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        $this->form_validation->set_rules('message', 'Message', 'trim|xss_clean|required');
        if ($this->form_validation->run() == FALSE) {

            $data['settings'] = $this->settings_model->getSettings();
            $data['shortcode'] = $this->email_model->getTag();
            $this->load->view('home/dashboard', $data);
            $this->load->view('addEmailTemplate');
            $this->load->view('home/footer');
        } else {
            $data = array();
            $data = array(
                'name' => $name,
                'message' => $message,
                'status' => $status,
            );

            $this->email_model->updateAutoTemplate($data, $id);
            $this->session->set_flashdata('feedback', 'Updated');

            redirect('email/emailTemplate');
        }
    }

    public function addNewTemplate() {
        $message = $this->input->post('message');
        $name = $this->input->post('name');
        $type = $this->input->post('type');
        $id = $this->input->post('id');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        // Validating 
        $this->form_validation->set_rules('message', 'Message', 'trim|xss_clean|required');

        // Validating 
        $this->form_validation->set_rules('name', 'Name', 'trim|xss_clean|required');
        if ($this->form_validation->run() == FALSE) {
            if (!empty($id)) {
                $data = array();
                $data['settings'] = $this->settings_model->getSettings();
                $data['templatename'] = $this->email_model->getTemplateById($id, $type);
                $data['shortcode'] = $this->email_model->getTag();
                $this->load->view('home/dashboard', $data); // just the header file
                $this->load->view('addtemplate', $data);
                $this->load->view('home/footer', $data); // just the footer file
            } else {
                $data = array();
                $data['setval'] = 'setval';
                $data['settings'] = $this->settings_model->getSettings();
                $data['shortcode'] = $this->email_model->getTag();
                $this->load->view('home/dashboard', $data); // just the header file
                $this->load->view('addtemplate', $data);
                $this->load->view('home/footer', $data); // just the footer file
            }
        } else {
            $data = array();
            $data = array(
                'name' => $name,
                'message' => $message,
                'type' => $type
            );
            if (empty($id)) {
                $this->email_model->addTemplate($data);
                $this->session->set_flashdata('feedback', 'Added');
            } else {
                $this->email_model->updateTemplate($data, $id);
                $this->session->set_flashdata('feedback', 'Updated');
            }
            redirect('email/emailManualTemplate');
        }
    }

    public function getTemplateText() {
        $id = $this->input->get('id');
        $type = $this->input->get('type');
        $data['user'] = $this->email_model->getTemplateById($id, $type);
        echo json_encode($data);
    }

    public function emailManualTemplate() {
        $data['settings'] = $this->settings_model->getSettings();
        $data['shortcode'] = $this->email_model->getTag();
        $this->load->view('home/dashboard', $data);
        $this->load->view('email_template', $data);
        $this->load->view('home/footer', $data);
    }

    public function editEmailTemplate() {
        $id = $this->input->get('id');
        $type = $this->input->get('type');

        $data['templatename'] = $this->email_model->getTemplateById($id, $type);

        echo json_encode($data);
    }

    function getTemplateList() {
        $type = $this->input->post('type');
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];

        if ($limit == -1) {
            if (!empty($search)) {
                $data['cases'] = $this->email_model->getTemplateBySearch($search, $type);
            } else {
                $data['cases'] = $this->email_model->getManualTemplate($type);
            }
        } else {
            if (!empty($search)) {
                $data['cases'] = $this->email_model->getTemplateByLimitBySearch($limit, $start, $search, $type);
            } else {
                $data['cases'] = $this->email_model->getTemplateByLimit($limit, $start, $type);
            }
        }
        $i = 0;
        $count = 0;
        foreach ($data['cases'] as $case) {
            $i = $i + 1;
            if ($this->ion_auth->in_group(array('admin'))) {

                $options1 = ' <a type="button" class="btn btn-success btn-xs btn_width editbutton1" title="' . lang('edit') . '" data-toggle = "modal" data-id="' . $case->id . '"><i class="fa fa-edit"> </i></a>';
                $options2 = '<a class="btn btn-danger btn-xs btn_width" title="' . lang('delete') . '" href="email/deleteTemplate?id=' . $case->id . '&redirect=sms/smsTemplate" onclick="return confirm(\'Are you sure you want to delete this item?\');"><i class="fa fa-trash"></i></a>';
            }
            $info[] = array(
                $i,
                $case->name,
                ' ' . $options1 . ' ' . $options2
            );
            $count = $count + 1;
        }

        if (!empty($data['cases'])) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => $count,
                "recordsFiltered" => $count,
                "data" => $info
            );
        } else {
            $output = array(
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }

    public function deleteTemplate() {
        $id = $this->input->get('id');
        $this->email_model->deleteTemplate($id);
        $this->session->set_flashdata('feedback', 'Deleted');
        redirect('email/emailManualTemplate');
    }

    public function getTemplateinfo() {
        // Search term
        $searchTerm = $this->input->post('searchTerm');
        $type = 'email';
        // Get users
        $response = $this->email_model->gettemplates($searchTerm, $type);

        echo json_encode($response);
    }

}

/* End of file profile.php */
/* Location: ./application/modules/profile/controllers/profile.php */
