<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Bank_model extends CI_model {

    function __construct() {
        parent::__construct();
        $this->load->database();
    }

    function insertBank($data) {
        $this->db->insert('bank', $data);
    }

    function getBank() {
        $query = $this->db->get('bank');
        return $query->result();
    }

  

    function getBankById($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('bank');
        return $query->row();
    }

   
    function updateBank($id, $data) {
        $this->db->where('id', $id);
        $this->db->update('bank', $data);
    }

    function delete($id) {
        $this->db->where('id', $id);
        $this->db->delete('bank');
    }

   
    function getbankBySearch($search) {
        $this->db->order_by('id', 'desc');
        $this->db->like('id', $search);
        $this->db->or_like('name', $search);
        $query = $this->db->get('bank');
        return $query->result();
    }

    function getbankByLimit($limit, $start) {
        $this->db->order_by('id', 'desc');
        $this->db->limit($limit, $start);
        $query = $this->db->get('bank');
        return $query->result();
    }

    function getbankByLimitBySearch($limit, $start, $search) {

        $this->db->like('id', $search);

        $this->db->order_by('id', 'desc');

        $this->db->or_like('name', $search);
       
        $this->db->limit($limit, $start);
        $query = $this->db->get('bank');
        return $query->result();
    }

}
