<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Bank extends MX_Controller {

    function __construct() {
        parent::__construct();

        $this->load->model('bank_model');
        $this->load->model('bank/transaction_model');
        if (!$this->ion_auth->in_group('admin')) {
            redirect('home/permission');
        }
    }

    public function index() {


        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('bank', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function addNewView() {
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('add_new');
        $this->load->view('home/footer'); // just the header file
    }

    public function editBankByJason() {
        $id = $this->input->get('id');
        $data['bank'] = $this->bank_model->getBankById($id);
        echo json_encode($data);
    }

    public function addNew() {

        $name = $this->input->post('name');
        $id = $this->input->post('id');
        $description = $this->input->post('description');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        $this->form_validation->set_rules('name', 'Name', 'trim|required|min_length[1]|max_length[100]|xss_clean');
        if ($this->form_validation->run() == FALSE) {

            $data['settings'] = $this->settings_model->getSettings();
            $this->load->view('home/dashboard', $data); // just the header file
            $this->load->view('add_new', $data);
            $this->load->view('home/footer'); // just the header file
        } else {
            $data = array();
            $data = array(
                'name' => $name,
                'description' => $description
            );
            if (!empty($id)) {
                $this->bank_model->updateBank($id, $data);
                $this->session->set_flashdata('feedback', 'Updated');
            } else {
                $this->bank_model->insertBank($data);
                $this->session->set_flashdata('feedback', 'Added');
            }
            redirect('bank');
        }
    }

    function delete() {
        $id = $this->input->get('id');
        $this->bank_model->delete($id);
        $this->session->set_flashdata('feedback', 'Deleted');
        redirect('bank');
    }

    public function getBankList() {
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];
        if ($limit == -1) {
            if (!empty($search)) {
                $data['bank'] = $this->bank_model->getbankBySearch($search); //done
            } else {
                $data['bank'] = $this->bank_model->getBank(); //done
            }
        } else {
            if (!empty($search)) {
                $data['bank'] = $this->bank_model->getbankByLimitBySearch($limit, $start, $search); //done
            } else {
                $data['bank'] = $this->bank_model->getbankByLimit($limit, $start); //done
            }
        }
        foreach ($data['bank'] as $banks) {

            if ($this->ion_auth->in_group(array('admin'))) {
                $options1 = ' <a type="button" class="btn btn btn-xs editbutton" title="' . lang('edit') . '" data-toggle = "modal" data-id="' . $banks->id . '"><i class="fa fa-edit"> </i> ' . lang('edit') . '</a>';
                $options2 = ' <a type="button" class="btn btn btn-xs detailsbutton" title="' . lang('details') . '"href="bank/details?id=' . $banks->id . '"><i class="fa fa-edit"> </i> ' . lang('details') . '</a>';
            }


            if ($this->ion_auth->in_group(array('admin'))) {
                $options5 = '<a class="btn btn-xs delete_button" title="' . lang('delete') . '" href="bank/delete?id=' . $banks->id . '" onclick="return confirm(\'Are you sure you want to delete this item?\');"><i class="fa fa-trash"></i> ' . lang('delete') . '</a>';
            }


            $info[] = array(
                $banks->name,
                $banks->description,
                $options1 . ' ' . $options2 . ' ' . $options5,
            );
        }

        if (!empty($data['bank'])) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => $this->db->get('bank')->num_rows(),
                "recordsFiltered" => $this->db->get('bank')->num_rows(),
                "data" => $info
            );
        } else {
            $output = array(
                // "draw" => 1,
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }

    public function details() {
        $bank = $this->input->get('id');
        $data = array();
        $data['id'] = $bank;
        $data['bankdetails'] = $this->bank_model->getBankById($bank);
        $data['transactiondetails'] = $this->transaction_model->getTransactionByBank($bank);
        $creditbalance = array();
        $debitbalance = array();
        if (!empty($data['transactiondetails'])) {
            foreach ($data['transactiondetails'] as $transaction) {
                if ($transaction->tran_type == 'credit') {
                    $creditbalance[] = $transaction->amount;
                }
                if ($transaction->tran_type == 'debit') {
                    $debitbalance[] = $transaction->amount;
                }
            }
        }
        if (!empty($creditbalance)) {
            $data['credit'] = array_sum($creditbalance);
        } else { 
            $data['credit'] = 0; 
        }
        if (!empty($debitbalance)) {
            $data['debit'] = array_sum($debitbalance);
        } else {
            $data['debit'] = 0;
        }
        $data['balance'] = $data['credit'] - $data['debit'];
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('transaction_details_by_bank', $data);
        $this->load->view('home/footer'); // just the header file
    }

    function getTransactionListByBank() {
        
    }

}

/* End of file client.php */
/* Location: ./application/modules/client/controllers/client.php */
