<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Accountant extends MX_Controller {

    function __construct() {
        parent::__construct();
        $this->load->module('sms');
        $this->load->model('accountant_model');
        $this->load->model('settings/settings_model');
        if (!$this->ion_auth->in_group('admin')) {
            redirect('home/permission');
        }
    }

    public function index() {

        $data['accountants'] = $this->accountant_model->getAccountant();
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('accountant', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function addNewView() {
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('add_new');
        $this->load->view('home/footer'); // just the header file
    }

    public function addNew() {

        $id = $this->input->post('id');
        $name = $this->input->post('name');
        $password = $this->input->post('password');
        $email = $this->input->post('email');
        $address = $this->input->post('address');
        $phone = $this->input->post('phone');
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');

        // Validating Name Field
        $this->form_validation->set_rules('name', 'Name', 'trim|required|min_length[1]|max_length[100]|xss_clean');
        // Validating Password Field
        if (empty($id)) {
            $this->form_validation->set_rules('password', 'Password', 'trim|required|min_length[5]|max_length[100]|xss_clean');
        }
        // Validating Email Field
        $this->form_validation->set_rules('email', 'Email', 'trim|required|min_length[2]|max_length[100]|xss_clean');
        // Validating Address Field   
        $this->form_validation->set_rules('address', 'Address', 'trim|required|min_length[1]|max_length[500]|xss_clean');
        // Validating Phone Field           
        $this->form_validation->set_rules('phone', 'Phone', 'trim|required|min_length[5]|max_length[50]|xss_clean');

        if ($this->form_validation->run() == FALSE) {
            if (!empty($id)) {
                redirect("accountant/editAccountant?id=$id");
            } else {
                $data['settings'] = $this->settings_model->getSettings();
                $this->load->view('home/dashboard', $data); // just the header file
                $this->load->view('add_new');
                $this->load->view('home/footer'); // just the header file
            }
        } else {
            $file_name = $_FILES['img_url']['name'];
            $file_name_pieces = explode('_', $file_name);
            $new_file_name = '';
            $count = 1;
            foreach ($file_name_pieces as $piece) {
                if ($count !== 1) {
                    $piece = ucfirst($piece);
                }

                $new_file_name .= $piece;
                $count++;
            }
            $config = array(
                'file_name' => $new_file_name,
                'upload_path' => "./uploads/",
                'allowed_types' => "gif|jpg|png|jpeg|pdf",
                'overwrite' => False,
                'max_size' => "20480000", // Can be set to particular file size , here it is 2 MB(2048 Kb)
                'max_height' => "1768",
                'max_width' => "2024"
            );

            $this->load->library('Upload', $config);
            $this->upload->initialize($config);

            if ($this->upload->do_upload('img_url')) {
                $path = $this->upload->data();
                $img_url = "uploads/" . $path['file_name'];
                $data = array();
                $data = array(
                    'img_url' => $img_url,
                    'name' => $name,
                    'email' => $email,
                    'address' => $address,
                    'phone' => $phone
                );
            } else {
                $data = array();
                $data = array(
                    'name' => $name,
                    'email' => $email,
                    'address' => $address,
                    'phone' => $phone
                );
            }

            $username = $this->input->post('name');

            if (empty($id)) {     // Adding New Accountant
                if ($this->ion_auth->email_check($email)) {
                    $this->session->set_flashdata('feedback', 'This Email Address Is Already Registered');
                    redirect('accountant/addNewView');
                } else {
                    $dfg = 3;
                    $this->ion_auth->register($username, $password, $email, $dfg);
                    $ion_user_id = $this->db->get_where('users', array('email' => $email))->row()->id;
                    $this->accountant_model->insertAccountant($data);
                    $accountant_user_id = $this->db->get_where('accountant', array('email' => $email))->row()->id;
                    $id_info = array('ion_user_id' => $ion_user_id);
                    $this->accountant_model->updateAccountant($accountant_user_id, $id_info);
                    $this->session->set_flashdata('feedback', 'Added');
                }
                $send_email = $this->db->get_where('autoEmailTemplate', array('id =' => 3))->row();
                $send_sms = $this->db->get_where('autoSmsTemplate', array('id =' => 2))->row();
                  $setings11 = $this->settings_model->getSettings();
                if ($send_sms->status == 'Active') {
                    $send_user = $this->db->get_where('accountant', array('email =' => $email))->row();
                    $data1 = array(
                        'name' => $send_user->name,
                        'companyname' => $setings11->system_vendor
                    );
                    $message = $this->parser->parse_string($send_sms->message, $data1);
                    $data3[] = array($send_user->phone => $message);
                    $this->sms->sendSms($send_user->phone, $message, $data3);
                }
                if ($send_email->status == 'Active') {
                    $send_user = $this->db->get_where('accountant', array('email =' => $email))->row();
                    $data2 = array(
                        'name' => $send_user->name,
                        'companyname' => $setings11->system_vendor
                    );
                    $message = $this->parser->parse_string($send_email->message, $data2);
                    $emailSettings = $this->db->get_where('email_settings', array('id =' => 1))->row();
                    $this->email->from($emailSettings->admin_email);
                    $this->email->to($send_user->email);
                    $this->email->subject('Registration Successful');
                    $this->email->message($message);
                    $this->email->send();
                }
            } else { // Updating Accountant
                $ion_user_id = $this->db->get_where('accountant', array('id' => $id))->row()->ion_user_id;
                if (empty($password)) {
                    $password = $this->db->get_where('users', array('id' => $ion_user_id))->row()->password;
                } else {
                    $password = $this->ion_auth_model->hash_password($password);
                }
                $this->accountant_model->updateIonUser($username, $email, $password, $ion_user_id);
                $this->accountant_model->updateAccountant($id, $data);
                $this->session->set_flashdata('feedback', 'Updated');
            }
            // Loading View
            redirect('accountant');
        }
    }

    function getAccountant() {
        $data['accountants'] = $this->accountant_model->getAccountant();
        $this->load->view('accountant', $data);
    }

    function editAccountant() {
        $data = array();
        $id = $this->input->get('id');
        $data['accountant'] = $this->accountant_model->getAccountantById($id);
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('add_new', $data);
        $this->load->view('home/footer'); // just the footer file
    }

    function editAccountantByJason() {
        $id = $this->input->get('id');
        $data['accountant'] = $this->accountant_model->getAccountantById($id);
        echo json_encode($data);
    }

    function delete() {
        $data = array();
        $id = $this->input->get('id');
        $user_data = $this->db->get_where('accountant', array('id' => $id))->row();
        $path = $user_data->img_url;

        if (!empty($path)) {
            unlink($path);
        }
        $ion_user_id = $user_data->ion_user_id;
        $this->db->where('id', $ion_user_id);
        $this->db->delete('users');
        $this->accountant_model->delete($id);
        $this->session->set_flashdata('feedback', 'Deleted');
        redirect('accountant');
    }

    function getAccountantList() {
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];
        if ($limit == -1) {
            if (!empty($search)) {
                $data['accountants'] = $this->accountant_model->getAccountantBySearch($search); //done
            } else {
                $data['accountants'] = $this->accountant_model->getAccountant(); //done
            }
        } else {
            if (!empty($search)) {
                $data['accountants'] = $this->accountant_model->getAccountantByLimitBySearch($limit, $start, $search); //done
            } else {
                $data['accountants'] = $this->accountant_model->getAccountantByLimit($limit, $start); //done
            }
        }
        $options5 = '';
        foreach ($data['accountants'] as $accountant) {

            if ($this->ion_auth->in_group(array('admin'))) {
                $options1 = ' <a type="button" class="btn btn-xs editbutton" title="' . lang('edit') . '" data-toggle = "modal" data-id="' . $accountant->id . '"><i class="fa fa-edit"> </i> ' . lang('edit') . '</a>';
            }
            $option7 = '<img  src="' . $accountant->img_url . '" width="80px;">';
            if ($this->ion_auth->in_group(array('admin'))) {
                $options5 = '<a class="btn btn-xs delete_button" title="' . lang('delete') . '" href="accountant/delete?id=' . $accountant->id . '" onclick="return confirm(\'Are you sure you want to delete this item?\');"><i class="fa fa-trash"></i> ' . lang('delete') . '</a>';
            }


            if ($this->ion_auth->in_group(array('admin'))) {
                $info[] = array(
                    $option7,
                    $accountant->name,
                    $accountant->email,
                    $accountant->phone,
                    $accountant->address,
                    $options1 . ' ' . $options5,
                );
            }
        }

        if (!empty($data['accountants'])) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => $this->db->get('accountant')->num_rows(),
                "recordsFiltered" => $this->db->get('accountant')->num_rows(),
                "data" => $info
            );
        } else {
            $output = array(
                // "draw" => 1,
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }

}

/* End of file accountant.php */
/* Location: ./application/modules/accountant/controllers/accountant.php */
