<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Supplier_model extends CI_model {

    function __construct() {
        parent::__construct();
        $this->load->database();
    }

    function insertSupplier($data) {
        $this->db->insert('supplier', $data);
    }
    
    public function featureSuppliers() {
       $this->db->order_by('rand()');
       $this->db->limit(1);
       $query = $this->db->get('supplier');
       return $query->result_array();

    }
    

    function getSupplier() {
        $this->db->order_by('id', 'desc');
        $query = $this->db->get('supplier');
        return $query->result();
    }

    function getSupplierBySearch($search) {
        $this->db->order_by('id', 'desc');
        $this->db->like('id', $search);
        $this->db->or_like('name', $search);
        $this->db->or_like('email', $search);
        $this->db->or_like('phone', $search);
        $query = $this->db->get('supplier');
        return $query->result();
    }

    function getSupplierByLimit($limit, $start) {
        $this->db->order_by('id', 'desc');
        $this->db->limit($limit, $start);
        $query = $this->db->get('supplier');
        return $query->result();
    }

    function getSupplierByLimitBySearch($limit, $start, $search) {

        $this->db->like('id', $search);

        $this->db->order_by('id', 'desc');
        $this->db->or_like('name', $search);
        $this->db->or_like('email', $search);
        $this->db->or_like('phone', $search);
        $this->db->or_like('address', $search);

        $this->db->limit($limit, $start);
        $query = $this->db->get('supplier');
        return $query->result();
    }

    function getSupplierById($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('supplier');
        return $query->row();
    }
    
    function getSupplierBySId($id) {
        $this->db->where('supplier_id', $id);
        $query = $this->db->get('supplier');
        return $query->row();
    }

    function getSupplierByIonUserId($id) {
        $this->db->where('ion_user_id', $id);
        $query = $this->db->get('supplier');
        return $query->row();
    }

    function getSupplierByEmail($email) {
        $this->db->where('email', $email);
        $query = $this->db->get('supplier');
        return $query->row();
    }

    function updateSupplier($id, $data) {
        $this->db->where('id', $id);
        $this->db->update('supplier', $data);
    }

    function delete($id) {
        $this->db->where('id', $id);
        $this->db->delete('supplier');
    }

    function insertSupplierCategory($data) {
        $this->db->insert('supplier_category', $data);
    }

    function getSupplierCategory() {
        $this->db->order_by("id", "desc");
        $query = $this->db->get('supplier_category');
        return $query->result();
    }

    function getSupplierCategoryById($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('supplier_category');
        return $query->row();
    }

    function updateSupplierCategory($id, $data) {
        $this->db->where('id', $id);
        $this->db->update('supplier_category', $data);
    }

    function deleteSupplierCategory($id) {
        $this->db->where('id', $id);
        $this->db->delete('supplier_category');
    }

    function insertMedicalHistory($data) {
        $this->db->insert('medical_history', $data);
    }

    function getMedicalHistoryBySupplierId($id) {
        $this->db->where('supplier_id', $id);
        $query = $this->db->get('medical_history');
        return $query->result();
    }

    function getMedicalHistory() {
        $this->db->order_by('id', 'desc');
        $query = $this->db->get('medical_history');
        return $query->result();
    }

    function getMedicalHistoryBySearch($search) {
        $this->db->order_by('id', 'desc');
        $this->db->like('id', $search);
        $this->db->or_like('supplier_name', $search);
        $query = $this->db->get('medical_history');
        return $query->result();
    }

    function getMedicalHistoryByLimit($limit, $start) {
        $this->db->order_by('id', 'desc');
        $this->db->limit($limit, $start);
        $query = $this->db->get('medical_history');
        return $query->result();
    }

    function getMedicalHistoryByLimitBySearch($limit, $start, $search) {

        $this->db->like('id', $search);

        $this->db->order_by('id', 'desc');

        $this->db->or_like('supplier_name', $search);
        $this->db->or_like('supplier_phone', $search);
        $this->db->or_like('supplier_address', $search);

        $this->db->or_like('description', $search);

        $this->db->limit($limit, $start);
        $query = $this->db->get('medical_history');
        return $query->result();
    }

    function getMedicalHistoryById($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('medical_history');
        return $query->row();
    }

    function updateMedicalHistory($id, $data) {
        $this->db->where('id', $id);
        $this->db->update('medical_history', $data);
    }

    function insertDiagnosticReport($data) {
        $this->db->insert('diagnostic_report', $data);
    }

    function updateDiagnosticReport($id, $data) {
        $this->db->where('id', $id);
        $this->db->update('diagnostic_report', $data);
    }

    function getDiagnosticReport() {
        $this->db->order_by('id', 'desc');
        $query = $this->db->get('diagnostic_report');
        return $query->result();
    }

    function getDiagnosticReportById($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('diagnostic_report');
        return $query->row();
    }

    function getDiagnosticReportByInvoiceId($id) {
        $this->db->where('invoice', $id);
        $query = $this->db->get('diagnostic_report');
        return $query->row();
    }

    function getDiagnosticReportBySupplierId($id) {
        $this->db->where('supplier', $id);
        $query = $this->db->get('diagnostic_report');
        return $query->result();
    }

    function insertSupplierMaterial($data) {
        $this->db->insert('supplier_material', $data);
    }

    function getSupplierMaterial() {
        $this->db->order_by('id', 'desc');
        $query = $this->db->get('supplier_material');
        return $query->result();
    }

    function getDocumentBySearch($search) {
        $this->db->order_by('id', 'desc');
        $this->db->like('id', $search);
        $this->db->or_like('supplier_name', $search);
        $query = $this->db->get('supplier_material');
        return $query->result();
    }

    function getDocumentByLimit($limit, $start) {
        $this->db->order_by('id', 'desc');
        $this->db->limit($limit, $start);
        $query = $this->db->get('supplier_material');
        return $query->result();
    }

    function getDocumentByLimitBySearch($limit, $start, $search) {

        $this->db->like('id', $search);

        $this->db->order_by('id', 'desc');

        $this->db->or_like('date_string', $search);

        $this->db->or_like('supplier_name', $search);
        $this->db->or_like('supplier_phone', $search);
        $this->db->or_like('supplier_address', $search);

        $this->db->or_like('title', $search);

        $this->db->limit($limit, $start);
        $query = $this->db->get('supplier_material');
        return $query->result();
    }

    function getSupplierMaterialById($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('supplier_material');
        return $query->row();
    }

    function getSupplierMaterialBySupplierId($id) {
        $this->db->where('supplier', $id);
        $query = $this->db->get('supplier_material');
        return $query->result();
    }

    function deleteSupplierMaterial($id) {
        $this->db->where('id', $id);
        $this->db->delete('supplier_material');
    }

    function deleteMedicalHistory($id) {
        $this->db->where('id', $id);
        $this->db->delete('medical_history');
    }

    function updateIonUser($username, $email, $password, $ion_user_id) {
        $uptade_ion_user = array(
            'username' => $username,
            'email' => $email,
            'password' => $password
        );
        $this->db->where('id', $ion_user_id);
        $this->db->update('users', $uptade_ion_user);
    }

    function getDueBalanceBySupplierId($supplier) {
        $query = $this->db->get_where('payment', array('supplier' => $supplier))->result();
        $deposits = $this->db->get_where('supplier_deposit', array('supplier' => $supplier))->result();
        $balance = array();
        $deposit_balance = array();
        foreach ($query as $gross) {
            $balance[] = $gross->gross_total;
        }
        $balance = array_sum($balance);


        foreach ($deposits as $deposit) {
            $deposit_balance[] = $deposit->deposited_amount;
        }
        $deposit_balance = array_sum($deposit_balance);



        $bill_balance = $balance;

        return $due_balance = $bill_balance - $deposit_balance;
    }

}
