<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Supplier extends MX_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('supplier_model');
        $this->load->model('finance/finance_model');
        $this->load->model('sms/sms_model');
        // $this->load->module('sms');
        // $this->load->module('paypal');
        // $this->load->module('payment');

        if (!$this->ion_auth->in_group(array('admin', 'Volunteer'))) {
            redirect('home/permission');
        }
    }

    public function index() {
        if ($this->ion_auth->in_group(array('Supplier'))) {
            redirect('home/permission');
        }
        $data['categorys'] = $this->supplier_model->getSupplierCategory();
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('supplier', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function calendar() {
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('calendar', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function addNewView() {
        if ($this->ion_auth->in_group(array('Supplier'))) {
            redirect('home/permission');
        }
        $data = array();
        $data['areas'] = $this->area_model->getArea();
        $data['categorys'] = $this->supplier_model->getSupplierCategory();
        $data['groups'] = $this->donor_model->getBloodBank();
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('add_new', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function addNew() {

        if ($this->ion_auth->in_group(array('Supplier'))) {
            redirect('home/permission');
        }

        $id = $this->input->post('id');
        $redirect = $this->input->get('redirect');
        $name = $this->input->post('name');
        $password = '12345';
        //$remarks = $this->input->post('remarks');
        $category = $this->input->post('category');
        $address = $this->input->post('address');
        $phone = $this->input->post('phone');
        
        $supplier_id = $this->input->post('supplier_id');
        if (empty($supplier_id)) {
            $supplier_id = rand(10000, 1000000);
        }
        if ((empty($id))) {
            $add_date = date("d-m-y");
            
        } else {
            $add_date = $this->supplier_model->getSupplierById($id)->add_date;   
        }


        $email = $this->input->post('email');
        if (empty($email)) {
            $email = $name . '@keswatech.com';
        }



        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');

        // Validating Name Field
        $this->form_validation->set_rules('name', 'Name', 'trim|required|min_length[2]|max_length[100]|xss_clean');
        // Validating Password Field
        if (empty($id)) {
            $this->form_validation->set_rules('password', 'Password', 'trim|min_length[3]|max_length[100]|xss_clean');
        }
        // Validating Email Field
        $this->form_validation->set_rules('email', 'Email', 'trim|min_length[2]|max_length[100]|xss_clean');
        // Validating Volunteer Field
        //   $this->form_validation->set_rules('volunteer', 'Volunteer', 'trim|min_length[1]|max_length[100]|xss_clean');
        // Validating Address Field   
        $this->form_validation->set_rules('address', 'Address', 'trim|required|min_length[2]|max_length[500]|xss_clean');
        // Validating Phone Field           
        $this->form_validation->set_rules('phone', 'Phone', 'trim|required|min_length[2]|max_length[50]|xss_clean');
        
        if ($this->form_validation->run() == FALSE) {
            if (!empty($id)) {
                $this->session->set_flashdata('feedback', 'Validation Error !');
                redirect("supplier/editSupplier?id=$id");
            } else {
                $data = array();
                $data['setval'] = 'setval';
                $data['categorys'] = $this->supplier_model->getSupplierCategory();
                
                $this->load->view('home/dashboard'); // just the header file
                $this->load->view('add_new', $data);
                $this->load->view('home/footer'); // just the header file
            }
        } else {
            $file_name = $_FILES['img_url']['name'];
            $file_name_pieces = explode('_', $file_name);
            $new_file_name = '';
            $count = 1;
            foreach ($file_name_pieces as $piece) {
                if ($count !== 1) {
                    $piece = ucfirst($piece);
                }

                $new_file_name .= $piece;
                $count++;
            }
            $config = array(
                'file_name' => $new_file_name,
                'upload_path' => "./uploads/",
                'allowed_types' => "gif|jpg|png|jpeg|pdf",
                'overwrite' => False,
                'max_size' => "20480000", // Can be set to particular file size , here it is 2 MB(2048 Kb)
                'max_height' => "1768",
                'max_width' => "2024"
            );

            $this->load->library('Upload', $config);
            $this->upload->initialize($config);

            if ($this->upload->do_upload('img_url')) {
                $path = $this->upload->data();
                $img_url = "uploads/" . $path['file_name'];
                $data = array();
                $data = array(
                    'supplier_id' => $supplier_id,
                    'img_url' => $img_url,
                    'name' => $name,
                    'supplier_category' => $category,
                    'email' => $email,
                    'address' => $address,
                    //'remarks' => $remarks,
                    'phone' => $phone,
                    
                    'add_date' => $add_date
                    
                );
            } else {
                //$error = array('error' => $this->upload->display_errors());
                $data = array();
                $data = array(
                    'supplier_id' => $supplier_id,
                    
                    'name' => $name,
                    'supplier_category' => $category,
                    'email' => $email,
                    'address' => $address,
                    //'remarks' => $remarks,
                    'phone' => $phone,
                    
                    'add_date' => $add_date
                );
            }

            $username = $this->input->post('name');

            if (empty($id)) {     // Adding New Supplier
                if ($this->ion_auth->email_check($email)) {
                    $this->session->set_flashdata('feedback', 'This Email Address Is Already Registered');
                    redirect('supplier/addNewView');
                } else {
                    $dfg = 7;
                    $this->ion_auth->register($username, $password, $email, $dfg);
                    $ion_user_id = $this->db->get_where('users', array('email' => $email))->row()->id;
                    $this->supplier_model->insertSupplier($data);
                    $supplier_user_id = $this->db->get_where('supplier', array('email' => $email))->row()->id;
                    $id_info = array('ion_user_id' => $ion_user_id);
                    $this->supplier_model->updateSupplier($supplier_user_id, $id_info);

                    if (!empty($sms)) {
                        $this->sms->sendSmsDuringSupplierRegistration($supplier_user_id);
                    }




                    $this->session->set_flashdata('feedback', 'Added');
                }
                //    }
            } else { // Updating Supplier
                $ion_user_id = $this->db->get_where('supplier', array('id' => $id))->row()->ion_user_id;
                if (empty($password)) {
                    $password = $this->db->get_where('users', array('id' => $ion_user_id))->row()->password;
                } else {
                    $password = $this->ion_auth_model->hash_password($password);
                }
                $this->supplier_model->updateIonUser($username, $email, $password, $ion_user_id);
                $this->supplier_model->updateSupplier($id, $data);
                $this->session->set_flashdata('feedback', 'Updated');
            }
            // Loading View
            if (!empty($redirect)) {
                redirect('finance/addPaymentView');
            } else {
                redirect('supplier');
            }
        }
    }

    function editSupplier() {
        $data = array();
        $id = $this->input->get('id');
        $data['supplier'] = $this->supplier_model->getSupplierById($id);
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('add_new', $data);
        $this->load->view('home/footer'); // just the footer file
    }

    function editSupplierByJason() {
        $id = $this->input->get('id');
        $data['supplier'] = $this->supplier_model->getSupplierById($id);
        echo json_encode($data);
    }

    function getSupplierByJason() {
        $id = $this->input->get('id');
        $data['supplier'] = $this->supplier_model->getSupplierById($id);

        $area = $data['supplier']->area;
        $data['area'] = $this->area_model->getAreaById($area);

        if (!empty($data['supplier']->birthdate)) {
            $birthDate = strtotime($data['supplier']->birthdate);
            $birthDate = date('m/d/Y', $birthDate);
            $birthDate = explode("/", $birthDate);
            $age = (date("md", date("U", mktime(0, 0, 0, $birthDate[0], $birthDate[1], $birthDate[2]))) > date("md") ? ((date("Y") - $birthDate[2]) - 1) : (date("Y") - $birthDate[2]));
            $data['age'] = $age . ' Year(s)';
        }

        echo json_encode($data);
    }

    function supplierDetails() {
        $data = array();
        $id = $this->input->get('id');
        $data['supplier'] = $this->supplier_model->getSupplierById($id);
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('details', $data);
        $this->load->view('home/footer'); // just the footer file
    }

    function report() {
        $data = array();
        $id = $this->input->get('id');
        $data['settings'] = $this->settings_model->getSettings();
        $data['payment'] = $this->finance_model->getPaymentById($id);
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('diagnostic_report_details', $data);
        $this->load->view('home/footer'); // just the footer file
    }

    function caseList() {
        $data['settings'] = $this->settings_model->getSettings();
        $data['suppliers'] = $this->supplier_model->getSupplier();
        $data['medical_histories'] = $this->supplier_model->getMedicalHistory();
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('case_list', $data);
        $this->load->view('home/footer'); // just the footer file
    }

    

  

    function deposit() {
        $id = $this->input->post('id');


        if ($this->ion_auth->in_group(array('Supplier'))) {
            $supplier_ion_id = $this->ion_auth->get_user_id();
            $supplier = $this->supplier_model->getSupplierByIonUserId($supplier_ion_id)->id;
        } else {
            $this->session->set_flashdata('feedback', 'Undefined Supplier Id');
            redirect('supplier/myPaymentsHistory');
        }



        $payment_id = $this->input->post('payment_id');
        $date = time();

        $deposited_amount = $this->input->post('deposited_amount');

        $deposit_type = $this->input->post('deposit_type');

        if ($deposit_type != 'Card') {
            $this->session->set_flashdata('feedback', 'Undefined Payment Type');
            redirect('supplier/myPaymentsHistory');
        }

        $user = $this->ion_auth->get_user_id();

        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
// Validating Supplier Name Field
        $this->form_validation->set_rules('supplier', 'Supplier', 'trim|min_length[1]|max_length[100]|xss_clean');
// Validating Deposited Amount Field
        $this->form_validation->set_rules('deposited_amount', 'Deposited Amount', 'trim|min_length[1]|max_length[100]|xss_clean');
        if ($this->form_validation->run() == FALSE) {
            redirect('supplier/myPaymentsHistory');
        } else {
            $data = array();
            $data = array('supplier' => $supplier,
                'date' => $date,
                'payment_id' => $payment_id,
                'deposited_amount' => $deposited_amount,
                'deposit_type' => $deposit_type,
                'user' => $user
            );
            if (empty($id)) {
                if ($deposit_type == 'Card') {
                    $payment_details = $this->finance_model->getPaymentById($payment_id);
                    $gateway = $this->settings_model->getSettings()->payment_gateway;
                    if ($gateway == 'PayPal') {
                        $card_type = $this->input->post('card_type');
                        $card_number = $this->input->post('card_number');
                        $expire_date = $this->input->post('expire_date');
                        $cvv = $this->input->post('cvv');

                        $all_details = array(
                            'supplier' => $payment_details->supplier,
                            'date' => $payment_details->date,
                            'amount' => $payment_details->amount,
                            'volunteer' => $payment_details->volunteer_name,
                            'discount' => $payment_details->discount,
                            'flat_discount' => $payment_details->flat_discount,
                            'gross_total' => $payment_details->gross_total,
                            'status' => 'unpaid',
                            'supplier_name' => $payment_details->supplier_name,
                            'supplier_phone' => $payment_details->supplier_phone,
                            'supplier_address' => $payment_details->supplier_address,
                            'deposited_amount' => $deposited_amount,
                            'payment_id' => $payment_details->id,
                            'card_type' => $card_type,
                            'card_number' => $card_number,
                            'expire_date' => $expire_date,
                            'cvv' => $cvv,
                            'from' => 'supplier_payment_details',
                            'user' => $user
                        );
                        $this->paypal->Do_direct_payment($all_details);
                    } elseif ($gateway == 'Pay U Money') {
                        redirect("payu/check?deposited_amount=" . "$deposited_amount" . '&payment_id=' . $payment_id);
                    } else {
                        $this->session->set_flashdata('feedback', 'Payment failed. No Gateway Selected');
                        redirect('supplier/myPaymentHistory');
                    }
                } else {
                    $this->finance_model->insertDeposit($data);
                    $this->session->set_flashdata('feedback', 'Added');
                }
            } else {
                $this->finance_model->updateDeposit($id, $data);

                $amount_received_id = $this->finance_model->getDepositById($id)->amount_received_id;
                if (!empty($amount_received_id)) {
                    $amount_received_payment_id = explode('.', $amount_received_id);
                    $payment_id = $amount_received_payment_id[0];
                    $data_amount_received = array('amount_received' => $deposited_amount);
                    $this->finance_model->updatePayment($amount_received_payment_id[0], $data_amount_received);
                }

                $this->session->set_flashdata('feedback', 'Updated');
            }
            redirect('supplier/myPaymentHistory');
        }
    }

    function myInvoice() {
        $id = $this->input->get('id');
        $data['settings'] = $this->settings_model->getSettings();
        $data['discount_type'] = $this->finance_model->getDiscountType();
        $data['payment'] = $this->finance_model->getPaymentById($id);
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('myInvoice', $data);
        $this->load->view('home/footer'); // just the footer fi
    }

    

    function supplierMaterial() {
        $data = array();
        $id = $this->input->get('supplier');
        $data['settings'] = $this->settings_model->getSettings();
        $data['supplier'] = $this->supplier_model->getSupplierById($id);
        $data['supplier_materials'] = $this->supplier_model->getSupplierMaterialBySupplierId($id);
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('supplier_material', $data);
        $this->load->view('home/footer'); // just the footer file
    }

    function addSupplierMaterial() {
        $title = $this->input->post('title');
        $supplier_id = $this->input->post('supplier');
        $img_url = $this->input->post('img_url');
        $date = time();
        $redirect = $this->input->post('redirect');
        if (empty($redirect)) {
            $redirect = "supplier/medicalHistory?id=" . $supplier_id;
        }
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');

        // Validating Supplier Field
        $this->form_validation->set_rules('supplier', 'Supplier', 'trim|required|min_length[1]|max_length[100]|xss_clean');


        if ($this->form_validation->run() == FALSE) {
            $this->session->set_flashdata('feedback', 'Validation Error !');
            redirect($redirect);
        } else {

            if (!empty($supplier_id)) {
                $supplier_details = $this->supplier_model->getSupplierById($supplier_id);
                $supplier_name = $supplier_details->name;
                $supplier_phone = $supplier_details->phone;
                $supplier_address = $supplier_details->address;
            } else {
                $supplier_name = 0;
                $supplier_phone = 0;
                $supplier_address = 0;
            }

            $file_name = $_FILES['img_url']['name'];
            $file_name_pieces = explode('_', $file_name);
            $new_file_name = '';
            $count = 1;
            foreach ($file_name_pieces as $piece) {
                if ($count !== 1) {
                    $piece = ucfirst($piece);
                }

                $new_file_name .= $piece;
                $count++;
            }
            $config = array(
                'file_name' => $new_file_name,
                'upload_path' => "./uploads/",
                'allowed_types' => "gif|jpg|png|jpeg|pdf",
                'overwrite' => False,
                'max_size' => "48000000", // Can be set to particular file size , here it is 2 MB(2048 Kb)
                'max_height' => "3000",
                'max_width' => "2024"
            );

            $this->load->library('Upload', $config);
            $this->upload->initialize($config);

            if ($this->upload->do_upload('img_url')) {
                $path = $this->upload->data();
                $img_url = "uploads/" . $path['file_name'];
                $data = array();
                $data = array(
                    'date' => $date,
                    'title' => $title,
                    'url' => $img_url,
                    'supplier' => $supplier_id,
                    'supplier_name' => $supplier_name,
                    'supplier_address' => $supplier_address,
                    'supplier_phone' => $supplier_phone,
                    'date_string' => date('d-m-y', $date),
                );
            } else {
                $data = array();
                $data = array(
                    'date' => $date,
                    'title' => $title,
                    'supplier' => $supplier_id,
                    'supplier_name' => $supplier_name,
                    'supplier_address' => $supplier_address,
                    'supplier_phone' => $supplier_phone,
                    'date_string' => date('d-m-y', $date),
                );
                $this->session->set_flashdata('feedback', 'Upload Error !');
            }

            $this->supplier_model->insertSupplierMaterial($data);
            $this->session->set_flashdata('feedback', 'Added');


            redirect($redirect);
        }
    }

    function deleteCaseHistory() {
        $id = $this->input->get('id');
        $redirect = $this->input->get('redirect');
        $case_history = $this->supplier_model->getMedicalHistoryById($id);
        $this->supplier_model->deleteMedicalHistory($id);
        $this->session->set_flashdata('feedback', 'Deleted');
        if ($redirect == 'case') {
            redirect('supplier/caseList');
        } else {
            redirect("supplier/MedicalHistory?id=" . $case_history->supplier_id);
        }
    }

  

    function delete() {
        $data = array();
        $id = $this->input->get('id');
        $user_data = $this->db->get_where('supplier', array('id' => $id))->row();
        $path = $user_data->img_url;

        if (!empty($path)) {
            unlink($path);
        }
        $ion_user_id = $user_data->ion_user_id;
        $this->db->where('id', $ion_user_id);
        $this->db->delete('users');
        $this->supplier_model->delete($id);
        $this->session->set_flashdata('feedback', 'Deleted');
        redirect('supplier');
    }

    public function supplierCategory() {
        $data['categorys'] = $this->supplier_model->getSupplierCategory();
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('supplier_category', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function addSuppliercategoryView() {
        $data = array();
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('add_new_supplier_category', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function addSupplierCategory() {
        $data['categorys'] = $this->supplier_model->getSupplierCategory();
        $id = $this->input->post('id');
        $category = $this->input->post('category');
        $description = $this->input->post('description');
        
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');

        // Validating Category Field
        $this->form_validation->set_rules('category', 'Supplier Category', 'trim|min_length[1]|max_length[100]|xss_clean');

        // Validating Description Field
        $this->form_validation->set_rules('description', 'Supplier Description', 'trim|min_length[1]|max_length[100]|xss_clean');

        if ($this->form_validation->run() == FALSE) {
            if (!empty($id)) {
                redirect("supplier/editSupplierCategory?id=$id");
            } else {
                $this->load->view('home/dashboard'); // just the header file
                $this->load->view('add_new_supplier_category', $data);
                $this->load->view('home/footer'); // just the header file
            }
        } else {

            $data = array();
            $data = array(
                'category' => $category,
                'description' => $description,
            );


            $username = $this->input->post('name');

            if (empty($id)) {     // Adding New Supplier
                $this->supplier_model->insertSupplierCategory($data);
                redirect('supplier/supplierCategory');
            } else { // Updating Supplier
                $this->supplier_model->updateSupplierCategory($id, $data);
                $this->session->set_flashdata('feedback', 'Updated');
                redirect('supplier/supplierCategory');
            }
            // Loading View
        }
    }

    function getSupplierCatory() {
        $data['supplier'] = $this->supplier_model->getSupplier();
        $this->load->view('supplier', $data);
    }

    function editSupplierCategory() {
        $data = array();
        $id = $this->input->get('id');
        $data['category'] = $this->supplier_model->getSupplierCategoryById($id);
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('add_new_supplier_category', $data);
        $this->load->view('home/footer'); // just the footer file
    }

    function editSuppliercategoryByJason() {
        $id = $this->input->get('id');
        $data['category'] = $this->supplier_model->getSupplierCategoryById($id);
        echo json_encode($data);
    }

    function deleteSupplierCategory() {
        $data = array();
        $id = $this->input->get('id');
        $this->supplier_model->deleteSupplierCategory($id);
        redirect('supplier/supplierCategory');
    }

    function getSupplier() {
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];

        if ($limit == -1) {
            if (!empty($search)) {
                $data['suppliers'] = $this->supplier_model->getSupplierBysearch($search);
            } else {
                $data['suppliers'] = $this->supplier_model->getSupplier();
            }
        } else {
            if (!empty($search)) {
                $data['suppliers'] = $this->supplier_model->getSupplierByLimitBySearch($limit, $start, $search);
            } else {
                $data['suppliers'] = $this->supplier_model->getSupplierByLimit($limit, $start);
            }
        }
        //  $data['suppliers'] = $this->supplier_model->getSupplier();

        foreach ($data['suppliers'] as $supplier) {

            if ($this->ion_auth->in_group(array('admin', 'Volunteer'))) {
                //   $options1 = '<a type="button" class="btn editbutton" title="Edit" data-toggle="modal" data-id="463"><i class="fa fa-edit"> </i> Edit</a>';
                $option = '<button type="button" data-toggle="modal" data-id="'.$supplier->id.'" class="btn btn-primary add_payment addpayment"><i class="fa fa-money"> ' . lang('add_payment') .'</i></button>  ';
                $options1 = ' <a type="button" class="btn editbutton" title="' . lang('edit') . '" data-toggle = "modal" data-id="' . $supplier->id . '"><i class="fa fa-edit"> </i> ' . lang('edit') . '</a>';
            }

            $options2 = '<a class="btn detailsbutton" title="' . lang('info') . '" style="color: #fff;" href="payment/supplierDetail?supplier_id=' . $supplier->id . '"><i class="fa fa-info"></i> ' . lang('details') . '</a>';

            if ($this->ion_auth->in_group(array('admin', 'Accountant', 'Receptionist', 'Laboratorist', 'Nurse', 'Volunteer'))) {
                $options5 = '<a class="btn delete_button" title="' . lang('delete') . '" href="supplier/delete?id=' . $supplier->id . '" onclick="return confirm(\'Are you sure you want to delete this item?\');"><i class="fa fa-trash-o"></i> ' . lang('delete') . '</a>';
            }

            $options6 = ' <a type="button" class="btn detailsbutton inffo" title="' . lang('info') . '" href="payment/supplierDetail?supplier_id=' . $supplier->id . '"><i class="fa fa-info"> </i> ' . lang('details') . '</a>';

            if ($this->ion_auth->in_group(array('admin'))) {
                $info[] = array(
                    $supplier->supplier_id,
                    '<img src="'.$supplier->img_url.'" width= "100">',
                    $supplier->name,
                    $supplier->supplier_category,
                    $supplier->email,
                    $supplier->phone,
                    $option,
                    $options1 . ' ' . $options6 . ' ' . $options5,
                        //  $options2
                );
            }

            if ($this->ion_auth->in_group(array('Accountant', 'Receptionist'))) {
                $info[] = array(
                    $supplier->supplier_id,
                    $supplier->img_url,
                    $supplier->name,
                    $supplier->supplier_category,
                    $supplier->email,
                    $supplier->phone,
                    $options1,
                    $options1 . ' ' . $options6 . ' ' . $options4,
                        //  $options2
                );
            }

            if ($this->ion_auth->in_group(array('Volunteer'))) {
                $info[] = array(
                    $supplier->supplier_id,
                    $supplier->img_url,
                    $supplier->name,
                    $supplier->supplier_category,
                    $supplier->email,
                    $supplier->phone,
                    $options1,
                    $options1 . ' ' . $options6 . ' ' . $options3,
                        //  $options2
                );
            }
        }

        if (!empty($data['suppliers'])) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => $this->db->get('supplier')->num_rows(),
                "recordsFiltered" => $this->db->get('supplier')->num_rows(),
                "data" => $info
            );
        } else {
            $output = array(
                // "draw" => 1,
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }

    function getSupplierPayments() {
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];

        if ($limit == -1) {
            if (!empty($search)) {
                $data['suppliers'] = $this->supplier_model->getSupplierBysearch($search);
            } else {
                $data['suppliers'] = $this->supplier_model->getSupplier();
            }
        } else {
            if (!empty($search)) {
                $data['suppliers'] = $this->supplier_model->getSupplierByLimitBySearch($limit, $start, $search);
            } else {
                $data['suppliers'] = $this->supplier_model->getSupplierByLimit($limit, $start);
            }
        }
        //  $data['suppliers'] = $this->supplier_model->getSupplier();

        foreach ($data['suppliers'] as $supplier) {

            if ($this->ion_auth->in_group(array('admin', 'Accountant', 'Receptionist', 'Laboratorist', 'Nurse', 'Volunteer'))) {
                //   $options1 = '<a type="button" class="btn editbutton" title="Edit" data-toggle="modal" data-id="463"><i class="fa fa-edit"> </i> Edit</a>';
                $options1 = ' <a type="button" class="btn editbutton" title="' . lang('edit') . '" data-toggle = "modal" data-id="' . $supplier->id . '"><i class="fa fa-edit"> </i> ' . lang('edit') . '</a>';
            }

            $options2 = '<a class="btn detailsbutton" title="' . lang('info') . '" style="color: #fff;" href="supplier/supplierDetails?id=' . $supplier->id . '"><i class="fa fa-info"></i> ' . lang('info') . '</a>';

            $options3 = '<a class="btn green" title="' . lang('history') . '" style="color: #fff;" href="supplier/medicalHistory?id=' . $supplier->id . '"><i class="fa fa-stethoscope"></i> ' . lang('history') . '</a>';

            $options4 = '<a class="btn btn-xs green" title="' . lang('payment') . ' ' . lang('history') . '" style="color: #fff;" href="finance/supplierPaymentHistory?supplier=' . $supplier->id . '"><i class="fa fa-money"></i> ' . lang('payment') . ' ' . lang('history') . '</a>';

            if ($this->ion_auth->in_group(array('admin', 'Accountant', 'Receptionist', 'Laboratorist', 'Nurse', 'Volunteer'))) {
                $options5 = '<a class="btn delete_button" title="' . lang('delete') . '" href="supplier/delete?id=' . $supplier->id . '" onclick="return confirm(\'Are you sure you want to delete this item?\');"><i class="fa fa-trash-o"></i> ' . lang('delete') . '</a>';
            }

            $due = $this->settings_model->getSettings()->currency . $this->supplier_model->getDueBalanceBySupplierId($supplier->id);

            $info[] = array(
                $supplier->id,
                $supplier->name,
                $supplier->phone,
                $due,
                //  $options1 . ' ' . $options2 . ' ' . $options3 . ' ' . $options4 . ' ' . $options5,
                $options4
            );
        }

        if (!empty($data['suppliers'])) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => $this->db->get('supplier')->num_rows(),
                "recordsFiltered" => $this->db->get('supplier')->num_rows(),
                "data" => $info
            );
        } else {
            $output = array(
                // "draw" => 1,
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }

    function getCaseList() {
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];

        if ($limit == -1) {
            if (!empty($search)) {
                $data['cases'] = $this->supplier_model->getMedicalHistoryBySearch($search);
            } else {
                $data['cases'] = $this->supplier_model->getMedicalHistory();
            }
        } else {
            if (!empty($search)) {
                $data['cases'] = $this->supplier_model->getMedicalHistoryByLimitBySearch($limit, $start, $search);
            } else {
                $data['cases'] = $this->supplier_model->getMedicalHistoryByLimit($limit, $start);
            }
        }
        //  $data['suppliers'] = $this->supplier_model->getSupplier();

        foreach ($data['cases'] as $case) {

            if ($this->ion_auth->in_group(array('admin', 'Accountant', 'Receptionist', 'Laboratorist', 'Nurse', 'Volunteer'))) {
                //   $options1 = '<a type="button" class="btn editbutton" title="Edit" data-toggle="modal" data-id="463"><i class="fa fa-edit"> </i> Edit</a>';
                $options1 = ' <a type="button" class="btn btn-info btn-xs btn_width editbutton" title="' . lang('edit') . '" data-toggle = "modal" data-id="' . $case->id . '"><i class="fa fa-edit"> </i> </a>';
            }
            if ($this->ion_auth->in_group(array('admin', 'Accountant', 'Receptionist', 'Laboratorist', 'Nurse', 'Volunteer'))) {
                $options2 = '<a class="btn btn-info btn-xs btn_width delete_button" title="' . lang('delete') . '" href="supplier/deleteCaseHistory?id=' . $case->id . '&redirect=case" onclick="return confirm(\'Are you sure you want to delete this item?\');"><i class="fa fa-trash-o"></i></a>';
                $options3 = ' <a type="button" class="btn btn-info btn-xs btn_width detailsbutton case" title="' . lang('case') . '" data-toggle = "modal" data-id="' . $case->id . '"><i class="fa fa-file"> </i> </a>';
            }

            if (!empty($case->supplier_id)) {
                $supplier_info = $this->supplier_model->getSupplierById($case->supplier_id);
                if (!empty($supplier_info)) {
                    $supplier_details = $supplier_info->name . '</br>' . $supplier_info->address . '</br>' . $supplier_info->phone . '</br>';
                } else {
                    $supplier_details = $case->supplier_name . '</br>' . $case->supplier_address . '</br>' . $case->supplier_phone . '</br>';
                }
            } else {
                $supplier_details = '';
            }

            $info[] = array(
                date('d-m-Y', $case->date),
                $supplier_details,
                $case->title,
                $options3 . ' ' . $options1 . ' ' . $options2
                    // $options4
            );
        }

        if (!empty($data['cases'])) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => $this->db->get('medical_history')->num_rows(),
                "recordsFiltered" => $this->db->get('medical_history')->num_rows(),
                "data" => $info
            );
        } else {
            $output = array(
                // "draw" => 1,
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }

    function getDocuments() {
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];

        if ($limit == -1) {
            if (!empty($search)) {
                $data['documents'] = $this->supplier_model->getDocumentBySearch($search);
            } else {
                $data['documents'] = $this->supplier_model->getSupplierMaterial();
            }
        } else {
            if (!empty($search)) {
                $data['documents'] = $this->supplier_model->getDocumentByLimitBySearch($limit, $start, $search);
            } else {
                $data['documents'] = $this->supplier_model->getDocumentByLimit($limit, $start);
            }
        }
        //  $data['suppliers'] = $this->supplier_model->getSupplier();

        foreach ($data['documents'] as $document) {

            if ($this->ion_auth->in_group(array('admin', 'Accountant', 'Receptionist', 'Laboratorist', 'Nurse', 'Volunteer'))) {
                //   $options1 = '<a type="button" class="btn editbutton" title="Edit" data-toggle="modal" data-id="463"><i class="fa fa-edit"> </i> Edit</a>';
                $options1 = '<a class="btn btn-info btn-xs" href="' . $document->url . '" download> ' . lang('download') . ' </a>';
            }
            if ($this->ion_auth->in_group(array('admin', 'Accountant', 'Receptionist', 'Laboratorist', 'Nurse', 'Volunteer'))) {
                $options2 = '<a class="btn btn-info btn-xs delete_button" href="supplier/deleteSupplierMaterial?id=' . $document->id . '&redirect=documents"onclick="return confirm(\'You want to delete the item??\');"> X </a>';
            }

            if (!empty($document->supplier)) {
                $supplier_info = $this->supplier_model->getSupplierById($document->supplier);
                if (!empty($supplier_info)) {
                    $supplier_details = $supplier_info->name . '</br>' . $supplier_info->address . '</br>' . $supplier_info->phone . '</br>';
                } else {
                    $supplier_details = $document->supplier_name . '</br>' . $document->supplier_address . '</br>' . $document->supplier_phone . '</br>';
                }
            } else {
                $supplier_details = '';
            }

            $info[] = array(
                date('d-m-y', $document->date),
                $supplier_details,
                $document->title,
                '<img src="' . $document->url . '" width="100px" height="100px">',
                $options1 . ' ' . $options2
                    // $options4
            );
        }

        if (!empty($data['documents'])) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => $this->db->get('supplier_material')->num_rows(),
                "recordsFiltered" => $this->db->get('supplier_material')->num_rows(),
                "data" => $info
            );
        } else {
            $output = array(
                // "draw" => 1,
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }

}

/* End of file supplier.php */
    /* Location: ./application/modules/supplier/controllers/supplier.php */
    