<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Sms extends MX_Controller {

    function __construct() {
        parent::__construct();
        $this->load->library('Ion_auth');
        $this->load->library('session');
        $this->load->library('form_validation');
        $this->load->model('sms_model');
        $this->load->model('client/client_model');
        $this->load->model('supplier/supplier_model');
        $language = $this->db->get('settings')->row()->language;
        $this->lang->load('system_syntax', $language);
        $this->load->model('ion_auth_model');
        if (!$this->ion_auth->logged_in()) {
            redirect('auth/login', 'refresh');
        }
    }

    public function index() {
        $data = array();
        $id = $this->ion_auth->get_user_id();
        $data['settings'] = $this->settings_model->getSettings();
        $data['sgateways'] = $this->sms_model->getSmsSettings();
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('sgateway', $data);
        $this->load->view('home/footer'); // just the footer file
    }

    public function sendView() {
        $data = array();
        $id = $this->ion_auth->get_user_id();
        $data['clients'] = $this->client_model->getClient();
        $data['suppliers'] = $this->supplier_model->getSupplier();
        $data['sms'] = $this->sms_model->getSmsSettingsById($id);
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('sendview', $data);
        $this->load->view('home/footer'); // just the footer file
    }

    public function settings() {
        $data = array();
        $id = $this->input->get('id');
        $data['settings'] = $this->sms_model->getSmsSettingsById($id);
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('settings', $data);
        $this->load->view('home/footer'); // just the footer file
    }

    public function addNewSettings() {

        $id = $this->input->post('id');
        $username = $this->input->post('username');
        $password = $this->input->post('password');
        $api_id = $this->input->post('api_id');

        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        // Validating Name Field
        $this->form_validation->set_rules('username', 'Username', 'trim|required|min_length[5]|max_length[100]|xss_clean');
        // Validating Password Field
        if (!empty($password)) {
            $this->form_validation->set_rules('password', 'Password', 'trim|required|min_length[5]|max_length[100]|xss_clean');
        }
        // Validating Email Field
        $this->form_validation->set_rules('api_id', 'Api Id', 'trim|required|min_length[5]|max_length[100]|xss_clean');

        if ($this->form_validation->run() == FALSE) {
            $data = array();
            $id = $this->ion_auth->get_user_id();
            $data['sms'] = $this->sms_model->getSmsSettingsById($id);
            $this->load->view('home/dashboard'); // just the header file
            $this->load->view('settings', $data);
            $this->load->view('home/footer'); // just the footer file
        } else {
            $data = array();
            $data = array(
                'username' => $username,
                'password' => $password,
                'api_id' => $api_id,
                'user' => $this->ion_auth->get_user_id()
            );
            if (empty($this->sms_model->getSmsSettingsById($id)->username)) {
                $this->sms_model->addSmsSettings($data);
                $this->session->set_flashdata('feedback', 'Added');
            } else {
                $this->sms_model->updateSmsSettings($data);
                $this->session->set_flashdata('feedback', 'Updated');
            }
            redirect('sms/settings');
        }
    }

    function sendSms($to, $message) {
        $sms_gateway = $this->settings_model->getSettings()->sms_gateway;
        if (!empty($sms_gateway)) {
            $smsSettings = $this->sms_model->getSmsSettingsByGatewayName($sms_gateway);
        } else {
            $this->session->set_flashdata('feedback', lang('gatewany_not_selected'));
            redirect('sms/sendView');
        }

        if ($smsSettings->name == 'Clickatell') {
            $username = $smsSettings->username;
            $password = $smsSettings->password;
            $api_id = $smsSettings->api_id;

            file_get_contents('https://platform.clickatell.com/messages/http/send?apiKey=' . $api_id . '==&to=' . $to . '&content=' . $message);           // file_get_contents('https://platform.clickatell.com/messages/http/send?apiKey='.$api_id.'==&to='.$to.'&content='.$message1);           // file_get_contents('https://api.clickatell.com/http/sendmsg?user=' . $username . '&password=' . $password . '&api_id=' . $api_id . '&to=' . $to . '&text=' . $message1);
        }

        if ($smsSettings->name == 'MSG91') {
            $authkey = $smsSettings->authkey;
            $sender = $smsSettings->sender;
            file_get_contents('http://api.msg91.com/api/sendhttp.php?route=4&sender=TESTIN&mobiles=fdsfsdfsd&authkey=' . $authkey . '&message=' . $message . '&country=0');           // file_get_contents('https://platform.clickatell.com/messages/http/send?apiKey='.$api_id.'==&to='.$to.'&content='.$message1);           // file_get_contents('https://api.clickatell.com/http/sendmsg?user=' . $username . '&password=' . $password . '&api_id=' . $api_id . '&to=' . $to . '&text=' . $message1);
        }
    }

    function send() {
        $userId = $this->ion_auth->get_user_id();
        $is_v_v = $this->input->post('radio');

        if ($is_v_v == 'allclient') {
            $clients = $this->client_model->getClient();
            foreach ($clients as $client) {
                $to[] = $client->phone;
            }
            $recipient = 'All Client';
        }



        if ($is_v_v == 'single_client') {
            $client = $this->input->post('client');

            $client_detail = $this->client_model->getClientById($client);
            $single_client_phone = $client_detail->phone;
            $recipient = 'Client Id: ' . $client_detail->id . '<br> Client Name: ' . $client_detail->name . '<br> Client Phone: ' . $client_detail->phone;
        }

        if (!empty($single_client_phone)) {
            $to = $single_client_phone;
        } else {
            if (!empty($to)) {
                $to = implode(',', $to);
            }
        }
        
        if ($is_v_v == 'allsupplier') {
            $suppliers = $this->supplier_model->getSupplier();
            foreach ($suppliers as $supplier) {
                $tos[] = $supplier->phone;
            }
            $recipient = 'All Supplier';
        }

        if ($is_v_v == 'single_supplier') {
            $supplier = $this->input->post('supplier');

            $supplier_detail = $this->supplier_model->getSupplierById($supplier);
            $single_supplier_phone = $supplier_detail->phone;
            $recipient = 'Supplier Id: ' . $supplier_detail->id . '<br> Supplier Name: ' . $supplier_detail->name . '<br> Supplier Phone: ' . $supplier_detail->phone;
        }

        if (!empty($single_supplier_phone)) {
            $tos = $single_supplier_phone;
        } else {
            if (!empty($tos)) {
                $tos = implode(',', $tos);
            }
        }
        
        if (!empty($to)) {
            $message = $this->input->post('message');
            $message1 = urlencode($message);
            $this->sendSms($to, $message1);
            $data = array();
            $date = time();
            $data = array(
                'message' => $message,
                'date' => $date,
                'recipient' => $recipient,
                'user' => $this->ion_auth->get_user_id()
            );
            $this->sms_model->insertSms($data);
            $this->session->set_flashdata('feedback', lang('msg_sent'));
        } else if (!empty($tos)) {
            $message = $this->input->post('message');
            $message1 = urlencode($message);
            $this->sendSms($tos, $message1);
            $data = array();
            $date = time();
            $data = array(
                'message' => $message,
                'date' => $date,
                'recipient' => $recipient,
                'user' => $this->ion_auth->get_user_id()
            );
            $this->sms_model->insertSms($data);
            $this->session->set_flashdata('feedback', lang('msg_sent'));
        } else {
            $this->session->set_flashdata('feedback', lang('msg_not_sent'));
        }
        
        redirect('sms/sendView');
    }

    function appointmentReminder() {
        $id = $this->input->post('id');
        $appointment_details = $this->appointment_model->getAppointmentById($id);
        $smsSettings = $this->sms_model->getSmsSettings();
        $username = $smsSettings->username;
        $password = $smsSettings->password;
        $api_id = $smsSettings->api_id;

        $client_detail = $this->client_model->getClientById($appointment_details->client);
       
        $recipient_p = 'Client Id: ' . $client_detail->id . '<br> Client Name: ' . $client_detail->name . '<br> Client Phone: ' . $client_detail->phone;
        $to = $client_detail->phone;

        // $message = urlencode("Test Message");
        if (!empty($to)) {
            $message = 'Reminder: Appointment is scheduled for you With Doctor ' . $doctor_detail->name . ' Date: ' . date('d-m-Y', $appointment_details->date) . ' Time: ' . $appointment_details->s_time;
            $message1 = urlencode($message);
            $this->sendSms($to, $message1);
            $data_p = array();
            $date = time();
            $data_p = array(
                'message' => $message,
                'date' => $date,
                'recipient' => $recipient_p,
                'user' => $this->ion_auth->get_user_id()
            );
            $this->sms_model->insertSms($data_p);
            $this->session->set_flashdata('feedback', 'Message Sent');
        }

        redirect('appointment/upcoming');
    }

    function sendSmsDuringAppointment($client, $doctor, $date, $s_time, $e_time) {
        $smsSettings = $this->sms_model->getSmsSettings();
        $username = $smsSettings->username;
        $password = $smsSettings->password;
        $api_id = $smsSettings->api_id;

        $client_detail = $this->client_model->getClientById($client);
    

        $recipient_p = 'Client Id: ' . $client_detail->id . '<br> Client Name: ' . $client_detail->name . '<br> Client Phone: ' . $client_detail->phone;
        $recipient_d = 'Doctor Id: ' . $doctor_detail->id . '<br> Client Name: ' . $doctor_detail->name . '<br> Doctor Phone: ' . $doctor_detail->phone;


        $to = $client_detail->phone . ', ' . $doctor_detail->phone;

        // $message = urlencode("Test Message");
        if (!empty($client)) {
            $message = 'Appointment is scheduled for you With Doctor ' . $doctor_detail->name . ' Date: ' . date('d-m-Y', $date) . ' Time: ' . $s_time;
            $message1 = urlencode($message);
            $this->sendSms($to, $message1);
            $data_p = array();
            $date = time();
            $data_p = array(
                'message' => $message,
                'date' => $date,
                'recipient' => $recipient_p,
                'user' => $this->ion_auth->get_user_id()
            );
            $this->sms_model->insertSms($data_p);
        }

        if (!empty($doctor)) {
            $message = 'Appointment is scheduled for you With Client ' . $client_detail->name . ' Date: ' . date('d-m-Y', $date) . ' Time: ' . $s_time;
            $message1 = urlencode($message);
            $this->sendSms($to, $message1);
            $data_d = array();
            $date = time();
            $data_d = array(
                'message' => $message,
                'date' => $date,
                'recipient' => $recipient_d,
                'user' => $this->ion_auth->get_user_id()
            );
            $this->sms_model->insertSms($data_d);
        }
    }

    function appointmentApproved() {
        $id = $this->input->post('id');
        $appointment_details = $this->appointment_model->getAppointmentById($id);
        $smsSettings = $this->sms_model->getSmsSettings();
        $username = $smsSettings->username;
        $password = $smsSettings->password;
        $api_id = $smsSettings->api_id;

        $client_detail = $this->client_model->getClientById($appointment_details->client);
        $doctor_detail = $this->doctor_model->getDoctorById($appointment_details->doctor);
        $recipient_p = 'Client Id: ' . $client_detail->id . '<br> Client Name: ' . $client_detail->name . '<br> Client Phone: ' . $client_detail->phone;
        $to = $client_detail->phone;

        // $message = urlencode("Test Message");
        if (!empty($to)) {
            $message = 'Approval: Appointment is scheduled for you With Doctor ' . $doctor_detail->name . ' Date: ' . date('d-m-Y', $appointment_details->date) . ' Time: ' . $appointment_details->s_time;
            $message1 = urlencode($message);
            $this->sendSms($to, $message1);
            $data_p = array();
            $date = time();
            $data_p = array(
                'message' => $message,
                'date' => $date,
                'recipient' => $recipient_p,
                'user' => $this->ion_auth->get_user_id()
            );
            $this->sms_model->insertSms($data_p);
        }
    }

    function sendSmsDuringPayment($client, $amount, $date) {
        $smsSettings = $this->sms_model->getSmsSettings();
        $username = $smsSettings->username;
        $password = $smsSettings->password;
        $api_id = $smsSettings->api_id;

        $client_detail = $this->client_model->getClientById($client);

        $recipient_p = 'Client Id: ' . $client_detail->id . '<br> Client Name: ' . $client_detail->name . '<br> Client Phone: ' . $client_detail->phone;

        // $message = urlencode("Test Message");
        if (!empty($client)) {
            $to = $client_detail->phone;
            $message = 'Bill For Client ' . $client_detail->name . 'Amount: ' . $amount . ' Date: ' . date('d-m-Y', $date);
            $message1 = urlencode($message);
            $this->sendSms($to, $message1);
            $data_p = array();
            $date = time();
            $data_p = array(
                'message' => $message,
                'date' => $date,
                'recipient' => $recipient_p,
                'user' => $this->ion_auth->get_user_id()
            );
            $this->sms_model->insertSms($data_p);
        }
    }

    function sendSmsDuringClientRegistration($client) {
        $smsSettings = $this->sms_model->getSmsSettings();
        $username = $smsSettings->username;
        $password = $smsSettings->password;
        $api_id = $smsSettings->api_id;

        $client_detail = $this->client_model->getClientById($client);

        $recipient_p = 'Client Id: ' . $client_detail->id . '<br> Client Name: ' . $client_detail->name . '<br> Client Phone: ' . $client_detail->phone;

        // $message = urlencode("Test Message");
        if (!empty($client)) {
            $to = $client_detail->phone;
            $message = 'Client Registration' . $client_detail->name . 'is successfully registerred';
            $message1 = urlencode($message);
            $this->sendSms($to, $message1);
            $data_p = array();
            $date = time();
            $data_p = array(
                'message' => $message,
                'date' => $date,
                'recipient' => $recipient_p,
                'user' => $this->ion_auth->get_user_id()
            );
            $this->sms_model->insertSms($data_p);
        }
    }

    function sent() {
        if ($this->ion_auth->in_group(array('admin'))) {
            $data['sents'] = $this->sms_model->getSms();
        } else {
            $current_user_id = $this->ion_auth->user()->row()->id;
            $data['sents'] = $this->sms_model->getSmsByUser($current_user_id);
        }

        $this->load->view('home/dashboard');
        $this->load->view('sms', $data);
        $this->load->view('home/footer');
    }

    function delete() {
        $id = $this->input->get('id');
        $this->sms_model->delete($id);
        $this->session->set_flashdata('feedback', 'Deleted');
        redirect('sms/sent');
    }

}

/* End of file profile.php */
/* Location: ./application/modules/profile/controllers/profile.php */
