<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Payment_model extends CI_model {

    function __construct() {
        parent::__construct();
        $this->load->database();
    }

    function insertPayment($data) {
        $this->db->insert('payment', $data);
        return $this->db->insert_id();
    }
    
    function insertSupplierPayment($data) {
        $this->db->insert('spayment', $data);
        return $this->db->insert_id();
    }

    function getPayment() {
        $this->db->order_by("id", "desc");
        $query = $this->db->get('payment');
        return $query->result();
    }
    
    function getSupplierPayment() {
        $this->db->order_by("id", "desc");
        $query = $this->db->get('spayment');
        return $query->result();
    }

    function getPaymentByClient($clientid) {
        $this->db->order_by("id", "desc");
        $query = $this->db->get_where('payment', array('client_id' => $clientid));
        return $query->result();
    }
    
    function getPaymentBySupplier($supplierid) {
        $this->db->order_by("id", "desc");
        $query = $this->db->get_where('spayment', array('supplier_id' => $supplierid));
        return $query->result();
    }

    function getPaymentById($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('payment');
        return $query->row();
    }
    
    function getSupplierPaymentById($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('spayment');
        return $query->row();
    }
    
    function getPaymentBySupplierId($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('spayment');
        return $query->row();
    }

    function updatePayment($id, $data) {
        $this->db->where('id', $id);
        $this->db->update('payment', $data);
    }
    
    function updateSupplierPayment($id, $data) {
        $this->db->where('id', $id);
        $this->db->update('spayment', $data);
    }

    function deletePayment($id) {
        $this->db->where('id', $id);
        $this->db->delete('payment');
    }
    
    function deleteSupplierPayment($id) {
        $this->db->where('id', $id);
        $this->db->delete('spayment');
    }

    function deleteAllPaymentByClientId($id) {
        $this->db->where('client_id', $id);
        $this->db->delete('payment');
    }
    
    function deleteAllPaymentBySupplierId($id) {
        $this->db->where('client_id', $id);
        $this->db->delete('spayment');
    }

    function getPaymentByDate($date_from, $date_to) {
        $this->db->select('*');
        $this->db->from('payment');
        $this->db->where('date >=', $date_from);
        $this->db->where('date <=', $date_to);
        $query = $this->db->get();
        return $query->result();
    }
    
    function getSupplierPaymentByDate($date_from, $date_to) {
        $this->db->select('*');
        $this->db->from('spayment');
        $this->db->where('date >=', $date_from);
        $this->db->where('date <=', $date_to);
        $query = $this->db->get();
        return $query->result();
    }

    function getExpenseByDate($date_from, $date_to) {
        $this->db->select('*');
        $this->db->from('expense');
        $this->db->where('date >=', $date_from);
        $this->db->where('date <=', $date_to);
        $query = $this->db->get();
        return $query->result();
    }
    

    function isDueZero($clientid) {
        $this->db->order_by("id", "desc");
        $query = $this->db->get_where('payment', array('client_id' => $clientid));
        $payments = $query->result();
        $due = array();
        foreach ($payments as $payment) {
            $due[] = $payment->due;
        }
        $due = array_sum($due);
        return $due;
    }

}
