<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Payment extends MX_Controller {

    function __construct() {
        parent::__construct();
        $this->load->library('Ion_auth');
        $this->load->library('session');
        $this->load->library('email');
        $this->load->library('form_validation');
        $this->load->library('upload');
        $this->load->module('paypal');
        $this->load->model('payment_model');
        $this->load->model('client/client_model');
        $this->load->model('supplier/supplier_model');
        $this->load->model('settings/settings_model');
        if (!$this->ion_auth->logged_in()) {
            redirect('auth/login', 'refresh');
        }
        if (!$this->ion_auth->in_group(array('admin', 'client'))) {
            redirect('home/permission');
        }
    }

    public function index() {
        if (!$this->ion_auth->in_group(array('admin', 'client'))) {
            redirect('home/permission');
        }
        redirect('payment');
    }

    public function payment() {
        if (!$this->ion_auth->in_group(array('admin', 'client'))) {
            redirect('home/permission');
        }
        $data['settings'] = $this->settings_model->getSettings();

        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('payment', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function addPaymentView() {
        if (!$this->ion_auth->in_group(array('admin'))) {
            redirect('home/permission');
        }
        $data = array();
        $data['client_iid'] = $this->input->get('client_id');
        $data['client'] = $this->client_model->getClientByCId($this->input->get('client_id'));
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('add_payment_view', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function addSupplierPaymentView() {
        if (!$this->ion_auth->in_group(array('admin'))) {
            redirect('home/permission');
        }
        $data = array();
        $data['supplier_iid'] = $this->input->get('supplier_id');
        $data['supplier'] = $this->supplier_model->getSupplierBySId($this->input->get('supplier_id'));
        //$data['payments'] = $this->payment_model->getSupplierById($data['supplier']->id);
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('add_spayment_view', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function addPayment() {

        $data['settings'] = $this->settings_model->getSettings();
        $id = $this->input->post('id');
        $client_id = $this->input->post('client_id');
        $name = $this->input->post('name');
        $ptype = $this->input->post('ptype');
        $remarks = $this->input->post('remarks');
        if ($ptype == 1) {
            $card_type = $this->input->post('ctype');
            $card_number = $this->input->post('cnum');
            $expire_date = $this->input->post('valid');
            $cvv = $this->input->post('cvv');
        }
        $date = $this->input->post('date');
        $amount = $this->input->post('amount');
        $cash_recevied = $this->input->post('cash_recevied');
        $due = $amount - $cash_recevied;

        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        // Validating Price Field
        $this->form_validation->set_rules('amount', 'Amount', 'trim|min_length[1]|max_length[100]|xss_clean');
        // Validating Cash Received Field
        $this->form_validation->set_rules('cash_recevied', 'Cash Recevied', 'trim|min_length[1]|max_length[100]|xss_clean');
        if ($ptype == 1) {
            $this->form_validation->set_rules('ctype', 'Card Type', 'trim|min_length[1]|max_length[100]|xss_clean');
            $this->form_validation->set_rules('cnum', 'Card Number', 'trim|min_length[1]|max_length[100]|xss_clean');
            $this->form_validation->set_rules('valid', 'Expire Date', 'trim|min_length[1]|max_length[100]|xss_clean');
            $this->form_validation->set_rules('cvv', 'CVV Number', 'trim|min_length[1]|max_length[100]|xss_clean');
        }
        $this->form_validation->set_rules('ptype', 'Payment Type', 'trim|min_length[1]|max_length[100]|xss_clean');
        $this->form_validation->set_rules('date', 'Date', 'trim|min_length[2]|max_length[50]|xss_clean');

        if ($this->form_validation->run() == FALSE) {
            redirect("payment/clientDetails?client_id=" . "$client_id");
        } else {
            $data = array();
            if (empty($id)) {
                $data = array(
                    'client_id' => $client_id,
                    'name' => $name,
                    'date' => strtotime($date),
                    'amount' => $amount,
                    'cash_recevied' => $cash_recevied,
                    'remarks' => $remarks,
                    'ptype' => $ptype,
                    'due' => $due,
                );
                $inserted_id = $this->payment_model->insertPayment($data);

                if ($ptype == 1) {
                    $data['settings'] = $this->settings_model->getSettings();
                    $payment = $data['settings']->payment_gateway;
                    if ($payment == 'PayPal') {

                        $data2 = array(
                            'client' => $client_id,
                            'client_name' => $name,
                            'card_type' => $card_type,
                            'card_number' => $card_number,
                            'expire_date' => $expire_date,
                            'cvv' => $cvv,
                            'deposited_amount' => $cash_recevied
                        );

                        $this->paypal->Do_direct_payment($data2);
                    }

                    if ($payment == 'Pay U Money') {
                        redirect("payu/check2?amount_received=" . "$cash_recevied" . '&payment_id=' . $inserted_id);
                    }
                }

                $this->session->set_flashdata('feedback', 'Added');
                redirect("payment/clientDetails?client_id=" . "$client_id");
            } else {
                $data = array(
                    'client_id' => $client_id,
                    'amount' => $amount,
                    'cash_recevied' => $cash_recevied,
                    'due' => $due,
                    'remarks' => $remarks,
                );
                $this->payment_model->updatePayment($id, $data);
                $this->session->set_flashdata('feedback', 'Updated!');
                redirect("payment/clientDetails?client_id=" . "$client_id");
            }
        }
    }

    public function addSupplierPayment() {
        if (!$this->ion_auth->in_group(array('admin'))) {
            redirect('home/permission');
        }
        $data['settings'] = $this->settings_model->getSettings();
        $id = $this->input->post('id');
        $supplier_id = $this->input->post('supplier_id');
        $name = $this->input->post('name');
        $remarks = $this->input->post('remarks');
        $date = $this->input->post('date');
        $amount = $this->input->post('amount');
        $cash_recevied = $this->input->post('cash_recevied');
        $due = $amount - $cash_recevied;

        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        // Validating Price Field
        $this->form_validation->set_rules('amount', 'Amount', 'trim|required|min_length[2]|max_length[100]|xss_clean');
        // Validating Cash Received Field
        $this->form_validation->set_rules('cash_recevied', 'Cash Recevied', 'trim|required|min_length[1]|max_length[100]|xss_clean');

        $this->form_validation->set_rules('date', 'Date', 'trim|min_length[2]|max_length[50]|xss_clean');

        if ($this->form_validation->run() == FALSE) {
            redirect("payment/supplierDetail?supplier_id=" . "$supplier_id");
        } else {
            $data = array();
            if (empty($id)) {
                $data = array(
                    'supplier_id' => $supplier_id,
                    'name' => $name,
                    'date' => strtotime($date),
                    'amount' => $amount,
                    'cash_recevied' => $cash_recevied,
                    'remarks' => $remarks,
                    'due' => $due,
                );
                $inserted_id = $this->payment_model->insertSupplierPayment($data);
                $this->session->set_flashdata('feedback', 'Added');
                redirect("payment/supplierDetail?supplier_id=" . $supplier_id);
            } else {
                $data = array(
                    'supplier_id' => $supplier_id,
                    'amount' => $amount,
                    'cash_recevied' => $cash_recevied,
                    'due' => $due,
                    'remarks' => $remarks,
                );
                $this->payment_model->updateSupplierPayment($id, $data);
                $this->session->set_flashdata('feedback', 'Updated!');
                redirect("payment/supplierDetails?supplier_id=" . $supplier_id);
            }
        }
    }

    function clientDetail() {
        $client_id = $this->input->get('client_id');

        if ($this->ion_auth->in_group(array('client'))) {
            $current_user_id = $this->ion_auth->get_user_id();
            $clinet_table_id = $this->client_model->getClientByIonUserId($current_user_id)->id;
            if ($clinet_table_id != $client_id) {
                redirect('home/permission');
            }
        }

        $data['client'] = $this->client_model->getClientById($client_id);
        $data['settings'] = $this->settings_model->getSettings();
        $data['payments'] = $this->payment_model->getPaymentByClient($client_id);
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('client_details', $data);
        $this->load->view('home/footer'); // just the header file
    }

    function supplierDetail() {
        $supplier_id = $this->input->get('supplier_id');
        $data['supplier'] = $this->supplier_model->getSupplierById($supplier_id);
        $data['settings'] = $this->settings_model->getSettings();
        $data['payments'] = $this->payment_model->getPaymentBySupplier($supplier_id);
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('supplier_details', $data);
        $this->load->view('home/footer'); // just the header file
    }

    function clientPayments($client_id) {
        //$client_id = $this->input->get('client_id');
        $data['client'] = $this->client_model->getClientById($client_id);
        $data['settings'] = $this->settings_model->getSettings();
        $data['payments'] = $this->payment_model->getPaymentByClient($client_id);
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('client_details', $data);
        $this->load->view('home/footer'); // just the header file
    }

    function supplierPayments($supplier_id) {
        //$client_id = $this->input->get('client_id');
        $data['supplier'] = $this->supplier_model->getSupplierById($supplier_id);
        $data['settings'] = $this->settings_model->getSettings();
        $data['payments'] = $this->payment_model->getPaymentBySupplier($supplier_id);
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('supplier_details', $data);
        $this->load->view('home/footer'); // just the header file
    }

    function clientDetails() {
        $client_id = $this->input->get('client_id');
        $data['client'] = $this->client_model->getClientById($client_id);
        $data['settings'] = $this->settings_model->getSettings();
        $data['payments'] = $this->payment_model->getPaymentByClient($client_id);
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('client_details', $data);
        $this->load->view('home/footer'); // just the header file
    }

    function supplierDetails() {
        $supplier_id = $this->input->get('supplier_id');
        $data['supplier'] = $this->supplier_model->getSupplierById($supplier_id);
        $data['settings'] = $this->settings_model->getSettings();
        $data['payments'] = $this->payment_model->getPaymentBySupplier($supplier_id);
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('supplier_details', $data);
        $this->load->view('home/footer'); // just the header file
    }

    function editPayment() {
        if ($this->ion_auth->in_group('admin')) {
            $data = array();
            $data['settings'] = $this->settings_model->getSettings();
            $id = $this->input->get('id');
            $data['payment'] = $this->payment_model->getPaymentById($id);
            $data['client'] = $this->client_model->getClientById($data['payment']->client_id);
            $this->load->view('home/dashboard', $data); // just the header file
            $this->load->view('add_payment_view', $data);
            $this->load->view('home/footer'); // just the footer file
        }
    }

    function editSupplierPayment() {
        if ($this->ion_auth->in_group('admin')) {
            $data = array();
            $data['settings'] = $this->settings_model->getSettings();
            $id = $this->input->get('id');
            $data['payment'] = $this->payment_model->getPaymentById($id);
            $data['client'] = $this->client_model->getClientById($data['payment']->client_id);
            $this->load->view('home/dashboard', $data); // just the header file
            $this->load->view('add_payment_view', $data);
            $this->load->view('home/footer'); // just the footer file
        }
    }

    function addPaymentByClientJason() {
        $data = array();
        $data['client_iid'] = $this->input->get('client_id');
        $data['client'] = $this->client_model->getClientById($this->input->get('client_id'));
        $data['settings'] = $this->settings_model->getSettings();
        echo json_encode($data);
    }

    function editPaymentByJason() {
        if ($this->ion_auth->in_group('admin')) {
            $id = $this->input->get('id');
            $data = $this->payment_model->getPaymentById($id);
            echo json_encode($data);
        }
    }

    function editSupplierPaymentByJason() {
        if ($this->ion_auth->in_group('admin')) {
            $id = $this->input->get('id');
            $data = $this->payment_model->getSupplierPaymentById($id);
            echo json_encode($data);
        }
    }

    function delete() {
        if ($this->ion_auth->in_group('admin')) {
            $id = $this->input->get('id');
            $client_id = $this->input->get('client_id');
            $this->payment_model->deletePayment($id);
            $this->session->set_flashdata('feedback', 'deleted!');
            redirect('payment/clientDetails?client_id=' . $client_id);
        }
    }

    function deleteSupplierPayment() {
        if ($this->ion_auth->in_group('admin')) {
            $id = $this->input->get('id');
            $supplier_id = $this->input->get('supplier_id');
            $this->payment_model->deleteSupplierPayment($id);
            $this->session->set_flashdata('feedback', 'deleted!');
            redirect('payment/supplierDetails?supplier_id=' . $supplier_id);
        }
    }

    function email() {
        $client_id = $this->input->post('client_id');
        $from = $this->input->post('from');
        $to = $this->input->post('to');
        $subject = $this->input->post('subject');
        $message = $this->input->post('message');
        $submit = $this->input->post('submit');
        $this->load->library('email');
        $this->email->set_newline("\r\n");
        $this->email->from($from);
        $this->email->to($to);
        $this->email->subject($subject);
        $this->email->message($message);
        if ($this->email->send()) {
            $this->session->set_flashdata('feedback', 'Email Sent');
            redirect('payment/clientDetails?client_id=' . $client_id);
        } else {
            $this->session->set_flashdata('feedback', '<i class="fa fa-close"></i> Error Sending Email');
            redirect('payment/clientDetails?client_id=' . $client_id);
        }
    }

    function myTransanctions() {
        if (!$this->ion_auth->in_group(array('admin', 'Client'))) {
            redirect('home/permission');
        }
        $client_id = $this->ion_auth->get_user_id();
        $client_id = $this->db->get_where('client', array('ion_user_id' => $client_id))->row()->id;
        $data['client'] = $this->client_model->getClientById($client_id);
        $data['settings'] = $this->settings_model->getSettings();
        $data['payments'] = $this->payment_model->getPaymentByClient($client_id);
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('client_details', $data);
        $this->load->view('home/footer'); // just the header file
    }

    function dueReport() {
        $date_from = strtotime($this->input->post('date_from'));
        $date_to = strtotime($this->input->post('date_to'));
        if (!empty($date_to)) {
            $date_to = $date_to + 24 * 60 * 60;
        }
        $data = array();
        $data['payments'] = $this->payment_model->getPaymentByDate($date_from, $date_to);
        $data['from'] = $this->input->post('date_from');
        $data['to'] = $this->input->post('date_to');
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('due_report', $data);
        $this->load->view('home/footer'); // just the footer fi
    }

}

/* End of file payment.php */
/* Location: ./application/modules/payment/controllers/payment.php */
