<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Finance_model extends CI_model {

    function __construct() {
        parent::__construct();
        $this->load->database();
    }






    function thisMonthExpense() {
        $query = $this->db->get('expense')->result();
        $total = array();
        foreach ($query as $q) {
            if (date('m/Y', time()) == date('m/Y', $q->date)) {
                $total[] = $q->amount;
            }
        }
        if (!empty($total)) {
            return array_sum($total);
        } else {
            return 0;
        }
    }




    function thisDayExpense() {
        $query = $this->db->get('expense')->result();
        $total = array();
        foreach ($query as $q) {
            if (date('d/m/Y', time()) == date('d/m/Y', $q->date)) {
                $total[] = $q->amount;
            }
        }
        if (!empty($total)) {
            return array_sum($total);
        } else {
            return 0;
        }
    }



    function thisYearExpense() {
        $query = $this->db->get('expense')->result();
        $total = array();
        foreach ($query as $q) {
            if (date('Y', time()) == date('Y', $q->date)) {
                $total[] = $q->amount;
            }
        }
        if (!empty($total)) {
            return array_sum($total);
        } else {
            return 0;
        }
    }

    
    function getExpensePerMonthThisYear() {
        $query = $this->db->get('expense')->result();
        $total = array();
        foreach ($query as $q) {
            if (date('Y', time()) == date('Y', $q->date)) {
                if (date('m', $q->date) == '01') {
                    $total['january'][] = $q->amount;
                }
                if (date('m', $q->date) == '02') {
                    $total['february'][] = $q->amount;
                }
                if (date('m', $q->date) == '03') {
                    $total['march'][] = $q->amount;
                }
                if (date('m', $q->date) == '04') {
                    $total['april'][] = $q->amount;
                }
                if (date('m', $q->date) == '05') {
                    $total['may'][] = $q->amount;
                }
                if (date('m', $q->date) == '06') {
                    $total['june'][] = $q->amount;
                }
                if (date('m', $q->date) == '07') {
                    $total['july'][] = $q->amount;
                }
                if (date('m', $q->date) == '08') {
                    $total['august'][] = $q->amount;
                }
                if (date('m', $q->date) == '09') {
                    $total['september'][] = $q->amount;
                }
                if (date('m', $q->date) == '10') {
                    $total['october'][] = $q->amount;
                }
                if (date('m', $q->date) == '11') {
                    $total['november'][] = $q->amount;
                }
                if (date('m', $q->date) == '12') {
                    $total['december'][] = $q->amount;
                }
            }
        }
        
        
        if(!empty($total['january'])){
            $total['january'] = array_sum($total['january']);
        }else{
            $total['january'] = 0;
        }
        if(!empty($total['february'])){
            $total['february'] = array_sum($total['february']);
        }else{
            $total['february'] = 0;
        }
        if(!empty($total['march'])){
            $total['march'] = array_sum($total['march']);
        }else{
            $total['march'] = 0;
        }
        if(!empty($total['april'])){
            $total['april'] = array_sum($total['april']);
        }else{
            $total['april'] = 0;
        }
        if(!empty($total['may'])){
            $total['may'] = array_sum($total['may']);
        }else{
            $total['may'] = 0;
        }
        if(!empty($total['june'])){
            $total['june'] = array_sum($total['june']);
        }else{
            $total['june'] = 0;
        }
        if(!empty($total['july'])){
            $total['july'] = array_sum($total['july']);
        }else{
            $total['july'] = 0;
        }
        if(!empty($total['august'])){
            $total['august'] = array_sum($total['august']);
        }else{
            $total['august'] = 0;
        }
        if(!empty($total['september'])){
            $total['september'] = array_sum($total['september']);
        }else{
            $total['september'] = 0;
        }
        if(!empty($total['october'])){
            $total['october'] = array_sum($total['october']);
        }else{
            $total['october'] = 0;
        }
        if(!empty($total['november'])){
            $total['november'] = array_sum($total['november']);
        }else{
            $total['november'] = 0;
        }
        if(!empty($total['december'])){
            $total['december'] = array_sum($total['december']);
        }else{
            $total['december'] = 0;
        }
        
        return $total;
    }
    
    function getClientExpenseByDate($date_from, $date_to) {
        $this->db->order_by("client_id", "desc");
        $this->db->where('date >=',$date_from);
        $this->db->where('date <=',$date_to);
        $query = $this->db->get('payment');
        return $query->result();        
    }
    
    function getClientExpenseByDateID($date_from, $date_to, $id) {
        $this->db->where('client_id',$id);
        $this->db->where('date >=',$date_from);
        $this->db->where('date <=',$date_to);
        $query = $this->db->get('payment');
        return $query->result();
    }
    
    function clientName() {
        $this->db->order_by("client_id", "desc");
        $query = $this->db->get('client');
        return $query->result();        
    }
    
    function supplierName() {
        $this->db->order_by("supplier_id", "desc");
        $query = $this->db->get('supplier');
        return $query->result();        
    }
    
    function getSupplierExpenseByDate($date_from, $date_to) {
        $this->db->order_by("supplier_id", "desc");
        $this->db->where('date >=',$date_from);
        $this->db->where('date <=',$date_to);
        $query = $this->db->get('spayment');
        return $query->result();        
    }
    
    function getSupplierExpenseByDateID($date_from, $date_to, $id) {
        $this->db->where('supplier_id',$id);
        $this->db->where('date >=',$date_from);
        $this->db->where('date <=',$date_to);
        $query = $this->db->get('spayment');
        return $query->result();
    }

    function insertExpense($data) {
        $this->db->insert('expense', $data);
    }

    function getExpense() {
        $query = $this->db->get('expense');
        return $query->result();
    }

    function getExpenseById($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('expense');
        return $query->row();
    }

    function updateExpense($id, $data) {
        $this->db->where('id', $id);
        $this->db->update('expense', $data);
    }

    function insertExpenseCategory($data) {
        $this->db->insert('expense_category', $data);
    }

    function getExpenseCategory() {
        $query = $this->db->get('expense_category');
        return $query->result();
    }

    function getExpenseCategoryById($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('expense_category');
        return $query->row();
    }

    function updateExpenseCategory($id, $data) {
        $this->db->where('id', $id);
        $this->db->update('expense_category', $data);
    }

    function deleteExpense($id) {
        $this->db->where('id', $id);
        $this->db->delete('expense');
    }

    function deleteExpenseCategory($id) {
        $this->db->where('id', $id);
        $this->db->delete('expense_category');
    }

    function getDiscountType() {
        $query = $this->db->get('settings');
        return $query->row()->discount;
    }

 




    function getDepositsByDate($date_from, $date_to) {
        $this->db->select('*');
        $this->db->from('client_deposit');
        $this->db->where('date >=', $date_from);
        $this->db->where('date <=', $date_to);
        $query = $this->db->get();
        return $query->result();
    }

    function getExpenseByDate($date_from, $date_to) {
        $this->db->select('*');
        $this->db->from('expense');
        $this->db->where('date >=', $date_from);
        $this->db->where('date <=', $date_to);
        $query = $this->db->get();
        return $query->result();
    }


    function getDepositByUserIdByDate($user, $date_from, $date_to) {
        $this->db->order_by('id', 'desc');
        $this->db->select('*');
        $this->db->from('client_deposit');
        $this->db->where('user', $user);
        $this->db->where('date >=', $date_from);
        $this->db->where('date <=', $date_to);
        $query = $this->db->get();
        return $query->result();
    }



}
