<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Client_model extends CI_model {

    function __construct() {
        parent::__construct();
        $this->load->database();
    }

    function insertClient($data) {
        $this->db->insert('client', $data);
    }
    
    public function featureClients() {
       $this->db->order_by('rand()');
       $this->db->limit(3);
       $query = $this->db->get('client');
       return $query->result();

    }
    

    function getClient() {
        $this->db->order_by('id', 'desc');
        $query = $this->db->get('client');
        return $query->result();
    }

    function getClientBySearch($search) {
        $this->db->order_by('id', 'desc');
        $this->db->like('id', $search);
        $this->db->or_like('name', $search);
        $this->db->or_like('email', $search);
        $this->db->or_like('phone', $search);
        $query = $this->db->get('client');
        return $query->result();
    }

    function getClientByLimit($limit, $start) {
        $this->db->order_by('id', 'desc');
        $this->db->limit($limit, $start);
        $query = $this->db->get('client');
        return $query->result();
    }

    function getClientByLimitBySearch($limit, $start, $search) {

        $this->db->like('id', $search);

        $this->db->order_by('id', 'desc');
        $this->db->or_like('name', $search);
        $this->db->or_like('email', $search);
        $this->db->or_like('phone', $search);
        $this->db->or_like('address', $search);

        $this->db->limit($limit, $start);
        $query = $this->db->get('client');
        return $query->result();
    }

    function getClientById($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('client');
        return $query->row();
    }
    
    function getClientByCId($id) {
        $this->db->where('client_id', $id);
        $query = $this->db->get('client');
        return $query->row();
    }

    function getClientByIonUserId($id) {
        $this->db->where('ion_user_id', $id);
        $query = $this->db->get('client');
        return $query->row();
    }

    function getClientByEmail($email) {
        $this->db->where('email', $email);
        $query = $this->db->get('client');
        return $query->row();
    }

    function updateClient($id, $data) {
        $this->db->where('id', $id);
        $this->db->update('client', $data);
    }

    function delete($id) {
        $this->db->where('id', $id);
        $this->db->delete('client');
    }

    function insertClientCategory($data) {
        $this->db->insert('client_category', $data);
    }

    function getClientCategory() {
        $this->db->order_by("id", "desc");
        $query = $this->db->get('client_category');
        return $query->result();
    }

    function getClientCategoryById($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('client_category');
        return $query->row();
    }

    function updateClientCategory($id, $data) {
        $this->db->where('id', $id);
        $this->db->update('client_category', $data);
    }

    function deleteClientCategory($id) {
        $this->db->where('id', $id);
        $this->db->delete('client_category');
    }

    function insertMedicalHistory($data) {
        $this->db->insert('medical_history', $data);
    }

    function getMedicalHistoryByClientId($id) {
        $this->db->where('client_id', $id);
        $query = $this->db->get('medical_history');
        return $query->result();
    }

    function getMedicalHistory() {
        $this->db->order_by('id', 'desc');
        $query = $this->db->get('medical_history');
        return $query->result();
    }

    function getMedicalHistoryBySearch($search) {
        $this->db->order_by('id', 'desc');
        $this->db->like('id', $search);
        $this->db->or_like('client_name', $search);
        $query = $this->db->get('medical_history');
        return $query->result();
    }

    function getMedicalHistoryByLimit($limit, $start) {
        $this->db->order_by('id', 'desc');
        $this->db->limit($limit, $start);
        $query = $this->db->get('medical_history');
        return $query->result();
    }

    function getMedicalHistoryByLimitBySearch($limit, $start, $search) {

        $this->db->like('id', $search);

        $this->db->order_by('id', 'desc');

        $this->db->or_like('client_name', $search);
        $this->db->or_like('client_phone', $search);
        $this->db->or_like('client_address', $search);

        $this->db->or_like('description', $search);

        $this->db->limit($limit, $start);
        $query = $this->db->get('medical_history');
        return $query->result();
    }

    function getMedicalHistoryById($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('medical_history');
        return $query->row();
    }

    function updateMedicalHistory($id, $data) {
        $this->db->where('id', $id);
        $this->db->update('medical_history', $data);
    }

    function insertDiagnosticReport($data) {
        $this->db->insert('diagnostic_report', $data);
    }

    function updateDiagnosticReport($id, $data) {
        $this->db->where('id', $id);
        $this->db->update('diagnostic_report', $data);
    }

    function getDiagnosticReport() {
        $this->db->order_by('id', 'desc');
        $query = $this->db->get('diagnostic_report');
        return $query->result();
    }

    function getDiagnosticReportById($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('diagnostic_report');
        return $query->row();
    }

    function getDiagnosticReportByInvoiceId($id) {
        $this->db->where('invoice', $id);
        $query = $this->db->get('diagnostic_report');
        return $query->row();
    }

    function getDiagnosticReportByClientId($id) {
        $this->db->where('client', $id);
        $query = $this->db->get('diagnostic_report');
        return $query->result();
    }

    function insertClientMaterial($data) {
        $this->db->insert('client_material', $data);
    }

    function getClientMaterial() {
        $this->db->order_by('id', 'desc');
        $query = $this->db->get('client_material');
        return $query->result();
    }

    function getDocumentBySearch($search) {
        $this->db->order_by('id', 'desc');
        $this->db->like('id', $search);
        $this->db->or_like('client_name', $search);
        $query = $this->db->get('client_material');
        return $query->result();
    }

    function getDocumentByLimit($limit, $start) {
        $this->db->order_by('id', 'desc');
        $this->db->limit($limit, $start);
        $query = $this->db->get('client_material');
        return $query->result();
    }

    function getDocumentByLimitBySearch($limit, $start, $search) {

        $this->db->like('id', $search);

        $this->db->order_by('id', 'desc');

        $this->db->or_like('date_string', $search);

        $this->db->or_like('client_name', $search);
        $this->db->or_like('client_phone', $search);
        $this->db->or_like('client_address', $search);

        $this->db->or_like('title', $search);

        $this->db->limit($limit, $start);
        $query = $this->db->get('client_material');
        return $query->result();
    }

    function getClientMaterialById($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('client_material');
        return $query->row();
    }

    function getClientMaterialByClientId($id) {
        $this->db->where('client', $id);
        $query = $this->db->get('client_material');
        return $query->result();
    }

    function deleteClientMaterial($id) {
        $this->db->where('id', $id);
        $this->db->delete('client_material');
    }

    function deleteMedicalHistory($id) {
        $this->db->where('id', $id);
        $this->db->delete('medical_history');
    }

    function updateIonUser($username, $email, $password, $ion_user_id) {
        $uptade_ion_user = array(
            'username' => $username,
            'email' => $email,
            'password' => $password
        );
        $this->db->where('id', $ion_user_id);
        $this->db->update('users', $uptade_ion_user);
    }

    function getDueBalanceByClientId($client) {
        $query = $this->db->get_where('payment', array('client' => $client))->result();
        $deposits = $this->db->get_where('client_deposit', array('client' => $client))->result();
        $balance = array();
        $deposit_balance = array();
        foreach ($query as $gross) {
            $balance[] = $gross->gross_total;
        }
        $balance = array_sum($balance);


        foreach ($deposits as $deposit) {
            $deposit_balance[] = $deposit->deposited_amount;
        }
        $deposit_balance = array_sum($deposit_balance);



        $bill_balance = $balance;

        return $due_balance = $bill_balance - $deposit_balance;
    }

}
