<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Client extends MX_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('client_model');
        $this->load->model('finance/finance_model');
        $this->load->model('sms/sms_model');
        // $this->load->module('sms');
        // $this->load->module('paypal');
        // $this->load->module('payment');

        if (!$this->ion_auth->in_group(array('admin'))) {
            redirect('home/permission');
        }
    }

    public function index() {
        if ($this->ion_auth->in_group(array('Client'))) {
            redirect('home/permission');
        }
        $data['categorys'] = $this->client_model->getClientCategory();
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('client', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function calendar() {
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('calendar', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function addNewView() {
        if ($this->ion_auth->in_group(array('Client'))) {
            redirect('home/permission');
        }
        $data = array();
        //$data['areas'] = $this->area_model->getArea();
        $data['categorys'] = $this->client_model->getClientCategory();
        //$data['groups'] = $this->donor_model->getBloodBank();
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('add_new', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function addNew() {

        if ($this->ion_auth->in_group(array('Client'))) {
            redirect('home/permission');
        }

        $id = $this->input->post('id');
        $redirect = $this->input->get('redirect');
        $name = $this->input->post('name');
        $password = $this->input->post('password');
        
        $category = $this->input->post('category');
        $address = $this->input->post('address');
        $phone = $this->input->post('phone');
        
        $client_id = $this->input->post('client_id');
        if (empty($client_id)) {
            $client_id = rand(10000, 1000000);
        }
        if ((empty($id))) {
            $add_date = date("d-m-y");
            
        } else {
            $add_date = $this->client_model->getClientById($id)->add_date;   
        }


        $email = $this->input->post('email');
        if (empty($email)) {
            $email = $name . '@keswatech.com';
        }



        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');

        // Validating Name Field
        $this->form_validation->set_rules('name', 'Name', 'trim|required|min_length[2]|max_length[100]|xss_clean');
        // Validating Password Field
        if (empty($id)) {
            $this->form_validation->set_rules('password', 'Password', 'trim|min_length[3]|max_length[100]|xss_clean');
        }
        // Validating Email Field
        $this->form_validation->set_rules('email', 'Email', 'trim|min_length[2]|max_length[100]|xss_clean');
        // Validating Volunteer Field
        //   $this->form_validation->set_rules('volunteer', 'Volunteer', 'trim|min_length[1]|max_length[100]|xss_clean');
        // Validating Address Field   
        $this->form_validation->set_rules('address', 'Address', 'trim|required|min_length[2]|max_length[500]|xss_clean');
        // Validating Phone Field           
        $this->form_validation->set_rules('phone', 'Phone', 'trim|required|min_length[2]|max_length[50]|xss_clean');
        //$this->form_validation->set_rules('date', 'Date', 'trim|required|min_length[2]|max_length[50]|xss_clean');
        
        
        if ($this->form_validation->run() == FALSE) {
            if (!empty($id)) {
                $this->session->set_flashdata('feedback', 'Validation Error !');
                redirect("client/editClient?id=$id");
            } else {
                $data = array();
                $data['setval'] = 'setval';
                $data['categorys'] = $this->client_model->getClientCategory();
                
                $this->load->view('home/dashboard'); // just the header file
                $this->load->view('add_new', $data);
                $this->load->view('home/footer'); // just the header file
            }
        } else {
            $file_name = $_FILES['img_url']['name'];
            $file_name_pieces = explode('_', $file_name);
            $new_file_name = '';
            $count = 1;
            foreach ($file_name_pieces as $piece) {
                if ($count !== 1) {
                    $piece = ucfirst($piece);
                }

                $new_file_name .= $piece;
                $count++;
            }
            $config = array(
                'file_name' => $new_file_name,
                'upload_path' => "./uploads/",
                'allowed_types' => "gif|jpg|png|jpeg|pdf",
                'overwrite' => False,
                'max_size' => "20480000", // Can be set to particular file size , here it is 2 MB(2048 Kb)
                'max_height' => "1768",
                'max_width' => "2024"
            );

            $this->load->library('Upload', $config);
            $this->upload->initialize($config);

            if ($this->upload->do_upload('img_url')) {
                $path = $this->upload->data();
                $img_url = "uploads/" . $path['file_name'];
                $data = array();
                $data = array(
                    'client_id' => $client_id,
                    'img_url' => $img_url,
                    'name' => $name,
                    'client_category' => $category,
                    'email' => $email,
                    'address' => $address,
                    //'remarks' => $remarks,
                    'phone' => $phone,
                    'add_date' => $add_date
                    
                );
            } else {
                //$error = array('error' => $this->upload->display_errors());
                $data = array();
                $data = array(
                    'client_id' => $client_id,
                    
                    'name' => $name,
                    'client_category' => $category,
                    'email' => $email,
                    'address' => $address,
                    //'remarks' => $remarks,
                    'phone' => $phone,
                    
                    'add_date' => $add_date
                );
            }

            $username = $this->input->post('name');

            if (empty($id)) {     // Adding New Client
                if ($this->ion_auth->email_check($email)) {
                    $this->session->set_flashdata('feedback', 'This Email Address Is Already Registered');
                    redirect('client/addNewView');
                } else {
                    $dfg = array(6);
                    $additional_data = array();
                    $this->ion_auth->register($username, $password, $email, $additional_data, $dfg);
                    $ion_user_id = $this->db->get_where('users', array('email' => $email))->row()->id;
                    $this->client_model->insertClient($data);
                    $client_user_id = $this->db->get_where('client', array('email' => $email))->row()->id;
                    $id_info = array('ion_user_id' => $ion_user_id);
                    $this->client_model->updateClient($client_user_id, $id_info);

                    if (!empty($sms)) {
                        $this->sms->sendSmsDuringClientRegistration($client_user_id);
                    }




                    $this->session->set_flashdata('feedback', 'Added');
                }
                //    }
            } else { // Updating Client
                $ion_user_id = $this->db->get_where('client', array('id' => $id))->row()->ion_user_id;
                if (empty($password)) {
                    $password = $this->db->get_where('users', array('id' => $ion_user_id))->row()->password;
                } else {
                    $password = $this->ion_auth_model->hash_password($password);
                }
                $this->client_model->updateIonUser($username, $email, $password, $ion_user_id);
                $this->client_model->updateClient($id, $data);
                $this->session->set_flashdata('feedback', 'Updated');
            }
            // Loading View
            if (!empty($redirect)) {
                redirect('finance/addPaymentView');
            } else {
                redirect('client');
            }
        }
    }

    function editClient() {
        $data = array();
        $id = $this->input->get('id');
        $data['client'] = $this->client_model->getClientById($id);
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('add_new', $data);
        $this->load->view('home/footer'); // just the footer file
    }

    function editClientByJason() {
        $id = $this->input->get('id');
        $data['client'] = $this->client_model->getClientById($id);
        echo json_encode($data);
    }

    function getClientByJason() {
        $id = $this->input->get('id');
        $data['client'] = $this->client_model->getClientById($id);

        $area = $data['client']->area;
        $data['area'] = $this->area_model->getAreaById($area);

        if (!empty($data['client']->birthdate)) {
            $birthDate = strtotime($data['client']->birthdate);
            $birthDate = date('m/d/Y', $birthDate);
            $birthDate = explode("/", $birthDate);
            $age = (date("md", date("U", mktime(0, 0, 0, $birthDate[0], $birthDate[1], $birthDate[2]))) > date("md") ? ((date("Y") - $birthDate[2]) - 1) : (date("Y") - $birthDate[2]));
            $data['age'] = $age . ' Year(s)';
        }

        echo json_encode($data);
    }

    function clientDetails() {
        $data = array();
        $id = $this->input->get('id');
        $data['client'] = $this->client_model->getClientById($id);
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('details', $data);
        $this->load->view('home/footer'); // just the footer file
    }

    function report() {
        $data = array();
        $id = $this->input->get('id');
        $data['settings'] = $this->settings_model->getSettings();
        $data['payment'] = $this->finance_model->getPaymentById($id);
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('diagnostic_report_details', $data);
        $this->load->view('home/footer'); // just the footer file
    }

    function caseList() {
        $data['settings'] = $this->settings_model->getSettings();
        $data['clients'] = $this->client_model->getClient();
        $data['medical_histories'] = $this->client_model->getMedicalHistory();
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('case_list', $data);
        $this->load->view('home/footer'); // just the footer file
    }

    

  

    function deposit() {
        $id = $this->input->post('id');


        if ($this->ion_auth->in_group(array('Client'))) {
            $client_ion_id = $this->ion_auth->get_user_id();
            $client = $this->client_model->getClientByIonUserId($client_ion_id)->id;
        } else {
            $this->session->set_flashdata('feedback', 'Undefined Client Id');
            redirect('client/myPaymentsHistory');
        }



        $payment_id = $this->input->post('payment_id');
        $date = time();

        $deposited_amount = $this->input->post('deposited_amount');

        $deposit_type = $this->input->post('deposit_type');

        if ($deposit_type != 'Card') {
            $this->session->set_flashdata('feedback', 'Undefined Payment Type');
            redirect('client/myPaymentsHistory');
        }

        $user = $this->ion_auth->get_user_id();

        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
// Validating Client Name Field
        $this->form_validation->set_rules('client', 'Client', 'trim|min_length[1]|max_length[100]|xss_clean');
// Validating Deposited Amount Field
        $this->form_validation->set_rules('deposited_amount', 'Deposited Amount', 'trim|min_length[1]|max_length[100]|xss_clean');
        if ($this->form_validation->run() == FALSE) {
            redirect('client/myPaymentsHistory');
        } else {
            $data = array();
            $data = array('client' => $client,
                'date' => $date,
                'payment_id' => $payment_id,
                'deposited_amount' => $deposited_amount,
                'deposit_type' => $deposit_type,
                'user' => $user
            );
            if (empty($id)) {
                if ($deposit_type == 'Card') {
                    $payment_details = $this->finance_model->getPaymentById($payment_id);
                    $gateway = $this->settings_model->getSettings()->payment_gateway;
                    if ($gateway == 'PayPal') {
                        $card_type = $this->input->post('card_type');
                        $card_number = $this->input->post('card_number');
                        $expire_date = $this->input->post('expire_date');
                        $cvv = $this->input->post('cvv');

                        $all_details = array(
                            'client' => $payment_details->client,
                            'date' => $payment_details->date,
                            'amount' => $payment_details->amount,
                            'volunteer' => $payment_details->volunteer_name,
                            'discount' => $payment_details->discount,
                            'flat_discount' => $payment_details->flat_discount,
                            'gross_total' => $payment_details->gross_total,
                            'status' => 'unpaid',
                            'client_name' => $payment_details->client_name,
                            'client_phone' => $payment_details->client_phone,
                            'client_address' => $payment_details->client_address,
                            'deposited_amount' => $deposited_amount,
                            'payment_id' => $payment_details->id,
                            'card_type' => $card_type,
                            'card_number' => $card_number,
                            'expire_date' => $expire_date,
                            'cvv' => $cvv,
                            'from' => 'client_payment_details',
                            'user' => $user
                        );
                        $this->paypal->Do_direct_payment($all_details);
                    } elseif ($gateway == 'Pay U Money') {
                        redirect("payu/check?deposited_amount=" . "$deposited_amount" . '&payment_id=' . $payment_id);
                    } else {
                        $this->session->set_flashdata('feedback', 'Payment failed. No Gateway Selected');
                        redirect('client/myPaymentHistory');
                    }
                } else {
                    $this->finance_model->insertDeposit($data);
                    $this->session->set_flashdata('feedback', 'Added');
                }
            } else {
                $this->finance_model->updateDeposit($id, $data);

                $amount_received_id = $this->finance_model->getDepositById($id)->amount_received_id;
                if (!empty($amount_received_id)) {
                    $amount_received_payment_id = explode('.', $amount_received_id);
                    $payment_id = $amount_received_payment_id[0];
                    $data_amount_received = array('amount_received' => $deposited_amount);
                    $this->finance_model->updatePayment($amount_received_payment_id[0], $data_amount_received);
                }

                $this->session->set_flashdata('feedback', 'Updated');
            }
            redirect('client/myPaymentHistory');
        }
    }
    
    function myPaymentsHistory() {
        $id = $this->ion_auth->get_user_id();
        $client = $this->cliend_model->getClientById($id);
        $this->payment->clientPayments($client->client_id);
    }

    function myInvoice() {
        $id = $this->input->get('id');
        $data['settings'] = $this->settings_model->getSettings();
        $data['discount_type'] = $this->finance_model->getDiscountType();
        $data['payment'] = $this->finance_model->getPaymentById($id);
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('myInvoice', $data);
        $this->load->view('home/footer'); // just the footer fi
    }

    

    function clientMaterial() {
        $data = array();
        $id = $this->input->get('client');
        $data['settings'] = $this->settings_model->getSettings();
        $data['client'] = $this->client_model->getClientById($id);
        $data['client_materials'] = $this->client_model->getClientMaterialByClientId($id);
        $this->load->view('home/dashboard', $data); // just the header file
        $this->load->view('client_material', $data);
        $this->load->view('home/footer'); // just the footer file
    }

    function addClientMaterial() {
        $title = $this->input->post('title');
        $client_id = $this->input->post('client');
        $img_url = $this->input->post('img_url');
        $date = time();
        $redirect = $this->input->post('redirect');
        if (empty($redirect)) {
            $redirect = "client/medicalHistory?id=" . $client_id;
        }
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');

        // Validating Client Field
        $this->form_validation->set_rules('client', 'Client', 'trim|required|min_length[1]|max_length[100]|xss_clean');


        if ($this->form_validation->run() == FALSE) {
            $this->session->set_flashdata('feedback', 'Validation Error !');
            redirect($redirect);
        } else {

            if (!empty($client_id)) {
                $client_details = $this->client_model->getClientById($client_id);
                $client_name = $client_details->name;
                $client_phone = $client_details->phone;
                $client_address = $client_details->address;
            } else {
                $client_name = 0;
                $client_phone = 0;
                $client_address = 0;
            }

            $file_name = $_FILES['img_url']['name'];
            $file_name_pieces = explode('_', $file_name);
            $new_file_name = '';
            $count = 1;
            foreach ($file_name_pieces as $piece) {
                if ($count !== 1) {
                    $piece = ucfirst($piece);
                }

                $new_file_name .= $piece;
                $count++;
            }
            $config = array(
                'file_name' => $new_file_name,
                'upload_path' => "./uploads/",
                'allowed_types' => "gif|jpg|png|jpeg|pdf",
                'overwrite' => False,
                'max_size' => "48000000", // Can be set to particular file size , here it is 2 MB(2048 Kb)
                'max_height' => "3000",
                'max_width' => "2024"
            );

            $this->load->library('Upload', $config);
            $this->upload->initialize($config);

            if ($this->upload->do_upload('img_url')) {
                $path = $this->upload->data();
                $img_url = "uploads/" . $path['file_name'];
                $data = array();
                $data = array(
                    'date' => $date,
                    'title' => $title,
                    'url' => $img_url,
                    'client' => $client_id,
                    'client_name' => $client_name,
                    'client_address' => $client_address,
                    'client_phone' => $client_phone,
                    'date_string' => date('d-m-y', $date),
                );
            } else {
                $data = array();
                $data = array(
                    'date' => $date,
                    'title' => $title,
                    'client' => $client_id,
                    'client_name' => $client_name,
                    'client_address' => $client_address,
                    'client_phone' => $client_phone,
                    'date_string' => date('d-m-y', $date),
                );
                $this->session->set_flashdata('feedback', 'Upload Error !');
            }

            $this->client_model->insertClientMaterial($data);
            $this->session->set_flashdata('feedback', 'Added');


            redirect($redirect);
        }
    }

    function deleteCaseHistory() {
        $id = $this->input->get('id');
        $redirect = $this->input->get('redirect');
        $case_history = $this->client_model->getMedicalHistoryById($id);
        $this->client_model->deleteMedicalHistory($id);
        $this->session->set_flashdata('feedback', 'Deleted');
        if ($redirect == 'case') {
            redirect('client/caseList');
        } else {
            redirect("client/MedicalHistory?id=" . $case_history->client_id);
        }
    }

  

    function delete() {
        $data = array();
        $id = $this->input->get('id');
        $user_data = $this->db->get_where('client', array('id' => $id))->row();
        $path = $user_data->img_url;

        if (!empty($path)) {
            unlink($path);
        }
        $ion_user_id = $user_data->ion_user_id;
        $this->db->where('id', $ion_user_id);
        $this->db->delete('users');
        $this->client_model->delete($id);
        $this->session->set_flashdata('feedback', 'Deleted');
        redirect('client');
    }

    public function clientCategory() {
        $data['categorys'] = $this->client_model->getClientCategory();
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('client_category', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function addClientcategoryView() {
        $data = array();
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('add_new_client_category', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function addClientCategory() {
        $data['categorys'] = $this->client_model->getClientCategory();
        $id = $this->input->post('id');
        $category = $this->input->post('category');
        $description = $this->input->post('description');
        
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');

        // Validating Category Field
        $this->form_validation->set_rules('category', 'Client Category', 'trim|min_length[1]|max_length[100]|xss_clean');

        // Validating Description Field
        $this->form_validation->set_rules('description', 'Client Description', 'trim|min_length[1]|max_length[100]|xss_clean');

        if ($this->form_validation->run() == FALSE) {
            if (!empty($id)) {
                redirect("client/editClientCategory?id=$id");
            } else {
                $this->load->view('home/dashboard'); // just the header file
                $this->load->view('add_new_client_category', $data);
                $this->load->view('home/footer'); // just the header file
            }
        } else {

            $data = array();
            $data = array(
                'category' => $category,
                'description' => $description,
            );


            $username = $this->input->post('name');

            if (empty($id)) {     // Adding New Client
                $this->client_model->insertClientCategory($data);
                redirect('client/clientCategory');
            } else { // Updating Client
                $this->client_model->updateClientCategory($id, $data);
                $this->session->set_flashdata('feedback', 'Updated');
                redirect('client/clientCategory');
            }
            // Loading View
        }
    }

    function getClientCatory() {
        $data['client'] = $this->client_model->getClient();
        $this->load->view('client', $data);
    }

    function editClientCategory() {
        $data = array();
        $id = $this->input->get('id');
        $data['category'] = $this->client_model->getClientCategoryById($id);
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('add_new_client_category', $data);
        $this->load->view('home/footer'); // just the footer file
    }

    function editClientcategoryByJason() {
        $id = $this->input->get('id');
        $data['category'] = $this->client_model->getClientCategoryById($id);
        echo json_encode($data);
    }

    function deleteClientCategory() {
        $data = array();
        $id = $this->input->get('id');
        $this->client_model->deleteClientCategory($id);
        redirect('client/clientCategory');
    }

    function getClient() {
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];

        if ($limit == -1) {
            if (!empty($search)) {
                $data['clients'] = $this->client_model->getClientBysearch($search);
            } else {
                $data['clients'] = $this->client_model->getClient();
            }
        } else {
            if (!empty($search)) {
                $data['clients'] = $this->client_model->getClientByLimitBySearch($limit, $start, $search);
            } else {
                $data['clients'] = $this->client_model->getClientByLimit($limit, $start);
            }
        }
        //  $data['clients'] = $this->client_model->getClient();

        foreach ($data['clients'] as $client) {

            if ($this->ion_auth->in_group(array('admin', 'Volunteer'))) {
                //   $options1 = '<a type="button" class="btn editbutton" title="Edit" data-toggle="modal" data-id="463"><i class="fa fa-edit"> </i> Edit</a>';
                $option = '<button type="button" data-toggle="modal" data-id="'.$client->id.'" class="btn btn-primary add_payment addpayment"><i class="fa fa-money"> ' . lang('add_payment') .'</i></button>  ';
                $options1 = ' <a type="button" class="btn editbutton" title="' . lang('edit') . '" data-toggle = "modal" data-id="' . $client->id . '"><i class="fa fa-edit"> </i> ' . lang('edit') . '</a>';
            }

            $options2 = '<a class="btn detailsbutton" title="' . lang('info') . '" style="color: #fff;" href="payment/clientDetail?client_id=' . $client->id . '"><i class="fa fa-info"></i> ' . lang('details') . '</a>';

            if ($this->ion_auth->in_group(array('admin', 'Accountant', 'Receptionist', 'Laboratorist', 'Nurse', 'Volunteer'))) {
                $options5 = '<a class="btn delete_button" title="' . lang('delete') . '" href="client/delete?id=' . $client->id . '" onclick="return confirm(\'Are you sure you want to delete this item?\');"><i class="fa fa-trash-o"></i> ' . lang('delete') . '</a>';
            }

            $options6 = ' <a type="button" class="btn detailsbutton inffo" title="' . lang('info') . '" href="payment/clientDetail?client_id=' . $client->id . '"><i class="fa fa-info"> </i> ' . lang('history') . '</a>';

            if ($this->ion_auth->in_group(array('admin'))) {
                $info[] = array(
                    $client->client_id,
                    '<img src="'.$client->img_url.'" width= "100">',
                    $client->name,
                    $client->client_category,
                    $client->email,
                    $client->phone,
                    $option,
                    $options1 . ' ' . $options6 . ' ' . $options5,
                        //  $options2
                );
            }

            if ($this->ion_auth->in_group(array('Accountant', 'Receptionist'))) {
                $info[] = array(
                    $client->client_id,
                    $client->img_url,
                    $client->name,
                    $client->client_category,
                    $client->email,
                    $client->phone,
                    $options1,
                    $options1 . ' ' . $options6 . ' ' . $options4,
                        //  $options2
                );
            }

            if ($this->ion_auth->in_group(array('Volunteer'))) {
                $info[] = array(
                    $client->client_id,
                    $client->img_url,
                    $client->name,
                    $client->client_category,
                    $client->email,
                    $client->phone,
                    $options1,
                    $options1 . ' ' . $options6 . ' ' . $options3,
                        //  $options2
                );
            }
        }

        if (!empty($data['clients'])) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => $this->db->get('client')->num_rows(),
                "recordsFiltered" => $this->db->get('client')->num_rows(),
                "data" => $info
            );
        } else {
            $output = array(
                // "draw" => 1,
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }

    function getClientPayments() {
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];

        if ($limit == -1) {
            if (!empty($search)) {
                $data['clients'] = $this->client_model->getClientBysearch($search);
            } else {
                $data['clients'] = $this->client_model->getClient();
            }
        } else {
            if (!empty($search)) {
                $data['clients'] = $this->client_model->getClientByLimitBySearch($limit, $start, $search);
            } else {
                $data['clients'] = $this->client_model->getClientByLimit($limit, $start);
            }
        }
        //  $data['clients'] = $this->client_model->getClient();

        foreach ($data['clients'] as $client) {

            if ($this->ion_auth->in_group(array('admin', 'Accountant', 'Receptionist', 'Laboratorist', 'Nurse', 'Volunteer'))) {
                //   $options1 = '<a type="button" class="btn editbutton" title="Edit" data-toggle="modal" data-id="463"><i class="fa fa-edit"> </i> Edit</a>';
                $options1 = ' <a type="button" class="btn editbutton" title="' . lang('edit') . '" data-toggle = "modal" data-id="' . $client->id . '"><i class="fa fa-edit"> </i> ' . lang('edit') . '</a>';
            }

            $options2 = '<a class="btn detailsbutton" title="' . lang('info') . '" style="color: #fff;" href="client/clientDetails?id=' . $client->id . '"><i class="fa fa-info"></i> ' . lang('details') . '</a>';

            $options3 = '<a class="btn green" title="' . lang('history') . '" style="color: #fff;" href="client/medicalHistory?id=' . $client->id . '"><i class="fa fa-stethoscope"></i> ' . lang('history') . '</a>';

            $options4 = '<a class="btn btn-xs green" title="' . lang('payment') . ' ' . lang('history') . '" style="color: #fff;" href="finance/clientPaymentHistory?client=' . $client->id . '"><i class="fa fa-money"></i> ' . lang('payment') . ' ' . lang('history') . '</a>';

            if ($this->ion_auth->in_group(array('admin', 'Accountant', 'Receptionist', 'Laboratorist', 'Nurse', 'Volunteer'))) {
                $options5 = '<a class="btn delete_button" title="' . lang('delete') . '" href="client/delete?id=' . $client->id . '" onclick="return confirm(\'Are you sure you want to delete this item?\');"><i class="fa fa-trash-o"></i> ' . lang('delete') . '</a>';
            }

            $due = $this->settings_model->getSettings()->currency . $this->client_model->getDueBalanceByClientId($client->id);

            $info[] = array(
                $client->id,
                $client->name,
                $client->phone,
                $due,
                //  $options1 . ' ' . $options2 . ' ' . $options3 . ' ' . $options4 . ' ' . $options5,
                $options4
            );
        }

        if (!empty($data['clients'])) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => $this->db->get('client')->num_rows(),
                "recordsFiltered" => $this->db->get('client')->num_rows(),
                "data" => $info
            );
        } else {
            $output = array(
                // "draw" => 1,
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }

    function getCaseList() {
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];

        if ($limit == -1) {
            if (!empty($search)) {
                $data['cases'] = $this->client_model->getMedicalHistoryBySearch($search);
            } else {
                $data['cases'] = $this->client_model->getMedicalHistory();
            }
        } else {
            if (!empty($search)) {
                $data['cases'] = $this->client_model->getMedicalHistoryByLimitBySearch($limit, $start, $search);
            } else {
                $data['cases'] = $this->client_model->getMedicalHistoryByLimit($limit, $start);
            }
        }
        //  $data['clients'] = $this->client_model->getClient();

        foreach ($data['cases'] as $case) {

            if ($this->ion_auth->in_group(array('admin', 'Accountant', 'Receptionist', 'Laboratorist', 'Nurse', 'Volunteer'))) {
                //   $options1 = '<a type="button" class="btn editbutton" title="Edit" data-toggle="modal" data-id="463"><i class="fa fa-edit"> </i> Edit</a>';
                $options1 = ' <a type="button" class="btn btn-info btn-xs btn_width editbutton" title="' . lang('edit') . '" data-toggle = "modal" data-id="' . $case->id . '"><i class="fa fa-edit"> </i> </a>';
            }
            if ($this->ion_auth->in_group(array('admin', 'Accountant', 'Receptionist', 'Laboratorist', 'Nurse', 'Volunteer'))) {
                $options2 = '<a class="btn btn-info btn-xs btn_width delete_button" title="' . lang('delete') . '" href="client/deleteCaseHistory?id=' . $case->id . '&redirect=case" onclick="return confirm(\'Are you sure you want to delete this item?\');"><i class="fa fa-trash-o"></i></a>';
                $options3 = ' <a type="button" class="btn btn-info btn-xs btn_width detailsbutton case" title="' . lang('case') . '" data-toggle = "modal" data-id="' . $case->id . '"><i class="fa fa-file"> </i> </a>';
            }

            if (!empty($case->client_id)) {
                $client_info = $this->client_model->getClientById($case->client_id);
                if (!empty($client_info)) {
                    $client_details = $client_info->name . '</br>' . $client_info->address . '</br>' . $client_info->phone . '</br>';
                } else {
                    $client_details = $case->client_name . '</br>' . $case->client_address . '</br>' . $case->client_phone . '</br>';
                }
            } else {
                $client_details = '';
            }

            $info[] = array(
                date('d-m-Y', $case->date),
                $client_details,
                $case->title,
                $options3 . ' ' . $options1 . ' ' . $options2
                    // $options4
            );
        }

        if (!empty($data['cases'])) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => $this->db->get('medical_history')->num_rows(),
                "recordsFiltered" => $this->db->get('medical_history')->num_rows(),
                "data" => $info
            );
        } else {
            $output = array(
                // "draw" => 1,
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }

    function getDocuments() {
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];

        if ($limit == -1) {
            if (!empty($search)) {
                $data['documents'] = $this->client_model->getDocumentBySearch($search);
            } else {
                $data['documents'] = $this->client_model->getClientMaterial();
            }
        } else {
            if (!empty($search)) {
                $data['documents'] = $this->client_model->getDocumentByLimitBySearch($limit, $start, $search);
            } else {
                $data['documents'] = $this->client_model->getDocumentByLimit($limit, $start);
            }
        }
        //  $data['clients'] = $this->client_model->getClient();

        foreach ($data['documents'] as $document) {

            if ($this->ion_auth->in_group(array('admin', 'Accountant', 'Receptionist', 'Laboratorist', 'Nurse', 'Volunteer'))) {
                //   $options1 = '<a type="button" class="btn editbutton" title="Edit" data-toggle="modal" data-id="463"><i class="fa fa-edit"> </i> Edit</a>';
                $options1 = '<a class="btn btn-info btn-xs" href="' . $document->url . '" download> ' . lang('download') . ' </a>';
            }
            if ($this->ion_auth->in_group(array('admin', 'Accountant', 'Receptionist', 'Laboratorist', 'Nurse', 'Volunteer'))) {
                $options2 = '<a class="btn btn-info btn-xs delete_button" href="client/deleteClientMaterial?id=' . $document->id . '&redirect=documents"onclick="return confirm(\'You want to delete the item??\');"> X </a>';
            }

            if (!empty($document->client)) {
                $client_info = $this->client_model->getClientById($document->client);
                if (!empty($client_info)) {
                    $client_details = $client_info->name . '</br>' . $client_info->address . '</br>' . $client_info->phone . '</br>';
                } else {
                    $client_details = $document->client_name . '</br>' . $document->client_address . '</br>' . $document->client_phone . '</br>';
                }
            } else {
                $client_details = '';
            }

            $info[] = array(
                date('d-m-y', $document->date),
                $client_details,
                $document->title,
                '<img src="' . $document->url . '" width="100px" height="100px">',
                $options1 . ' ' . $options2
                    // $options4
            );
        }

        if (!empty($data['documents'])) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => $this->db->get('client_material')->num_rows(),
                "recordsFiltered" => $this->db->get('client_material')->num_rows(),
                "data" => $info
            );
        } else {
            $output = array(
                // "draw" => 1,
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }

}

/* End of file client.php */
    /* Location: ./application/modules/client/controllers/client.php */
    