"use strict";
$(document).ready(function () {
    "use strict";
    $(".table").on("click", ".editbutton1", function () {
        "use strict";
        $("#loader").show();
        var iid = $(this).attr('data-id');
        $('#divbuttontag').html("");

        $.ajax({
            url: 'sms/editAutoSMSTemplate?id=' + iid,
            method: 'GET',
            data: '',
            dataType: 'json',
            success: function (response) {
                "use strict";
                $('#smstemp').find('[name="id"]').val(response.autotemplatename.id).end();
                $('#smstemp').find('[name="category"]').val(response.autotemplatename.name).end();
                $('#smstemp').find('[name="message"]').val(response.autotemplatename.message).end();
                var option = '';
                var count = 0;
                $.each(response.autotag, function (index, value) {
                    "use strict";
                    option += '<input type="button" name="myBtn" value="' + value.name + '" onClick="addtext(this);">';
                    count += 1;
                    if (count % 7 === 0) {
                        option += '<br><br>';
                    }
                });
                $('#divbuttontag').html(option);
                $('#status').html(response.status_options);
                $('#myModal1').modal('show');
            },
            complete: function () {
                $("#loader").hide();
            }
        })
    });
});

// Initialize DataTables for each language tab
$(document).ready(function () {
    "use strict";
    
    // Common DataTable configuration
    var commonConfig = {
        responsive: true,
        "processing": true,
        "serverSide": true,
        "searchable": true,
        "autoWidth": false,
        "scrollX": true,
        scroller: {
            loadingIndicator: true
        },
        dom: "<'row'<'col-sm-3'><'col-sm-5 text-center'B><'col-sm-4'>>" +
            "<'row'<'col-sm-12'tr>>" +
            "<'row'<'col-sm-5'i><'col-sm-7'>>",
        buttons: [
            { extend: 'copyHtml5', exportOptions: { columns: [0, 1, 2], } },
            { extend: 'excelHtml5', exportOptions: { columns: [0, 1, 2], } },
            { extend: 'csvHtml5', exportOptions: { columns: [0, 1, 2], } },
            { extend: 'pdfHtml5', exportOptions: { columns: [0, 1, 2], } },
            { extend: 'print', exportOptions: { columns: [0, 1, 2], } },
        ],
        "columns": [
            { "width": "8%", "className": "text-center" },   // #
            { "width": "20%" },                               // Category
            { "width": "45%" },                               // Message
            { "width": "12%", "className": "text-center" },  // Status
            { "width": "15%", "className": "text-center" }   // Options
        ],
        "columnDefs": [
            {
                "targets": [2], // Message column
                "render": function(data, type, row) {
                    if (type === 'display' && data && data.length > 80) {
                        return '<div style="white-space: normal; word-wrap: break-word; max-width: 400px;"><span title="' + data + '">' + data.substr(0, 80) + '...</span></div>';
                    }
                    return '<div style="white-space: normal; word-wrap: break-word; max-width: 400px;">' + (data || '') + '</div>';
                }
            }
        ],
        aLengthMenu: [
            [10, 25, 50, 100, -1],
            [10, 25, 50, 100, "All"]
        ],
        iDisplayLength: 100,
        "order": [[0, "desc"]],
        "language": {
            "lengthMenu": "_MENU_",
            search: "_INPUT_",
            searchPlaceholder: "Search..."
        }
    };

    // English Table
    var englishTable = $('#english-table').DataTable($.extend({}, commonConfig, {
        "ajax": {
            url: "sms/getAutoSMSTemplateList",
            type: 'POST',
            'data': { 'language': 'english' }
        }
    }));
    englishTable.buttons().container().appendTo('.custom_buttons');

    // Sinhala Table
    var sinhalaTable = $('#sinhala-table').DataTable($.extend({}, commonConfig, {
        "ajax": {
            url: "sms/getAutoSMSTemplateList",
            type: 'POST',
            'data': { 'language': 'sinhala' }
        }
    }));
    sinhalaTable.buttons().container().appendTo('.custom_buttons');

    // Tamil Table
    var tamilTable = $('#tamil-table').DataTable($.extend({}, commonConfig, {
        "ajax": {
            url: "sms/getAutoSMSTemplateList",
            type: 'POST',
            'data': { 'language': 'tamil' }
        }
    }));
    tamilTable.buttons().container().appendTo('.custom_buttons');

    // Handle tab switching to reload data and adjust columns
    $('#smsTemplateTabs a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
        var target = $(e.target).attr("href");
        if (target === '#english-templates') {
            setTimeout(function() {
                englishTable.columns.adjust().responsive.recalc();
                englishTable.ajax.reload();
            }, 150);
        } else if (target === '#sinhala-templates') {
            setTimeout(function() {
                sinhalaTable.columns.adjust().responsive.recalc();
                sinhalaTable.ajax.reload();
            }, 150);
        } else if (target === '#tamil-templates') {
            setTimeout(function() {
                tamilTable.columns.adjust().responsive.recalc();
                tamilTable.ajax.reload();
            }, 150);
        }
    });

    // Force column adjustment on window resize
    $(window).on('resize', function() {
        setTimeout(function() {
            englishTable.columns.adjust();
            sinhalaTable.columns.adjust();
            tamilTable.columns.adjust();
        }, 100);
    });
});

$(document).ready(function () {
    "use strict";
    $(".flashmessage").delay(3000).fadeOut(100);
});

function addtext(ele) {
    "use strict";
    var fired_button = ele.value;
    document.myform.message.value += fired_button;
}

