<?php 
// Debug: Check if variables are set
$is_patient = $this->ion_auth->in_group(array('Patient'));
$hospitals_exist = isset($hospitals) && !empty($hospitals);
$selected_hospital_set = isset($selected_hospital);

if ($is_patient && $hospitals_exist) { ?>
    <!-- Hospital Selection Dropdown (Patient Portal) -->
    <!-- Debug Info: Patient=<?php echo $is_patient ? 'Yes' : 'No'; ?>, Hospitals=<?php echo count($hospitals); ?>, Selected=<?php echo isset($selected_hospital) ? $selected_hospital : 'Not set'; ?> -->
    <div class="row mb-3">
        <div class="col-12">
            <div class="d-flex align-items-center justify-content-between flex-wrap">
                <div class="mr-3">
                    <label class="font-weight-bold text-primary mb-1">
                        <i class="fas fa-hospital mr-2"></i>Select Hospital Data View:
                    </label>
                    <select class="form-control" id="patient_hospital_select" name="hospital_id" 
                            style="min-width: 250px; border: 2px solid #007bff;">
                        <option value="consolidated" <?php echo ($selected_hospital === 'consolidated') ? 'selected' : ''; ?>>
                            📊 Consolidated Data (All Hospitals)
                        </option>
                        <?php foreach ($hospitals as $hospital) { ?>
                            <option value="<?php echo $hospital->id; ?>" 
                                    <?php echo ($selected_hospital == $hospital->id) ? 'selected' : ''; ?>>
                                🏥 <?php echo $hospital->name; ?>
                            </option>
                        <?php } ?>
                    </select>
                </div>
                
                <!-- Current Hospital View Indicator -->
                <div class="ml-auto">
                    <?php if ($selected_hospital === 'consolidated') { ?>
                        <span class="badge badge-info">
                            <i class="fas fa-globe mr-1"></i>Consolidated View
                        </span>
                    <?php } elseif (!empty($selected_hospital)) { ?>
                        <?php 
                        $current_hospital_name = '';
                        foreach ($hospitals as $hospital) {
                            if ($hospital->id == $selected_hospital) {
                                $current_hospital_name = $hospital->name;
                                break;
                            }
                        }
                        ?>
                        <span class="badge badge-success">
                            <i class="fas fa-hospital mr-1"></i><?php echo $current_hospital_name; ?>
                        </span>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>

    <!-- JavaScript to handle hospital selection -->
    <script>
    // Ensure jQuery is loaded before using it
    if (typeof jQuery !== 'undefined') {
        $(document).ready(function() {
            $('#patient_hospital_select').on('change', function() {
                var selectedHospital = $(this).val();
                console.log('Hospital selected:', selectedHospital);
                
                // Create URL with new hospital parameter
                var currentUrl = window.location.href;
                var url = new URL(currentUrl);
                
                // Set or update the hospital_id parameter
                url.searchParams.set('hospital_id', selectedHospital);
                
                console.log('Redirecting to:', url.toString());
                
                // Show loading indication
                $(this).prop('disabled', true);
                $('body').append('<div id="loading-overlay" style="position:fixed;top:0;left:0;width:100%;height:100%;background:rgba(0,0,0,0.5);z-index:9999;display:flex;align-items:center;justify-content:center;color:white;font-size:18px;"><i class="fas fa-spinner fa-spin mr-2"></i>Loading...</div>');
                
                // Reload the page with the new hospital selection
                window.location.href = url.toString();
            });
        });
    } else {
        // Fallback for when jQuery is not available
                 document.addEventListener('DOMContentLoaded', function() {
             var selectElement = document.getElementById('patient_hospital_select');
            if (selectElement) {
                selectElement.addEventListener('change', function() {
                    var selectedHospital = this.value;
                    console.log('Hospital selected:', selectedHospital);
                    
                    var currentUrl = window.location.href;
                    var url = new URL(currentUrl);
                    url.searchParams.set('hospital_id', selectedHospital);
                    
                    console.log('Redirecting to:', url.toString());
                    window.location.href = url.toString();
                });
            }
        });
    }
    </script>
<?php } else { ?>
    <!-- Debug: Dropdown not shown -->
    <!-- Reason: Patient=<?php echo $is_patient ? 'Yes' : 'No'; ?>, Hospitals Available=<?php echo $hospitals_exist ? 'Yes' : 'No'; ?> -->
    <?php if (!$is_patient) { ?>
        <!-- Not a patient user -->
    <?php } elseif (!$hospitals_exist) { ?>
        <!-- No hospitals data available -->
        <div class="alert alert-warning">
            <i class="fas fa-exclamation-triangle mr-2"></i>
            Hospital selection not available - no hospital data found.
        </div>
    <?php } ?>
<?php } ?> 