<div class="content-wrapper bg-gradient-light" style="min-height: 2726.9px;">
    <section class="content-header py-4 bg-white shadow-sm">
        <div class="container-fluid">
            <div class="row align-items-center">
                <div class="col-sm-6">
                    <h1 class="display-4 font-weight-black mb-0">
                        <i class="fas fa-stethoscope text-primary mr-3"></i>
                        <?php echo lang('speciality'); ?> <?php echo lang('management'); ?>
                    </h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb bg-transparent mb-0">
                            <li class="breadcrumb-item"><a href="home"><?php echo lang('home'); ?></a></li>
                            <li class="breadcrumb-item active"><?php echo lang('speciality'); ?></li>
                        </ol>
                    </nav>
                </div>
                <div class="col-sm-6 text-right">
                    <button class="btn btn-primary btn-lg" data-toggle="modal" data-target="#myModal">
                        <i class="fa fa-plus-circle"></i> <?php echo lang('add_new'); ?> <?php echo lang('speciality'); ?>
                    </button>
                </div>
            </div>
        </div>
    </section>

    <section class="content px-4 py-5">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="card shadow-lg border-0">
                        <div class="card-body bg-light p-4">
                            <table class="table table-hover datatables" id="editable-sample" width="100%">
                                <thead>
                                    <tr class="bg-light">
                                        <th class="font-weight-bold text-uppercase"><?php echo lang('id'); ?></th>
                                        <th class="font-weight-bold"><?php echo lang('name'); ?></th>
                                        <th class="font-weight-bold"><?php echo lang('description'); ?></th>
                                        <th class="font-weight-bold"><?php echo lang('status'); ?></th>
                                        <th class="font-weight-bold no-print"><?php echo lang('options'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($specialities as $speciality) { ?>
                                        <tr>
                                            <td><?php echo $speciality->id; ?></td>
                                            <td><?php echo $speciality->name; ?></td>
                                            <td><?php echo $speciality->description; ?></td>
                                            <td>
                                                <?php if ($speciality->status == 'active') { ?>
                                                    <span class="badge badge-success"><?php echo lang('active'); ?></span>
                                                <?php } else { ?>
                                                    <span class="badge badge-danger"><?php echo lang('inactive'); ?></span>
                                                <?php } ?>
                                            </td>
                                            <td>
                                                <button class="btn btn-info btn-sm editSpecialityButton" 
                                                        data-toggle="modal" 
                                                        data-target="#myModal2" 
                                                        data-id="<?php echo $speciality->id; ?>"
                                                        data-name="<?php echo $speciality->name; ?>"
                                                        data-description="<?php echo $speciality->description; ?>"
                                                        data-status="<?php echo $speciality->status; ?>">
                                                    <i class="fa fa-edit"></i> <?php echo lang('edit'); ?>
                                                </button>
                                                <a class="btn btn-danger btn-sm" href="speciality/deleteSpeciality?id=<?php echo $speciality->id; ?>" onclick="return confirm('<?php echo lang('are_you_sure'); ?>')">
                                                    <i class="fa fa-trash"></i> <?php echo lang('delete'); ?>
                                                </a>
                                            </td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Add Speciality Modal-->
<div class="modal fade" id="myModal" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-gradient-primary">
                <h2 class="modal-title text-white font-weight-800"><?php echo lang('add_new'); ?> <?php echo lang('speciality'); ?></h2>
                <button type="button" class="close text-white" data-dismiss="modal" aria-hidden="true">×</button>
            </div>
            <div class="modal-body bg-light p-4">
                <form role="form" action="speciality/addNew" class="clearfix" method="post" enctype="multipart/form-data">
                    <div class="row mb-4">
                        <div class="col-12 mb-4">
                            <h3 class="border-bottom border-primary pb-3 text-uppercase font-weight-900">
                                <i class="fas fa-stethoscope mr-3 text-primary"></i><?php echo lang('speciality'); ?> <?php echo lang('details'); ?>
                            </h3>
                        </div>

                        <div class="col-md-12 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('name'); ?> <span class="text-danger">*</span></label>
                                <input type="text" class="form-control form-control-lg shadow-sm" name="name" required placeholder="<?php echo lang('speciality'); ?> <?php echo lang('name'); ?>">
                            </div>
                        </div>

                        <div class="col-md-12 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('description'); ?></label>
                                <textarea class="form-control shadow-sm" name="description" rows="4" placeholder="<?php echo lang('speciality'); ?> <?php echo lang('description'); ?>"></textarea>
                            </div>
                        </div>

                        <div class="col-md-12 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('status'); ?> <span class="text-danger">*</span></label>
                                <select class="form-control form-control-lg shadow-sm" name="status" required>
                                    <option value="">-- <?php echo lang('select'); ?> <?php echo lang('status'); ?> --</option>
                                    <option value="active" selected><?php echo lang('active'); ?></option>
                                    <option value="inactive"><?php echo lang('inactive'); ?></option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <button type="submit" name="submit" class="btn btn-primary btn-lg btn-block shadow-lg py-3">
                                <i class="fas fa-plus mr-3"></i><?php echo lang('submit'); ?>
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Edit Speciality Modal-->
<div class="modal fade" id="myModal2" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-gradient-primary">
                <h2 class="modal-title text-white font-weight-800"><?php echo lang('edit'); ?> <?php echo lang('speciality'); ?></h2>
                <button type="button" class="close text-white" data-dismiss="modal" aria-hidden="true">×</button>
            </div>
            <div class="modal-body bg-light p-4">
                <form role="form" id="editSpecialityForm" class="clearfix" action="speciality/addNew" method="post" enctype="multipart/form-data">
                    <div class="row mb-4">
                        <div class="col-12 mb-4">
                            <h3 class="border-bottom border-primary pb-3 text-uppercase font-weight-900">
                                <i class="fas fa-stethoscope mr-3 text-primary"></i><?php echo lang('speciality'); ?> <?php echo lang('details'); ?>
                            </h3>
                        </div>

                        <div class="col-md-12 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('name'); ?> <span class="text-danger">*</span></label>
                                <input type="text" class="form-control form-control-lg shadow-sm" name="name" required placeholder="<?php echo lang('speciality'); ?> <?php echo lang('name'); ?>">
                            </div>
                        </div>

                        <div class="col-md-12 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('description'); ?></label>
                                <textarea class="form-control shadow-sm" name="description" rows="4" placeholder="<?php echo lang('speciality'); ?> <?php echo lang('description'); ?>"></textarea>
                            </div>
                        </div>

                        <div class="col-md-12 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('status'); ?> <span class="text-danger">*</span></label>
                                <select class="form-control form-control-lg shadow-sm" name="status" required>
                                    <option value="">-- <?php echo lang('select'); ?> <?php echo lang('status'); ?> --</option>
                                    <option value="active"><?php echo lang('active'); ?></option>
                                    <option value="inactive"><?php echo lang('inactive'); ?></option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <input type="hidden" name="id" id="edit_id">

                    <div class="row">
                        <div class="col-md-12">
                            <button type="submit" name="submit" class="btn btn-primary btn-lg btn-block shadow-lg py-3">
                                <i class="fas fa-save mr-3"></i><?php echo lang('update'); ?>
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function() {
        $('.datatables').DataTable({
            "responsive": true,
            "autoWidth": false,
        });

        // Handle edit button click
        $('.editSpecialityButton').click(function() {
            var id = $(this).data('id');
            var name = $(this).data('name');
            var description = $(this).data('description');
            var status = $(this).data('status');

            // Populate the edit modal form
            $('#editSpecialityForm input[name="name"]').val(name);
            $('#editSpecialityForm textarea[name="description"]').val(description);
            $('#editSpecialityForm select[name="status"]').val(status);
            $('#edit_id').val(id);
        });
    });
</script> 