<div class="content-wrapper bg-light">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row my-2 pl-1">
                <div class="col-sm-6">
                    <h1 class="font-weight-bold">
                        <i class="fas fa-stethoscope mr-2"></i>
                        <?php
                        if (!empty($speciality->id))
                            echo lang('edit') . ' ' . lang('speciality');
                        else
                            echo lang('add_new') . ' ' . lang('speciality');
                        ?>
                    </h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="home"><?php echo lang('home') ?></a></li>
                        <li class="breadcrumb-item"><a href="speciality"><?php echo lang('speciality') ?></a></li>
                        <li class="breadcrumb-item active"> <?php
                                                            if (!empty($speciality->id))
                                                                echo lang('edit');
                                                            else
                                                                echo lang('add_new');
                                                            ?></li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-8">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">
                                <?php if (!empty($speciality->id)) { ?>
                                    <?php echo lang('edit'); ?> <?php echo lang('speciality'); ?>
                                <?php } else { ?>
                                    <?php echo lang('add_new'); ?> <?php echo lang('speciality'); ?>
                                <?php } ?>
                            </h3>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <div class="col-lg-12">
                                <div class="col-lg-2"></div>
                                <div class="col-lg-8">
                                    <?php echo validation_errors(); ?>
                                    <?php echo $this->session->flashdata('feedback'); ?>
                                </div>
                                <div class="col-lg-2"></div>
                            </div>
                            
                            <form role="form" action="speciality/addNew" method="post" enctype="multipart/form-data">
                                <div class="form-group">
                                    <label for="name"><?php echo lang('name'); ?> <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control form-control-lg" name="name" id="name" value='<?php
                                        if (!empty($setval)) {
                                            echo set_value('name');
                                        }
                                        if (!empty($speciality->name)) {
                                            echo $speciality->name;
                                        }
                                    ?>' placeholder="<?php echo lang('speciality'); ?> <?php echo lang('name'); ?>" required>
                                </div>
                                
                                <div class="form-group">
                                    <label for="description"><?php echo lang('description'); ?></label>
                                    <textarea class="form-control" name="description" id="description" rows="4" placeholder="<?php echo lang('speciality'); ?> <?php echo lang('description'); ?>"><?php
                                        if (!empty($setval)) {
                                            echo set_value('description');
                                        }
                                        if (!empty($speciality->description)) {
                                            echo $speciality->description;
                                        }
                                    ?></textarea>
                                </div>
                                
                                <div class="form-group">
                                    <label for="status"><?php echo lang('status'); ?> <span class="text-danger">*</span></label>
                                    <select class="form-control form-control-lg" name="status" id="status" required>
                                        <option value="">-- <?php echo lang('select'); ?> <?php echo lang('status'); ?> --</option>
                                        <option value="active" <?php 
                                            if (!empty($speciality->status) && $speciality->status == 'active') {
                                                echo 'selected';
                                            } elseif (empty($speciality->status)) {
                                                echo 'selected';
                                            }
                                        ?>><?php echo lang('active'); ?></option>
                                        <option value="inactive" <?php 
                                            if (!empty($speciality->status) && $speciality->status == 'inactive') {
                                                echo 'selected';
                                            }
                                        ?>><?php echo lang('inactive'); ?></option>
                                    </select>
                                </div>
                                
                                <input type="hidden" name="id" value='<?php
                                    if (!empty($speciality->id)) {
                                        echo $speciality->id;
                                    }
                                ?>'>
                                
                                <div class="form-group mt-4">
                                    <button type="submit" class="btn btn-info btn-lg">
                                        <i class="fa fa-check"></i> 
                                        <?php if (!empty($speciality->id)) { ?>
                                            <?php echo lang('update'); ?>
                                        <?php } else { ?>
                                            <?php echo lang('submit'); ?>
                                        <?php } ?>
                                    </button>
                                    <a href="speciality" class="btn btn-warning btn-lg ml-2">
                                        <i class="fa fa-times"></i> <?php echo lang('cancel'); ?>
                                    </a>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div> 