<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Speciality extends MX_Controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->model('speciality_model');
        
        if (!$this->ion_auth->in_group(array('admin'))) {
            redirect('home/permission');
        }
    }

    public function index()
    {
        $data['specialities'] = $this->speciality_model->getSpeciality();
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard');
        $this->load->view('speciality', $data);
        $this->load->view('home/footer');
    }

    public function addNewView()
    {
        // Redirect to main page since we're using modals now
        redirect('speciality');
    }

    public function addNew()
    {
        $id = $this->input->post('id');
        $name = $this->input->post('name');
        $description = $this->input->post('description');
        $status = $this->input->post('status');

        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        
        // Validating Name Field
        $this->form_validation->set_rules('name', 'Name', 'trim|required|min_length[2]|max_length[255]|xss_clean');
        // Validating Description Field
        $this->form_validation->set_rules('description', 'Description', 'trim|max_length[1000]|xss_clean');
        // Validating Status Field
        $this->form_validation->set_rules('status', 'Status', 'trim|required|xss_clean');

        if ($this->form_validation->run() == FALSE) {
            // Redirect back to main page with validation errors
            redirect('speciality');
        } else {
            $data = array();
            $data = array(
                'name' => $name,
                'description' => $description,
                'status' => $status
            );

            if (empty($id)) {     // Adding New Speciality
                $this->speciality_model->insertSpeciality($data);
                show_swal(lang('new_speciality_added_successfully'), 'success', lang('added'));
            } else { // Updating Speciality
                $this->speciality_model->updateSpeciality($id, $data);
                show_swal(lang('speciality_updated_successfully'), 'success', lang('updated'));
            }
            redirect('speciality');
        }
    }

    function editSpeciality()
    {
        // Redirect to main page since we're using modals now
        redirect('speciality');
    }

    function deleteSpeciality()
    {
        $id = $this->input->get('id');
        $this->speciality_model->delete($id);
        show_swal(lang('speciality_deleted_successfully'), 'success', lang('deleted'));
        redirect('speciality');
    }

    public function getSpecialityInfo()
    {
        $searchTerm = $this->input->post('searchTerm');
        $response = $this->speciality_model->getSpecialityByStatus();
        $data = array();
        foreach ($response as $item) {
            $data[] = array("id" => $item->id, "text" => $item->name);
        }
        echo json_encode($data);
    }
} 