<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

use Twilio\Rest\Client;

class Sms extends MX_Controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->model('sms_model');
        $this->load->model('patient/patient_model');
        $this->load->model('donor/donor_model');
        $this->load->model('doctor/doctor_model');
    }
    public function testsms()
    {
        $hutch_username = 'ashankodagodasl@gmail.com';
        $hutch_password = 'C4Z2s73AHfdE6pv@';
        $mask = 'CyberGrab';

        if (!empty($hutch_username) && !empty($hutch_password) && !empty($mask)) {
            $accessToken = $this->getHutchAccessToken($hutch_username, $hutch_password);

            if (!empty($accessToken)) {
                $postData = array(
                    'campaignName' => 'Hospital SMS Campaign',
                    'mask' => $mask,
                    'numbers' => '94753382106',
                    'content' => 'Test message from Hutch OAuth - 1',
                    'deliveryReportRequest' => false
                );

                $ch = curl_init('https://bsms.hutch.lk/api/sendsms');
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                    'Content-Type: application/json',
                    'Accept: */*',
                    'X-API-VERSION: v1',
                    'Authorization: Bearer ' . $accessToken
                ));

                $result = curl_exec($ch);

                if ($result === false) {
                    echo 'cURL Error: ' . curl_error($ch);
                } else {
                    echo 'Raw Response:<br>';
                    echo htmlspecialchars($result);  // Safe for browser

                    $response = json_decode($result, true);

                    echo '<br><br>Decoded Response:<br>';
                    echo '<pre>';
                    print_r($response);
                    echo '</pre>';
                }

                curl_close($ch);
            } else {
                echo 'Failed to get access token.';
            }
        } else {
            echo 'Credentials or mask missing.';
        }
    }




    public function index()
    {
        $data = array();
        $data['settings'] = $this->settings_model->getSettings();
        $data['sgateways'] = $this->sms_model->getSmsSettings();
        $this->load->view('home/dashboard');
        $this->load->view('sgateway', $data);
        $this->load->view('home/footer');
    }

    public function superadminSettings()
    {
        $data = array();
        $data['settings'] = $this->settings_model->getSettings();
        $data['sgateways'] = $this->sms_model->getSmsSettingsBySuperadmin();
        $this->load->view('home/dashboard');
        $this->load->view('sgateway', $data);
        $this->load->view('home/footer');
    }

    public function sendView()
    {
        $data = array();
        $data['groups'] = $this->donor_model->getBloodBank();
        $data['patients'] = $this->patient_model->getPatient();
        $data['sms'] = $this->sms_model->getSmsSettings();
        $data['teams'] = $this->doctor_model->getDoctor();
        $type = 'sms';
        $data['templates'] = $this->sms_model->getManualSMSTemplate($type);
        $data['shortcode'] = $this->sms_model->getManualSMSShortcodeTag($type);
        $this->load->view('home/dashboard');
        $this->load->view('sendview', $data);
        $this->load->view('home/footer');
    }

    public function settings()
    {
        $data = array();
        $id = $this->input->get('id');
        $data['settings'] = $this->sms_model->getSmsSettingsById($id);
        $this->load->view('home/dashboard');
        $this->load->view('settings', $data);
        $this->load->view('home/footer');
    }

    public function getSettingsForModal()
    {
        $id = $this->input->get('id');
        $settings = $this->sms_model->getSmsSettingsById($id);

        // Generate the form HTML for the modal
        $this->load->view('modal_settings_form', array('settings' => $settings));
    }

    public function addNewSettings()
    {

        $id = $this->input->post('id');
        $username = $this->input->post('username');
        $password = $this->input->post('password');
        $api_id = $this->input->post('api_id');
        $auth_key = $this->input->post('authkey');
        $sender = $this->input->post('sender');
        $sid = $this->input->post('sid');
        $token = $this->input->post('token');
        $sendernumber = $this->input->post('sendernumber');
        $email = $this->input->post('email');
        $sender_name = $this->input->post('sender_name');
        $hutch_username = $this->input->post('hutch_username');
        $hutch_password = $this->input->post('hutch_password');
        $mask = $this->input->post('mask');
        $sms_token = $this->input->post('sms_token');
        $dialog_username = $this->input->post('dialog_username');
        $dialog_password = $this->input->post('dialog_password');
        $dialog_mask = $this->input->post('dialog_mask');
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        // Validating Name Field
        $this->form_validation->set_rules('username', 'Username', 'trim|min_length[5]|max_length[100]|xss_clean');
        // Validating Password Field
        if (!empty($password)) {
            $this->form_validation->set_rules('password', 'Password', 'trim|min_length[5]|max_length[100]|xss_clean');
        }
        // Validating SMS Field
        $this->form_validation->set_rules('api_id', 'Api Id', 'trim|min_length[5]|max_length[100]|xss_clean');

        // Validating SMS Field
        $this->form_validation->set_rules('authkey', 'Auth Key', 'trim|min_length[5]|max_length[100]|xss_clean');

        // Validating SMS Field
        $this->form_validation->set_rules('sender', 'Sender', 'trim|min_length[5]|max_length[100]|xss_clean');
        $this->form_validation->set_rules('sid', 'Sid', 'trim|max_length[100]|xss_clean');

        // Validating Email Field
        $this->form_validation->set_rules('token', 'Token', 'trim|max_length[100]|xss_clean');

        // Validating Email Field
        $this->form_validation->set_rules('sendernumber', 'Sender Number', 'trim|max_length[100]|xss_clean');
        $this->form_validation->set_rules('email', 'Username', 'trim|min_length[5]|max_length[200]|xss_clean');
        // Validating Password Field

        $this->form_validation->set_rules('sender_name', 'Sender Number', 'trim|min_length[2]|max_length[200]|xss_clean');

        // Hutch BSMS validation rules
        $this->form_validation->set_rules('username', 'Username', 'trim|max_length[200]|xss_clean');
        $this->form_validation->set_rules('password', 'Password', 'trim|max_length[200]|xss_clean');
        $this->form_validation->set_rules('mask', 'Sender Mask', 'trim|max_length[100]|xss_clean');

        if ($this->form_validation->run() == FALSE) {
            $data = array();
            $data['sms'] = $this->sms_model->getSmsSettings();
            $this->load->view('home/dashboard');
            $this->load->view('settings', $data);
            $this->load->view('home/footer');
        } else {
            $data = array();
            $data = array(
                'username' => $username,
                'password' => $password,
                'api_id' => $api_id,
                'authkey' => $auth_key,
                'sender' => $sender,
                'sid' => $sid,
                'token' => $token,
                'sendernumber' => $sendernumber,
                'email' => $email,
                'sender_name' => $sender_name,
                'hutch_username' => $hutch_username,
                'hutch_password' => $hutch_password,
                'mask' => $mask,
                'sms_token' => $sms_token,
                'dialog_username' => $dialog_username,
                'dialog_password' => $dialog_password,
                'dialog_mask' => $dialog_mask,
                'user' => $this->ion_auth->get_user_id()
            );
            if (empty($id)) {
                $this->sms_model->addSmsSettings($data);
                show_swal(lang('added'), 'success', lang('added'));
            } else {
                $this->sms_model->updateSmsSettings($id, $data);
                show_swal(lang('updated'), 'success', lang('updated'));
            }
            redirect('sms');
        }
    }

    function sendSms($to, $message, $data)
    {
        $sms_gateway = $this->settings_model->getSettings()->sms_gateway;
        if (!empty($sms_gateway)) {
            $smsSettings = $this->sms_model->getSmsSettingsByGatewayName($sms_gateway);
        } else {
            show_swal(lang('gatewany_not_selected'), 'error', lang('error'));
            redirect('sms/sendView');
        }
        $j = sizeof($data);
        foreach ($data as $key => $value) {
            foreach ($value as $key2 => $value2) {
                if ($smsSettings->name == 'Bdbulksms') {

                    $token = $smsSettings->sms_token;
                    $url = "https://api.bdbulksms.net/api.php?json";
                    $data = array(
                        'to' => "$key2",
                        'message' => "$value2",
                        'token' => "$token"
                    );
                    $ch = curl_init();
                    curl_setopt($ch, CURLOPT_URL, $url);
                    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
                    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
                    curl_setopt($ch, CURLOPT_ENCODING, '');
                    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                    $smsresult = curl_exec($ch);
                }

                if ($smsSettings->name == 'Clickatell') {
                    $username = $smsSettings->username;
                    $password = $smsSettings->password;
                    $api_id = $smsSettings->api_id;

                    $racepage[] = file_get_contents("https://api.clickatell.com/http/sendmsg?user=" . $username . "&password=" . $password . "&api_id=" . $api_id . "&to=" . $key2 . "&text=" . $value2);
                }

                if ($smsSettings->name == 'MSG91') {
                    $authkey = $smsSettings->authkey;
                    $sender = $smsSettings->sender;
                    $value2 = urlencode($value2);

                    file_get_contents('http://world.msg91.com/api/v2/sendsms?authkey=' . $authkey . '&mobiles=' . $key2 . '&message=' . $value2 . '&sender=' . $sender . '&route=4&country=0');
                }

                if ($smsSettings->name == 'Twilio') {
                    $sid = $smsSettings->sid;
                    $token = $smsSettings->token;
                    $sendername = $smsSettings->sendernumber;
                    if (!empty($sid) && !empty($token) && !empty($sendername)) {
                        $client = new Client($sid, $token);
                        $client->messages->create(
                            $key2, // Text this number
                            array(
                                'from' => $sendername, // From a valid Twilio number
                                'body' => $value2
                            )
                        );
                    }
                }

                if ($smsSettings->name == '80Kobo') {
                    $email = $smsSettings->email;
                    $password = $smsSettings->password;
                    $sender_name = $smsSettings->sender_name;

                    $data = array("email" => $email, "password" => $password, "message" => $value2, "sender_name" => $sender_name, "recipients" => $key2);

                    $data_string = json_encode($data);
                    $ch = curl_init('https://api.80kobosms.com/v2/app/sms');
                    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
                    curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json', 'Content-Length: ' . strlen($data_string)));
                    $result = curl_exec($ch);
                    $res_array = json_decode($result);
                }

                if ($smsSettings->name == 'Hutch BSMS') {
                    $username = $smsSettings->hutch_username; // your Hutch username
                    $password = $smsSettings->hutch_password; // your Hutch password
                    $mask     = $smsSettings->mask; // pre-approved sender ID
                    $number   = $key2;
                    $text  = $value2;
                    $campaign = "Hospital Campaign";
                    // 1. Login to get access token
                    $loginUrl = "https://bsms.hutch.lk/api/login";
                    $loginData = [
                        "username" => $username,
                        "password" => $password
                    ];

                    $ch = curl_init($loginUrl);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                    curl_setopt($ch, CURLOPT_POST, true);
                    curl_setopt($ch, CURLOPT_HTTPHEADER, [
                        "Content-Type: application/json",
                        "Accept: */*",
                        "X-API-VERSION: v1"
                    ]);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($loginData));
                    $loginResponse = curl_exec($ch);
                    curl_close($ch);

                    $loginResult = json_decode($loginResponse, true);

                    if (empty($loginResult['accessToken'])) {
                        echo "Login failed: " . $loginResponse;
                        return;
                    }

                    $accessToken = $loginResult['accessToken'];

                    // 2. Send SMS using access token
                    $smsUrl = "https://bsms.hutch.lk/api/sendsms";
                    $smsData = [
                        "campaignName" => $campaign,
                        "mask" => $mask,
                        "numbers" => $number,
                        "content" => $text,
                        "deliveryReportRequest" => true
                    ];

                    $ch = curl_init($smsUrl);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                    curl_setopt($ch, CURLOPT_POST, true);
                    curl_setopt($ch, CURLOPT_HTTPHEADER, [
                        "Content-Type: application/json",
                        "Accept: */*",
                        "X-API-VERSION: v1",
                        "Authorization: Bearer " . $accessToken
                    ]);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($smsData));
                    $smsResponse = curl_exec($ch);
                    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                    curl_close($ch);
                    return array('success' => true, 'message' => 'SMS sent successfully');
                }
                if ($smsSettings->name == 'Dialog') {


                    error_reporting(E_ALL);
                    date_default_timezone_set('Asia/Colombo');

                    $now = date("Y-m-d\TH:i:s");
                    $username = $smsSettings->dialog_username;
                    $password = $smsSettings->dialog_password;
                    $digest = md5($password);
                    $number = $key2;
                    $mask = $smsSettings->dialog_mask;
                    $text = $value2;
                    $campaignName = 'Hospital SMS Campaign';
                    $clientRef = str_pad(mt_rand(0, 9999999), 7, '0', STR_PAD_LEFT);

                    // Build the payload as a PHP array
                    $bodyArray = [
                        "messages" => [
                            [
                                "clientRef" => $clientRef,
                                "number" => $number,
                                "mask" => $mask,
                                "text" => $text,
                                "campaignName" => $campaignName
                            ]
                        ]
                    ];

                    // Convert array to JSON
                    $body = json_encode($bodyArray);

                    // Initialize CURL
                    $ch = curl_init();
                    curl_setopt($ch, CURLOPT_URL, "https://richcommunication.dialog.lk/api/sms/send");
                    curl_setopt($ch, CURLOPT_POST, 1);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, $body);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

                    // Set headers
                    $headers = [
                        'Content-Type: application/json',
                        'USER: ' . $username,
                        'DIGEST: ' . $digest,
                        'CREATED: ' . $now
                    ];
                    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

                    // Execute request
                    $server_output = curl_exec($ch);
                    $curl_error = curl_error($ch);
                    curl_close($ch);
                    $response = json_decode($server_output, true);
                    var_dump($response);
                }
            }
        }
    }

    function send()
    {
        $userId = $this->ion_auth->get_user_id();
        $is_v_v = $this->input->post('radio');
        $settngsname = $this->settings_model->getSettings()->system_vendor;
        if ($is_v_v == 'allpatient') {
            $patients = $this->patient_model->getpatient();
            foreach ($patients as $patient) {
                $to[] = $patient->phone;
                $message = $this->input->post('message');
                $name = explode(' ', $patient->name);
                if (!isset($name[1])) {
                    $name[1] = null;
                }
                $data1 = array(
                    'firstname' => $name[0],
                    'lastname' => $name[1],
                    'name' => $patient->name,
                    'phone' => $patient->phone,
                    'email' => $patient->email,
                    'address' => $patient->address,
                    'company' => $settngsname
                );
                $messageprint = $this->parser->parse_string($message, $data1);
                $data2[] = array($patient->phone => $messageprint);
            }
            $recipient = 'All Patient';
        }

        if ($is_v_v == 'alldoctor') {
            $doctors = $this->doctor_model->getDoctor();
            foreach ($doctors as $doctor) {
                $message = $this->input->post('message');
                $name = explode(' ', $doctor->name);
                if (!isset($name[1])) {
                    $name[1] = null;
                }
                $data1 = array(
                    'firstname' => $name[0],
                    'lastname' => $name[1],
                    'name' => $doctor->name,
                    'phone' => $doctor->phone,
                    'email' => $doctor->email,
                    'address' => $doctor->address,
                    'company' => $settngsname,
                    'department' => $doctor->department
                );
                $messageprint = $this->parser->parse_string($message, $data1);
                $data2[] = array($doctor->phone => $messageprint);
                $to[] = $doctor->phone;
            }
            $recipient = 'All Doctor';
        }

        if ($is_v_v == 'bloodgroupwise') {
            $blood_group = $this->input->post('bloodgroup');
            $donors = $this->donor_model->getDonor();
            foreach ($donors as $donor) {
                if ($donor->group == $blood_group) {
                    $message = $this->input->post('message');
                    $name = explode(' ', $donor->name);
                    if (!isset($name[1])) {
                        $name[1] = null;
                    }
                    $data1 = array(
                        'firstname' => $name[0],
                        'lastname' => $name[1],
                        'name' => $donor->name,
                        'phone' => $donor->phone,
                        'email' => $donor->email,
                        'company' => $settngsname
                    );
                    $messageprint = $this->parser->parse_string($message, $data1);
                    $data2[] = array($donor->phone => $messageprint);
                    $to[] = $donor->phone;
                }
            }
            $recipient = 'All Blood Donors With Blood Group ' . $blood_group;
        }


        if ($is_v_v == 'single_patient') {
            $patient = $this->input->post('patient');

            $patient_detail = $this->patient_model->getPatientById($patient);
            $message = $this->input->post('message');
            $name = explode(' ', $patient_detail->name);
            if (!isset($name[1])) {
                $name[1] = null;
            }
            $data1 = array(
                'firstname' => $name[0],
                'lastname' => $name[1],
                'name' => $patient_detail->name,
                'phone' => $patient_detail->phone,
                'email' => $patient_detail->email,
                'address' => $patient_detail->address,
                'company' => $settngsname
            );
            $messageprint = $this->parser->parse_string($message, $data1);
            $data2[] = array($patient_detail->phone => $messageprint);
            $single_patient_phone = $patient_detail->phone;
            $recipient = 'Patient Id: ' . $patient_detail->id . '<br> Patient Name: ' . $patient_detail->name . '<br> Patient Phone: ' . $patient_detail->phone;
        }

        if (!empty($single_patient_phone)) {
            $to = $single_patient_phone;
        } else {
            if (!empty($to)) {
                $to = implode(',', $to);
            }
        }

        if (!empty($to)) {
            $message = $this->input->post('message');
            $message1 = urlencode($message);
            $this->sendSms($to, $message1, $data2);
            $data = array();
            $date = time();
            $data = array(
                'message' => $message,
                'date' => $date,
                'recipient' => $recipient,
                'user' => $this->ion_auth->get_user_id()
            );
            $this->sms_model->insertSms($data);
            show_swal(lang('message_sent'), 'success', lang('success'));
        } else {
            show_swal(lang('not_sent'), 'error', lang('error'));
        }
        redirect('sms/sendView');
    }

    function appointmentReminder()
    {
        $id = $this->input->post('id');
        $appointment_details = $this->appointment_model->getAppointmentById($id);

        $patient_detail = $this->patient_model->getPatientById($appointment_details->patient);
        $doctor_detail = $this->doctor_model->getDoctorById($appointment_details->doctor);
        $recipient_p = 'Patient Id: ' . $patient_detail->id . '<br> Patient Name: ' . $patient_detail->name . '<br> Patient Phone: ' . $patient_detail->phone;
        $to = $patient_detail->phone;


        if (!empty($to)) {
            $message = 'Reminder: Appointment is scheduled for you With Doctor ' . $doctor_detail->name . ' Date: ' . date('d-m-Y', $appointment_details->date) . ' Time: ' . $appointment_details->s_time;
            $message1 = urlencode($message);
            $this->sendSms($to, $message1);
            $data_p = array();
            $date = time();
            $data_p = array(
                'message' => $message,
                'date' => $date,
                'recipient' => $recipient_p,
                'user' => $this->ion_auth->get_user_id()
            );
            $this->sms_model->insertSms($data_p);
            show_swal(lang('message_sent'), 'success', lang('success'));
        }

        redirect('appointment/upcoming');
    }

    function sendSmsDuringAppointment($patient, $doctor, $date, $s_time, $e_time)
    {

        $patient_detail = $this->patient_model->getPatientById($patient);
        $doctor_detail = $this->doctor_model->getDoctorById($doctor);

        $recipient_p = 'Patient Id: ' . $patient_detail->id . '<br> Patient Name: ' . $patient_detail->name . '<br> Patient Phone: ' . $patient_detail->phone;
        $recipient_d = 'Doctor Id: ' . $doctor_detail->id . '<br> Patient Name: ' . $doctor_detail->name . '<br> Doctor Phone: ' . $doctor_detail->phone;


        if (!empty($patient)) {
            $message = 'Appointment is scheduled for you With Doctor ' . $doctor_detail->name . ' Date: ' . date('d-m-Y', $date) . ' Time: ' . $s_time;
            $message1 = urlencode($message);
            $this->sendSms($patient_detail->phone, $message1);
            $data_p = array();
            $date = time();
            $data_p = array(
                'message' => $message,
                'date' => $date,
                'recipient' => $recipient_p,
                'user' => $this->ion_auth->get_user_id()
            );
            $this->sms_model->insertSms($data_p);
        }

        if (!empty($doctor)) {
            $message = 'Appointment is scheduled for you With Patient ' . $patient_detail->name . ' Date: ' . date('d-m-Y', $date) . ' Time: ' . $s_time;
            $message1 = urlencode($message);
            $this->sendSms($doctor_detail->phone, $message1);
            $data_d = array();
            $date = time();
            $data_d = array(
                'message' => $message,
                'date' => $date,
                'recipient' => $recipient_d,
                'user' => $this->ion_auth->get_user_id()
            );
            $this->sms_model->insertSms($data_d);
        }
    }

    function appointmentApproved()
    {
        $id = $this->input->post('id');
        $appointment_details = $this->appointment_model->getAppointmentById($id);

        $patient_detail = $this->patient_model->getPatientById($appointment_details->patient);
        $doctor_detail = $this->doctor_model->getDoctorById($appointment_details->doctor);
        $recipient_p = 'Patient Id: ' . $patient_detail->id . '<br> Patient Name: ' . $patient_detail->name . '<br> Patient Phone: ' . $patient_detail->phone;
        $to = $patient_detail->phone;


        if (!empty($to)) {
            $message = 'Approval: Appointment is scheduled for you With Doctor ' . $doctor_detail->name . ' Date: ' . date('d-m-Y', $appointment_details->date) . ' Time: ' . $appointment_details->s_time;
            $message1 = urlencode($message);
            $this->sendSms($to, $message1);
            $data_p = array();
            $date = time();
            $data_p = array(
                'message' => $message,
                'date' => $date,
                'recipient' => $recipient_p,
                'user' => $this->ion_auth->get_user_id()
            );
            $this->sms_model->insertSms($data_p);
        }
    }

    function sendSmsDuringPayment($patient, $amount, $date)
    {

        $patient_detail = $this->patient_model->getPatientById($patient);

        $recipient_p = 'Patient Id: ' . $patient_detail->id . '<br> Patient Name: ' . $patient_detail->name . '<br> Patient Phone: ' . $patient_detail->phone;

        // $message = urlencode("Test Message");
        if (!empty($patient)) {
            $to = $patient_detail->phone;
            $message = 'Bill For Patient ' . $patient_detail->name . 'Amount: ' . $amount . ' Date: ' . date('d-m-Y', $date);
            $message1 = urlencode($message);
            $this->sendSms($to, $message1);
            $data_p = array();
            $date = time();
            $data_p = array(
                'message' => $message,
                'date' => $date,
                'recipient' => $recipient_p,
                'user' => $this->ion_auth->get_user_id()
            );
            $this->sms_model->insertSms($data_p);
        }
    }

    function sendSmsDuringPatientRegistration($patient)
    {

        $patient_detail = $this->patient_model->getPatientById($patient);

        $recipient_p = 'Patient Id: ' . $patient_detail->id . '<br> Patient Name: ' . $patient_detail->name . '<br> Patient Phone: ' . $patient_detail->phone;

        // $message = urlencode("Test Message");
        if (!empty($patient)) {
            $to = $patient_detail->phone;
            $message = 'Patient Registration' . $patient_detail->name . 'is successfully registerred';
            $message1 = urlencode($message);
            $this->sendSms($to, $message1);
            $data_p = array();
            $date = time();
            $data_p = array(
                'message' => $message,
                'date' => $date,
                'recipient' => $recipient_p,
                'user' => $this->ion_auth->get_user_id()
            );
            $this->sms_model->insertSms($data_p);
        }
    }

    function sent()
    {
        if ($this->ion_auth->in_group(array('admin'))) {
            $data['sents'] = $this->sms_model->getSms();
        } else {
            $current_user_id = $this->ion_auth->user()->row()->id;
            $data['sents'] = $this->sms_model->getSmsByUser($current_user_id);
        }

        $this->load->view('home/dashboard');
        $this->load->view('sms', $data);
        $this->load->view('home/footer');
    }

    function delete()
    {
        $id = $this->input->get('id');
        $this->sms_model->delete($id);
        show_swal(lang('deleted'), 'warning', lang('deleted'));
        redirect('sms/sent');
    }

    public function autoSMSTemplate()
    {
        $data['settings'] = $this->settings_model->getSettings();
        $data['shortcode'] = $this->sms_model->getAutoSMSTemplateAllLanguages();
        $this->load->view('home/dashboard', $data);
        $this->load->view('autosmstemplate', $data);
        $this->load->view('home/footer', $data);
    }

    function getAutoSMSTemplateList()
    {
        $language = $this->input->post('language');
        if (empty($language)) {
            $language = 'english'; // default to English
        }

        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];

        if ($limit == -1) {
            if (!empty($search)) {
                $data['cases'] = $this->sms_model->getAutoSMSTemplateBySearch($search, $language);
            } else {
                $data['cases'] = $this->sms_model->getAutoSMSTemplate($language);
            }
        } else {
            if (!empty($search)) {
                $data['cases'] = $this->sms_model->getAutoSMSTemplateByLimitBySearch($limit, $start, $search, $language);
            } else {
                $data['cases'] = $this->sms_model->getAutoSMSTemplateByLimit($limit, $start, $language);
            }
        }

        $i = 0;
        $count = 0;
        foreach ($data['cases'] as $case) {
            $i = $i + 1;
            if ($this->ion_auth->in_group(array('admin'))) {

                $options1 = ' <a type="button" class="btn btn-success btn-sm btn_width editbutton1" title="' . lang('edit') . '" data-toggle = "modal" data-id="' . $case->id . '"><i class="fa fa-edit"> </i></a>';
            }
            $info[] = array(
                $i,
                $case->name,
                $case->message,
                $case->status,
                $options1
            );
            $count = $count + 1;
        }

        if (!empty($data['cases'])) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => count($this->sms_model->getAutoSMSTemplate($language)),
                "recordsFiltered" => $count,
                "data" => $info
            );
        } else {
            $output = array(
                // "draw" => 1,
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }

    public function editAutoSMSTemplate()
    {
        $id = $this->input->get('id');
        $data['autotemplatename'] = $this->sms_model->getAutoSMSTemplateById($id);
        $data['autotag'] = $this->sms_model->getAutoSMSTemplateTag($data['autotemplatename']->type);
        if ($data['autotemplatename']->status == 'Active') {
            $data['status_options'] = '<option value="Active" selected>' . lang("active") . '
                            </option>
                            <option value="Inactive"> ' . lang("inactive") . '
        </option>';
        } else {
            $data['status_options'] = '<option value="Active">' . lang("active") . '
                            </option>
                            <option value="Inactive" selected> ' . lang("inactive") . '
        </option>';
        }
        echo json_encode($data);
    }

    public function addNewAutoSMSTemplate()
    {
        $message = $this->input->post('message');
        $name = $this->input->post('category');
        $id = $this->input->post('id');
        $status = $this->input->post('status');

        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        $this->form_validation->set_rules('message', 'Message', 'trim|xss_clean|required');
        if ($this->form_validation->run() == FALSE) {

            $data['settings'] = $this->settings_model->getSettings();
            $data['shortcode'] = $this->sms_model->getTag();
            $this->load->view('home/dashboard', $data);
            $this->load->view('autosmstemplate', $data);
            $this->load->view('home/footer', $data);
        } else {
            $data = array();
            $data = array(
                'name' => $name,
                'message' => $message,
                'status' => $status,
            );

            $this->sms_model->updateAutoSMSTemplate($data, $id);
            show_swal(lang('updated'), 'success', lang('updated'));

            redirect('sms/autoSMSTemplate');
        }
    }

    public function addNewManualTemplate()
    {
        $message = $this->input->post('message');
        $name = $this->input->post('name');
        $type = $this->input->post('type');
        $id = $this->input->post('id');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        // Validating 
        $this->form_validation->set_rules('message', 'Message', 'trim|xss_clean|required');

        // Validating 
        $this->form_validation->set_rules('name', 'Name', 'trim|xss_clean|required');
        if ($this->form_validation->run() == FALSE) {
            if (!empty($id)) {
                $data = array();
                $data['settings'] = $this->settings_model->getSettings();
                $data['templatename'] = $this->sms_model->getManualSMSTemplateById($id, $type);
                $data['shortcode'] = $this->sms_model->getManualSMSShortcodeTag($type);
                $this->load->view('home/dashboard', $data);
                $this->load->view('add_manual_template', $data);
                $this->load->view('home/footer', $data);
            } else {
                $data = array();
                $data['setval'] = 'setval';
                $data['settings'] = $this->settings_model->getSettings();
                $data['shortcode'] = $this->sms_model->getManualSMSShortcodeTag($type);
                $this->load->view('home/dashboard', $data);
                $this->load->view('add_manual_template', $data);
                $this->load->view('home/footer', $data);
            }
        } else {
            $data = array();
            $data = array(
                'name' => $name,
                'message' => $message,
                'type' => $type
            );
            if (empty($id)) {
                $this->sms_model->addManualSMSTemplate($data);
                show_swal(lang('added'), 'success', lang('added'));
            } else {
                $this->sms_model->updateManualSMSTemplate($data, $id);
                show_swal(lang('updated'), 'success', lang('updated'));
            }
            redirect('sms/sendView');
        }
    }

    public function manualSMSTemplate()
    {
        $data['settings'] = $this->settings_model->getSettings();
        $type = 'sms';
        $data['shortcode'] = $this->sms_model->getManualSMSShortcodeTag($type);
        $this->load->view('home/dashboard', $data);
        $this->load->view('manual_sms_template', $data);
        $this->load->view('home/footer', $data);
    }

    function getManualSMSTemplateList()
    {
        $type = $this->input->post('type');
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];

        if ($limit == -1) {
            if (!empty($search)) {
                $data['cases'] = $this->sms_model->getManualSMSTemplateBySearch($search, $type);
            } else {
                $data['cases'] = $this->sms_model->getManualSMSTemplate($type);
            }
        } else {
            if (!empty($search)) {
                $data['cases'] = $this->sms_model->getManualSMSTemplateByLimitBySearch($limit, $start, $search, $type);
            } else {
                $data['cases'] = $this->sms_model->getManualSMSTemplateByLimit($limit, $start, $type);
            }
        }

        $i = 0;
        $count = 0;
        foreach ($data['cases'] as $case) {
            $i = $i + 1;
            if ($this->ion_auth->in_group(array('admin'))) {

                $options1 = ' <a type="button" class="btn btn-success btn-sm btn_width editbutton1" title="' . lang('edit') . '" data-toggle = "modal" data-id="' . $case->id . '"><i class="fa fa-edit"> </i></a>';

                $options2 = '<a class="btn btn-danger btn-sm btn_width" title="' . lang('delete') . '" href="sms/deleteManualSMSTemplate?id=' . $case->id . '&redirect=sms/smsTemplate" onclick="return confirm(\'Are you sure you want to delete this item?\');"><i class="fa fa-trash"></i></a>';
            }
            $info[] = array(
                $i,
                $case->name,
                ' ' . $options1 . ' ' . $options2
            );
            $count = $count + 1;
        }

        if (!empty($data['cases'])) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => count($this->sms_model->getManualSMSTemplate($type)),
                "recordsFiltered" => $count,
                "data" => $info
            );
        } else {
            $output = array(
                // "draw" => 1,
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }

    public function deleteManualSMSTemplate()
    {
        $id = $this->input->get('id');
        $this->sms_model->deleteManualSMSTemplate($id);
        show_swal(lang('deleted'), 'warning', lang('deleted'));
        redirect('sms/manualSMSTemplate');
    }

    public function editManualSMSTemplate()
    {
        $id = $this->input->get('id');
        $type = $this->input->get('type');

        $data['templatename'] = $this->sms_model->getManualSMSTemplateById($id, $type);

        echo json_encode($data);
    }

    public function getManualSMSTemplateinfo()
    {
        // Search term
        $searchTerm = $this->input->post('searchTerm');
        $type = 'sms';
        // Get users
        $response = $this->sms_model->getManualSMSTemplateListSelect2($searchTerm, $type);

        echo json_encode($response);
    }

    public function getManualSMSTemplateMessageboxText()
    {
        $id = $this->input->get('id');
        $type = $this->input->get('type');
        $data['user'] = $this->sms_model->getManualSMSTemplateById($id, $type);
        echo json_encode($data);
    }

    /**
     * Get Hutch BSMS OAuth 2.0 Access Token
     */
    private function getHutchAccessToken($username, $password)
    {
        $cacheKey = 'hutch_access_token_' . md5($username);
        $cacheFile = APPPATH . 'cache/hutch_tokens/' . $cacheKey . '.json';

        // Create cache directory if it doesn't exist
        if (!is_dir(APPPATH . 'cache/hutch_tokens/')) {
            mkdir(APPPATH . 'cache/hutch_tokens/', 0755, true);
        }

        // Check if we have a valid cached token
        if (file_exists($cacheFile)) {
            $tokenData = json_decode(file_get_contents($cacheFile), true);
            if ($tokenData && isset($tokenData['accessToken']) && isset($tokenData['expires'])) {
                // Check if token is still valid (with 5 minute buffer)
                if (time() < ($tokenData['expires'] - 300)) {
                    return $tokenData['accessToken'];
                }

                // Try to refresh the token
                if (isset($tokenData['refreshToken'])) {
                    $newToken = $this->refreshHutchAccessToken($tokenData['refreshToken']);
                    if ($newToken) {
                        return $newToken;
                    }
                }
            }
        }

        // Get new tokens via login
        return $this->loginHutchBSMS($username, $password);
    }

    /**
     * Login to Hutch BSMS and get tokens
     */
    private function loginHutchBSMS($username, $password)
    {
        $postData = array(
            'username' => $username,
            'password' => $password
        );

        $ch = curl_init('https://bsms.hutch.lk/api/login');
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
            'Accept: */*',
            'X-API-VERSION: v1'
        ));

        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($httpCode == 200 && $response) {
            $tokenData = json_decode($response, true);
            if (isset($tokenData['accessToken']) && isset($tokenData['refreshToken'])) {
                // Cache the tokens with expiry (assuming 1 hour validity)
                $cacheData = array(
                    'accessToken' => $tokenData['accessToken'],
                    'refreshToken' => $tokenData['refreshToken'],
                    'expires' => time() + 3600 // 1 hour from now
                );

                $cacheKey = 'hutch_access_token_' . md5($username);
                $cacheFile = APPPATH . 'cache/hutch_tokens/' . $cacheKey . '.json';
                file_put_contents($cacheFile, json_encode($cacheData));

                return $tokenData['accessToken'];
            }
        }

        return false;
    }

    /**
     * Refresh Hutch BSMS Access Token
     */
    private function refreshHutchAccessToken($refreshToken)
    {
        $ch = curl_init('https://bsms.hutch.lk/api/token/accessToken');
        curl_setopt($ch, CURLOPT_HTTPGET, true);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
            'Accept: */*',
            'X-API-VERSION: v1',
            'Authorization: Bearer ' . $refreshToken
        ));

        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($httpCode == 200 && $response) {
            $tokenData = json_decode($response, true);
            if (isset($tokenData['accessToken'])) {
                return $tokenData['accessToken'];
            }
        }

        return false;
    }
}

/* End of file profile.php */
/* Location: ./application/modules/profile/controllers/profile.php */
