<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Schedule_model extends CI_model
{

    function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

    function getSchedule()
    {
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $this->db->group_start();
        $this->db->where('schedule_type !=', 'date');
        $this->db->or_where('schedule_type IS NULL'); // Include schedules without schedule_type (legacy weekday schedules)
        $this->db->group_end();
        $query = $this->db->get('time_schedule');
        return $query->result();
    }

    function getAvailableDoctorByDate($date)
    {

        $weekday = date("l", $date);
        $this->db->where('date', $date);
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $query1 = $this->db->get('holidays')->result();
        if (!empty($query1)) {
            $doctor = array();
            foreach ($query1 as $q1) {
                $doctor[] = $q1->doctor;
            }
            $this->db->where_not_in('id', $staff);
        }
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $query = $this->db->get('doctor')->result();
        foreach ($query as $availableDoctor) {
            $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
            $this->db->where('doctor', $availableDoctor->id);
            $this->db->where('weekday', $weekday);
            $query_slot = $this->db->get('time_slot')->result();

            if (!empty($query_slot)) {
                $doctor_avail[] = $availableDoctor->id;
            }
        }
        $this->db->where_in('id', $doctor_avail);
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $query_avail_doctor = $this->db->get('doctor');
        return $query_avail_doctor->result();
    }

    function getAvailableDoctorsByDateBySlot($date, $slot)
    {

        $weekday = date("l", $date);
        $this->db->where('date', $date);
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $query1 = $this->db->get('holidays')->result();
        if (!empty($query1)) {
            $doctor = array();
            foreach ($query1 as $q1) {
                $doctor[] = $q1->doctor;
            }
            $this->db->where_not_in('id', $doctor);
        }

        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $query = $this->db->get('doctor')->result();
        foreach ($query as $availableDoctor) {
            $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
            $this->db->where('doctor', $availableDoctor->id);
            $this->db->where('weekday', $weekday);
            $query_slot = $this->db->get('time_slot')->result();

            if (!empty($query_slot)) {
                $doctor_avail[] = $availableDoctor->id;
            }
        }

        foreach ($doctor_avail as $key => $value) {
            $this->db->where('doctor', $value);
            $this->db->where('date', $date);
            $this->db->where('time_slot', $slot);
            $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
            $query_appointment = $this->db->get('appointment')->result();

            if (empty($query_appointment)) {
                $most_probable_avail_doctor[] = $value;
            }
        }
        $this->db->where_in('id', $most_probable_avail_doctor);
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $query_avail_doctor = $this->db->get('staff');
        return $query_avail_doctor->result();
    }

    function getAvailableSlotByDoctorByDate($date, $doctor)
    {
        //$newDate = date("m-d-Y", strtotime($date));
        $weekday = date("l", $date);

        $this->db->where('date', $date);
        $this->db->where('doctor', $doctor);
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $holiday = $this->db->get('holidays')->result();

        if (empty($holiday)) {
            $this->db->where('date', $date);
            $this->db->where('doctor', $doctor);
            $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
            $query = $this->db->get('appointment')->result();

            // Check doctor's schedule type
            $this->db->select('schedule_type');
            $this->db->where('id', $doctor);
            $doctor_info = $this->db->get('doctor')->row();
            $schedule_type = isset($doctor_info->schedule_type) ? $doctor_info->schedule_type : 'weekday';

            // Get time slots based on doctor's schedule type
            $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
            $this->db->where('doctor', $doctor);
            
            if ($schedule_type === 'date') {
                // Date-based scheduling - prioritize exact date match
                $target_date = date('Y-m-d', $date); // Full date (YYYY-MM-DD)
                $date_of_month = date('j', $date); // Get day of month (1-31) for fallback
                
                // First try to find slots for the exact date
                $this->db->group_start();
                $this->db->where('schedule_date', $target_date);
                $this->db->or_group_start();
                $this->db->where('schedule_date IS NULL');
                $this->db->where('date_of_month', $date_of_month);
                $this->db->group_end();
                $this->db->group_end();
                $this->db->where('schedule_type', 'date');
            } else {
                // Weekday-based scheduling (default)
                $this->db->where('weekday', $weekday);
                $this->db->group_start();
                $this->db->where('schedule_type !=', 'date');
                $this->db->or_where('schedule_type IS NULL'); // Include legacy weekday schedules
                $this->db->group_end();
            }
            
            $this->db->order_by('s_time_key', 'asc');
            $query1 = $this->db->get('time_slot')->result();

            $availabletimeSlot = array();
            $bookedTimeSlot = array();

            $this->db->where('hospital_id', $this->hospital_id);
            $this->settings = $this->db->get('settings')->row();

            foreach ($query1 as $timeslot) {
                if ($this->settings->time_format == 24) {
                    $timeslot->s_time = $this->settings_model->convert_to_24h($timeslot->s_time);
                    $timeslot->e_time = $this->settings_model->convert_to_24h($timeslot->e_time);
                }
                $availabletimeSlot[] = $timeslot->s_time . ' To ' . $timeslot->e_time;
            }
            foreach ($query as $bookedTime) {
                if ($bookedTime->status != 'Cancelled') {
                    if ($this->settings->time_format == 24) {
                        $time_string = explode(' To ', $bookedTime->time_slot);
                        $time_string[0] = $this->settings_model->convert_to_24h($time_string[0]);
                        $time_string[1] = $this->settings_model->convert_to_24h($time_string[1]);
                    } else {
                        $time_string = explode(' To ', $bookedTime->time_slot);
                    }

                    $bookedTimeSlot[] = $time_string[0] . ' To ' . $time_string[1];
                }
            }

            $availableSlot = array_diff($availabletimeSlot, $bookedTimeSlot);
        } else {
            $availableSlot = array();
        }

        return $availableSlot;
    }

    function getAvailableSlotByDoctorByDateByAppointmentId($date, $doctor, $appointment_id)
    {
        //$newDate = date("m-d-Y", strtotime($date));
        $weekday = date("l", $date);

        $this->db->where('date', $date);
        $this->db->where('doctor', $doctor);
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $holiday = $this->db->get('holidays')->result();

        if (empty($holiday)) {

            $this->db->where('date', $date);
            $this->db->where('doctor', $doctor);
            $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
            $query = $this->db->get('appointment')->result();

            // Check doctor's schedule type
            $this->db->select('schedule_type');
            $this->db->where('id', $doctor);
            $doctor_info = $this->db->get('doctor')->row();
            $schedule_type = isset($doctor_info->schedule_type) ? $doctor_info->schedule_type : 'weekday';

            // Get time slots based on doctor's schedule type
            $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
            $this->db->where('doctor', $doctor);
            
            if ($schedule_type === 'date') {
                // Date-based scheduling - prioritize exact date match
                $target_date = date('Y-m-d', $date); // Full date (YYYY-MM-DD)
                $date_of_month = date('j', $date); // Get day of month (1-31) for fallback
                
                // First try to find slots for the exact date
                $this->db->group_start();
                $this->db->where('schedule_date', $target_date);
                $this->db->or_group_start();
                $this->db->where('schedule_date IS NULL');
                $this->db->where('date_of_month', $date_of_month);
                $this->db->group_end();
                $this->db->group_end();
                $this->db->where('schedule_type', 'date');
            } else {
                // Weekday-based scheduling (default)
                $this->db->where('weekday', $weekday);
                $this->db->group_start();
                $this->db->where('schedule_type !=', 'date');
                $this->db->or_where('schedule_type IS NULL'); // Include legacy weekday schedules
                $this->db->group_end();
            }
            
            $this->db->order_by('s_time_key', 'asc');
            $query1 = $this->db->get('time_slot')->result();

            $availabletimeSlot = array();
            $bookedTimeSlot = array();

            $this->db->where('hospital_id', $this->hospital_id);
            $this->settings = $this->db->get('settings')->row();

            foreach ($query1 as $timeslot) {
                if ($this->settings->time_format == 24) {
                    $timeslot->s_time = $this->settings_model->convert_to_24h($timeslot->s_time);
                    $timeslot->e_time = $this->settings_model->convert_to_24h($timeslot->e_time);
                }
                $availabletimeSlot[] = $timeslot->s_time . ' To ' . $timeslot->e_time;
            }
            foreach ($query as $bookedTime) {
                if ($bookedTime->status != 'Cancelled') {
                    if ($bookedTime->id != $appointment_id) {
                        if ($this->settings->time_format == 24) {
                            $time_string = explode(' To ', $bookedTime->time_slot);
                            $time_string[0] = $this->settings_model->convert_to_24h($time_string[0]);
                            $time_string[1] = $this->settings_model->convert_to_24h($time_string[1]);
                            $bookedTime->time_slot = $time_string[0] . ' ' . lang('to') . ' ' . $time_string[1];
                        } else {
                            $time_string = explode(' To ', $bookedTime->time_slot);
                        }
                        $bookedTimeSlot[] = $time_string[0] . ' To ' . $time_string[1];
                    }
                } 
            }  

            $availableSlot = array_diff($availabletimeSlot, $bookedTimeSlot);
        } else {
            $availableSlot = array();
        }

        return $availableSlot;
    }

    function updateIonUser($username, $email, $password, $ion_user_id)
    {
        $uptade_ion_user = array(
            'username' => $username,
            'email' => $email,
            'password' => $password
        );
        $this->db->where('id', $ion_user_id);
        $this->db->update('users', $uptade_ion_user);
    }

    function getDoctorByIonUserId($id)
    {
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $this->db->where('ion_user_id', $id);
        $query = $this->db->get('doctor');
        return $query->row();
    }

    function insertTimeSlot($data)
    {
        $data1 = array('hospital_id' => $this->session->userdata('hospital_id'));
        $data2 = array_merge($data, $data1);
        $this->db->insert('time_slot', $data2);
    }

    function getTimeSlot()
    {
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $query = $this->db->get('time_slot');
        return $query->result();
    }

    function getTimeSlotById($id)
    {
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $this->db->where('id', $id);
        $query = $this->db->get('time_slot');
        return $query->row();
    }

    function getTimeSlotByDoctor($id)
    {
        $this->db->order_by('s_time_key', 'asc');
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $this->db->where('doctor', $id);
        $query = $this->db->get('time_slot');
        return $query->result();
    }

    function updateTimeSlot($id, $data)
    {
        $this->db->where('id', $id);
        $this->db->update('time_slot', $data);
    }

    function deleteTimeSlot($id)
    {
        $this->db->where('id', $id);
        $this->db->delete('time_slot');
    }

    function insertSchedule($data)
    {
        $data1 = array('hospital_id' => $this->session->userdata('hospital_id'));
        $data2 = array_merge($data, $data1);
        $this->db->insert('time_schedule', $data2);
    }

    function getScheduleByDoctor($doctor)
    {
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $this->db->where('doctor', $doctor);
        $this->db->group_start();
        $this->db->where('schedule_type !=', 'date');
        $this->db->or_where('schedule_type IS NULL'); // Include schedules without schedule_type (legacy weekday schedules)
        $this->db->group_end();
        $query = $this->db->get('time_schedule');
        return $query->result();
    }

    function getScheduleById($id)
    {
        $this->db->where('id', $id);
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $query = $this->db->get('time_schedule');
        return $query->row();
    }

    function getScheduleByDoctorByWeekday($doctor, $weekday)
    {
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $this->db->where('doctor', $doctor);
        $this->db->where('weekday', $weekday);
        $query = $this->db->get('time_schedule');
        return $query->result();
    }

    function getScheduleByDoctorByWeekdayById($doctor, $weekday, $id)
    {
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $this->db->where_not_in('id', $id);
        $this->db->where('doctor', $doctor);
        $this->db->where('weekday', $weekday);
        $query = $this->db->get('time_schedule');
        return $query->result();
    }

    function updateSchedule($id, $data)
    {
        $this->db->where('id', $id);
        $this->db->update('time_schedule', $data);
    }

    function deleteSchedule($id)
    {
        $this->db->where('id', $id);
        $this->db->delete('time_schedule');
    }

    function deleteTimeSlotByDoctorByWeekday($doctor, $weekday)
    {
        $this->db->where('doctor', $doctor);
        $this->db->where('weekday', $weekday);
        $this->db->delete('time_slot');
    }

    function insertHoliday($data)
    {
        $data1 = array('hospital_id' => $this->session->userdata('hospital_id'));
        $data2 = array_merge($data, $data1);
        $this->db->insert('holidays', $data2);
    }

    function getHolidays()
    {
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $query = $this->db->get('holidays');
        return $query->result();
    }

    function getHolidayById($id)
    {
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $this->db->where('id', $id);
        $query = $this->db->get('holidays');
        return $query->row();
    }

    function getHolidaysByDoctor($id)
    {
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $this->db->order_by('id', 'asc');
        $this->db->where('doctor', $id);
        $query = $this->db->get('holidays');
        return $query->result();
    }

    function getHolidayByDoctorByDate($doctor, $date)
    {
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $this->db->where('doctor', $doctor);
        $this->db->where('date', $date);
        $query = $this->db->get('holidays');
        return $query->row();
    }

    function getTimeSlotByDoctorByWeekday($doctor, $weekday)
    {
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $this->db->where('doctor', $doctor);
        $this->db->where('weekday', $weekday);
        $query = $this->db->get('time_slot');
        return $query->result();
    }

    function getTimeSlotByDoctorByWeekdayById($doctor, $weekday, $id)
    {
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $this->db->where_not_in('id', $id);
        $this->db->where('doctor', $doctor);
        $this->db->where('weekday', $weekday);
        $query = $this->db->get('time_slot');
        return $query->result();
    }

    function updateHoliday($id, $data)
    {
        $this->db->where('id', $id);
        $this->db->update('holidays', $data);
    }

    function deleteHoliday($id)
    {
        $this->db->where('id', $id);
        $this->db->delete('holidays');
    }

    // Get available time slots for weekday-based scheduling (for appointment booking)
    function getAvailableTimeSlotsByWeekday($doctor_id, $weekday)
    {
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $this->db->where('doctor', $doctor_id);
        $this->db->where('weekday', $weekday);
        $this->db->order_by('s_time_key', 'asc');
        $query = $this->db->get('time_slot');
        return $query->result();
    }
}
