<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Dateschedule_model extends CI_model
{

    function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

    function insertDateSchedule($data)
    {
        $data1 = array('hospital_id' => $this->session->userdata('hospital_id'));
        $data2 = array_merge($data, $data1);
        $this->db->insert('doctor_date_schedule', $data2);
        return $this->db->insert_id();
    }

    function getDateSchedulesByDoctor($doctor_id)
    {
        $this->db->where('doctor_id', $doctor_id);
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $this->db->where('status', 'active');
        $this->db->order_by('date_of_month', 'asc');
        $query = $this->db->get('doctor_date_schedule');
        return $query->result();
    }

    function getDateScheduleById($id)
    {
        $this->db->where('id', $id);
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $query = $this->db->get('doctor_date_schedule');
        return $query->row();
    }

    function getDateScheduleByDate($doctor_id, $date_of_month)
    {
        $this->db->where('doctor_id', $doctor_id);
        $this->db->where('date_of_month', $date_of_month);
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $this->db->where('status', 'active');
        $query = $this->db->get('doctor_date_schedule');
        return $query->row();
    }

    function updateDateSchedule($id, $data)
    {
        $this->db->where('id', $id);
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $this->db->update('doctor_date_schedule', $data);
    }

    function deleteDateSchedule($id)
    {
        $this->db->where('id', $id);
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $this->db->delete('doctor_date_schedule');
    }

    // Generate time slots for date-based schedule
    function generateDateTimeSlots($schedule_id, $doctor_id, $date_of_month, $start_time, $end_time, $duration)
    {
        // Clear existing slots for this schedule
        $this->db->where('schedule_id', $schedule_id);
        $this->db->delete('doctor_date_timeslots');

        // Convert times to minutes for calculation
        $start_minutes = $this->timeToMinutes($start_time);
        $end_minutes = $this->timeToMinutes($end_time);
        
        // Generate slots
        $slots = array();
        for ($current = $start_minutes; $current + $duration <= $end_minutes; $current += $duration) {
            $slot_start = $this->minutesToTime($current);
            $slot_end = $this->minutesToTime($current + $duration);
            
            $slot_data = array(
                'schedule_id' => $schedule_id,
                'doctor_id' => $doctor_id,
                'date_of_month' => $date_of_month,
                'start_time' => $slot_start,
                'end_time' => $slot_end,
                'status' => 'available',
                'hospital_id' => $this->session->userdata('hospital_id')
            );
            
            $slots[] = $slot_data;
        }
        
        if (!empty($slots)) {
            $this->db->insert_batch('doctor_date_timeslots', $slots);
        }
        
        return count($slots);
    }

    // Get time slots for a specific date of month
    function getDateTimeSlots($doctor_id, $date_of_month)
    {
        $this->db->where('doctor_id', $doctor_id);
        $this->db->where('date_of_month', $date_of_month);
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $this->db->order_by('start_time', 'asc');
        $query = $this->db->get('doctor_date_timeslots');
        return $query->result();
    }

    // Get available time slots for appointment booking
    function getAvailableDateTimeSlots($doctor_id, $date_of_month)
    {
        $this->db->where('doctor_id', $doctor_id);
        $this->db->where('date_of_month', $date_of_month);
        $this->db->where('status', 'available');
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $this->db->order_by('start_time', 'asc');
        $query = $this->db->get('doctor_date_timeslots');
        return $query->result();
    }

    // Helper function to convert time string to minutes
    private function timeToMinutes($time)
    {
        list($hours, $minutes) = explode(':', $time);
        return ($hours * 60) + $minutes;
    }

    // Helper function to convert minutes to time string
    private function minutesToTime($minutes)
    {
        $hours = intval($minutes / 60);
        $mins = $minutes % 60;
        return sprintf('%02d:%02d', $hours, $mins);
    }

    // Update slot status when appointment is booked
    function bookDateTimeSlot($doctor_id, $date_of_month, $start_time)
    {
        $this->db->where('doctor_id', $doctor_id);
        $this->db->where('date_of_month', $date_of_month);
        $this->db->where('start_time', $start_time);
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $this->db->update('doctor_date_timeslots', array('status' => 'booked'));
    }

    // Get all date schedules for admin view
    function getAllDateSchedules()
    {
        $this->db->select('doctor_date_schedule.*, doctor.name as doctor_name');
        $this->db->from('doctor_date_schedule');
        $this->db->join('doctor', 'doctor_date_schedule.doctor_id = doctor.id');
        $this->db->where('doctor_date_schedule.hospital_id', $this->session->userdata('hospital_id'));
        $this->db->order_by('doctor.name', 'asc');
        $this->db->order_by('doctor_date_schedule.date_of_month', 'asc');
        $query = $this->db->get();
        return $query->result();
    }
} 