<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Schedule extends MX_Controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->model('schedule_model');
        $this->load->model('doctor/doctor_model');
        $this->load->model('appointment/appointment_model');
        if (!$this->ion_auth->in_group(array('admin', 'Doctor', 'Patient', 'Nurse', 'Receptionist'))) {
            redirect('home/permission');
        }
    }

    function index()
    {
        if ($this->ion_auth->in_group(array('Doctor'))) {
            redirect('home/permission');
        }

        // Hospital data for doctors
        if ($this->ion_auth->in_group(array('Doctor'))) {
            $user_id = $this->ion_auth->user()->row()->id;
            $doctor_data = $this->db->get_where('doctor', array('ion_user_id' => $user_id))->row();
            
            $data['hospitals'] = $this->db->get('hospital')->result();
            $current_hospital_id = $this->session->userdata('hospital_id');
            if (empty($current_hospital_id)) {
                $current_hospital_id = $doctor_data->hospital_id;
            }
            $data['selected_hospital'] = $current_hospital_id;
        }

        $data['settings'] = $this->settings_model->getSettings();
        $data['schedules'] = $this->schedule_model->getSchedule();
        $data['date_schedules'] = $this->getUnifiedDateSchedules();
        $data['doctors'] = $this->doctor_model->getDoctor();
        $this->load->view('home/dashboard', $data);
        $this->load->view('schedule', $data);
        $this->load->view('home/footer');
    }

    function timeSchedule()
    {
        if ($this->ion_auth->in_group(array('Doctor'))) { 
            $doctor_ion_id = $this->ion_auth->get_user_id();
            $doctor = $this->doctor_model->getDoctorByIonUserId($doctor_ion_id)->id;
            
            // Hospital filter for doctors
            $doctor_data = $this->doctor_model->getDoctorByIonUserId($doctor_ion_id);
            
            // Hospital selection logic
            $selected_hospital = $this->input->get('hospital_id');
            $data['hospitals'] = $this->db->get('hospital')->result();
            
            // Set default hospital if none selected
            if (empty($selected_hospital)) {
                $current_hospital_id = $this->session->userdata('hospital_id');
                if (empty($current_hospital_id)) {
                    $current_hospital_id = $doctor_data->hospital_id;
                    $this->session->set_userdata('hospital_id', $current_hospital_id);
                }
                $selected_hospital = $current_hospital_id;
            }
            $data['selected_hospital'] = $selected_hospital;
            
            // Set hospital context
            if ($selected_hospital === 'consolidated') {
                $this->session->unset_userdata('hospital_id');
            } else {
                $this->session->set_userdata('hospital_id', $selected_hospital);
            }
        } else {
            $doctor = $this->input->get('doctor');
        }

        $doctor_details = $this->doctor_model->getDoctorById($doctor);
        
        // Updated hospital permission check - allow if no hospital session or if consolidated view
        if ($this->ion_auth->in_group(array('Doctor'))) {
            $current_hospital_session = $this->session->userdata('hospital_id');
            if (!empty($current_hospital_session) && $doctor_details->hospital_id != $current_hospital_session) {
                redirect('home/permission');
            }
        } else {
            // Non-doctor users still need strict hospital matching
            if ($doctor_details->hospital_id != $this->session->userdata('hospital_id')) {
                redirect('home/permission');
            }
        }

        $data['doctorr'] = $doctor;
        $data['settings'] = $this->settings_model->getSettings();
        $data['schedules'] = $this->schedule_model->getScheduleByDoctor($doctor);
        $data['date_schedules'] = $this->getUnifiedDateSchedulesByDoctor($doctor);
        $data['doctor_details'] = $doctor_details;
        $this->load->view('home/dashboard', $data);
        $this->load->view('timeschedule', $data);
        $this->load->view('home/footer');
    }

    function addSchedule()
    {
        // Handle hospital selection for doctors
        if ($this->ion_auth->in_group(array('Doctor'))) {
            $selected_hospital_id = $this->input->post('schedule_hospital_id');
            if (!empty($selected_hospital_id)) {
                $this->session->set_userdata('hospital_id', $selected_hospital_id);
            }
        }

        $redirect = $this->input->post('redirect');
        if (empty($redirect)) {
            $redirect = 'schedule';
        }
        $id = $this->input->post('id');
        $doctor = $this->input->post('doctor');
        $s_time = $this->input->post('s_time');
        $e_time = $this->input->post('e_time');
        $weekday = $this->input->post('weekday');




        if ($this->settings->time_format == '24') {
            $s_time = $this->settings_model->convert_to_12h($s_time);
            $e_time = $this->settings_model->convert_to_12h($e_time);
        }





        $duration = $this->input->post('duration');

        // if (empty($id)) {
        //     $check = $this->schedule_model->getScheduleByDoctorByWeekday($doctor, $weekday);
        //     if (!empty($check)) {
        //         show_swal('feedback', lang('schedule_already_exists'));
        //         redirect($redirect);
        //         die();
        //     }
        // }

        $schedule_type = $this->input->post('schedule_type'); // Get schedule type
        $date_of_month = $this->input->post('date_of_month'); // For date-based schedules (backward compatibility)
        $schedule_date = $this->input->post('schedule_date'); // For new date field
        
        // Handle both old and new date formats
        if ($schedule_type == 'date') {
            if (!empty($schedule_date)) {
                // Extract day from full date (YYYY-MM-DD format)
                $date_parts = explode('-', $schedule_date);
                if (count($date_parts) == 3) {
                    $date_of_month = intval($date_parts[2]); // Get day part
                }
            }
        }

        if (empty($s_time)) {
            show_swal(lang('fields_can_not_be_empty'), 'error', lang('error'));
            redirect($redirect);
            die();
        }

        if (empty($e_time)) {
            show_swal(lang('fields_can_not_be_empty'), 'error', lang('error'));
            redirect($redirect);
            die();
        }

        // For date-based schedules, validate date_of_month
        if ($schedule_type == 'date' && (empty($date_of_month) || $date_of_month < 1 || $date_of_month > 31)) {
            show_swal('Date of month must be between 1-31', 'error', lang('error'));
            redirect($redirect);
            die();
        }

        $all_slot = array(
            '0' => '12:00 AM',
            '1' => '12:05 AM',
            '2' => '12:10 AM',
            '3' => '12:15 AM',
            '4' => '12:20 AM',
            '5' => '12:25 AM',
            '6' => '12:30 AM',
            '7' => '12:35 AM',
            '8' => '12:40 PM',
            '9' => '12:45 AM',
            '10' => '12:50 AM',
            '11' => '12:55 AM',
            '12' => '01:00 AM',
            '13' => '01:05 AM',
            '14' => '01:10 AM',
            '15' => '01:15 AM',
            '16' => '01:20 AM',
            '17' => '01:25 AM',
            '18' => '01:30 AM',
            '19' => '01:35 AM',
            '20' => '01:40 AM',
            '21' => '01:45 AM',
            '22' => '01:50 AM',
            '23' => '01:55 AM',
            '24' => '02:00 AM',
            '25' => '02:05 AM',
            '26' => '02:10 AM',
            '27' => '02:15 AM',
            '28' => '02:20 AM',
            '29' => '02:25 AM',
            '30' => '02:30 AM',
            '31' => '02:35 AM',
            '32' => '02:40 AM',
            '33' => '02:45 AM',
            '34' => '02:50 AM',
            '35' => '02:55 AM',
            '36' => '03:00 AM',
            '37' => '03:05 AM',
            '38' => '03:10 AM',
            '39' => '03:15 AM',
            '40' => '03:20 AM',
            '41' => '03:25 AM',
            '42' => '03:30 AM',
            '43' => '03:35 AM',
            '44' => '03:40 AM',
            '45' => '03:45 AM',
            '46' => '03:50 AM',
            '47' => '03:55 AM',
            '48' => '04:00 AM',
            '49' => '04:05 AM',
            '50' => '04:10 AM',
            '51' => '04:15 AM',
            '52' => '04:20 AM',
            '53' => '04:25 AM',
            '54' => '04:30 AM',
            '55' => '04:35 AM',
            '56' => '04:40 AM',
            '57' => '04:45 AM',
            '58' => '04:50 AM',
            '59' => '04:55 AM',
            '60' => '05:00 AM',
            '61' => '05:05 AM',
            '62' => '05:10 AM',
            '63' => '05:15 AM',
            '64' => '05:20 AM',
            '65' => '05:25 AM',
            '66' => '05:30 AM',
            '67' => '05:35 AM',
            '68' => '05:40 AM',
            '69' => '05:45 AM',
            '70' => '05:50 AM',
            '71' => '05:55 AM',
            '72' => '06:00 AM',
            '73' => '06:05 AM',
            '74' => '06:10 AM',
            '75' => '06:15 AM',
            '76' => '06:20 AM',
            '77' => '06:25 AM',
            '78' => '06:30 AM',
            '79' => '06:35 AM',
            '80' => '06:40 AM',
            '81' => '06:45 AM',
            '82' => '06:50 AM',
            '83' => '06:55 AM',
            '84' => '07:00 AM',
            '85' => '07:05 AM',
            '86' => '07:10 AM',
            '87' => '07:15 AM',
            '88' => '07:20 AM',
            '89' => '07:25 AM',
            '90' => '07:30 AM',
            '91' => '07:35 AM',
            '92' => '07:40 AM',
            '93' => '07:45 AM',
            '94' => '07:50 AM',
            '95' => '07:55 AM',
            '96' => '08:00 AM',
            '97' => '08:05 AM',
            '98' => '08:10 AM',
            '99' => '08:15 AM',
            '100' => '08:20 AM',
            '101' => '08:25 AM',
            '102' => '08:30 AM',
            '103' => '08:35 AM',
            '104' => '08:40 AM',
            '105' => '08:45 AM',
            '106' => '08:50 AM',
            '107' => '08:55 AM',
            '108' => '09:00 AM',
            '109' => '09:05 AM',
            '110' => '09:10 AM',
            '111' => '09:15 AM',
            '112' => '09:20 AM',
            '113' => '09:25 AM',
            '114' => '09:30 AM',
            '115' => '09:35 AM',
            '116' => '09:40 AM',
            '117' => '09:45 AM',
            '118' => '09:50 AM',
            '119' => '09:55 AM',
            '120' => '10:00 AM',
            '121' => '10:05 AM',
            '122' => '10:10 AM',
            '123' => '10:15 AM',
            '124' => '10:20 AM',
            '125' => '10:25 AM',
            '126' => '10:30 AM',
            '127' => '10:35 AM',
            '128' => '10:40 AM',
            '129' => '10:45 AM',
            '130' => '10:50 AM',
            '131' => '10:55 AM',
            '132' => '11:00 AM',
            '133' => '11:05 AM',
            '134' => '11:10 AM',
            '135' => '11:15 AM',
            '136' => '11:20 AM',
            '137' => '11:25 AM',
            '138' => '11:30 AM',
            '139' => '11:35 AM',
            '140' => '11:40 AM',
            '141' => '11:45 AM',
            '142' => '11:50 AM',
            '143' => '11:55 AM',
            '144' => '12:00 PM',
            '145' => '12:05 PM',
            '146' => '12:10 PM',
            '147' => '12:15 PM',
            '148' => '12:20 PM',
            '149' => '12:25 PM',
            '150' => '12:30 PM',
            '151' => '12:35 PM',
            '152' => '12:40 PM',
            '153' => '12:45 PM',
            '154' => '12:50 PM',
            '155' => '12:55 PM',
            '156' => '01:00 PM',
            '157' => '01:05 PM',
            '158' => '01:10 PM',
            '159' => '01:15 PM',
            '160' => '01:20 PM',
            '161' => '01:25 PM',
            '162' => '01:30 PM',
            '163' => '01:35 PM',
            '164' => '01:40 PM',
            '165' => '01:45 PM',
            '166' => '01:50 PM',
            '167' => '01:55 PM',
            '168' => '02:00 PM',
            '169' => '02:05 PM',
            '170' => '02:10 PM',
            '171' => '02:15 PM',
            '172' => '02:20 PM',
            '173' => '02:25 PM',
            '174' => '02:30 PM',
            '175' => '02:35 PM',
            '176' => '02:40 PM',
            '177' => '02:45 PM',
            '178' => '02:50 PM',
            '179' => '02:55 PM',
            '180' => '03:00 PM',
            '181' => '03:05 PM',
            '182' => '03:10 PM',
            '183' => '03:15 PM',
            '184' => '03:20 PM',
            '185' => '03:25 PM',
            '186' => '03:30 PM',
            '187' => '03:35 PM',
            '188' => '03:40 PM',
            '189' => '03:45 PM',
            '190' => '03:50 PM',
            '191' => '03:55 PM',
            '192' => '04:00 PM',
            '193' => '04:05 PM',
            '194' => '04:10 PM',
            '195' => '04:15 PM',
            '196' => '04:20 PM',
            '197' => '04:25 PM',
            '198' => '04:30 PM',
            '199' => '04:35 PM',
            '200' => '04:40 PM',
            '201' => '04:45 PM',
            '202' => '04:50 PM',
            '203' => '04:55 PM',
            '204' => '05:00 PM',
            '205' => '05:05 PM',
            '206' => '05:10 PM',
            '207' => '05:15 PM',
            '208' => '05:20 PM',
            '209' => '05:25 PM',
            '210' => '05:30 PM',
            '211' => '05:35 PM',
            '212' => '05:40 PM',
            '213' => '05:45 PM',
            '214' => '05:50 PM',
            '215' => '05:55 PM',
            '216' => '06:00 PM',
            '217' => '06:05 PM',
            '218' => '06:10 PM',
            '219' => '06:15 PM',
            '220' => '06:20 PM',
            '221' => '06:25 PM',
            '222' => '06:30 PM',
            '223' => '06:35 PM',
            '224' => '06:40 PM',
            '225' => '06:45 PM',
            '226' => '06:50 PM',
            '227' => '06:55 PM',
            '228' => '07:00 PM',
            '229' => '07:05 PM',
            '230' => '07:10 PM',
            '231' => '07:15 PM',
            '232' => '07:20 PM',
            '233' => '07:25 PM',
            '234' => '07:30 PM',
            '235' => '07:35 PM',
            '236' => '07:40 PM',
            '237' => '07:45 PM',
            '238' => '07:50 PM',
            '239' => '07:55 PM',
            '240' => '08:00 PM',
            '241' => '08:05 PM',
            '242' => '08:10 PM',
            '243' => '08:15 PM',
            '244' => '08:20 PM',
            '245' => '08:25 PM',
            '246' => '08:30 PM',
            '247' => '08:35 PM',
            '248' => '08:40 PM',
            '249' => '08:45 PM',
            '250' => '08:50 PM',
            '251' => '08:55 PM',
            '252' => '09:00 PM',
            '253' => '09:05 PM',
            '254' => '09:10 PM',
            '255' => '09:15 PM',
            '256' => '09:20 PM',
            '257' => '09:25 PM',
            '258' => '09:30 PM',
            '259' => '09:35 PM',
            '260' => '09:40 PM',
            '261' => '09:45 PM',
            '262' => '09:50 PM',
            '263' => '09:55 PM',
            '264' => '10:00 PM',
            '265' => '10:05 PM',
            '266' => '10:10 PM',
            '267' => '10:15 PM',
            '268' => '10:20 PM',
            '269' => '10:25 PM',
            '270' => '10:30 PM',
            '271' => '10:35 PM',
            '272' => '10:40 PM',
            '273' => '10:45 PM',
            '274' => '10:50 PM',
            '275' => '10:55 PM',
            '276' => '11:00 PM',
            '277' => '11:05 PM',
            '278' => '11:10 PM',
            '279' => '11:15 PM',
            '280' => '11:20 PM',
            '281' => '11:25 PM',
            '282' => '11:30 PM',
            '283' => '11:35 PM',
            '284' => '11:40 PM',
            '285' => '11:45 PM',
            '286' => '11:50 PM',
            '287' => '11:55 PM',
        );

        $key1 = array_search($s_time, $all_slot);
        $key2 = array_search($e_time, $all_slot);



        if ($key1 > $key2) {
            show_swal(lang('time_selection_error'), 'error', lang('error'));
            redirect($redirect);
            die();
        }

        // Different overlap validation logic for date vs weekday schedules
        if ($schedule_type == 'date') {
            // For date schedules, check overlaps with other date schedules for same doctor and date
            if (!empty($id)) {
                // For editing: get other date schedules excluding current one
                $this->db->where('doctor', $doctor);
                $this->db->where('date_of_month', $date_of_month);
                $this->db->where('schedule_type', 'date');
                $this->db->where('id !=', $id);
                $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
                $previous_time = $this->db->get('time_schedule')->result();
            } else {
                // For new schedules: get all date schedules for same doctor and date
                $this->db->where('doctor', $doctor);
                $this->db->where('date_of_month', $date_of_month);
                $this->db->where('schedule_type', 'date');
                $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
                $previous_time = $this->db->get('time_schedule')->result();
            }
        } else {
            // For weekday schedules, use existing logic
            if (!empty($id)) {
                $previous_time = $this->schedule_model->getScheduleByDoctorByWeekdayById($doctor, $weekday, $id);
            } else {
                $previous_time = $this->schedule_model->getScheduleByDoctorByWeekday($doctor, $weekday);
            }
        }

        if (!empty($previous_time)) {
            $x = 0;
            foreach ($previous_time as $pre_time) {
                $pre_s_time = $pre_time->s_time;
                $pre_e_time = $pre_time->e_time;

                $key_pre_s = array_search($pre_s_time, $all_slot);
                $key_pre_e = array_search($pre_e_time, $all_slot);

                if ($key1 < $key_pre_s) {
                    if ($key2 <= $key_pre_s) {
                        continue;
                    } else {
                        show_swal(lang('slot_overlapped'), 'error', lang('error'));
                        redirect($redirect);
                        die();
                    }
                } elseif ($key1 > $key_pre_s) {
                    if ($key1 >= $key_pre_e) {
                        if ($key2 > $key_pre_e) {
                            continue;
                        } else {
                            show_swal(lang('slot_overlapped'), 'error', lang('error'));
                            redirect($redirect);
                            die();
                        }
                    } else {
                        show_swal(lang('slot_overlapped'), 'error', lang('error'));
                        redirect($redirect);
                        die();
                    }
                } elseif ($key1 >= $key_pre_s && $key2 <= $key_pre_e) {
                    show_swal(lang('slot_overlapped'), 'error', lang('error'));
                    redirect($redirect);
                    die();
                } elseif ($key1 == $key_pre_s) {
                    show_swal(lang('slot_overlapped'), 'error', lang('error'));
                    redirect($redirect);
                    die();
                }
            }
        }



        // Validating Starting Time Field
        $this->form_validation->set_rules('s_time', 'Start Time', 'trim|required|min_length[1]|max_length[100]|xss_clean');
        // Validating End Time Field   
        $this->form_validation->set_rules('e_time', 'End Time', 'trim|required|min_length[1]|max_length[500]|xss_clean');
        // Validating Week Day Field   
        $this->form_validation->set_rules('e_time', 'End Time', 'trim|required|min_length[1]|max_length[500]|xss_clean');

        // Validating Duration Field   
        $this->form_validation->set_rules('duration', 'Duration', 'trim|required|min_length[1]|max_length[500]|xss_clean');

        if ($this->form_validation->run() == FALSE) {
            if (!empty($id)) {
                redirect("schedule/editSchedule?id=$id");
            } else {
                $data['settings'] = $this->settings_model->getSettings();
                $this->load->view('home/dashboard', $data);
                $this->load->view('timeschedule');
                $this->load->view('home/footer');
            }
        } else {

            $data = array();
            $data = array(
                'doctor' => $doctor,
                's_time' => $s_time,
                'e_time' => $e_time,
                'weekday' => $weekday,
                's_time_key' => $key1,
                'duration' => $duration,
                'schedule_type' => $schedule_type ? $schedule_type : 'weekday',
                'date_of_month' => $schedule_type == 'date' ? $date_of_month : null,
                'schedule_date' => $schedule_type == 'date' ? $schedule_date : null
            );
            if (!empty($id)) {
                show_swal(lang('schedule_updated_successfully'), 'success', lang('updated'));
                $this->schedule_model->updateSchedule($id, $data);
            } else {
                $duration = intval($duration);
                $slot_s_time = $key1;
                $slot_e_time = $key1 + $duration;

                foreach ($all_slot as $key_start => $value) {
                    if ($slot_s_time == $key_start) {
                        $p_slot_s_time = $value;
                        foreach ($all_slot as $key_end => $value_e) {
                            if ($slot_e_time == $key_end) {
                                if ($slot_e_time <= $key2) {
                                    $p_slot_e_time = $value_e;

                                    $slot_data = array(
                                        'doctor' => $doctor,
                                        's_time' => $p_slot_s_time,
                                        'e_time' => $p_slot_e_time,
                                        'weekday' => $weekday,
                                        's_time_key' => $key_start,
                                        'schedule_type' => $schedule_type ? $schedule_type : 'weekday',
                                        'date_of_month' => $schedule_type == 'date' ? $date_of_month : null,
                                        'schedule_date' => $schedule_type == 'date' ? $schedule_date : null
                                    );
                                    $this->schedule_model->insertTimeSlot($slot_data);
                                }
                            }
                        }
                        $slot_s_time = $slot_e_time;
                        $slot_e_time = $slot_s_time + $duration;
                    }
                }
                $this->schedule_model->insertSchedule($data);
                show_swal(lang('schedule_added_successfully'), 'success', lang('added'));
            }

            redirect($redirect);
        }
    }

    function editScheduleByJason()
    {
        $id = $this->input->get('id');
        $data['schedule'] = $this->schedule_model->getScheduleById($id);
        echo json_encode($data);
    }

    function deleteSchedule()
    {
        $from = $this->input->get('all');
        $id = $this->input->get('id');

        $schedule_details = $this->schedule_model->getScheduleById($id);
        if ($schedule_details->hospital_id != $this->session->userdata('hospital_id')) {
            redirect('redirect/permission');
        }

        $doctor = $this->input->get('doctor');
        $weekday = $this->input->get('weekday');
        $this->schedule_model->deleteTimeSlotByDoctorByWeekday($doctor, $weekday);
        $this->schedule_model->deleteSchedule($id);

        if ($this->ion_auth->in_group(array('Doctor'))) {
            redirect('schedule/timeSchedule');
        } else {
            redirect('schedule');
        }
    }

    function timeSlots()
    {
        $doctor = $this->input->get('doctor');
        $data['doctorr'] = $doctor;
        $data['settings'] = $this->settings_model->getSettings();
        $data['slots'] = $this->schedule_model->getTimeSlotByDoctor($doctor);
        $this->load->view('home/dashboard', $data);
        $this->load->view('timeslot', $data);
        $this->load->view('home/footer');
    }

    function addTimeSlot()
    {
        $id = $this->input->post('id');
        $doctor = $this->input->post('doctor');
        $s_time = $this->input->post('s_time');
        $e_time = $this->input->post('e_time');
        $weekday = $this->input->post('weekday');


        if (empty($s_time)) {
            show_swal(lang('fields_can_not_be_empty'), 'error', lang('error'));
            redirect('schedule/timeSlots?doctor=' . $doctor);
            die();
        }

        if (empty($e_time)) {
            show_swal(lang('fields_can_not_be_empty'), 'error', lang('error'));
            redirect('schedule/timeSlots?doctor=' . $doctor);
            die();
        }



        $all_slot = array(
            '0' => '12:00 AM',
            '1' => '12:05 AM',
            '2' => '12:10 AM',
            '3' => '12:15 AM',
            '4' => '12:20 AM',
            '5' => '12:25 AM',
            '6' => '12:30 AM',
            '7' => '12:35 AM',
            '8' => '12:40 PM',
            '9' => '12:45 AM',
            '10' => '12:50 AM',
            '11' => '12:55 AM',
            '12' => '01:00 AM',
            '13' => '01:05 AM',
            '14' => '01:10 AM',
            '15' => '01:15 AM',
            '16' => '01:20 AM',
            '17' => '01:25 AM',
            '18' => '01:30 AM',
            '19' => '01:35 AM',
            '20' => '01:40 AM',
            '21' => '01:45 AM',
            '22' => '01:50 AM',
            '23' => '01:55 AM',
            '24' => '02:00 AM',
            '25' => '02:05 AM',
            '26' => '02:10 AM',
            '27' => '02:15 AM',
            '28' => '02:20 AM',
            '29' => '02:25 AM',
            '30' => '02:30 AM',
            '31' => '02:35 AM',
            '32' => '02:40 AM',
            '33' => '02:45 AM',
            '34' => '02:50 AM',
            '35' => '02:55 AM',
            '36' => '03:00 AM',
            '37' => '03:05 AM',
            '38' => '03:10 AM',
            '39' => '03:15 AM',
            '40' => '03:20 AM',
            '41' => '03:25 AM',
            '42' => '03:30 AM',
            '43' => '03:35 AM',
            '44' => '03:40 AM',
            '45' => '03:45 AM',
            '46' => '03:50 AM',
            '47' => '03:55 AM',
            '48' => '04:00 AM',
            '49' => '04:05 AM',
            '50' => '04:10 AM',
            '51' => '04:15 AM',
            '52' => '04:20 AM',
            '53' => '04:25 AM',
            '54' => '04:30 AM',
            '55' => '04:35 AM',
            '56' => '04:40 AM',
            '57' => '04:45 AM',
            '58' => '04:50 AM',
            '59' => '04:55 AM',
            '60' => '05:00 AM',
            '61' => '05:05 AM',
            '62' => '05:10 AM',
            '63' => '05:15 AM',
            '64' => '05:20 AM',
            '65' => '05:25 AM',
            '66' => '05:30 AM',
            '67' => '05:35 AM',
            '68' => '05:40 AM',
            '69' => '05:45 AM',
            '70' => '05:50 AM',
            '71' => '05:55 AM',
            '72' => '06:00 AM',
            '73' => '06:05 AM',
            '74' => '06:10 AM',
            '75' => '06:15 AM',
            '76' => '06:20 AM',
            '77' => '06:25 AM',
            '78' => '06:30 AM',
            '79' => '06:35 AM',
            '80' => '06:40 AM',
            '81' => '06:45 AM',
            '82' => '06:50 AM',
            '83' => '06:55 AM',
            '84' => '07:00 AM',
            '85' => '07:05 AM',
            '86' => '07:10 AM',
            '87' => '07:15 AM',
            '88' => '07:20 AM',
            '89' => '07:25 AM',
            '90' => '07:30 AM',
            '91' => '07:35 AM',
            '92' => '07:40 AM',
            '93' => '07:45 AM',
            '94' => '07:50 AM',
            '95' => '07:55 AM',
            '96' => '08:00 AM',
            '97' => '08:05 AM',
            '98' => '08:10 AM',
            '99' => '08:15 AM',
            '100' => '08:20 AM',
            '101' => '08:25 AM',
            '102' => '08:30 AM',
            '103' => '08:35 AM',
            '104' => '08:40 AM',
            '105' => '08:45 AM',
            '106' => '08:50 AM',
            '107' => '08:55 AM',
            '108' => '09:00 AM',
            '109' => '09:05 AM',
            '110' => '09:10 AM',
            '111' => '09:15 AM',
            '112' => '09:20 AM',
            '113' => '09:25 AM',
            '114' => '09:30 AM',
            '115' => '09:35 AM',
            '116' => '09:40 AM',
            '117' => '09:45 AM',
            '118' => '09:50 AM',
            '119' => '09:55 AM',
            '120' => '10:00 AM',
            '121' => '10:05 AM',
            '122' => '10:10 AM',
            '123' => '10:15 AM',
            '124' => '10:20 AM',
            '125' => '10:25 AM',
            '126' => '10:30 AM',
            '127' => '10:35 AM',
            '128' => '10:40 AM',
            '129' => '10:45 AM',
            '130' => '10:50 AM',
            '131' => '10:55 AM',
            '132' => '11:00 AM',
            '133' => '11:05 AM',
            '134' => '11:10 AM',
            '135' => '11:15 AM',
            '136' => '11:20 AM',
            '137' => '11:25 AM',
            '138' => '11:30 AM',
            '139' => '11:35 AM',
            '140' => '11:40 AM',
            '141' => '11:45 AM',
            '142' => '11:50 AM',
            '143' => '11:55 AM',
            '144' => '12:00 PM',
            '145' => '12:05 PM',
            '146' => '12:10 PM',
            '147' => '12:15 PM',
            '148' => '12:20 PM',
            '149' => '12:25 PM',
            '150' => '12:30 PM',
            '151' => '12:35 PM',
            '152' => '12:40 PM',
            '153' => '12:45 PM',
            '154' => '12:50 PM',
            '155' => '12:55 PM',
            '156' => '01:00 PM',
            '157' => '01:05 PM',
            '158' => '01:10 PM',
            '159' => '01:15 PM',
            '160' => '01:20 PM',
            '161' => '01:25 PM',
            '162' => '01:30 PM',
            '163' => '01:35 PM',
            '164' => '01:40 PM',
            '165' => '01:45 PM',
            '166' => '01:50 PM',
            '167' => '01:55 PM',
            '168' => '02:00 PM',
            '169' => '02:05 PM',
            '170' => '02:10 PM',
            '171' => '02:15 PM',
            '172' => '02:20 PM',
            '173' => '02:25 PM',
            '174' => '02:30 PM',
            '175' => '02:35 PM',
            '176' => '02:40 PM',
            '177' => '02:45 PM',
            '178' => '02:50 PM',
            '179' => '02:55 PM',
            '180' => '03:00 PM',
            '181' => '03:05 PM',
            '182' => '03:10 PM',
            '183' => '03:15 PM',
            '184' => '03:20 PM',
            '185' => '03:25 PM',
            '186' => '03:30 PM',
            '187' => '03:35 PM',
            '188' => '03:40 PM',
            '189' => '03:45 PM',
            '190' => '03:50 PM',
            '191' => '03:55 PM',
            '192' => '04:00 PM',
            '193' => '04:05 PM',
            '194' => '04:10 PM',
            '195' => '04:15 PM',
            '196' => '04:20 PM',
            '197' => '04:25 PM',
            '198' => '04:30 PM',
            '199' => '04:35 PM',
            '200' => '04:40 PM',
            '201' => '04:45 PM',
            '202' => '04:50 PM',
            '203' => '04:55 PM',
            '204' => '05:00 PM',
            '205' => '05:05 PM',
            '206' => '05:10 PM',
            '207' => '05:15 PM',
            '208' => '05:20 PM',
            '209' => '05:25 PM',
            '210' => '05:30 PM',
            '211' => '05:35 PM',
            '212' => '05:40 PM',
            '213' => '05:45 PM',
            '214' => '05:50 PM',
            '215' => '05:55 PM',
            '216' => '06:00 PM',
            '217' => '06:05 PM',
            '218' => '06:10 PM',
            '219' => '06:15 PM',
            '220' => '06:20 PM',
            '221' => '06:25 PM',
            '222' => '06:30 PM',
            '223' => '06:35 PM',
            '224' => '06:40 PM',
            '225' => '06:45 PM',
            '226' => '06:50 PM',
            '227' => '06:55 PM',
            '228' => '07:00 PM',
            '229' => '07:05 PM',
            '230' => '07:10 PM',
            '231' => '07:15 PM',
            '232' => '07:20 PM',
            '233' => '07:25 PM',
            '234' => '07:30 PM',
            '235' => '07:35 PM',
            '236' => '07:40 PM',
            '237' => '07:45 PM',
            '238' => '07:50 PM',
            '239' => '07:55 PM',
            '240' => '08:00 PM',
            '241' => '08:05 PM',
            '242' => '08:10 PM',
            '243' => '08:15 PM',
            '244' => '08:20 PM',
            '245' => '08:25 PM',
            '246' => '08:30 PM',
            '247' => '08:35 PM',
            '248' => '08:40 PM',
            '249' => '08:45 PM',
            '250' => '08:50 PM',
            '251' => '08:55 PM',
            '252' => '09:00 PM',
            '253' => '09:05 PM',
            '254' => '09:10 PM',
            '255' => '09:15 PM',
            '256' => '09:20 PM',
            '257' => '09:25 PM',
            '258' => '09:30 PM',
            '259' => '09:35 PM',
            '260' => '09:40 PM',
            '261' => '09:45 PM',
            '262' => '09:50 PM',
            '263' => '09:55 PM',
            '264' => '10:00 PM',
            '265' => '10:05 PM',
            '266' => '10:10 PM',
            '267' => '10:15 PM',
            '268' => '10:20 PM',
            '269' => '10:25 PM',
            '270' => '10:30 PM',
            '271' => '10:35 PM',
            '272' => '10:40 PM',
            '273' => '10:45 PM',
            '274' => '10:50 PM',
            '275' => '10:55 PM',
            '276' => '11:00 PM',
            '277' => '11:05 PM',
            '278' => '11:10 PM',
            '279' => '11:15 PM',
            '280' => '11:20 PM',
            '281' => '11:25 PM',
            '282' => '11:30 PM',
            '283' => '11:35 PM',
            '284' => '11:40 PM',
            '285' => '11:45 PM',
            '286' => '11:50 PM',
            '287' => '11:55 PM',
        );

        $key1 = array_search($s_time, $all_slot);
        $key2 = array_search($e_time, $all_slot);


        if ($key1 > $key2) {
            show_swal(lang('time_selection_error'), 'warning', lang('error'));
            redirect('schedule/timeSlots?doctor=' . $doctor);
            die();
        }

        if (!empty($id)) {
            $previous_time = $this->schedule_model->getTimeSlotByDoctorByWeekdayById($doctor, $weekday, $id);
        } else {
            $previous_time = $this->schedule_model->getTimeSlotByDoctorByWeekday($doctor, $weekday);
        }

        if (!empty($previous_time)) {
            $x = 0;
            foreach ($previous_time as $pre_time) {
                $pre_s_time = $pre_time->s_time;
                $pre_e_time = $pre_time->e_time;

                $key_pre_s = array_search($pre_s_time, $all_slot);
                $key_pre_e = array_search($pre_e_time, $all_slot);

                if ($key1 < $key_pre_s) {
                    if ($key2 <= $key_pre_s) {
                        continue;
                    } else {
                        show_swal(lang('slot_overlapped'), 'error', lang('error'));
                        redirect('schedule/timeSlots?doctor=' . $doctor);
                        die();
                    }
                } elseif ($key1 > $key_pre_s) {
                    if ($key1 >= $key_pre_e) {
                        if ($key2 > $key_pre_e) {
                            continue;
                        } else {
                            show_swal(lang('slot_overlapped'), 'error', lang('error'));
                            redirect('schedule/timeSlots?doctor=' . $doctor);
                            die();
                        }
                    } else {
                        show_swal(lang('slot_overlapped'), 'error', lang('error'));
                        redirect('schedule/timeSlots?doctor=' . $doctor);
                        die();
                    }
                } elseif ($key1 >= $key_pre_s && $key2 <= $key_pre_e) {
                    show_swal(lang('slot_overlapped'), 'error', lang('error'));
                    redirect('schedule/timeSlots?doctor=' . $doctor);
                    die();
                } elseif ($key1 == $key_pre_s) {
                    show_swal(lang('slot_overlapped'), 'error', lang('error'));
                    redirect('schedule/timeSlots?doctor=' . $doctor);
                    die();
                }
            }
        }



        // Validating Starting Time Field
        $this->form_validation->set_rules('s_time', 'Start Time', 'trim|required|min_length[5]|max_length[100]|xss_clean');
        // Validating End Time Field   
        $this->form_validation->set_rules('e_time', 'End Time', 'trim|required|min_length[5]|max_length[500]|xss_clean');
        // Validating Week Day Field   
        $this->form_validation->set_rules('e_time', 'End Time', 'trim|required|min_length[5]|max_length[500]|xss_clean');

        if ($this->form_validation->run() == FALSE) {
            if (!empty($id)) {
                redirect("schedule/editTimeSlot?id=$id");
            } else {
                $data['settings'] = $this->settings_model->getSettings();
                $this->load->view('home/dashboard', $data);
                $this->load->view('timeslot');
                $this->load->view('home/footer');
            }
        } else {

            $data = array();
            $data = array(
                'doctor' => $doctor,
                's_time' => $s_time,
                'e_time' => $e_time,
                'weekday' => $weekday,
                's_time_key' => $key1
            );
            if (!empty($id)) {
                show_swal(lang('updated'), 'success', lang('updated'));
                $this->schedule_model->updateTimeSlot($id, $data);
            } else {
                show_swal(lang('added'), 'success', lang('added'));
                $this->schedule_model->insertTimeSlot($data);
            }
            redirect('schedule/timeSlots?doctor=' . $doctor);
        }
    }

    function edittimeSlotByJason()
    {
        $id = $this->input->get('id');
        $data['slot'] = $this->schedule_model->getTimeSlotById($id);
        echo json_encode($data);
    }

    function getAvailableSlotByDoctorByDateByJason()
    {
        $data = array();
        $date = $this->input->get('date');
        if (!empty($date)) {
            $date = strtotime($date);
        }
        $doctor = $this->input->get('doctor');
        $data['aslots'] = $this->schedule_model->getAvailableSlotByDoctorByDate($date, $doctor);
        echo json_encode($data);
    }

    function getAvailableSlotByDoctorByDateByAppointmentIdByJason()
    {
        $data = array();
        $appointment_id = $this->input->get('appointment_id');
        $date = $this->input->get('date');
        $doctor = $this->input->get('doctor');
        if (!empty($date)) {
            $date = strtotime($date);
        }
        if (!empty($date) && !empty($doctor)) {
            $data['aslots'] = $this->schedule_model->getAvailableSlotByDoctorByDateByAppointmentId($date, $doctor, $appointment_id);
            $data['current_value'] = $this->appointment_model->getAppointmentById($appointment_id)->time_slot;
        }
        echo json_encode($data);
    }

    function allHolidays()
    {
        $data['settings'] = $this->settings_model->getSettings();
        $data['holidays'] = $this->schedule_model->getHolidays();
        $data['doctors'] = $this->doctor_model->getDoctor();
        $this->load->view('home/dashboard', $data);
        $this->load->view('all_holidays', $data);
        $this->load->view('home/footer');
    }

    function holidays()
    {
        if ($this->ion_auth->in_group(array('Doctor'))) {
            $doctor_ion_id = $this->ion_auth->get_user_id();
            $doctor = $this->doctor_model->getDoctorByIonUserId($doctor_ion_id)->id;
        } else {
            $doctor = $this->input->get('doctor');
        }


        $doctor_details = $this->doctor_model->getDoctorById($doctor);
        if ($doctor_details->hospital_id != $this->session->userdata('hospital_id')) {
            redirect('home/permission');
        }

        $data['doctorr'] = $doctor;
        $data['settings'] = $this->settings_model->getSettings();
        $data['holidays'] = $this->schedule_model->getHolidaysByDoctor($doctor);
        $this->load->view('home/dashboard', $data);
        $this->load->view('holidays', $data);
        $this->load->view('home/footer');
    }

    function addHoliday()
    {
        $id = $this->input->post('id');
        $redirect = $this->input->post('redirect');
        if (empty($redirect)) {
            $redirect = 'schedule/allHolidays';
        }
        $doctor = $this->input->post('doctor');
        $date = $this->input->post('date');
        if (!empty($date)) {
            $date = strtotime($date);
        } else {
            show_swal(lang('date_not_selected'), 'error', lang('error'));
            redirect($redirect);
            die();
        }


        if (empty($id)) {
            $is_exist = $this->schedule_model->getHolidayByDoctorByDate($doctor, $date);
            if (!empty($is_exist)) {
                show_swal(lang('already_exist'), 'error', lang('error'));
                redirect($redirect);
                die();
            }
        } else {
            $is_exist = $this->schedule_model->getHolidayByDoctorByDate($doctor, $date);
            if (!empty($is_exist)) {
                if ($is_exist->date == $date) {
                    show_swal(lang('already_exist'), 'error', lang('error'));
                    redirect($redirect);
                    die();
                }
            }
        }
        // Validating Email Field
        $this->form_validation->set_rules('date', 'Date', 'trim|required|min_length[5]|max_length[100]|xss_clean');



        if ($this->form_validation->run() == FALSE) {
            if (!empty($id)) {
                redirect("schedule/editHoliday?id=$id");
            } else {
                $data['settings'] = $this->settings_model->getSettings();
                $this->load->view('home/dashboard', $data);
                $this->load->view('timeslot');
                $this->load->view('home/footer');
            }
        } else {

            $data = array();
            $data = array(
                'doctor' => $doctor,
                'date' => $date,
            );
            if (!empty($id)) {
                show_swal(lang('holiday_added_successfully'), 'success', lang('updated'));
                $this->schedule_model->updateHoliday($id, $data);
            } else {
                show_swal(lang('holiday_updated_successfully'), 'success', lang('added'));
                $this->schedule_model->insertHoliday($data);
            }

            redirect($redirect);
        }
    }

    function editHolidayByJason()
    {
        $id = $this->input->get('id');
        $data['holiday'] = $this->schedule_model->getHolidayById($id);
        $data['doctor'] = $this->doctor_model->getDoctorById($data['holiday']->doctor);
        echo json_encode($data);
    }

    function deleteHoliday()
    {
        $id = $this->input->get('id');

        $holiday_details = $this->schedule_model->getHolidayById($id);
        if ($holiday_details->hospital_id != $this->session->userdata('hospital_id')) {
            redirect('home/permission');
        }

        $redirect = $this->input->get('redirect');
        if (empty($redirect)) {
            $redirect = 'schedule/allHolidays';
        }
        $doctor = $this->input->get('doctor');
        $this->schedule_model->deleteHoliday($id);
        show_swal(lang('holiday_deleted'), 'warning', lang('deleted'));
        redirect($redirect);
    }

    function delete()
    {
        $data = array();
        $id = $this->input->get('id');
        $user_data = $this->db->get_where('doctor', array('id' => $id))->row();
        $path = $user_data->img_url;

        if (!empty($path)) {
            unlink($path);
        }
        $ion_user_id = $user_data->ion_user_id;
        $this->db->where('id', $ion_user_id);
        $this->db->delete('users');
        $this->schedule_model->delete($id);
        show_swal(lang('deleted'), 'warning', lang('deleted')); 
        redirect('doctor');
    }

    function deleteTimeSlot()
    {
        $id = $this->input->get('id');
        $doctor = $this->input->get('doctor');
        $this->schedule_model->deleteTimeSlot($id);
        redirect('scedule/timeSlots?doctor=' . $doctor);
    }
    function arrayKey($key)
    {
        $all_slot = array(
            '0' => '12:00 AM',
            '1' => '12:05 AM',
            '2' => '12:10 AM',
            '3' => '12:15 AM',
            '4' => '12:20 AM',
            '5' => '12:25 AM',
            '6' => '12:30 AM',
            '7' => '12:35 AM',
            '8' => '12:40 PM',
            '9' => '12:45 AM',
            '10' => '12:50 AM',
            '11' => '12:55 AM',
            '12' => '01:00 AM',
            '13' => '01:05 AM',
            '14' => '01:10 AM',
            '15' => '01:15 AM',
            '16' => '01:20 AM',
            '17' => '01:25 AM',
            '18' => '01:30 AM',
            '19' => '01:35 AM',
            '20' => '01:40 AM',
            '21' => '01:45 AM',
            '22' => '01:50 AM',
            '23' => '01:55 AM',
            '24' => '02:00 AM',
            '25' => '02:05 AM',
            '26' => '02:10 AM',
            '27' => '02:15 AM',
            '28' => '02:20 AM',
            '29' => '02:25 AM',
            '30' => '02:30 AM',
            '31' => '02:35 AM',
            '32' => '02:40 AM',
            '33' => '02:45 AM',
            '34' => '02:50 AM',
            '35' => '02:55 AM',
            '36' => '03:00 AM',
            '37' => '03:05 AM',
            '38' => '03:10 AM',
            '39' => '03:15 AM',
            '40' => '03:20 AM',
            '41' => '03:25 AM',
            '42' => '03:30 AM',
            '43' => '03:35 AM',
            '44' => '03:40 AM',
            '45' => '03:45 AM',
            '46' => '03:50 AM',
            '47' => '03:55 AM',
            '48' => '04:00 AM',
            '49' => '04:05 AM',
            '50' => '04:10 AM',
            '51' => '04:15 AM',
            '52' => '04:20 AM',
            '53' => '04:25 AM',
            '54' => '04:30 AM',
            '55' => '04:35 AM',
            '56' => '04:40 AM',
            '57' => '04:45 AM',
            '58' => '04:50 AM',
            '59' => '04:55 AM',
            '60' => '05:00 AM',
            '61' => '05:05 AM',
            '62' => '05:10 AM',
            '63' => '05:15 AM',
            '64' => '05:20 AM',
            '65' => '05:25 AM',
            '66' => '05:30 AM',
            '67' => '05:35 AM',
            '68' => '05:40 AM',
            '69' => '05:45 AM',
            '70' => '05:50 AM',
            '71' => '05:55 AM',
            '72' => '06:00 AM',
            '73' => '06:05 AM',
            '74' => '06:10 AM',
            '75' => '06:15 AM',
            '76' => '06:20 AM',
            '77' => '06:25 AM',
            '78' => '06:30 AM',
            '79' => '06:35 AM',
            '80' => '06:40 AM',
            '81' => '06:45 AM',
            '82' => '06:50 AM',
            '83' => '06:55 AM',
            '84' => '07:00 AM',
            '85' => '07:05 AM',
            '86' => '07:10 AM',
            '87' => '07:15 AM',
            '88' => '07:20 AM',
            '89' => '07:25 AM',
            '90' => '07:30 AM',
            '91' => '07:35 AM',
            '92' => '07:40 AM',
            '93' => '07:45 AM',
            '94' => '07:50 AM',
            '95' => '07:55 AM',
            '96' => '08:00 AM',
            '97' => '08:05 AM',
            '98' => '08:10 AM',
            '99' => '08:15 AM',
            '100' => '08:20 AM',
            '101' => '08:25 AM',
            '102' => '08:30 AM',
            '103' => '08:35 AM',
            '104' => '08:40 AM',
            '105' => '08:45 AM',
            '106' => '08:50 AM',
            '107' => '08:55 AM',
            '108' => '09:00 AM',
            '109' => '09:05 AM',
            '110' => '09:10 AM',
            '111' => '09:15 AM',
            '112' => '09:20 AM',
            '113' => '09:25 AM',
            '114' => '09:30 AM',
            '115' => '09:35 AM',
            '116' => '09:40 AM',
            '117' => '09:45 AM',
            '118' => '09:50 AM',
            '119' => '09:55 AM',
            '120' => '10:00 AM',
            '121' => '10:05 AM',
            '122' => '10:10 AM',
            '123' => '10:15 AM',
            '124' => '10:20 AM',
            '125' => '10:25 AM',
            '126' => '10:30 AM',
            '127' => '10:35 AM',
            '128' => '10:40 AM',
            '129' => '10:45 AM',
            '130' => '10:50 AM',
            '131' => '10:55 AM',
            '132' => '11:00 AM',
            '133' => '11:05 AM',
            '134' => '11:10 AM',
            '135' => '11:15 AM',
            '136' => '11:20 AM',
            '137' => '11:25 AM',
            '138' => '11:30 AM',
            '139' => '11:35 AM',
            '140' => '11:40 AM',
            '141' => '11:45 AM',
            '142' => '11:50 AM',
            '143' => '11:55 AM',
            '144' => '12:00 PM',
            '145' => '12:05 PM',
            '146' => '12:10 PM',
            '147' => '12:15 PM',
            '148' => '12:20 PM',
            '149' => '12:25 PM',
            '150' => '12:30 PM',
            '151' => '12:35 PM',
            '152' => '12:40 PM',
            '153' => '12:45 PM',
            '154' => '12:50 PM',
            '155' => '12:55 PM',
            '156' => '01:00 PM',
            '157' => '01:05 PM',
            '158' => '01:10 PM',
            '159' => '01:15 PM',
            '160' => '01:20 PM',
            '161' => '01:25 PM',
            '162' => '01:30 PM',
            '163' => '01:35 PM',
            '164' => '01:40 PM',
            '165' => '01:45 PM',
            '166' => '01:50 PM',
            '167' => '01:55 PM',
            '168' => '02:00 PM',
            '169' => '02:05 PM',
            '170' => '02:10 PM',
            '171' => '02:15 PM',
            '172' => '02:20 PM',
            '173' => '02:25 PM',
            '174' => '02:30 PM',
            '175' => '02:35 PM',
            '176' => '02:40 PM',
            '177' => '02:45 PM',
            '178' => '02:50 PM',
            '179' => '02:55 PM',
            '180' => '03:00 PM',
            '181' => '03:05 PM',
            '182' => '03:10 PM',
            '183' => '03:15 PM',
            '184' => '03:20 PM',
            '185' => '03:25 PM',
            '186' => '03:30 PM',
            '187' => '03:35 PM',
            '188' => '03:40 PM',
            '189' => '03:45 PM',
            '190' => '03:50 PM',
            '191' => '03:55 PM',
            '192' => '04:00 PM',
            '193' => '04:05 PM',
            '194' => '04:10 PM',
            '195' => '04:15 PM',
            '196' => '04:20 PM',
            '197' => '04:25 PM',
            '198' => '04:30 PM',
            '199' => '04:35 PM',
            '200' => '04:40 PM',
            '201' => '04:45 PM',
            '202' => '04:50 PM',
            '203' => '04:55 PM',
            '204' => '05:00 PM',
            '205' => '05:05 PM',
            '206' => '05:10 PM',
            '207' => '05:15 PM',
            '208' => '05:20 PM',
            '209' => '05:25 PM',
            '210' => '05:30 PM',
            '211' => '05:35 PM',
            '212' => '05:40 PM',
            '213' => '05:45 PM',
            '214' => '05:50 PM',
            '215' => '05:55 PM',
            '216' => '06:00 PM',
            '217' => '06:05 PM',
            '218' => '06:10 PM',
            '219' => '06:15 PM',
            '220' => '06:20 PM',
            '221' => '06:25 PM',
            '222' => '06:30 PM',
            '223' => '06:35 PM',
            '224' => '06:40 PM',
            '225' => '06:45 PM',
            '226' => '06:50 PM',
            '227' => '06:55 PM',
            '228' => '07:00 PM',
            '229' => '07:05 PM',
            '230' => '07:10 PM',
            '231' => '07:15 PM',
            '232' => '07:20 PM',
            '233' => '07:25 PM',
            '234' => '07:30 PM',
            '235' => '07:35 PM',
            '236' => '07:40 PM',
            '237' => '07:45 PM',
            '238' => '07:50 PM',
            '239' => '07:55 PM',
            '240' => '08:00 PM',
            '241' => '08:05 PM',
            '242' => '08:10 PM',
            '243' => '08:15 PM',
            '244' => '08:20 PM',
            '245' => '08:25 PM',
            '246' => '08:30 PM',
            '247' => '08:35 PM',
            '248' => '08:40 PM',
            '249' => '08:45 PM',
            '250' => '08:50 PM',
            '251' => '08:55 PM',
            '252' => '09:00 PM',
            '253' => '09:05 PM',
            '254' => '09:10 PM',
            '255' => '09:15 PM',
            '256' => '09:20 PM',
            '257' => '09:25 PM',
            '258' => '09:30 PM',
            '259' => '09:35 PM',
            '260' => '09:40 PM',
            '261' => '09:45 PM',
            '262' => '09:50 PM',
            '263' => '09:55 PM',
            '264' => '10:00 PM',
            '265' => '10:05 PM',
            '266' => '10:10 PM',
            '267' => '10:15 PM',
            '268' => '10:20 PM',
            '269' => '10:25 PM',
            '270' => '10:30 PM',
            '271' => '10:35 PM',
            '272' => '10:40 PM',
            '273' => '10:45 PM',
            '274' => '10:50 PM',
            '275' => '10:55 PM',
            '276' => '11:00 PM',
            '277' => '11:05 PM',
            '278' => '11:10 PM',
            '279' => '11:15 PM',
            '280' => '11:20 PM',
            '281' => '11:25 PM',
            '282' => '11:30 PM',
            '283' => '11:35 PM',
            '284' => '11:40 PM',
            '285' => '11:45 PM',
            '286' => '11:50 PM',
            '287' => '11:55 PM',
        );
        $key1 = array_search($key, $all_slot);
        return $key1;
    }




    function getAvailableScheduleStime()
    {

        $data = array();

        $s_time = $this->input->get('s_time');
        $e_time = $this->input->get('e_time');

        if (($this->arrayKey($s_time) >= $this->arrayKey($e_time)) && !empty($s_time) && !empty($e_time)) {
            $data['response'] = 'upper_lower';
        } else {
            $weekday = $this->input->get('weekday');
            $doctor = $this->input->get('doctor');
            if (empty($e_time) && empty($doctor)) {
                $data['response'] = 'yes';
            } elseif (!empty($e_time) && empty($doctor)) {
                $data['response'] = 'yes';
            } else {
                $schedule_data = $this->schedule_model->getScheduleByDoctorByWeekday($doctor, $weekday);

                if (empty($schedule_data)) {
                    $data['response'] = 'yes';
                } else {
                    $schedule_pre = array();

                    $key1 = $this->arrayKey($s_time);
                    if (!empty($e_time)) {
                        $key2 = $this->arrayKey($e_time);
                    }
                    foreach ($schedule_data as $schedule) {
                        $previous_key_s = $this->arrayKey($schedule->s_time);
                        $previous_key_e = $this->arrayKey($schedule->e_time);
                        if (empty($e_time)) {
                            if ($key1 >= $previous_key_s && $key1 <= $previous_key_e) {
                                $schedule_pre[] = 'yes';
                            } else {
                                $schedule_pre[] = 'no';
                            }
                        } else {
                            if ($key1 >= $previous_key_s && $key2 <= $previous_key_e) {
                                $schedule_pre[] = 'yes';
                            } elseif ($key1 <= $previous_key_s && $key2 >= $previous_key_e) {
                                $schedule_pre[] = 'yes';
                            } elseif ($key1 > $previous_key_s && $key1 <= $previous_key_e) {
                                $schedule_pre[] = 'yes';
                            } elseif ($key2 > $previous_key_s && $key2 <= $previous_key_e) {
                                $schedule_pre[] = 'yes';
                            } else {
                                $schedule_pre[] = 'no';
                            }
                        }
                    }
                    if (in_array('yes', $schedule_pre)) {
                        $data['response'] = 'no';
                    } else {
                        $data['response'] = 'yes';
                    }
                }
            }
        }
        echo json_encode($data);
    }
    function getAvailableScheduleEtime()
    {



        $s_time = $this->input->get('s_time');
        $e_time = $this->input->get('e_time');
        $weekday = $this->input->get('weekday');
        $doctor = $this->input->get('doctor');
        if (($this->arrayKey($s_time) >= $this->arrayKey($e_time)) && !empty($s_time) && !empty($e_time)) {
            $data['response'] = 'upper_lower';
        } else {
            if (empty($s_time) && empty($doctor)) {
                $data['response'] = 'yes';
            } else {
                $schedule_data = $this->schedule_model->getScheduleByDoctorByWeekday($doctor, $weekday);

                if (empty($schedule_data)) {
                    $data['response'] = 'yes';
                } else {
                    $schedule_pre = array();
                    if (!empty($s_time)) {
                        $key1 = $this->arrayKey($s_time);
                    }

                    $key2 = $this->arrayKey($e_time);

                    foreach ($schedule_data as $schedule) {
                        $previous_key_s = $this->arrayKey($schedule->s_time);
                        $previous_key_e = $this->arrayKey($schedule->e_time);
                        if (empty($s_time)) {
                            if ($key2 >= $previous_key_s && $key2 <= $previous_key_e) {
                                $schedule_pre[] = 'yes';
                            } else {
                                $schedule_pre[] = 'no';
                            }
                        } else {
                            if ($key1 >= $previous_key_s && $key2 <= $previous_key_e) {
                                $schedule_pre[] = 'yes';
                            } elseif ($key1 <= $previous_key_s && $key2 >= $previous_key_e) {
                                $schedule_pre[] = 'yes';
                            } elseif ($key1 > $previous_key_s && $key1 <= $previous_key_e) {
                                $schedule_pre[] = 'yes';
                            } elseif ($key2 > $previous_key_s && $key2 <= $previous_key_e) {
                                $schedule_pre[] = 'yes';
                            } else {
                                $schedule_pre[] = 'no';
                            }
                        }
                    }
                    if (in_array('yes', $schedule_pre)) {
                        $data['response'] = 'no';
                    } else {
                        $data['response'] = 'yes';
                    }
                }
            }
        }
        echo json_encode($data);
    }











    function getIfPatientIsAvailableOrNot()
    {
        $date = $this->input->get('date');
        $patient = $this->input->get('patient');
        $current_slot_string = $this->input->get('current_slot');
        $appointment_id = $this->input->get('appointment_id');
        $doctor = $this->input->get('doctor');



        if (!empty($date)) {
            $date = strtotime(($date));
        }

        $appointments = $this->appointment_model->getAppointmentByPatientByDate($patient, $date);

        if (!empty($current_slot_string)) {
            $current_slot = explode(' To ', $current_slot_string);
        }

        $s_time = $current_slot[0];
        $e_time = $current_slot[1];
        $s_key = $this->arrayKey($s_time);
        $e_key = $this->arrayKey($e_time);



        foreach ($appointments as $appointment) {
            if (!empty($appointment->s_time) && !empty($appointment->e_time)) {
                $previous_s_time = $appointment->s_time;
                $previous_e_time = $appointment->e_time;
                $previous_s_key = $this->arrayKey($previous_s_time);
                $previous_e_key = $this->arrayKey($previous_e_time);

                if ($s_key >= $previous_s_key && $e_key <= $previous_e_key) {
                    $available[] = 'no';
                } elseif ($s_key <= $previous_s_key && $e_key >= $previous_e_key) {
                    $available[] = 'no';
                } elseif ($s_key > $previous_s_key && $s_key <= $previous_e_key) {
                    $available[] = 'no';
                } elseif ($e_key > $previous_s_key && $e_key <= $previous_e_key) {
                    $available[] = 'no';
                } else {
                    $available[] = 'yes';
                }
            }
        }
        $data = array();
        if (in_array('no', $available)) {
            $data['response'] = 'no';
        } else {
            $data['response'] = 'yes';
        }

        if (!empty($appointment_id)) {
            $current_appointment = $this->appointment_model->getAppointmentById($appointment_id);
            if ($patient == $current_appointment->patient && $doctor == $current_appointment->doctor && $date == $current_appointment->date && $current_slot_string == $current_appointment->time_slot) {
                $data['response'] = 'yes';
            }
        }



        echo json_encode($data);
    }

    // Date-based Schedule Methods for Admin (UNIFIED VERSION)
    function addDateSchedule()
    {
        if ($this->ion_auth->in_group(array('Doctor'))) {
            redirect('home/permission');
        }

        $doctor = $this->input->post('doctor');
        $date_of_month = $this->input->post('date_of_month');
        $start_time = $this->input->post('start_time');
        $end_time = $this->input->post('end_time');
        $duration = $this->input->post('duration');

        $this->load->library('form_validation');
        $this->form_validation->set_rules('doctor', 'Doctor', 'trim|required|xss_clean');
        $this->form_validation->set_rules('date_of_month', 'Date of Month', 'trim|required|integer|greater_than[0]|less_than[32]|xss_clean');
        $this->form_validation->set_rules('start_time', 'Start Time', 'trim|required|xss_clean');
        $this->form_validation->set_rules('end_time', 'End Time', 'trim|required|xss_clean');
        $this->form_validation->set_rules('duration', 'Duration', 'trim|required|integer|greater_than[0]|xss_clean');

        if ($this->form_validation->run() == FALSE) {
            $this->session->set_flashdata('feedback', validation_errors());
            $this->session->set_flashdata('feedback_class', 'alert-danger');
        } else {
            // Check if schedule already exists for this doctor and date in unified table
            $this->db->where('doctor', $doctor);
            $this->db->where('date_of_month', $date_of_month);
            $this->db->where('schedule_type', 'date');
            $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
            $existing = $this->db->get('time_schedule')->row();
            
            if ($existing) {
                $this->session->set_flashdata('feedback', lang('schedule_already_exists_for_this_date'));
                $this->session->set_flashdata('feedback_class', 'alert-danger');
            } else {
                // Convert time format for compatibility
                if ($this->settings->time_format == '24') {
                    $start_time = $this->settings_model->convert_to_12h($start_time);
                    $end_time = $this->settings_model->convert_to_12h($end_time);
                }

                $data = array(
                    'doctor' => $doctor,
                    's_time' => $start_time,
                    'e_time' => $end_time,
                    'duration' => $duration,
                    'schedule_type' => 'date',
                    'date_of_month' => $date_of_month,
                    'hospital_id' => $this->session->userdata('hospital_id')
                );

                // Insert into unified time_schedule table
                $this->db->insert('time_schedule', $data);
                $schedule_id = $this->db->insert_id();
                
                if ($schedule_id) {
                    // Update doctor's schedule_type to 'date' if not already set
                    $this->db->where('id', $doctor);
                    $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
                    $this->db->update('doctor', array('schedule_type' => 'date'));
                    
                    // Generate time slots using the unified logic
                    $slots_created = $this->generateUnifiedTimeSlots($doctor, $start_time, $end_time, $duration, 'date', $date_of_month);
                    
                    $this->session->set_flashdata('feedback', lang('date_schedule_added_successfully') . ' (' . $slots_created . ' slots created)');
                    $this->session->set_flashdata('feedback_class', 'alert-success');
                } else {
                    $this->session->set_flashdata('feedback', lang('failed_to_add_date_schedule'));
                    $this->session->set_flashdata('feedback_class', 'alert-danger');
                }
            }
        }
        redirect('schedule');
    }

    // Unified method to generate time slots for both weekday and date-based schedules
    private function generateUnifiedTimeSlots($doctor, $start_time, $end_time, $duration, $schedule_type, $date_of_month = null, $weekday = null)
    {
        // Parse start and end times
        $start_timestamp = strtotime($start_time);
        $end_timestamp = strtotime($end_time);
        
        if ($start_timestamp === false || $end_timestamp === false) {
            return 0;
        }
        
        $duration_seconds = $duration * 60; // Convert minutes to seconds
        $slots = array();
        
        // Generate time slots
        for ($current_time = $start_timestamp; $current_time < $end_timestamp; $current_time += $duration_seconds) {
            $slot_start = date('h:i A', $current_time);
            $slot_end = date('h:i A', $current_time + $duration_seconds);
            
            // Calculate s_time_key (minutes from midnight)
            $s_time_key = (date('H', $current_time) * 60) + date('i', $current_time);
            
            $slot_data = array(
                'doctor' => $doctor,
                's_time' => $slot_start,
                'e_time' => $slot_end,
                's_time_key' => $s_time_key,
                'schedule_type' => $schedule_type,
                'hospital_id' => $this->session->userdata('hospital_id')
            );
            
            // Add type-specific fields
            if ($schedule_type == 'date') {
                $slot_data['date_of_month'] = $date_of_month;
                $slot_data['weekday'] = null;
            } else {
                $slot_data['weekday'] = $weekday;
                $slot_data['date_of_month'] = null;
            }
            
            $slots[] = $slot_data;
        }
        
        // Insert slots in batch
        if (!empty($slots)) {
            $this->db->insert_batch('time_slot', $slots);
        }
        
        return count($slots);
    }

    function updateDateSchedule()
    {
        if ($this->ion_auth->in_group(array('Doctor'))) {
            redirect('home/permission');
        }

        $id = $this->input->post('id');
        $doctor = $this->input->post('doctor');
        $date_of_month = $this->input->post('date_of_month');
        $start_time = $this->input->post('start_time');
        $end_time = $this->input->post('end_time');
        $duration = $this->input->post('duration');

        $this->load->library('form_validation');
        $this->form_validation->set_rules('id', 'ID', 'trim|required|integer|xss_clean');
        $this->form_validation->set_rules('doctor', 'Doctor', 'trim|required|xss_clean');
        $this->form_validation->set_rules('date_of_month', 'Date of Month', 'trim|required|integer|greater_than[0]|less_than[32]|xss_clean');
        $this->form_validation->set_rules('start_time', 'Start Time', 'trim|required|xss_clean');
        $this->form_validation->set_rules('end_time', 'End Time', 'trim|required|xss_clean');
        $this->form_validation->set_rules('duration', 'Duration', 'trim|required|integer|greater_than[0]|xss_clean');

        if ($this->form_validation->run() == FALSE) {
            $this->session->set_flashdata('feedback', validation_errors());
            $this->session->set_flashdata('feedback_class', 'alert-danger');
        } else {
            // Convert time format for compatibility
            if ($this->settings->time_format == '24') {
                $start_time = $this->settings_model->convert_to_12h($start_time);
                $end_time = $this->settings_model->convert_to_12h($end_time);
            }

            $data = array(
                'doctor' => $doctor,
                's_time' => $start_time,
                'e_time' => $end_time,
                'date_of_month' => $date_of_month,
                'duration' => $duration
            );

            // Update the schedule in unified table
            $this->db->where('id', $id);
            $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
            $this->db->update('time_schedule', $data);
            
            // Get the schedule to regenerate slots
            $this->db->where('id', $id);
            $schedule = $this->db->get('time_schedule')->row();
            
            if ($schedule) {
                // Delete old time slots for this schedule
                $this->db->where('doctor', $schedule->doctor);
                $this->db->where('date_of_month', $schedule->date_of_month);
                $this->db->where('schedule_type', 'date');
                $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
                $this->db->delete('time_slot');
                
                // Regenerate time slots using unified method
                $slots_created = $this->generateUnifiedTimeSlots(
                    $schedule->doctor, $start_time, $end_time, $duration, 'date', $date_of_month
                );
                
                $this->session->set_flashdata('feedback', lang('date_schedule_updated_successfully') . ' (' . $slots_created . ' slots updated)');
                $this->session->set_flashdata('feedback_class', 'alert-success');
            } else {
                $this->session->set_flashdata('feedback', lang('schedule_not_found'));
                $this->session->set_flashdata('feedback_class', 'alert-danger');
            }
        }
        redirect('schedule');
    }

    function deleteDateSchedule()
    {
        if ($this->ion_auth->in_group(array('Doctor'))) {
            redirect('home/permission');
        }

        $id = $this->input->get('id');
        
        // Get schedule details to find the doctor and date_of_month for slot cleanup
        $this->db->where('id', $id);
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $schedule = $this->db->get('time_schedule')->row();
        
        if ($schedule && $schedule->schedule_type == 'date') {
            // Delete related time slots
            $this->db->where('doctor', $schedule->doctor);
            $this->db->where('date_of_month', $schedule->date_of_month);
            $this->db->where('schedule_type', 'date');
            $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
            $this->db->delete('time_slot');
            
            // Delete the schedule
            $this->db->where('id', $id);
            $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
            $this->db->delete('time_schedule');
            
            show_swal(lang('date_schedule_deleted_successfully'), 'success', lang('deleted'));
        } else {
            show_swal(lang('schedule_not_found'), 'error', lang('error'));
        }
        
        redirect('schedule');
    }

    function getDateScheduleById()
    {
        $id = $this->input->get('id');
        
        // Get date schedule from unified table
        $this->db->where('id', $id);
        $this->db->where('schedule_type', 'date');
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $schedule = $this->db->get('time_schedule')->row();
        
        $data['schedule'] = $schedule;
        echo json_encode($data);
    }

    // Get available slots for appointment booking (AJAX endpoint)
    function getAvailableSlots()
    {
        $doctor_id = $this->input->get('doctor_id');
        $selected_date = $this->input->get('date');
        
        if (!$doctor_id || !$selected_date) {
            echo json_encode(array('status' => 'error', 'message' => 'Missing parameters'));
            return;
        }
        
        // Convert date to timestamp
        $date_timestamp = strtotime($selected_date);
        
        // Ensure hospital_id is set in session
        if (!$this->session->userdata('hospital_id')) {
            // Try to get hospital_id from doctor
            $doctor = $this->doctor_model->getDoctorById($doctor_id);
            if ($doctor && !empty($doctor->hospital_id)) {
                $this->session->set_userdata('hospital_id', $doctor->hospital_id);
            }
        }
        
        // Use the existing working function that properly filters booked slots
        $available_slots = $this->schedule_model->getAvailableSlotByDoctorByDate($date_timestamp, $doctor_id);
        
        if (empty($available_slots)) {
            echo json_encode(array('status' => 'success', 'slots' => array()));
            return;
        }
        
        // Convert to the format expected by the JavaScript
        $formatted_slots = array();
        foreach ($available_slots as $slot_string) {
            $time_parts = explode(' To ', $slot_string);
            if (count($time_parts) == 2) {
                $formatted_slots[] = array(
                    's_time' => trim($time_parts[0]),
                    'e_time' => trim($time_parts[1])
                );
            }
        }
        
        $result = array(
            'status' => 'success',
            'slots' => $formatted_slots
        );
        
        echo json_encode($result);
    }

    // Date-based Schedule Methods for Individual Doctors (UNIFIED VERSION)
    function addDoctorDateSchedule()
    {
        $redirect = $this->input->post('redirect');
        if (empty($redirect)) {
            $redirect = 'schedule/timeSchedule';
        }

        if ($this->ion_auth->in_group(array('Doctor'))) {
            $doctor_ion_id = $this->ion_auth->get_user_id();
            $doctor = $this->doctor_model->getDoctorByIonUserId($doctor_ion_id)->id;
        } else {
            $doctor = $this->input->post('doctor');
        }

        $date_of_month = $this->input->post('date_of_month');
        $start_time = $this->input->post('start_time');
        $end_time = $this->input->post('end_time');
        $duration = $this->input->post('duration');

        $this->load->library('form_validation');
        $this->form_validation->set_rules('date_of_month', 'Date of Month', 'trim|required|integer|greater_than[0]|less_than[32]|xss_clean');
        $this->form_validation->set_rules('start_time', 'Start Time', 'trim|required|xss_clean');
        $this->form_validation->set_rules('end_time', 'End Time', 'trim|required|xss_clean');
        $this->form_validation->set_rules('duration', 'Duration', 'trim|required|integer|greater_than[0]|xss_clean');

        if ($this->form_validation->run() == FALSE) {
            $this->session->set_flashdata('feedback', validation_errors());
            $this->session->set_flashdata('feedback_class', 'alert-danger');
        } else {
            // Check if schedule already exists for this doctor and date in unified table
            $this->db->where('doctor', $doctor);
            $this->db->where('date_of_month', $date_of_month);
            $this->db->where('schedule_type', 'date');
            $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
            $existing = $this->db->get('time_schedule')->row();
            
            if ($existing) {
                $this->session->set_flashdata('feedback', lang('schedule_already_exists_for_this_date'));
                $this->session->set_flashdata('feedback_class', 'alert-danger');
            } else {
                // Convert time format for compatibility
                if ($this->settings->time_format == '24') {
                    $start_time = $this->settings_model->convert_to_12h($start_time);
                    $end_time = $this->settings_model->convert_to_12h($end_time);
                }

                $data = array(
                    'doctor' => $doctor,
                    's_time' => $start_time,
                    'e_time' => $end_time,
                    'duration' => $duration,
                    'schedule_type' => 'date',
                    'date_of_month' => $date_of_month,
                    'hospital_id' => $this->session->userdata('hospital_id')
                );

                // Insert into unified time_schedule table
                $this->db->insert('time_schedule', $data);
                $schedule_id = $this->db->insert_id();
                
                if ($schedule_id) {
                    // Update doctor's schedule_type to 'date' if not already set
                    $this->db->where('id', $doctor);
                    $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
                    $this->db->update('doctor', array('schedule_type' => 'date'));
                    
                    // Generate time slots using the unified logic
                    $slots_created = $this->generateUnifiedTimeSlots($doctor, $start_time, $end_time, $duration, 'date', $date_of_month);
                    
                    $this->session->set_flashdata('feedback', lang('date_schedule_added_successfully') . ' (' . $slots_created . ' slots created)');
                    $this->session->set_flashdata('feedback_class', 'alert-success');
                } else {
                    $this->session->set_flashdata('feedback', lang('failed_to_add_date_schedule'));
                    $this->session->set_flashdata('feedback_class', 'alert-danger');
                }
            }
        }
        redirect($redirect);
    }

    function updateDoctorDateSchedule()
    {
        $redirect = $this->input->post('redirect');
        if (empty($redirect)) {
            $redirect = 'schedule/timeSchedule';
        }

        if ($this->ion_auth->in_group(array('Doctor'))) {
            $doctor_ion_id = $this->ion_auth->get_user_id();
            $doctor = $this->doctor_model->getDoctorByIonUserId($doctor_ion_id)->id;
        } else {
            $doctor = $this->input->post('doctor');
        }

        $id = $this->input->post('id');
        $date_of_month = $this->input->post('date_of_month');
        $start_time = $this->input->post('start_time');
        $end_time = $this->input->post('end_time');
        $duration = $this->input->post('duration');

        $this->load->library('form_validation');
        $this->form_validation->set_rules('id', 'ID', 'trim|required|integer|xss_clean');
        $this->form_validation->set_rules('date_of_month', 'Date of Month', 'trim|required|integer|greater_than[0]|less_than[32]|xss_clean');
        $this->form_validation->set_rules('start_time', 'Start Time', 'trim|required|xss_clean');
        $this->form_validation->set_rules('end_time', 'End Time', 'trim|required|xss_clean');
        $this->form_validation->set_rules('duration', 'Duration', 'trim|required|integer|greater_than[0]|xss_clean');

        if ($this->form_validation->run() == FALSE) {
            $this->session->set_flashdata('feedback', validation_errors());
            $this->session->set_flashdata('feedback_class', 'alert-danger');
        } else {
            // Convert time format for compatibility
            if ($this->settings->time_format == '24') {
                $start_time = $this->settings_model->convert_to_12h($start_time);
                $end_time = $this->settings_model->convert_to_12h($end_time);
            }

            $data = array(
                'doctor' => $doctor,
                's_time' => $start_time,
                'e_time' => $end_time,
                'date_of_month' => $date_of_month,
                'duration' => $duration
            );

            // Update the schedule in unified table
            $this->db->where('id', $id);
            $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
            $this->db->update('time_schedule', $data);
            
            // Get the schedule to regenerate slots
            $this->db->where('id', $id);
            $schedule = $this->db->get('time_schedule')->row();
            
            if ($schedule) {
                // Delete old time slots for this schedule
                $this->db->where('doctor', $schedule->doctor);
                $this->db->where('date_of_month', $schedule->date_of_month);
                $this->db->where('schedule_type', 'date');
                $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
                $this->db->delete('time_slot');
                
                // Regenerate time slots using unified method
                $slots_created = $this->generateUnifiedTimeSlots(
                    $schedule->doctor, $start_time, $end_time, $duration, 'date', $date_of_month
                );
                
                $this->session->set_flashdata('feedback', lang('date_schedule_updated_successfully') . ' (' . $slots_created . ' slots updated)');
                $this->session->set_flashdata('feedback_class', 'alert-success');
            } else {
                $this->session->set_flashdata('feedback', lang('schedule_not_found'));
                $this->session->set_flashdata('feedback_class', 'alert-danger');
            }
        }
        redirect($redirect);
    }

    function deleteDoctorDateSchedule()
    {
        $redirect = $this->input->get('redirect');
        if (empty($redirect)) {
            $redirect = 'schedule/timeSchedule';
        }

        $id = $this->input->get('id');
        
        // Get schedule details
        $this->db->where('id', $id);
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $schedule = $this->db->get('time_schedule')->row();
        
        if (!$schedule || $schedule->schedule_type != 'date') {
            show_swal(lang('schedule_not_found'), 'error', lang('error'));
            redirect($redirect);
            return;
        }
        
        // Verify ownership if doctor
        if ($this->ion_auth->in_group(array('Doctor'))) {
            $doctor_ion_id = $this->ion_auth->get_user_id();
            $doctor = $this->doctor_model->getDoctorByIonUserId($doctor_ion_id)->id;
            
            if ($schedule->doctor != $doctor) {
                redirect('home/permission');
            }
        }

        // Delete related time slots
        $this->db->where('doctor', $schedule->doctor);
        $this->db->where('date_of_month', $schedule->date_of_month);
        $this->db->where('schedule_type', 'date');
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $this->db->delete('time_slot');
        
        // Delete the schedule
        $this->db->where('id', $id);
        $this->db->where('hospital_id', $this->session->userdata('hospital_id'));
        $this->db->delete('time_schedule');
        
        show_swal(lang('date_schedule_deleted_successfully'), 'success', lang('deleted'));
        redirect($redirect);
    }

    // UTILITY METHOD: Generate time slots for migrated date-based schedules
    // Call this once after running the SQL migration script
    function generateMigratedTimeSlots()
    {
        // Only admin can run this utility
        if (!$this->ion_auth->in_group(array('admin'))) {
            redirect('home/permission');
        }

        // Get all date-based schedules that don't have time slots yet
        $this->db->select('ts.*');
        $this->db->from('time_schedule ts');
        $this->db->where('ts.schedule_type', 'date');
        $this->db->where('ts.hospital_id', $this->session->userdata('hospital_id'));
        
        // Check if they already have time slots
        $this->db->join('time_slot tsl', 'tsl.doctor = ts.doctor AND tsl.date_of_month = ts.date_of_month AND tsl.schedule_type = "date"', 'left');
        $this->db->where('tsl.id IS NULL'); // Only schedules without existing slots
        
        $schedules = $this->db->get()->result();
        
        $total_generated = 0;
        foreach ($schedules as $schedule) {
            $slots_created = $this->generateUnifiedTimeSlots(
                $schedule->doctor, 
                $schedule->s_time, 
                $schedule->e_time, 
                $schedule->duration, 
                'date', 
                $schedule->date_of_month
            );
            $total_generated += $slots_created;
        }
        
        echo "Generated " . $total_generated . " time slots for " . count($schedules) . " date-based schedules.";
    }

    // Replacement methods for the removed dateschedule_model
    private function getUnifiedDateSchedules()
    {
        $this->db->select('time_schedule.*, doctor.name as doctor_name, doctor.id as doctor_id');
        $this->db->from('time_schedule');
        $this->db->join('doctor', 'doctor.id = time_schedule.doctor');
        $this->db->where('time_schedule.schedule_type', 'date');
        $this->db->where('time_schedule.hospital_id', $this->session->userdata('hospital_id'));
        $this->db->order_by('time_schedule.date_of_month', 'asc');
        $query = $this->db->get();
        return $query->result();
    }

    private function getUnifiedDateSchedulesByDoctor($doctor_id)
    {
        $this->db->select('time_schedule.*, doctor.name as doctor_name, doctor.id as doctor_id');
        $this->db->from('time_schedule');
        $this->db->join('doctor', 'doctor.id = time_schedule.doctor');
        $this->db->where('time_schedule.doctor', $doctor_id);
        $this->db->where('time_schedule.schedule_type', 'date');
        $this->db->where('time_schedule.hospital_id', $this->session->userdata('hospital_id'));
        $this->db->order_by('time_schedule.date_of_month', 'asc');
        $query = $this->db->get();
        return $query->result();
    }
}

/* End of file schedule.php */
/* Location: ./application/modules/schedule/controllers/schedule.php */
