<!-- Patient Selection Page -->
<div class="content-wrapper bg-light">
    <section class="content-header py-4 bg-white shadow-sm">
        <div class="container-fluid">
            <div class="row align-items-center">
                <div class="col-sm-6">
                    <h1 class="display-4 font-weight-black mb-0">
                        <i class="fas fa-users mr-3 text-primary"></i>
                        Select Patient Account
                    </h1>
                    <p class="text-muted mt-2">Choose which patient account you want to access</p>
                </div>
                <div class="col-sm-6">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb float-sm-right bg-transparent">
                            <li class="breadcrumb-item"><a href="home" class="text-primary">Home</a></li>
                            <li class="breadcrumb-item active font-weight-bold">Patient Selection</li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
    </section>

    <section class="content py-5">
        <div class="container-fluid">
            <div class="row justify-content-center">
                <div class="col-md-10">
                    
                    <!-- Guardian Card -->
                    <?php if ($guardian_data): ?>
                    <div class="card shadow-lg border-0 mb-4">
                        <div class="card-header bg-gradient-primary py-4">
                            <h3 class="card-title mb-0 text-white">
                                <i class="fas fa-user-shield mr-3"></i>Your Account (Guardian)
                            </h3>
                        </div>
                        <div class="card-body bg-light p-4">
                            <div class="row align-items-center">
                                <div class="col-md-3 text-center">
                                    <div class="patient-avatar">
                                        <?php if (!empty($guardian_data->img_url) && file_exists($guardian_data->img_url)): ?>
                                            <img src="<?php echo $guardian_data->img_url; ?>" alt="Profile" class="rounded-circle" style="width: 100px; height: 100px; object-fit: cover;">
                                        <?php else: ?>
                                            <div class="bg-primary rounded-circle d-flex align-items-center justify-content-center" style="width: 100px; height: 100px;">
                                                <i class="fas fa-user text-white" style="font-size: 40px;"></i>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <h4 class="font-weight-bold text-primary"><?php echo $guardian_data->name; ?></h4>
                                    <p class="text-muted mb-1">
                                        <i class="fas fa-phone mr-2"></i><?php echo $guardian_data->phone; ?>
                                    </p>
                                    <?php 
                                    $age_parts = explode('-', $guardian_data->age);
                                    $age = $age_parts[0] ?? '0';
                                    ?>
                                    <p class="text-muted mb-1">
                                        <i class="fas fa-birthday-cake mr-2"></i><?php echo $age; ?> years old
                                    </p>
                                    <p class="text-muted mb-0">
                                        <i class="fas fa-venus-mars mr-2"></i><?php echo ucfirst($guardian_data->sex); ?>
                                    </p>
                                </div>
                                <div class="col-md-3 text-center">
                                    <a href="patientselection/switchToPatient/<?php echo $guardian_data->id; ?>" 
                                       class="btn btn-primary btn-lg px-4 py-3">
                                        <i class="fas fa-sign-in-alt mr-2"></i>
                                        Access Your Account
                                    </a>
                                    <?php if ($current_patient_id == $guardian_data->id): ?>
                                        <div class="badge badge-success mt-2">Currently Active</div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>

                    <!-- Dependents Section -->
                    <?php if (!empty($dependents)): ?>
                    <div class="card shadow-lg border-0">
                        <div class="card-header bg-gradient-info py-4">
                            <h3 class="card-title mb-0 text-white">
                                <i class="fas fa-users mr-3"></i>
                                Your Dependents (<?php echo count($dependents); ?>)
                            </h3>
                            <p class="text-white-50 mb-0 mt-2">Family members you can manage</p>
                        </div>
                        <div class="card-body bg-light p-4">
                            <div class="row">
                                <?php foreach ($dependents as $dependent): ?>
                                    <?php 
                                    $age_parts = explode('-', $dependent->age);
                                    $age = $age_parts[0] ?? '0';
                                    ?>
                                <div class="col-md-6 mb-4">
                                    <div class="card border shadow-sm h-100">
                                        <div class="card-body">
                                            <div class="row align-items-center">
                                                <div class="col-4 text-center">
                                                    <div class="dependent-avatar">
                                                        <?php if (!empty($dependent->img_url) && file_exists($dependent->img_url)): ?>
                                                            <img src="<?php echo $dependent->img_url; ?>" alt="Profile" class="rounded-circle" style="width: 70px; height: 70px; object-fit: cover;">
                                                        <?php else: ?>
                                                            <div class="bg-info rounded-circle d-flex align-items-center justify-content-center" style="width: 70px; height: 70px;">
                                                                <?php if ($dependent->relationship == 'son' || $dependent->relationship == 'daughter'): ?>
                                                                    <i class="fas fa-child text-white" style="font-size: 30px;"></i>
                                                                <?php elseif ($dependent->relationship == 'spouse'): ?>
                                                                    <i class="fas fa-heart text-white" style="font-size: 25px;"></i>
                                                                <?php elseif (in_array($dependent->relationship, ['mother', 'father', 'grandmother', 'grandfather'])): ?>
                                                                    <i class="fas fa-user-friends text-white" style="font-size: 25px;"></i>
                                                                <?php else: ?>
                                                                    <i class="fas fa-user text-white" style="font-size: 25px;"></i>
                                                                <?php endif; ?>
                                                            </div>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                                <div class="col-8">
                                                    <h5 class="font-weight-bold text-info mb-1"><?php echo $dependent->name; ?></h5>
                                                    <p class="text-muted mb-1 small">
                                                        <i class="fas fa-heart mr-1"></i>
                                                        <strong><?php echo ucfirst($dependent->relationship); ?></strong>
                                                    </p>
                                                    <p class="text-muted mb-1 small">
                                                        <i class="fas fa-birthday-cake mr-1"></i><?php echo $age; ?> years
                                                    </p>
                                                    <p class="text-muted mb-2 small">
                                                        <i class="fas fa-venus-mars mr-1"></i><?php echo ucfirst($dependent->sex); ?>
                                                    </p>
                                                    
                                                    <?php if ($current_patient_id == $dependent->id): ?>
                                                        <div class="badge badge-success mb-2">Currently Active</div>
                                                    <?php endif; ?>
                                                    
                                                    <a href="patientselection/switchToPatient/<?php echo $dependent->id; ?>" 
                                                       class="btn btn-info btn-sm btn-block">
                                                        <i class="fas fa-sign-in-alt mr-1"></i>
                                                        Access Account
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>

                    <!-- Information Section -->
                    <div class="card shadow-lg border-0 mt-4">
                        <div class="card-header bg-gradient-secondary py-3">
                            <h5 class="card-title mb-0 text-white">
                                <i class="fas fa-info-circle mr-2"></i>Important Information
                            </h5>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <h6 class="text-primary">
                                        <i class="fas fa-shield-alt mr-2"></i>Access & Permissions
                                    </h6>
                                    <ul class="list-unstyled text-muted">
                                        <li><i class="fas fa-check text-success mr-2"></i>Full access to medical records</li>
                                        <li><i class="fas fa-check text-success mr-2"></i>Appointment management</li>
                                        <li><i class="fas fa-check text-success mr-2"></i>Prescription history</li>
                                        <li><i class="fas fa-check text-success mr-2"></i>Lab reports & documents</li>
                                    </ul>
                                </div>
                                <div class="col-md-6">
                                    <h6 class="text-primary">
                                        <i class="fas fa-bell mr-2"></i>Notifications
                                    </h6>
                                    <ul class="list-unstyled text-muted">
                                        <li><i class="fas fa-sms text-info mr-2"></i>SMS alerts sent to your phone</li>
                                        <li><i class="fas fa-envelope text-info mr-2"></i>Email notifications for appointments</li>
                                        <li><i class="fas fa-phone text-info mr-2"></i>Emergency contacts maintained</li>
                                    </ul>
                                </div>
                            </div>
                            <div class="alert alert-info mt-3 mb-0">
                                <i class="fas fa-lightbulb mr-2"></i>
                                <strong>Note:</strong> As a guardian, you have the same access level for all your dependents as you do for your own account. 
                                All medical information and appointment management is available with full permissions.
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </section>
</div>

<!-- Quick Switch Widget (can be embedded in other pages) -->
<style>
.patient-avatar, .dependent-avatar {
    transition: transform 0.3s ease;
}

.patient-avatar:hover, .dependent-avatar:hover {
    transform: scale(1.1);
}

.card {
    transition: transform 0.2s ease, box-shadow 0.2s ease;
}

.card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.15) !important;
}

.btn {
    transition: all 0.3s ease;
}

.btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 15px rgba(0,0,0,0.2);
}
</style> 