<link href="common/extranal/css/patient/medical_history.css" rel="stylesheet">

<div class="content-wrapper bg-gradient-light" style="min-height: 2726.9px;">
    <section class="content-header py-4 bg-white shadow-sm">
        <div class="container-fluid">
            <div class="row align-items-center">
                <div class="col-sm-6">
                    <h1 class="display-4 font-weight-black mb-0">
                        <i class="fas fa-user text-primary mr-3"></i>
                        <?php echo lang('all'); ?> <?php echo lang('patients'); ?>
                    </h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb bg-transparent mb-0">
                            <li class="breadcrumb-item"><a href="home"> <?php echo lang('home'); ?></a></li>
                            <li class="breadcrumb-item active"> <?php echo lang('patient'); ?></li>
                        </ol>
                    </nav>
                </div>
                <div class="col-sm-6 text-right">
                    <a data-toggle="modal" href="#myModal" class="btn btn-primary btn-sm px-4 py-3">
                        <i class="fa fa-plus"></i> <?php echo lang('add_new'); ?> <?php echo lang('patient'); ?>
                    </a>
                </div>
            </div>
        </div>
    </section>

    <section class="content py-5">
        <div class="container-fluid">
            <div class="row justify-content-center">
                <div class="col-md-12">
                    <div class="card shadow-lg border-0">

                        <div class="card-body bg-light p-4">
                            <table class="table table-hover datatables" id="editable-sample" width="100%">
                                <thead>
                                    <tr class="bg-light">
                                        <th class="font-weight-bold text-uppercase"><?php echo lang('id'); ?></th>
                                        <th class="font-weight-bold"><?php echo lang('name'); ?></th>
                                        <th class="font-weight-bold"><?php echo lang('phone'); ?></th>
                                        <th class="font-weight-bold"><?php echo lang('hospital'); ?></th>
                                        <th class="font-weight-bold">Patient Type / Dependents</th>
                                        <?php if ($this->ion_auth->in_group(array('admin', 'Accountant', 'Receptionist'))) { ?>
                                            <th class="font-weight-bold"><?php echo lang('due_balance'); ?></th>
                                        <?php } ?>
                                        <th class="font-weight-bold no-print"><?php echo lang('options'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>





<!-- Add Patient Modal-->
<div class="modal fade" id="myModal" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content bg-light">
            <div class="modal-header bg-gradient-primary">
                <h2 class="modal-title text-white font-weight-800"><?php echo lang('register_new_patient'); ?></h2>
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body p-4">
                <form action="patient/addNew" method="post" enctype="multipart/form-data" id="patientModalForm">
                    <input type="hidden" name="id" id="modal_patient_id" value="">
                    <!-- Personal Information -->
                    <div class="row mb-5">
                        <div class="col-12 mb-4">
                            <h3 class="border-bottom border-primary pb-3 text-uppercase font-weight-900">
                                <i
                                    class="fas fa-user-circle mr-3 text-primary"></i><?php echo lang('personal_details'); ?>
                            </h3>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label
                                    class="text-uppercase font-weight-bold text-muted"><?php echo lang('full_name'); ?>
                                    <span class="text-danger">*</span></label>
                                <input type="text" class="form-control form-control-lg shadow-sm" name="name" required>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label
                                    class="text-uppercase font-weight-bold text-muted"><?php echo lang('mobile_number'); ?>
                                    <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <input type="tel" class="form-control form-control-lg shadow-sm" name="phone" id="modal_patient_phone"
                                        placeholder="+94 77 123 4567" required>
                                    <div class="input-group-append">
                                        <button type="button" class="btn btn-info btn-lg" id="modalCheckPhoneBtn">
                                            <i class="fas fa-search"></i> Check
                                        </button>
                                    </div>
                                </div>
                                <small class="text-muted">Enter mobile number and click "Check" to verify if patient exists.</small>
                                <div id="modalPhoneCheckResult" class="mt-2" style="display: none;"></div>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label
                                    class="text-uppercase font-weight-bold text-muted"><?php echo lang('email_address'); ?></label>
                                <input type="email" class="form-control form-control-lg shadow-sm" name="email">
                                <small class="text-muted">Optional - can be same for multiple patients</small>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <div class="alert alert-info">
                                    <i class="fas fa-info-circle"></i>
                                    <strong>Login Password:</strong> A 6-digit password will be automatically generated and sent to the patient's mobile number.
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label
                                    class="text-uppercase font-weight-bold text-muted"><?php echo lang('preferred_language'); ?>
                                    <span class="text-danger">*</span></label>
                                <select class="form-control form-control-lg shadow-sm" name="sms_language" required>
                                    <option value="english"><?php echo lang('english_lang'); ?></option>
                                    <option value="sinhala"><?php echo lang('sinhala'); ?></option>
                                    <option value="tamil"><?php echo lang('tamil'); ?></option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label
                                    class="text-uppercase font-weight-bold text-muted"><?php echo lang('date_of_birth'); ?></label>
                                <input type="text" class="form-control form-control-lg shadow-sm default-date-picker"
                                    name="birthdate">
                            </div>
                        </div>
                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label
                                    class="text-uppercase font-weight-bold text-muted"><?php echo lang('national_id'); ?></label>
                                <input type="text" class="form-control form-control-lg shadow-sm" name="national_id"
                                    placeholder="123456789V">
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label
                                    class="text-uppercase font-weight-bold text-muted"><?php echo lang('passport_no'); ?></label>
                                <input type="text" class="form-control form-control-lg shadow-sm" name="passport_no"
                                    placeholder="N1234567">
                            </div>
                        </div>
                    </div>

                    <!-- Guardian & Dependent Information -->
                    <div class="row mb-5">
                        <div class="col-12 mb-4">
                            <h3 class="border-bottom border-info pb-3 text-uppercase font-weight-900">
                                <i class="fas fa-users mr-3 text-info"></i>Guardian & Dependent Information
                            </h3>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted">Patient Type</label>
                                <div class="custom-control custom-radio">
                                    <input type="radio" class="custom-control-input" id="modal_independent_patient" name="patient_type" value="independent" checked>
                                    <label class="custom-control-label" for="modal_independent_patient">
                                        <strong>Independent Patient</strong>
                                        <br><small class="text-muted">Patient manages their own account</small>
                                    </label>
                                </div>
                                <div class="custom-control custom-radio mt-3">
                                    <input type="radio" class="custom-control-input" id="modal_dependent_patient" name="patient_type" value="dependent">
                                    <label class="custom-control-label" for="modal_dependent_patient">
                                        <strong>Dependent Patient</strong>
                                        <br><small class="text-muted">Managed by a guardian (children, elderly, etc.)</small>
                                    </label>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4" id="modal_guardian_section" style="display: none;">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted">Select Guardian <span class="text-danger">*</span></label>
                                <select class="form-control form-control-lg shadow-sm js-example-basic-single" name="guardian_patient_id" id="modal_guardian_select">
                                    <option value="">-- Select Guardian --</option>
                                    <?php if (isset($eligible_guardians)) { ?>
                                        <?php foreach ($eligible_guardians as $guardian) { ?>
                                            <option value="<?php echo $guardian->id; ?>">
                                                <?php echo $guardian->name; ?> - <?php echo $guardian->phone; ?> (Age: <?php echo $guardian->age; ?>)
                                            </option>
                                        <?php } ?>
                                    <?php } ?>
                                </select>
                                <small class="text-muted">Only adult patients (18+) can be guardians</small>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4" id="modal_relationship_section" style="display: none;">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted">Relationship to Guardian <span class="text-danger">*</span></label>
                                <select class="form-control form-control-lg shadow-sm" name="relationship_to_guardian" id="modal_relationship_select">
                                    <option value="">-- Select Relationship --</option>
                                    <option value="son">Son</option>
                                    <option value="daughter">Daughter</option>
                                    <option value="spouse">Spouse</option>
                                    <option value="parent">Parent</option>
                                    <option value="sibling">Sibling</option>
                                    <option value="grandchild">Grandchild</option>
                                    <option value="other">Other</option>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4" id="modal_emergency_contact_section" style="display: none;">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted">Emergency Contact</label>
                                <input type="text" class="form-control form-control-lg shadow-sm" name="emergency_contact" placeholder="Will use guardian's phone if empty">
                                <small class="text-muted">Optional: Leave empty to use guardian's phone number</small>
                            </div>
                        </div>

                        <div class="col-md-12 mb-4" id="modal_dependent_note_section" style="display: none;">
                            <div class="alert alert-info">
                                <i class="fas fa-info-circle mr-2"></i>
                                <strong>Note:</strong> Dependent patients can login using their guardian's phone number. 
                                The guardian will be able to view and manage appointments for this patient.
                            </div>
                        </div>
                    </div>

                    <div class="row mb-5">
                        <div class="col-12 mb-4">
                            <h3 class="border-bottom border-danger pb-3 text-uppercase font-weight-900">
                                <i class="fas fa-heartbeat mr-3 text-danger"></i><?php echo lang('medical_profile'); ?>
                            </h3>
                        </div>
                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label
                                    class="text-uppercase font-weight-bold text-muted"><?php echo lang('sex'); ?></label>
                                <select class="form-control form-control-lg shadow-sm" name="sex">
                                    <option value="Male"><?php echo lang('male'); ?></option>
                                    <option value="Female"><?php echo lang('female'); ?></option>
                                </select>
                            </div>
                        </div>



                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label
                                    class="text-uppercase font-weight-bold text-muted"><?php echo lang('blood_group'); ?></label>
                                <select class="form-control form-control-lg shadow-sm" name="bloodgroup">
                                    <option value=""><?php echo lang('select_blood_group'); ?></option>
                                    <?php foreach ($groups as $group) { ?>
                                        <option value="<?php echo $group->group; ?>"><?php echo $group->group; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('height'); ?>
                                    (cm)</label>
                                <input type="number" class="form-control form-control-lg shadow-sm" name="height"
                                    placeholder="175">
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('weight'); ?>
                                    (kg)</label>
                                <input type="number" class="form-control form-control-lg shadow-sm" name="weight"
                                    placeholder="70">
                            </div>
                        </div>



                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label
                                    class="text-uppercase font-weight-bold text-muted"><?php echo lang('known_allergies'); ?></label>
                                <textarea class="form-control shadow-sm" name="known_allergies" rows="3"
                                    placeholder="<?php echo lang('list_any_known_allergies_or_sensitivities'); ?>"></textarea>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label
                                    class="text-uppercase font-weight-bold text-muted"><?php echo lang('medical_history'); ?></label>
                                <textarea class="form-control shadow-sm" name="medical_history" rows="3"
                                    placeholder="<?php echo lang('brief_medical_history_or_ongoing_conditions'); ?>"></textarea>
                            </div>
                        </div>
                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label
                                    class="text-uppercase font-weight-bold text-muted"><?php echo lang('doctor'); ?></label>
                                <select class="form-control form-control-lg shadow-sm" id="doctorchoose1" name="doctor">
                                </select>
                            </div>
                        </div>
                    </div>

                    <!-- Contact Information -->
                    <div class="row mb-5">
                        <div class="col-12 mb-4">
                            <h3 class="border-bottom border-success pb-3 text-uppercase font-weight-900">
                                <i
                                    class="fas fa-map-marked-alt mr-3 text-success"></i><?php echo lang('contact_information'); ?>
                            </h3>
                        </div>

                        <div class="col-md-12 mb-4">
                            <div class="form-group">
                                <label
                                    class="text-uppercase font-weight-bold text-muted"><?php echo lang('residential_address'); ?>
                                    <span class="text-danger">*</span></label>
                                <textarea class="form-control shadow-sm" rows="3" name="address" required></textarea>
                            </div>
                        </div>
                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label
                                    class="text-uppercase font-weight-bold text-muted"><?php echo lang('emergency_contact_name'); ?></label>
                                <input type="text" class="form-control form-control-lg shadow-sm"
                                    name="emergency_contact_name"
                                    placeholder="<?php echo lang('emergency_contact_person'); ?>">
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label
                                    class="text-uppercase font-weight-bold text-muted"><?php echo lang('emergency_contact_number'); ?></label>
                                <input type="tel" class="form-control form-control-lg shadow-sm"
                                    name="emergency_contact_number"
                                    placeholder="<?php echo lang('emergency_contact_number'); ?>">
                            </div>
                        </div>
                    </div>

                    <!-- Profile Image -->
                    <div class="row mb-5">
                        <div class="col-12 mb-4">
                            <h3 class="border-bottom border-info pb-3 text-uppercase font-weight-900">
                                <i class="fas fa-camera mr-3 text-info"></i> <?php echo lang('profile_photo'); ?>
                            </h3>
                        </div>
                        <div class="col-md-12">
                            <div class="fileupload fileupload-new" data-provides="fileupload">
                                <div
                                    class="fileupload-new thumbnail img_class fileupload-preview fileupload-exists thumbnail img_thumb bg-white p-2">
                                    <img src="" height="100px" alt="" />
                                </div>
                                <div class="mt-2">
                                    <span class="btn btn-white btn-file">
                                        <span class="btn fileupload-new badge badge-secondary"><i
                                                class="fa fa-paper-clip"></i> <?php echo lang('select_image'); ?></span>
                                        <input type="file" class="default" name="img_url" />
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mb-4">
                        <div class="col-md-12">
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" class="custom-control-input" id="sms" name="sms">
                                <label class="custom-control-label font-weight-bold"
                                    for="sms"><?php echo lang('send_sms'); ?></label>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <button type="submit" class="btn btn-primary btn-lg btn-block shadow-lg py-3">
                                <i class="fas fa-user-plus mr-3"></i><?php echo lang('submit'); ?>
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Dependent Patient JavaScript for Edit Modal -->
<script>
$(document).ready(function() {
    // Handle patient type radio button changes in edit modal
    $('input[name="patient_type"]').change(function() {
        const isDependent = $(this).val() === 'dependent';
        
        if (isDependent) {
            $('#edit_modal_guardian_section').slideDown();
            $('#edit_modal_relationship_section').slideDown();
            $('#edit_modal_emergency_contact_section').slideDown();
            $('#edit_modal_dependent_note_section').slideDown();
            
            // Make guardian and relationship required
            $('#edit_modal_guardian_select').attr('required', true);
            $('#edit_modal_relationship_select').attr('required', true);
        } else {
            $('#edit_modal_guardian_section').slideUp();
            $('#edit_modal_relationship_section').slideUp();
            $('#edit_modal_emergency_contact_section').slideUp();
            $('#edit_modal_dependent_note_section').slideUp();
            
            // Remove required attributes
            $('#edit_modal_guardian_select').attr('required', false);
            $('#edit_modal_relationship_select').attr('required', false);
        }
    });

    // Handle form submission validation in edit modal
    $('#editPatientForm').submit(function(e) {
        const isDependent = $('input[name="patient_type"]:checked').val() === 'dependent';
        
        if (isDependent) {
            const guardianId = $('#edit_modal_guardian_select').val();
            const relationship = $('#edit_modal_relationship_select').val();
            
            if (!guardianId) {
                alert('Please select a guardian for the dependent patient.');
                e.preventDefault();
                return false;
            }
            
            if (!relationship) {
                alert('Please specify the relationship to the guardian.');
                e.preventDefault();
                return false;
            }
        }
    });

    // Auto-fill emergency contact when guardian is selected in edit modal
    $('#edit_modal_guardian_select').change(function() {
        const selectedOption = $(this).find('option:selected');
        const guardianPhone = selectedOption.text().match(/- (\d+)/);
        
        if (guardianPhone && !$('input[name="emergency_contact"]').val()) {
            $('input[name="emergency_contact"]').val(guardianPhone[1]);
        }
    });

    // When edit modal opens, populate existing data
    $('#myModal2').on('show.bs.modal', function (e) {
        // This will be called when edit modal opens
        // You can add logic here to populate existing guardian/dependent data
        setTimeout(function() {
            // Check if patient is dependent and show/hide sections accordingly
            const patientType = $('input[name="patient_type"]:checked').val();
            if (patientType === 'dependent') {
                $('#edit_modal_guardian_section').show();
                $('#edit_modal_relationship_section').show();
                $('#edit_modal_emergency_contact_section').show();
                $('#edit_modal_dependent_note_section').show();
            }
        }, 100);
    });
});
</script>

<!-- Dependent Patient JavaScript for Modal -->
<script>
$(document).ready(function() {
    // Handle patient type radio button changes in modal
    $('input[name="patient_type"]').change(function() {
        const isDependent = $(this).val() === 'dependent';
        
        if (isDependent) {
            $('#modal_guardian_section').slideDown();
            $('#modal_relationship_section').slideDown();
            $('#modal_emergency_contact_section').slideDown();
            $('#modal_dependent_note_section').slideDown();
            
            // Make guardian and relationship required
            $('#modal_guardian_select').attr('required', true);
            $('#modal_relationship_select').attr('required', true);
            
            // Optional: Clear phone requirement for dependents
            $('input[name="phone"]').attr('required', false);
            $('input[name="phone"]').closest('.form-group').find('label').html(
                $('input[name="phone"]').closest('.form-group').find('label').html().replace(' <span class="text-danger">*</span>', '')
            );
        } else {
            $('#modal_guardian_section').slideUp();
            $('#modal_relationship_section').slideUp();
            $('#modal_emergency_contact_section').slideUp();
            $('#modal_dependent_note_section').slideUp();
            
            // Remove required attributes
            $('#modal_guardian_select').attr('required', false);
            $('#modal_relationship_select').attr('required', false);
            
            // Make phone required for independent patients
            $('input[name="phone"]').attr('required', true);
            if ($('input[name="phone"]').closest('.form-group').find('label').html().indexOf('*') === -1) {
                $('input[name="phone"]').closest('.form-group').find('label').append(' <span class="text-danger">*</span>');
            }
        }
    });

    // Handle form submission validation in modal
    $('#myModal form').submit(function(e) {
        const isDependent = $('input[name="patient_type"]:checked').val() === 'dependent';
        
        if (isDependent) {
            const guardianId = $('#modal_guardian_select').val();
            const relationship = $('#modal_relationship_select').val();
            
            if (!guardianId) {
                alert('Please select a guardian for the dependent patient.');
                e.preventDefault();
                return false;
            }
            
            if (!relationship) {
                alert('Please specify the relationship to the guardian.');
                e.preventDefault();
                return false;
            }
        }
    });

    // Auto-fill emergency contact when guardian is selected in modal
    $('#modal_guardian_select').change(function() {
        const selectedOption = $(this).find('option:selected');
        const guardianPhone = selectedOption.text().match(/- (\d+)/);
         
        if (guardianPhone && !$('input[name="emergency_contact"]').val()) {
            $('input[name="emergency_contact"]').val(guardianPhone[1]); 
        }
    });

    // Phone number check functionality for modal
    $('#modalCheckPhoneBtn').click(function() {
        var phone = $('#modal_patient_phone').val().trim();
        var $btn = $(this);
        var $result = $('#modalPhoneCheckResult');
        
        if (!phone) {
            $result.html('<div class="alert alert-warning"><i class="fas fa-exclamation-triangle"></i> Please enter a mobile number first.</div>').show();
            return;
        }
        
        // Show loading state
        $btn.prop('disabled', true).html('<i class="fas fa-spinner fa-spin"></i> Checking...');
        $result.html('<div class="alert alert-info"><i class="fas fa-spinner fa-spin"></i> Checking phone number...</div>').show();
        
        $.ajax({
            url: '<?php echo base_url(); ?>patient/checkExistingPatientByPhone',
            type: 'POST',
            data: { phone: phone },
            dataType: 'json',
            success: function(response) {
                $btn.prop('disabled', false).html('<i class="fas fa-search"></i> Check');
                
                if (response.exists) {
                    if (response.is_patient) {
                        // Patient exists - populate modal form and switch to update mode
                        var patient = response.patient;
                        $result.html('<div class="alert alert-success"><i class="fas fa-user-check"></i> <strong>Patient Found!</strong> Form populated with existing data. You can now update the patient information.</div>');
                        
                        // Populate modal form fields (basic fields only for modal)
                        $('#modal_patient_id').val(patient.id);
                        $('#patientModalForm input[name="name"]').val(patient.name || '');
                        $('#patientModalForm input[name="email"]').val(patient.email || '');
                        $('#patientModalForm input[name="phone"]').val(patient.phone || '');
                        $('#patientModalForm textarea[name="address"]').val(patient.address || '');
                        $('#patientModalForm input[name="birthdate"]').val(patient.birthdate || '');
                        $('#patientModalForm select[name="sex"]').val(patient.sex || '');
                        $('#patientModalForm input[name="p_id"]').val(patient.patient_id || '');
                        $('#patientModalForm select[name="sms_language"]').val(patient.sms_language || 'english');
                        
                        $('#patientModalForm input[name="national_id"]').val(patient.national_id || '');
                        $('#patientModalForm input[name="passport_no"]').val(patient.passport_no || '');
                        $('#patientModalForm select[name="bloodgroup"]').val(patient.bloodgroup || '');
                        $('#patientModalForm input[name="height"]').val(patient.height || '');
                        $('#patientModalForm input[name="weight"]').val(patient.weight || '');
                        $('#patientModalForm textarea[name="known_allergies"]').val(patient.known_allergies || '');
                        $('#patientModalForm textarea[name="medical_history"]').val(patient.medical_history || '');
                        $('#patientModalForm input[name="emergency_contact_name"]').val(patient.emergency_contact_name || '');
                        $('#patientModalForm input[name="emergency_contact_number"]').val(patient.emergency_contact_number || '');
                        // Update modal title and submit button
                        $('#myModal .modal-title').html('<i class="fas fa-user-edit"></i> Update Patient Information');
                        $('#patientModalForm button[type="submit"]').html('<i class="fas fa-save"></i> Update Patient');
                        
                        // Store original data for comparison
                        $('#patientModalForm').data('originalData', patient);
                        
                    } else {
                        // Phone belongs to other user type
                        $result.html('<div class="alert alert-danger"><i class="fas fa-exclamation-circle"></i> <strong>Phone Number Occupied!</strong> This mobile number is already registered by another type of user (Doctor, Admin, etc.). Please use a different number.</div>');
                        clearModalForm();
                    }
                } else {
                    // New patient - can proceed with registration
                    $result.html('<div class="alert alert-success"><i class="fas fa-plus-circle"></i> <strong>New Patient!</strong> This mobile number is available. You can proceed with registration.</div>');
                    clearModalForm();
                    $('#myModal .modal-title').html('<i class="fas fa-user-plus"></i> <?php echo lang('register_new_patient'); ?>');
                    $('#patientModalForm button[type="submit"]').html('<i class="fas fa-save"></i> Register Patient');
                }
            },
            error: function() {
                $btn.prop('disabled', false).html('<i class="fas fa-search"></i> Check');
                $result.html('<div class="alert alert-danger"><i class="fas fa-exclamation-triangle"></i> Error checking phone number. Please try again.</div>');
            }
        });
    });
    
    // Function to clear modal form except phone number
    function clearModalForm() {
        $('#modal_patient_id').val('');
        $('#patientModalForm input[name="name"]').val('');
        $('#patientModalForm input[name="email"]').val('');
        $('#patientModalForm textarea[name="address"]').val('');
        $('#patientModalForm input[name="birthdate"]').val('');
        $('#patientModalForm select[name="sex"]').val('');
        $('#patientModalForm input[name="p_id"]').val('');
        $('#patientModalForm select[name="sms_language"]').val('english');
        $('#patientModalForm').removeData('originalData');
    }
    
    // Handle modal form submission to check for changes and send SMS
    $('#patientModalForm').submit(function(e) {
        var originalData = $(this).data('originalData');
        var patientId = $('#modal_patient_id').val();
        
        // If updating existing patient, check for changes
        if (patientId && originalData) {
            var currentData = {
                name: $('#patientModalForm input[name="name"]').val(),
                email: $('#patientModalForm input[name="email"]').val(),
                phone: $('#patientModalForm input[name="phone"]').val(),
                address: $('#patientModalForm textarea[name="address"]').val(),
                birthdate: $('#patientModalForm input[name="birthdate"]').val(),
                sex: $('#patientModalForm select[name="sex"]').val(),
                sms_language: $('#patientModalForm select[name="sms_language"]').val()
            };
            
            // Check if any data has changed
            var hasChanges = false;
            for (var key in currentData) {
                if (currentData[key] != (originalData[key] || '')) {
                    hasChanges = true;
                    break;
                }
            }
            
            // Add a hidden field to indicate if SMS should be sent
            if (hasChanges) {
                $('<input>').attr({
                    type: 'hidden',
                    name: 'send_update_sms',
                    value: '1'
                }).appendTo(this);
            }
        }
        
        return true; // Allow form submission
    });
});
</script>

<!-- Edit Patient Modal-->
<div class="modal fade" id="myModal2" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content bg-light">
            <div class="modal-header bg-gradient-primary">
                <h2 class="modal-title text-white font-weight-800"><?php echo lang('edit_patient'); ?></h2>
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body p-4">
                <form role="form" id="editPatientForm" action="patient/addNew" method="post"
                    enctype="multipart/form-data">
                    <!-- Personal Information -->
                    <div class="row mb-5">
                        <div class="col-12 mb-4">
                            <h3 class="border-bottom border-primary pb-3 text-uppercase font-weight-900">
                                <i
                                    class="fas fa-user-circle mr-3 text-primary"></i><?php echo lang('personal_details'); ?>
                            </h3>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label
                                    class="text-uppercase font-weight-bold text-muted"><?php echo lang('full_name'); ?>
                                    <span class="text-danger">*</span></label>
                                <input type="text" class="form-control form-control-lg shadow-sm" name="name" required>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label
                                    class="text-uppercase font-weight-bold text-muted"><?php echo lang('mobile_number'); ?>
                                    <span class="text-danger">*</span></label>
                                <input type="tel" class="form-control form-control-lg shadow-sm" name="phone"
                                    placeholder="+94 77 123 4567" required>
                                <small class="text-muted">Used for login. Must be unique.</small>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label
                                    class="text-uppercase font-weight-bold text-muted"><?php echo lang('email_address'); ?></label>
                                <input type="email" class="form-control form-control-lg shadow-sm" name="email">
                                <small class="text-muted">Optional - can be same for multiple patients</small>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <div class="alert alert-warning">
                                    <i class="fas fa-key"></i>
                                    <strong>Password Reset:</strong> To reset password, use the "Reset Password" feature which will send a new 6-digit code to patient's mobile.
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label
                                    class="text-uppercase font-weight-bold text-muted"><?php echo lang('preferred_language'); ?>
                                    <span class="text-danger">*</span></label>
                                <select class="form-control form-control-lg shadow-sm" name="sms_language" required>
                                    <option value="english"><?php echo lang('english_lang'); ?></option>
                                    <option value="sinhala"><?php echo lang('sinhala'); ?></option>
                                    <option value="tamil"><?php echo lang('tamil'); ?></option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label
                                    class="text-uppercase font-weight-bold text-muted"><?php echo lang('date_of_birth'); ?></label>
                                <input type="text" class="form-control form-control-lg shadow-sm default-date-picker"
                                    name="birthdate">
                            </div>
                        </div>
                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label
                                    class="text-uppercase font-weight-bold text-muted"><?php echo lang('national_id'); ?></label>
                                <input type="text" class="form-control form-control-lg shadow-sm" name="national_id"
                                    placeholder="123456789V">
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label
                                    class="text-uppercase font-weight-bold text-muted"><?php echo lang('passport_no'); ?></label>
                                <input type="text" class="form-control form-control-lg shadow-sm" name="passport_no"
                                    placeholder="N1234567">
                            </div>
                        </div>
                    </div>

                    <!-- Guardian & Dependent Information - Edit Modal -->
                    <div class="row mb-5">
                        <div class="col-12 mb-4">
                            <h3 class="border-bottom border-info pb-3 text-uppercase font-weight-900">
                                <i class="fas fa-users mr-3 text-info"></i>Guardian & Dependent Information
                            </h3>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted">Patient Type</label>
                                <div class="custom-control custom-radio">
                                    <input type="radio" class="custom-control-input" id="edit_modal_independent_patient" name="patient_type" value="independent" checked>
                                    <label class="custom-control-label" for="edit_modal_independent_patient">
                                        <strong>Independent Patient</strong>
                                        <br><small class="text-muted">Patient manages their own account</small>
                                    </label>
                                </div>
                                <div class="custom-control custom-radio mt-3">
                                    <input type="radio" class="custom-control-input" id="edit_modal_dependent_patient" name="patient_type" value="dependent">
                                    <label class="custom-control-label" for="edit_modal_dependent_patient">
                                        <strong>Dependent Patient</strong>
                                        <br><small class="text-muted">Managed by a guardian (children, elderly, etc.)</small>
                                    </label>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4" id="edit_modal_guardian_section" style="display: none;">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted">Select Guardian <span class="text-danger">*</span></label>
                                <select class="form-control form-control-lg shadow-sm js-example-basic-single" name="guardian_patient_id" id="edit_modal_guardian_select">
                                    <option value="">-- Select Guardian --</option>
                                    <?php if (isset($eligible_guardians)) { ?>
                                        <?php foreach ($eligible_guardians as $guardian) { ?>
                                            <option value="<?php echo $guardian->id; ?>">
                                                <?php echo $guardian->name; ?> - <?php echo $guardian->phone; ?> (Age: <?php echo $guardian->age; ?>)
                                            </option>
                                        <?php } ?>
                                    <?php } ?>
                                </select>
                                <small class="text-muted">Only adult patients (18+) can be guardians</small>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4" id="edit_modal_relationship_section" style="display: none;">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted">Relationship to Guardian <span class="text-danger">*</span></label>
                                <select class="form-control form-control-lg shadow-sm" name="relationship_to_guardian" id="edit_modal_relationship_select">
                                    <option value="">-- Select Relationship --</option>
                                    <option value="son">Son</option>
                                    <option value="daughter">Daughter</option>
                                    <option value="spouse">Spouse</option>
                                    <option value="parent">Parent</option>
                                    <option value="sibling">Sibling</option>
                                    <option value="grandchild">Grandchild</option>
                                    <option value="other">Other</option>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4" id="edit_modal_emergency_contact_section" style="display: none;">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted">Emergency Contact</label>
                                <input type="text" class="form-control form-control-lg shadow-sm" name="emergency_contact" placeholder="Will use guardian's phone if empty">
                                <small class="text-muted">Optional: Leave empty to use guardian's phone number</small>
                            </div>
                        </div>

                        <div class="col-md-12 mb-4" id="edit_modal_dependent_note_section" style="display: none;">
                            <div class="alert alert-info">
                                <i class="fas fa-info-circle mr-2"></i>
                                <strong>Note:</strong> Dependent patients can login using their guardian's phone number. 
                                The guardian will be able to view and manage appointments for this patient.
                            </div>
                        </div>
                    </div>

                    <div class="row mb-5">
                        <div class="col-12 mb-4">
                            <h3 class="border-bottom border-danger pb-3 text-uppercase font-weight-900">
                                <i class="fas fa-heartbeat mr-3 text-danger"></i><?php echo lang('medical_profile'); ?>
                            </h3>
                        </div>
                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label
                                    class="text-uppercase font-weight-bold text-muted"><?php echo lang('sex'); ?></label>
                                <select class="form-control form-control-lg shadow-sm" name="sex">
                                    <option value="Male"><?php echo lang('male'); ?></option>
                                    <option value="Female"><?php echo lang('female'); ?></option>
                                </select>
                            </div>
                        </div>



                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label
                                    class="text-uppercase font-weight-bold text-muted"><?php echo lang('blood_group'); ?></label>
                                <select class="form-control form-control-lg shadow-sm" name="bloodgroup">
                                    <option value=""><?php echo lang('select_blood_group'); ?></option>
                                    <?php foreach ($groups as $group) { ?>
                                        <option value="<?php echo $group->group; ?>"><?php echo $group->group; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('height'); ?>
                                    (cm)</label>
                                <input type="number" class="form-control form-control-lg shadow-sm" name="height"
                                    placeholder="175">
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('weight'); ?>
                                    (kg)</label>
                                <input type="number" class="form-control form-control-lg shadow-sm" name="weight"
                                    placeholder="70">
                            </div>
                        </div>



                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label
                                    class="text-uppercase font-weight-bold text-muted"><?php echo lang('known_allergies'); ?></label>
                                <textarea class="form-control shadow-sm" name="known_allergies" rows="3"
                                    placeholder="<?php echo lang('list_any_known_allergies_or_sensitivities'); ?>"></textarea>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label
                                    class="text-uppercase font-weight-bold text-muted"><?php echo lang('medical_history'); ?></label>
                                <textarea class="form-control shadow-sm" name="medical_history" rows="3"
                                    placeholder="<?php echo lang('brief_medical_history_or_ongoing_conditions'); ?>"></textarea>
                            </div>
                        </div>
                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label
                                    class="text-uppercase font-weight-bold text-muted"><?php echo lang('doctor'); ?></label>
                                <select class="form-control form-control-lg shadow-sm" id="doctorchoose1" name="doctor">
                                </select>
                            </div>
                        </div>
                    </div>

                    <!-- Contact Information -->
                    <div class="row mb-5">
                        <div class="col-12 mb-4">
                            <h3 class="border-bottom border-success pb-3 text-uppercase font-weight-900">
                                <i
                                    class="fas fa-map-marked-alt mr-3 text-success"></i><?php echo lang('contact_information'); ?>
                            </h3>
                        </div>

                        <div class="col-md-12 mb-4">
                            <div class="form-group">
                                <label
                                    class="text-uppercase font-weight-bold text-muted"><?php echo lang('residential_address'); ?>
                                    <span class="text-danger">*</span></label>
                                <textarea class="form-control shadow-sm" rows="3" name="address" required></textarea>
                            </div>
                        </div>
                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label
                                    class="text-uppercase font-weight-bold text-muted"><?php echo lang('emergency_contact_name'); ?></label>
                                <input type="text" class="form-control form-control-lg shadow-sm"
                                    name="emergency_contact_name"
                                    placeholder="<?php echo lang('emergency_contact_person'); ?>">
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label
                                    class="text-uppercase font-weight-bold text-muted"><?php echo lang('emergency_contact_number'); ?></label>
                                <input type="tel" class="form-control form-control-lg shadow-sm"
                                    name="emergency_contact_number"
                                    placeholder="<?php echo lang('emergency_contact_number'); ?>">
                            </div>
                        </div>
                    </div>

                    <!-- Profile Image -->
                    <div class="row mb-5">
                        <div class="col-12 mb-4">
                            <h3 class="border-bottom border-info pb-3 text-uppercase font-weight-900">
                                <i class="fas fa-camera mr-3 text-info"></i> <?php echo lang('profile_photo'); ?>
                            </h3>
                        </div>
                        <div class="col-md-12">
                            <div class="fileupload fileupload-new" data-provides="fileupload">
                                <div
                                    class="fileupload-new thumbnail img_class fileupload-preview fileupload-exists thumbnail img_thumb bg-white p-2">
                                    <img src="" height="100px" id="img" alt="" />
                                </div>
                                <div class="mt-2">
                                    <span class="btn btn-white btn-file">
                                        <span class="btn fileupload-new badge badge-secondary"><i
                                                class="fa fa-paper-clip"></i> <?php echo lang('select_image'); ?></span>
                                        <input type="file" class="default" name="img_url" />
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mb-4">
                        <div class="col-md-12">
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" class="custom-control-input" name="sms" value="sms">
                                <label
                                    class="custom-control-label font-weight-bold"><?php echo lang('send_sms'); ?></label>
                            </div>
                        </div>
                    </div>

                    <input type="hidden" name="id" value=''>
                    <input type="hidden" name="p_id" value='<?php
                                                            if (!empty($patient->patient_id)) {
                                                                echo $patient->patient_id;
                                                            }
                                                            ?>'>

                    <div class="row">
                        <div class="col-md-12">
                            <button type="submit" name="submit" class="btn btn-primary btn-lg btn-block shadow-lg py-3">
                                <i class="fas fa-user-edit mr-3"></i><?php echo lang('submit'); ?>
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>












<div class="modal fade" id="infoModal" role="dialog" aria-labelledby="modalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h4 class="modal-title font-weight-bold" id="modalLabel"><?php echo lang('patient'); ?>
                    <?php echo lang('info'); ?></h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body row">
                <form role="form" action="patient/addNew" class="form-horizontal" method="post"
                    enctype="multipart/form-data">
                    <div class="container-fluid">
                        <div class="justify-content-center" style="display:flex">
                            <div class="col-md-6">
                                <!-- Basic Information Section -->
                                <div class="card mb-4 shadow-sm">
                                    <div class="card-header bg-primary text-white">
                                        <h5 class="mb-0"><i class="fas fa-user-circle mr-2"></i><?php echo lang('basic_information'); ?></h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="text-center mb-4">
                                            <img src="" id="img1" class="img-thumbnail rounded-circle" style="width: 150px; height: 150px; object-fit: cover;">
                                        </div>

                                        <div class="form-group">
                                            <label class="font-weight-bold text-muted d-block"><?php echo lang('patient_id'); ?></label>
                                            <div class="patientIdClass"></div>
                                        </div>

                                        <div class="form-group">
                                            <label class="font-weight-bold text-muted d-block"><?php echo lang('full_name'); ?></label>
                                            <div class="nameClass"></div>
                                        </div>

                                        <div class="form-group">
                                            <label class="font-weight-bold text-muted d-block"><?php echo lang('email_address'); ?></label>
                                            <div class="emailClass"></div>
                                        </div>

                                        <div class="form-group">
                                            <label class="font-weight-bold text-muted d-block"><?php echo lang('contact_number'); ?></label>
                                            <div class="phoneClass"></div>
                                        </div>

                                        <div class="form-group">
                                            <label class="font-weight-bold text-muted d-block"><?php echo lang('national_id'); ?></label>
                                            <div class="national_id"></div>
                                        </div>

                                        <div class="form-group">
                                            <label class="font-weight-bold text-muted d-block"><?php echo lang('residential_address'); ?></label>
                                            <div class="addressClass"></div>
                                        </div>

                                        <div class="form-group">
                                            <label class="font-weight-bold text-muted d-block"><?php echo lang('age'); ?></label>
                                            <div class="ageClass"></div>
                                        </div>

                                        <div class="form-group">
                                            <label class="font-weight-bold text-muted d-block"><?php echo lang('gender'); ?></label>
                                            <div class="genderClass"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <!-- Medical Information Section -->
                                <div class="card mb-4 shadow-sm">
                                    <div class="card-header bg-info text-white">
                                        <h5 class="mb-0"><i class="fas fa-heartbeat mr-2"></i><?php echo lang('medical_information'); ?></h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="form-group">
                                            <label class="font-weight-bold text-muted d-block"><?php echo lang('blood_group'); ?></label>
                                            <div class="bloodgroupClass"></div>
                                        </div>

                                        <div class="form-group">
                                            <label class="font-weight-bold text-muted d-block"><?php echo lang('birth_date'); ?></label>
                                            <div class="birthdateClass"></div>
                                        </div>

                                        <div class="form-group">
                                            <label class="font-weight-bold text-muted d-block"><?php echo lang('doctor'); ?></label>
                                            <div class="doctorClass"></div>
                                        </div>

                                        <div class="form-group">
                                            <label class="font-weight-bold text-muted d-block"><?php echo lang('height'); ?></label>
                                            <div class="height"></div>
                                        </div>

                                        <div class="form-group">
                                            <label class="font-weight-bold text-muted d-block"><?php echo lang('weight'); ?></label>
                                            <div class="weight"></div>
                                        </div>

                                        <div class="form-group">
                                            <label class="font-weight-bold text-muted d-block"><?php echo lang('known_allergies'); ?></label>
                                            <div class="known_allergies"></div>
                                        </div>

                                        <div class="form-group">
                                            <label class="font-weight-bold text-muted d-block"><?php echo lang('medical_history'); ?></label>
                                            <div class="medical_history"></div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Emergency Contact Section -->
                                <div class="card shadow-sm">
                                    <div class="card-header bg-danger text-white">
                                        <h5 class="mb-0"><i class="fas fa-ambulance mr-2"></i><?php echo lang('emergency_contact'); ?></h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="form-group">
                                            <label class="font-weight-bold text-muted d-block"><?php echo lang('emergency_contact_name'); ?></label>
                                            <div class="emergency_contact_name"></div>
                                        </div>

                                        <div class="form-group">
                                            <label class="font-weight-bold text-muted d-block"><?php echo lang('emergency_contact_number'); ?></label>
                                            <div class="emergency_contact_number"></div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </form>
            </div>
        </div>
    </div>
</div>




<script src="common/js/codearistos.min.js"></script>
<script type="text/javascript">
    var select_doctor = "<?php echo lang('select_doctor'); ?>";
</script>
<script type="text/javascript">
    var language = "<?php echo $this->language; ?>";
</script>

<script src="common/extranal/js/patient/patient.js"></script>


<!-- <script>
    function openNewWindow() {
        window.open('https://codearistos.net/dev/hmz/v2/patient/medicalHistory?id=24', '_blank', 'toolbar=yes,scrollbars=yes,resizable=yes,top=500,left=300,width=1000,height=600');
    }
</script> -->