<div class="content-wrapper bg-light">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row my-2 pl-1">
                <div class="col-sm-6">
                    <h1 class="font-weight-bold"><i class="fas fa-prescription mr-2"></i><?php echo lang('prescription'); ?></h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="home"><?php echo lang('home') ?></a></li>
                        <li class="breadcrumb-item active"><?php echo lang('prescription') ?></li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header bg-light border-bottom">
                            <div class="row align-items-center">
                                <div class="col-md-6">
                                    <h3 class="card-title mb-0">
                                        <i class="fas fa-prescription mr-2 text-primary"></i>
                                        <?php echo lang('All my prescriptions'); ?>
                                    </h3>
                                </div>
                                <div class="col-md-6 text-right">
                                    <?php if ($this->ion_auth->in_group(array('Patient')) && isset($hospitals)) { ?>
                                        <select class="form-control form-control-sm d-inline-block" id="patient_hospital_select" name="hospital_id" 
                                                style="width: 280px; border: 2px solid #007bff;">
                                            <option value="consolidated" <?php echo ($selected_hospital === 'consolidated') ? 'selected' : ''; ?>>
                                                📊 All Hospitals Data
                                            </option>
                                            <?php foreach ($hospitals as $hospital) { ?>
                                                <option value="<?php echo $hospital->id; ?>" 
                                                        <?php echo ($selected_hospital == $hospital->id) ? 'selected' : ''; ?>>
                                                    🏥 <?php echo $hospital->name; ?>
                                                </option>
                                            <?php } ?>
                                        </select>
                                    <?php } ?>
                                    <?php if ($this->ion_auth->in_group('Doctor')) { ?>
                                        <div class="mt-2">
                                            <a data-toggle="modal" href="#myModa3">
                                                <button id="" class="btn btn-success btn-sm">
                                                    <i class="fa fa-plus-circle"></i> <?php echo lang('add_new'); ?>
                                                </button>
                                            </a>
                                        </div>
                                    <?php } ?>
                                </div>
                            </div>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <table class="table table-bordered table-hover" id="editable-sample">
                                <thead>
                                    <tr>
                                        <th> <?php echo lang('date'); ?></th>
                                        <th> <?php echo lang('patient'); ?></th>
                                        <th> <?php echo lang('medicine'); ?></th>
                                        <th> <?php echo lang('options'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>



                                    <?php foreach ($prescriptions as $prescription) { ?>
                                        <tr class="">
                                            <td><?php echo date('d-m-Y', $prescription->date); ?></td>
                                            <td> <?php echo $this->patient_model->getPatientById($prescription->patient)->name; ?></td>
                                            <td>

                                                <?php
                                                if (!empty($prescription->medicine)) {
                                                    $medicine = explode('###', $prescription->medicine);

                                                    foreach ($medicine as $key => $value) {
                                                        $medicine_id = explode('***', $value);
                                                        $medicine_name_with_dosage = $this->medicine_model->getMedicineById($medicine_id[0])->name . ' -' . $medicine_id[1];
                                                        $medicine_name_with_dosage = $medicine_name_with_dosage . ' | ' . $medicine_id[3] . ' Days<br>';
                                                        rtrim($medicine_name_with_dosage, ',');
                                                        echo '<p>' . $medicine_name_with_dosage . '</p>';
                                                    }
                                                }
                                                ?>


                                            </td>
                                            <td>
                                                <a class="btn btn-warning btn-sm btn_width" href="prescription/viewPrescription?id=<?php echo $prescription->id; ?>"><i class="fa fa-eye"> <?php echo lang('view'); ?> <?php echo lang('prescription'); ?> </i></a>
                                            </td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </section>

    <!-- /.content -->
</div>



<!--main content end-->
<!--footer start-->



<?php
$current_user = $this->ion_auth->get_user_id();
if ($this->ion_auth->in_group('Doctor')) {
    $doctor_id = $this->db->get_where('doctor', array('ion_user_id' => $current_user))->row()->id;
}
?>

<!-- Add Prescription Modal-->
<div class="modal fade" id="myModa3" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                <h4 class="modal-title font-weight-bold"><i class="fa fa-plus-circle"></i> <?php echo lang('add_prescription'); ?></h4>
            </div>
            <div class="modal-body">
                <form role="form" action="prescription/addNewPrescription" method="post" enctype="multipart/form-data">
                    <div class="form-group col-md-12">
                        <input type="hidden" class="form-control form-control-inline input-medium default-date-picker" name="doctor" value='<?php
                                                                                                                                            if (!empty($doctor_id)) {
                                                                                                                                                echo $doctor_id;
                                                                                                                                            }
                                                                                                                                            ?>' placeholder="">
                    </div>
                    <div class="form-group col-md-6">
                        <label for="exampleInputEmail1"> <?php echo lang('date'); ?></label>
                        <input type="text" class="form-control form-control-inline input-medium default-date-picker" name="date" value='' placeholder="">
                    </div>
                    <div class="form-group col-md-6">
                        <label for="exampleInputEmail1"> <?php echo lang('patient'); ?></label>
                        <select class="form-control form-control-lg m-bot15 js-example-basic-single" name="patient" value=''>
                            <option value="">Select .....</option>
                            <?php foreach ($patients as $patientss) { ?>
                                <option value="<?php echo $patientss->id; ?>" <?php
                                                                                if (!empty($prescription->patient)) {
                                                                                    if ($prescription->patient == $patientss->id) {
                                                                                        echo 'selected';
                                                                                    }
                                                                                }
                                                                                ?>><?php echo $patientss->name; ?> </option>
                            <?php } ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label class="control-label col-md-3"><?php echo lang('history'); ?></label>
                        <div class="col-md-9">
                            <textarea class="ckeditor form-control" name="symptom" value="" rows="10"></textarea>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="control-label col-md-3"><?php echo lang('medication'); ?></label>
                        <div class="col-md-9">
                            <textarea class="ckeditor form-control" name="medicine" value="" rows="10"></textarea>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="control-label col-md-3"><?php echo lang('note'); ?></label>
                        <div class="col-md-9">
                            <textarea class="ckeditor form-control" name="note" value="" rows="10"></textarea>
                        </div>
                    </div>

                    <input type="hidden" name="patient_id" value='<?php echo $patient->id; ?>'>
                    <input type="hidden" name="id" value=''>
                    <section class="">
                        <button type="submit" name="submit" class="btn btn-info submit_button">Submit</button>
                    </section>
                </form>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>
<!-- Add Prescription Modal-->


<!-- Edit Prescription Modal-->
<div class="modal fade" id="myModal5" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                <h4 class="modal-title font-weight-bold"><i class="fa fa-plus-circle"></i> <?php echo lang('edit_prescription'); ?></h4>
            </div>
            <div class="modal-body">
                <form role="form" id="prescriptionEditForm" action="prescription/addNewPrescription" method="post" enctype="multipart/form-data">
                    <div class="form-group col-md-12">
                        <input type="hidden" class="form-control form-control-inline input-medium default-date-picker" name="doctor" value='' placeholder="">
                    </div>
                    <div class="form-group col-md-6">
                        <label for="exampleInputEmail1"> <?php echo lang('date'); ?></label>
                        <input type="text" class="form-control form-control-inline input-medium default-date-picker" name="date" value='' placeholder="">
                    </div>
                    <div class="form-group col-md-6">
                        <label for="exampleInputEmail1"> <?php echo lang('patient'); ?></label>
                        <select class="form-control form-control-lg m-bot15" name="patient" value=''>
                            <option value="">Select .....</option>
                            <?php foreach ($patients as $patientss) { ?>
                                <option value="<?php echo $patientss->id; ?>" <?php
                                                                                if (!empty($prescription->patient)) {
                                                                                    if ($prescription->patient == $patientss->id) {
                                                                                        echo 'selected';
                                                                                    }
                                                                                }
                                                                                ?>><?php echo $patientss->name; ?> </option>
                            <?php } ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label class="control-label col-md-3"><?php echo lang('history'); ?></label>
                        <div class="col-md-9">
                            <textarea class="ckeditor form-control" id="editor1" name="symptom" value="" rows="10"></textarea>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="control-label col-md-3"><?php echo lang('medication'); ?></label>
                        <div class="col-md-9">
                            <textarea class="ckeditor form-control" id="editor2" name="medicine" value="" rows="10"></textarea>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="control-label col-md-3"><?php echo lang('note'); ?></label>
                        <div class="col-md-9">
                            <textarea class="ckeditor form-control" id="editor3" name="note" value="" rows="10"></textarea>
                        </div>
                    </div>


                    <input type="hidden" name="id" value=''>
                    <section class="">
                        <button type="submit" name="submit" class="btn btn-info submit_button"><?php echo lang('submit'); ?></button>
                    </section>
                </form>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>
<!-- Edit Prescription Modal-->


<script src="common/js/codearistos.min.js"></script>
<script type="text/javascript">
    var language = "<?php echo $this->language; ?>";
</script>

<script src="common/extranal/js/patient/my_prescription.js"></script>

<script>
// Wait for all scripts to load, then initialize hospital dropdown
$(window).on('load', function() {
    console.log('Prescription: Window loaded, initializing dropdown...');
    
    // Small delay to ensure all scripts are ready
    setTimeout(function() {
        // Patient hospital selection dropdown change handler
        $('#patient_hospital_select').off('change.hospital').on('change.hospital', function() {
            console.log('Prescription: Dropdown changed to:', $(this).val());
            const selectedHospital = $(this).val();
            
            // Build URL with hospital parameter
            let url = 'patient/myPrescription';
            if (selectedHospital) {
                url += '?hospital_id=' + selectedHospital;
            }
            
            console.log('Prescription: Redirecting to:', url);
            
            // Show loading indication
            $(this).prop('disabled', true);
            $('body').append('<div id="loading-overlay" style="position:fixed;top:0;left:0;width:100%;height:100%;background:rgba(0,0,0,0.5);z-index:9999;display:flex;align-items:center;justify-content:center;color:white;font-size:18px;"><i class="fas fa-spinner fa-spin mr-2"></i>Loading hospital data...</div>');
            
            // Redirect to reload page with selected hospital
            window.location.href = url;
        });
        
        // Check if dropdown exists
        if ($('#patient_hospital_select').length) {
            console.log('Prescription: Dropdown found successfully');
        } else {
            console.log('Prescription: Dropdown NOT found!');
        }
    }, 100);
});
</script>