<div class="content-wrapper">
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>
                        <i class="fas fa-notes-medical mr-2 text-primary"></i>
                        Medical History - <?php echo $patient->name; ?>
                    </h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="home">Home</a></li>
                        <li class="breadcrumb-item"><a href="<?php echo base_url('patient/guardianDashboard'); ?>">Dependents</a></li>
                        <li class="breadcrumb-item"><a href="<?php echo base_url('patient/guardianViewDependent?id=' . $patient->id); ?>"><?php echo $patient->name; ?></a></li>
                        <li class="breadcrumb-item active">Medical History</li>
                    </ol>
                </div>
            </div>
        </div>
    </section>

    <section class="content">
        <div class="container-fluid">

            <!-- Patient Info Card -->
            <div class="card card-primary card-outline">
                <div class="card-body box-profile">
                    <div class="row">
                        <div class="col-md-2 text-center">
                            <?php if (!empty($patient->img_url)) { ?>
                                <img src="<?php echo base_url() . $patient->img_url; ?>" class="img-circle elevation-2" style="width: 80px; height: 80px; object-fit: cover;">
                            <?php } else { ?>
                                <div class="img-circle elevation-2 bg-secondary d-flex align-items-center justify-content-center" style="width: 80px; height: 80px;">
                                    <i class="fas fa-user fa-2x text-white"></i>
                                </div>
                            <?php } ?>
                        </div>
                        <div class="col-md-10">
                            <div class="row">
                                <div class="col-md-6">
                                    <h4><?php echo $patient->name; ?> <span class="badge badge-warning">Dependent</span></h4>
                                    <p class="text-muted mb-1"><strong>Patient ID:</strong> <?php echo $patient->patient_id; ?></p>
                                    <p class="text-muted mb-1"><strong>Age:</strong> <?php echo $patient->age; ?> | <strong>Gender:</strong> <?php echo $patient->sex; ?></p>
                                </div>
                                <div class="col-md-4">
                                    <p class="text-muted mb-1"><strong>Guardian:</strong> <?php echo $guardian->name; ?></p>
                                    <p class="text-muted mb-1"><strong>Relationship:</strong> <?php echo ucfirst($patient->relationship_to_guardian); ?></p>
                                    <p class="text-muted mb-1"><strong>Emergency Contact:</strong> <?php echo $patient->emergency_contact; ?></p>
                                </div>
                                <div class="col-md-2">
                                    <a href="<?php echo base_url('patient/guardianViewDependent?id=' . $patient->id); ?>" class="btn btn-outline-primary btn-sm btn-block">
                                        <i class="fas fa-arrow-left mr-1"></i> Back to Details
                                    </a>
                                    <a href="<?php echo base_url('appointment/addNewView?patient_id=' . $patient->id . '&guardian_booking=1'); ?>" class="btn btn-success btn-sm btn-block mt-1">
                                        <i class="fas fa-calendar-plus mr-1"></i> Book Appointment
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Medical Records Tabs -->
            <div class="card card-primary card-outline card-outline-tabs">
                <div class="card-header p-0 border-bottom-0">
                    <ul class="nav nav-tabs" id="custom-tabs-four-tab" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link <?php echo empty($redirect_tab) ? 'active' : ''; ?>" id="basic-tab" data-toggle="pill" href="#basic" role="tab">
                                <i class="fas fa-user-circle mr-2"></i>Patient Info
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo $redirect_tab == 'appointment' ? 'active' : ''; ?>" id="appointment-tab" data-toggle="pill" href="#appointment" role="tab">
                                <i class="fas fa-calendar-alt mr-2"></i>Appointments
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo $redirect_tab == 'prescription' ? 'active' : ''; ?>" id="prescription-tab" data-toggle="pill" href="#prescription" role="tab">
                                <i class="fas fa-prescription-bottle mr-2"></i>Prescriptions
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo $redirect_tab == 'lab' ? 'active' : ''; ?>" id="lab-tab" data-toggle="pill" href="#lab" role="tab">
                                <i class="fas fa-flask mr-2"></i>Lab Reports
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo $redirect_tab == 'case' ? 'active' : ''; ?>" id="case-tab" data-toggle="pill" href="#case" role="tab">
                                <i class="fas fa-notes-medical mr-2"></i>Medical Cases
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo $redirect_tab == 'vital' ? 'active' : ''; ?>" id="vital-tab" data-toggle="pill" href="#vital" role="tab">
                                <i class="fas fa-heartbeat mr-2"></i>Vital Signs
                            </a>
                        </li>
                    </ul>
                </div>
                <div class="card-body">
                    <div class="tab-content" id="custom-tabs-four-tabContent">
                        
                        <!-- Patient Info Tab -->
                        <div id="basic" class="tab-pane <?php echo empty($redirect_tab) ? 'active' : ''; ?>">
                            <div class="row">
                                <div class="col-md-6">
                                    <table class="table table-borderless">
                                        <tr><td><strong>Full Name:</strong></td><td><?php echo $patient->name; ?></td></tr>
                                        <tr><td><strong>Patient ID:</strong></td><td><?php echo $patient->patient_id; ?></td></tr>
                                        <tr><td><strong>Gender:</strong></td><td><?php echo $patient->sex; ?></td></tr>
                                        <tr><td><strong>Age:</strong></td><td><?php echo $patient->age; ?></td></tr>
                                        <tr><td><strong>Blood Group:</strong></td><td><?php echo $patient->bloodgroup; ?></td></tr>
                                        <tr><td><strong>Address:</strong></td><td><?php echo $patient->address; ?></td></tr>
                                    </table>
                                </div>
                                <div class="col-md-6">
                                    <table class="table table-borderless">
                                        <tr><td><strong>Guardian:</strong></td><td><?php echo $guardian->name; ?></td></tr>
                                        <tr><td><strong>Relationship:</strong></td><td><?php echo ucfirst($patient->relationship_to_guardian); ?></td></tr>
                                        <tr><td><strong>Emergency Contact:</strong></td><td><?php echo $patient->emergency_contact; ?></td></tr>
                                        <tr><td><strong>Registration Date:</strong></td><td><?php echo $patient->add_date; ?></td></tr>
                                        <tr><td><strong>Known Allergies:</strong></td><td><?php echo $patient->known_allergies ?: 'None recorded'; ?></td></tr>
                                        <tr><td><strong>Medical History:</strong></td><td><?php echo $patient->medical_history ?: 'None recorded'; ?></td></tr>
                                    </table>
                                </div>
                            </div>
                        </div>

                        <!-- Appointments Tab -->
                        <div id="appointment" class="tab-pane <?php echo $redirect_tab == 'appointment' ? 'active' : ''; ?>">
                            <?php if (!empty($appointments)) { ?>
                                <div class="table-responsive">
                                    <table class="table table-hover">
                                        <thead class="thead-light">
                                            <tr>
                                                <th>Date</th>
                                                <th>Time</th>
                                                <th>Doctor</th>
                                                <th>Status</th>
                                                <th>Notes</th>
                                                <th>Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($appointments as $appointment) { ?>
                                                <tr>
                                                    <td><?php echo date('M d, Y', strtotime($appointment->date)); ?></td>
                                                    <td><?php echo $appointment->time; ?></td>
                                                    <td>
                                                        <?php 
                                                        $doctor = null;
                                                        foreach ($doctors as $doc) {
                                                            if ($doc->id == $appointment->doctor) {
                                                                $doctor = $doc;
                                                                break;
                                                            }
                                                        }
                                                        echo $doctor ? $doctor->name : 'N/A';
                                                        ?>
                                                    </td>
                                                    <td>
                                                        <span class="badge badge-<?php echo $appointment->status == 'Confirmed' ? 'success' : ($appointment->status == 'Pending' ? 'warning' : 'secondary'); ?>">
                                                            <?php echo $appointment->status; ?>
                                                        </span>
                                                    </td>
                                                    <td><?php echo substr($appointment->problem, 0, 50) . (strlen($appointment->problem) > 50 ? '...' : ''); ?></td>
                                                    <td>
                                                        <a href="<?php echo base_url('appointment/appointmentDetails?id=' . $appointment->id); ?>" class="btn btn-sm btn-info">
                                                            <i class="fas fa-eye"></i>
                                                        </a>
                                                    </td>
                                                </tr>
                                            <?php } ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php } else { ?>
                                <div class="text-center py-5">
                                    <i class="fas fa-calendar-times fa-3x text-muted mb-3"></i>
                                    <h5 class="text-muted">No appointments found</h5>
                                    <p>This patient has no appointment history.</p>
                                    <a href="<?php echo base_url('appointment/addNewView?patient_id=' . $patient->id . '&guardian_booking=1'); ?>" class="btn btn-primary">
                                        <i class="fas fa-plus mr-2"></i>Book Appointment
                                    </a>
                                </div>
                            <?php } ?>
                        </div>

                        <!-- Prescriptions Tab -->
                        <div id="prescription" class="tab-pane <?php echo $redirect_tab == 'prescription' ? 'active' : ''; ?>">
                            <?php if (!empty($prescriptions)) { ?>
                                <div class="table-responsive">
                                    <table class="table table-hover">
                                        <thead class="thead-light">
                                            <tr>
                                                <th>Date</th>
                                                <th>Doctor</th>
                                                <th>Medicine</th>
                                                <th>Instructions</th>
                                                <th>Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($prescriptions as $prescription) { ?>
                                                <tr>
                                                    <td><?php echo date('M d, Y', strtotime($prescription->date)); ?></td>
                                                    <td>
                                                        <?php 
                                                        $doctor = null;
                                                        foreach ($doctors as $doc) {
                                                            if ($doc->id == $prescription->doctor_id) {
                                                                $doctor = $doc;
                                                                break;
                                                            }
                                                        }
                                                        echo $doctor ? $doctor->name : 'N/A';
                                                        ?>
                                                    </td>
                                                    <td><?php echo $prescription->medicine; ?></td>
                                                    <td><?php echo substr($prescription->instruction, 0, 50) . (strlen($prescription->instruction) > 50 ? '...' : ''); ?></td>
                                                    <td>
                                                        <a href="<?php echo base_url('prescription/prescriptionDetails?id=' . $prescription->id); ?>" class="btn btn-sm btn-info">
                                                            <i class="fas fa-eye"></i>
                                                        </a>
                                                    </td>
                                                </tr>
                                            <?php } ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php } else { ?>
                                <div class="text-center py-5">
                                    <i class="fas fa-prescription-bottle fa-3x text-muted mb-3"></i>
                                    <h5 class="text-muted">No prescriptions found</h5>
                                    <p>This patient has no prescription history.</p>
                                </div>
                            <?php } ?>
                        </div>

                        <!-- Lab Reports Tab -->
                        <div id="lab" class="tab-pane <?php echo $redirect_tab == 'lab' ? 'active' : ''; ?>">
                            <?php if (!empty($labs)) { ?>
                                <div class="table-responsive">
                                    <table class="table table-hover">
                                        <thead class="thead-light">
                                            <tr>
                                                <th>Date</th>
                                                <th>Test Name</th>
                                                <th>Doctor</th>
                                                <th>Status</th>
                                                <th>Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($labs as $lab) { ?>
                                                <tr>
                                                    <td><?php echo date('M d, Y', strtotime($lab->date)); ?></td>
                                                    <td><?php echo $lab->test_name; ?></td>
                                                    <td>
                                                        <?php 
                                                        $doctor = null;
                                                        foreach ($doctors as $doc) {
                                                            if ($doc->id == $lab->doctor_id) {
                                                                $doctor = $doc;
                                                                break;
                                                            }
                                                        }
                                                        echo $doctor ? $doctor->name : 'N/A';
                                                        ?>
                                                    </td>
                                                    <td>
                                                        <span class="badge badge-<?php echo $lab->status == 'completed' ? 'success' : 'warning'; ?>">
                                                            <?php echo ucfirst($lab->status); ?>
                                                        </span>
                                                    </td>
                                                    <td>
                                                        <a href="<?php echo base_url('lab/labDetails?id=' . $lab->id); ?>" class="btn btn-sm btn-info">
                                                            <i class="fas fa-eye"></i>
                                                        </a>
                                                    </td>
                                                </tr>
                                            <?php } ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php } else { ?>
                                <div class="text-center py-5">
                                    <i class="fas fa-flask fa-3x text-muted mb-3"></i>
                                    <h5 class="text-muted">No lab reports found</h5>
                                    <p>This patient has no lab test history.</p>
                                </div>
                            <?php } ?>
                        </div>

                        <!-- Medical Cases Tab -->
                        <div id="case" class="tab-pane <?php echo $redirect_tab == 'case' ? 'active' : ''; ?>">
                            <?php if (!empty($medical_histories)) { ?>
                                <div class="row">
                                    <?php foreach ($medical_histories as $history) { ?>
                                        <div class="col-md-6 mb-4">
                                            <div class="card border-left-primary">
                                                <div class="card-body">
                                                    <div class="d-flex justify-content-between align-items-center mb-2">
                                                        <h6 class="card-title mb-0">
                                                            <i class="fas fa-notes-medical mr-2"></i>
                                                            <?php echo date('M d, Y', strtotime($history->date)); ?>
                                                        </h6>
                                                        <a href="<?php echo base_url('patient/guardianDependentHistory?id=' . $patient->id . '&case_id=' . $history->id); ?>" class="btn btn-sm btn-outline-primary">
                                                            <i class="fas fa-eye"></i>
                                                        </a>
                                                    </div>
                                                    <p class="card-text">
                                                        <strong>Doctor:</strong> 
                                                        <?php 
                                                        $doctor = null;
                                                        foreach ($doctors as $doc) {
                                                            if ($doc->id == $history->doctor_id) {
                                                                $doctor = $doc;
                                                                break;
                                                            }
                                                        }
                                                        echo $doctor ? $doctor->name : 'N/A';
                                                        ?>
                                                    </p>
                                                    <p class="card-text">
                                                        <?php echo substr(strip_tags($history->description), 0, 100) . '...'; ?>
                                                    </p>
                                                </div>
                                            </div>
                                        </div>
                                    <?php } ?>
                                </div>
                            <?php } else { ?>
                                <div class="text-center py-5">
                                    <i class="fas fa-notes-medical fa-3x text-muted mb-3"></i>
                                    <h5 class="text-muted">No medical cases found</h5>
                                    <p>This patient has no medical case history.</p>
                                </div>
                            <?php } ?>
                        </div>

                        <!-- Vital Signs Tab -->
                        <div id="vital" class="tab-pane <?php echo $redirect_tab == 'vital' ? 'active' : ''; ?>">
                            <?php if (!empty($vital_signs)) { ?>
                                <div class="table-responsive">
                                    <table class="table table-hover">
                                        <thead class="thead-light">
                                            <tr>
                                                <th>Date</th>
                                                <th>Blood Pressure</th>
                                                <th>Temperature</th>
                                                <th>Heart Rate</th>
                                                <th>Weight</th>
                                                <th>Height</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($vital_signs as $vital) { ?>
                                                <tr>
                                                    <td><?php echo date('M d, Y', strtotime($vital->add_date_time)); ?></td>
                                                    <td><?php echo $vital->blood_pressure; ?></td>
                                                    <td><?php echo $vital->temperature; ?>°F</td>
                                                    <td><?php echo $vital->heart_rate; ?> bpm</td>
                                                    <td><?php echo $vital->weight; ?> kg</td>
                                                    <td><?php echo $vital->height; ?> cm</td>
                                                </tr>
                                            <?php } ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php } else { ?>
                                <div class="text-center py-5">
                                    <i class="fas fa-heartbeat fa-3x text-muted mb-3"></i>
                                    <h5 class="text-muted">No vital signs recorded</h5>
                                    <p>This patient has no vital signs history.</p>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<style>
.content-wrapper {
    background-color: #f4f6f9;
}

.card {
    border-radius: 10px;
    box-shadow: 0 0 1px rgba(0,0,0,.125), 0 1px 3px rgba(0,0,0,.2);
}

.nav-tabs .nav-link {
    border-radius: 10px 10px 0 0;
    margin-right: 2px;
}

.nav-tabs .nav-link.active {
    background-color: #007bff;
    color: white !important;
    border-color: #007bff;
}

.border-left-primary {
    border-left: 4px solid #007bff !important;
}

.table-borderless td {
    border: none !important;
    padding: 0.3rem 0.75rem;
}

.img-circle {
    border-radius: 50%;
}

.badge {
    font-size: 0.8em;
}

.tab-pane {
    padding: 20px 0;
}

.table-striped > tbody > tr:nth-of-type(odd) > td,
.table-striped > tbody > tr:nth-of-type(odd) > th {
    background-color: rgba(0,0,0,.02);
}
</style> 