<div class="content-wrapper">
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>
                        <i class="fas fa-user mr-2 text-primary"></i>
                        <?php echo $patient->name; ?>
                    </h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="home">Home</a></li>
                        <li class="breadcrumb-item"><a href="<?php echo base_url('patient/guardianDashboard'); ?>">Dependents</a></li>
                        <li class="breadcrumb-item active"><?php echo $patient->name; ?></li>
                    </ol>
                </div>
            </div>
        </div>
    </section>

    <section class="content">
        <div class="container-fluid">
            
            <!-- Patient Profile Header -->
            <div class="row">
                <div class="col-md-3">
                    <!-- Profile Image -->
                    <div class="card card-primary card-outline">
                        <div class="card-body box-profile">
                            <div class="text-center">
                                <?php if (!empty($patient->img_url)) { ?>
                                    <img class="profile-user-img img-fluid img-circle" src="<?php echo base_url() . $patient->img_url; ?>" alt="Patient profile picture">
                                <?php } else { ?>
                                    <div class="profile-user-img img-fluid img-circle bg-secondary d-flex align-items-center justify-content-center" style="width: 100px; height: 100px; margin: 0 auto;">
                                        <i class="fas fa-user fa-3x text-white"></i>
                                    </div>
                                <?php } ?>
                            </div>

                            <h3 class="profile-username text-center"><?php echo $patient->name; ?></h3>

                            <p class="text-muted text-center">
                                <span class="badge badge-warning"><?php echo ucfirst($patient->relationship_to_guardian); ?></span>
                                <span class="badge badge-info">Dependent</span>
                            </p>

                            <ul class="list-group list-group-unbordered mb-3">
                                <li class="list-group-item">
                                    <b>Patient ID</b> <a class="float-right"><?php echo $patient->patient_id; ?></a>
                                </li>
                                <li class="list-group-item">
                                    <b>Age</b> <a class="float-right"><?php echo $patient->age; ?></a>
                                </li>
                                <li class="list-group-item">
                                    <b>Gender</b> <a class="float-right"><?php echo $patient->sex; ?></a>
                                </li>
                                <li class="list-group-item">
                                    <b>Blood Group</b> <a class="float-right"><?php echo $patient->bloodgroup; ?></a>
                                </li>
                            </ul>

                            <a href="<?php echo base_url('appointment/addNewView?patient_id=' . $patient->id . '&guardian_booking=1'); ?>" class="btn btn-primary btn-block">
                                <i class="fas fa-calendar-plus mr-2"></i><b>Book Appointment</b>
                            </a>
                        </div>
                    </div>

                    <!-- Guardian Info -->
                    <div class="card card-success">
                        <div class="card-header">
                            <h3 class="card-title"><i class="fas fa-user-shield mr-2"></i>Guardian</h3>
                        </div>
                        <div class="card-body">
                            <strong><i class="fas fa-user mr-1"></i> Name</strong>
                            <p class="text-muted"><?php echo $guardian->name; ?></p>

                            <strong><i class="fas fa-heart mr-1"></i> Relationship</strong>
                            <p class="text-muted"><?php echo ucfirst($patient->relationship_to_guardian); ?></p>

                            <strong><i class="fas fa-phone mr-1"></i> Emergency Contact</strong>
                            <p class="text-muted"><?php echo $patient->emergency_contact; ?></p>

                            <strong><i class="fas fa-map-marker-alt mr-1"></i> Address</strong>
                            <p class="text-muted"><?php echo $patient->address; ?></p>
                        </div>
                    </div>
                </div>

                <div class="col-md-9">
                    <div class="card">
                        <div class="card-header p-2">
                            <ul class="nav nav-pills">
                                <li class="nav-item"><a class="nav-link active" href="#overview" data-toggle="tab"><i class="fas fa-chart-line mr-1"></i> Overview</a></li>
                                <li class="nav-item"><a class="nav-link" href="#appointments" data-toggle="tab"><i class="fas fa-calendar-alt mr-1"></i> Appointments</a></li>
                                <li class="nav-item"><a class="nav-link" href="#medical" data-toggle="tab"><i class="fas fa-notes-medical mr-1"></i> Medical History</a></li>
                            </ul>
                        </div>
                        <div class="card-body">
                            <div class="tab-content">
                                
                                <!-- Overview Tab -->
                                <div class="active tab-pane" id="overview">
                                    <!-- Stats Row -->
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="info-box">
                                                <span class="info-box-icon bg-info"><i class="fas fa-calendar-alt"></i></span>
                                                <div class="info-box-content">
                                                    <span class="info-box-text">Total Appointments</span>
                                                    <span class="info-box-number"><?php echo count($appointments); ?></span>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="info-box">
                                                <span class="info-box-icon bg-success"><i class="fas fa-prescription-bottle"></i></span>
                                                <div class="info-box-content">
                                                    <span class="info-box-text">Prescriptions</span>
                                                    <span class="info-box-number"><?php echo count($prescriptions); ?></span>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="info-box">
                                                <span class="info-box-icon bg-warning"><i class="fas fa-flask"></i></span>
                                                <div class="info-box-content">
                                                    <span class="info-box-text">Lab Reports</span>
                                                    <span class="info-box-number"><?php echo count($labs); ?></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Quick Actions -->
                                    <div class="row">
                                        <div class="col-12">
                                            <h5><i class="fas fa-bolt mr-2"></i>Quick Actions</h5>
                                            <div class="row">
                                                <div class="col-md-3">
                                                    <a href="<?php echo base_url('patient/guardianDependentHistory?id=' . $patient->id); ?>" class="btn btn-info btn-block">
                                                        <i class="fas fa-history mr-2"></i>Full Medical History
                                                    </a>
                                                </div>
                                                <div class="col-md-3">
                                                    <a href="<?php echo base_url('patient/guardianDependentHistory?id=' . $patient->id . '&redirect_tab=prescription'); ?>" class="btn btn-warning btn-block">
                                                        <i class="fas fa-prescription-bottle mr-2"></i>View Prescriptions
                                                    </a>
                                                </div>
                                                <div class="col-md-3">
                                                    <a href="<?php echo base_url('patient/guardianDependentHistory?id=' . $patient->id . '&redirect_tab=lab'); ?>" class="btn btn-secondary btn-block">
                                                        <i class="fas fa-flask mr-2"></i>View Lab Reports
                                                    </a>
                                                </div>
                                                <div class="col-md-3">
                                                    <a href="<?php echo base_url('patient/guardianDashboard'); ?>" class="btn btn-outline-primary btn-block">
                                                        <i class="fas fa-arrow-left mr-2"></i>Back to Dependents
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Appointments Tab -->
                                <div class="tab-pane" id="appointments">
                                    <?php if (!empty($appointments)) { ?>
                                        <div class="table-responsive">
                                            <table class="table table-striped">
                                                <thead>
                                                    <tr>
                                                        <th>Date</th>
                                                        <th>Time</th>
                                                        <th>Doctor</th>
                                                        <th>Status</th>
                                                        <th>Actions</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php foreach (array_slice($appointments, 0, 10) as $appointment) { ?>
                                                        <tr>
                                                            <td><?php echo date('M d, Y', strtotime($appointment->date)); ?></td>
                                                            <td><?php echo $appointment->time; ?></td>
                                                            <td>
                                                                <?php 
                                                                $doctor = null;
                                                                foreach ($doctors as $doc) {
                                                                    if ($doc->id == $appointment->doctor) {
                                                                        $doctor = $doc;
                                                                        break;
                                                                    }
                                                                }
                                                                echo $doctor ? $doctor->name : 'N/A';
                                                                ?>
                                                            </td>
                                                            <td>
                                                                <span class="badge badge-<?php echo $appointment->status == 'Confirmed' ? 'success' : 'warning'; ?>">
                                                                    <?php echo $appointment->status; ?>
                                                                </span>
                                                            </td>
                                                            <td>
                                                                <a href="<?php echo base_url('appointment/appointmentDetails?id=' . $appointment->id); ?>" class="btn btn-sm btn-info">
                                                                    <i class="fas fa-eye"></i>
                                                                </a>
                                                            </td>
                                                        </tr>
                                                    <?php } ?>
                                                </tbody>
                                            </table>
                                        </div>
                                        <?php if (count($appointments) > 10) { ?>
                                            <div class="text-center">
                                                <a href="<?php echo base_url('patient/guardianDependentHistory?id=' . $patient->id . '&redirect_tab=appointment'); ?>" class="btn btn-outline-primary">
                                                    View All <?php echo count($appointments); ?> Appointments
                                                </a>
                                            </div>
                                        <?php } ?>
                                    <?php } else { ?>
                                        <div class="text-center py-4">
                                            <i class="fas fa-calendar-times fa-3x text-muted mb-3"></i>
                                            <h5 class="text-muted">No Appointments</h5>
                                            <p class="text-muted">This patient has no appointment history.</p>
                                            <a href="<?php echo base_url('appointment/addNewView?patient_id=' . $patient->id . '&guardian_booking=1'); ?>" class="btn btn-primary">
                                                <i class="fas fa-plus mr-2"></i>Book First Appointment
                                            </a>
                                        </div>
                                    <?php } ?>
                                </div>

                                <!-- Medical History Tab -->
                                <div class="tab-pane" id="medical">
                                    <?php if (!empty($medical_histories)) { ?>
                                        <div class="timeline">
                                            <?php foreach (array_slice($medical_histories, 0, 5) as $history) { ?>
                                                <div class="time-label">
                                                    <span class="bg-red"><?php echo date('M d, Y', strtotime($history->date)); ?></span>
                                                </div>
                                                <div>
                                                    <i class="fas fa-notes-medical bg-blue"></i>
                                                    <div class="timeline-item">
                                                        <span class="time"><i class="fas fa-clock"></i> <?php echo date('h:i A', strtotime($history->date)); ?></span>
                                                        <h3 class="timeline-header">
                                                            Medical Consultation
                                                            <?php 
                                                            $doctor = null;
                                                            foreach ($doctors as $doc) {
                                                                if ($doc->id == $history->doctor_id) {
                                                                    $doctor = $doc;
                                                                    break;
                                                                }
                                                            }
                                                            if ($doctor) echo ' - Dr. ' . $doctor->name;
                                                            ?>
                                                        </h3>
                                                        <div class="timeline-body">
                                                            <?php echo substr(strip_tags($history->description), 0, 200) . '...'; ?>
                                                        </div>
                                                        <div class="timeline-footer">
                                                            <a href="<?php echo base_url('patient/guardianDependentHistory?id=' . $patient->id . '&case_id=' . $history->id); ?>" class="btn btn-primary btn-sm">View Details</a>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php } ?>
                                            <div>
                                                <i class="fas fa-clock bg-gray"></i>
                                            </div>
                                        </div>
                                        
                                        <?php if (count($medical_histories) > 5) { ?>
                                            <div class="text-center">
                                                <a href="<?php echo base_url('patient/guardianDependentHistory?id=' . $patient->id); ?>" class="btn btn-outline-info">
                                                    View All Medical Records (<?php echo count($medical_histories); ?>)
                                                </a>
                                            </div>
                                        <?php } ?>
                                    <?php } else { ?>
                                        <div class="text-center py-4">
                                            <i class="fas fa-notes-medical fa-3x text-muted mb-3"></i>
                                            <h5 class="text-muted">No Medical History</h5>
                                            <p class="text-muted">This patient has no medical history recorded.</p>
                                        </div>
                                    <?php } ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<style>
.content-wrapper {
    background-color: #f4f6f9;
}

.profile-user-img {
    border: 3px solid #adb5bd;
    margin: 0 auto;
    padding: 3px;
    width: 100px;
}

.timeline {
    position: relative;
    margin: 0 0 30px 0;
}

.timeline:before {
    content: '';
    position: absolute;
    top: 0;
    left: 31px;
    height: 100%;
    width: 4px;
    background: #dee2e6;
}

.timeline > div {
    position: relative;
    margin: 10px 0 10px 0;
    clear: both;
}

.timeline > div > .timeline-item {
    box-shadow: 0 1px 1px rgba(0,0,0,0.1);
    border-radius: 3px;
    margin-top: 0;
    background: #fff;
    margin-left: 60px;
    margin-right: 15px;
    padding: 0;
    position: relative;
}

.timeline > div > .timeline-item > .time {
    color: #999;
    float: right;
    padding: 10px;
    font-size: 12px;
}

.timeline > div > .timeline-item > .timeline-header {
    margin: 0;
    color: #555;
    border-bottom: 1px solid #f4f4f4;
    padding: 10px;
    font-weight: 600;
    font-size: 16px;
}

.timeline > div > .timeline-item > .timeline-body {
    padding: 10px;
}

.timeline > div > .timeline-item > .timeline-footer {
    padding: 10px;
    background: #f4f4f4;
}

.timeline > div > .fa,
.timeline > div > .fas,
.timeline > div > .far,
.timeline > div > .fab,
.timeline > div > .fal,
.timeline > div > .fad,
.timeline > div > .svg-inline--fa {
    width: 30px;
    height: 30px;
    font-size: 15px;
    line-height: 30px;
    position: absolute;
    color: #666;
    background: #d2d6de;
    border-radius: 50%;
    text-align: center;
    left: 18px;
    top: 0;
}

.timeline > .time-label > span {
    font-weight: 600;
    color: #fff;
    border-radius: 4px;
    display: inline-block;
    padding: 5px;
}

.bg-red {
    background-color: #dd4b39 !important;
}

.bg-blue {
    background-color: #0073b7 !important;
}

.info-box {
    border-radius: 10px;
}

.card {
    border-radius: 10px;
}

.nav-pills .nav-link.active {
    background-color: #007bff;
}
</style> 