<!--sidebar end-->
<!--main content start-->
<div class="content-wrapper bg-light">
    <section class="content-header py-4 bg-white shadow-sm">
        <div class="container-fluid">
            <div class="row align-items-center">
                <div class="col-sm-6">
                    <h1 class="display-4 font-weight-black mb-0">
                        <i class="fas fa-key text-primary mr-3"></i>
                        Change Password
                    </h1>
                    <?php if (isset($first_time_login) && $first_time_login): ?>
                        <div class="alert alert-info mt-3">
                            <i class="fas fa-info-circle"></i>
                            <strong>Security Recommendation:</strong> Change your auto-generated password for better security.
                        </div>
                    <?php endif; ?>
                </div>
                <div class="col-sm-6">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb float-sm-right bg-transparent">
                            <li class="breadcrumb-item"><a href="home" class="text-primary">Home</a></li>
                            <li class="breadcrumb-item active font-weight-bold">Change Password</li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
    </section>

    <section class="content py-4">
        <div class="container-fluid">
            <div class="row justify-content-center">
                <div class="col-md-6">
                    <div class="card shadow-lg border-0">
                        <div class="card-header bg-gradient-primary py-4">
                            <h2 class="card-title mb-0 text-white display-6 font-weight-800">
                                <i class="fas fa-shield-alt mr-3"></i>Change Your Password
                            </h2>
                        </div>
                        <div class="card-body bg-light p-5">
                            <?php if ($this->session->flashdata('error_message')): ?>
                                <div class="alert alert-danger alert-dismissible fade show">
                                    <button type="button" class="close" data-dismiss="alert">&times;</button>
                                    <i class="fas fa-exclamation-triangle mr-2"></i>
                                    <?php echo $this->session->flashdata('error_message'); ?>
                                </div>
                            <?php endif; ?>
                            
                            <?php if ($this->session->flashdata('success_message')): ?>
                                <div class="alert alert-success alert-dismissible fade show">
                                    <button type="button" class="close" data-dismiss="alert">&times;</button>
                                    <div class="row align-items-center">
                                        <div class="col-md-8">
                                            <h5 class="alert-heading mb-1">
                                                <i class="fas fa-check-circle mr-2"></i>Success!
                                            </h5>
                                            <p class="mb-0"><?php echo $this->session->flashdata('success_message'); ?></p>
                                        </div>
                                        <div class="col-md-4 text-right">
                                            <a href="patient/medicalHistory" class="btn btn-success btn-sm">
                                                <i class="fas fa-home mr-1"></i>Go to Dashboard
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                            
                            <?php if (validation_errors()): ?>
                                <div class="alert alert-danger alert-dismissible fade show">
                                    <button type="button" class="close" data-dismiss="alert">&times;</button>
                                    <i class="fas fa-exclamation-triangle mr-2"></i>
                                    <?php echo validation_errors(); ?>
                                </div>
                            <?php endif; ?>

                            <form method="post" action="patient/changePassword">
                                <div class="form-group mb-4">
                                    <label class="text-uppercase font-weight-bold text-muted">Current Password <span class="text-danger">*</span></label>
                                    <input type="password" class="form-control form-control-lg shadow-sm" name="current_password" required>
                                    <small class="text-muted">Enter the password sent to your mobile number</small>
                                </div>

                                <div class="form-group mb-4">
                                    <label class="text-uppercase font-weight-bold text-muted">New Password <span class="text-danger">*</span></label>
                                    <input type="password" class="form-control form-control-lg shadow-sm" name="new_password" required>
                                    <small class="text-muted">Minimum 6 characters</small>
                                </div>

                                <div class="form-group mb-4">
                                    <label class="text-uppercase font-weight-bold text-muted">Confirm New Password <span class="text-danger">*</span></label>
                                    <input type="password" class="form-control form-control-lg shadow-sm" name="confirm_password" required>
                                    <small class="text-muted">Re-enter your new password</small>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <button type="submit" class="btn btn-primary btn-lg btn-block shadow-lg py-3">
                                            <i class="fas fa-check mr-3"></i>Change Password
                                        </button>
                                    </div>
                                    <div class="col-md-6">
                                        <a href="patient/medicalHistory" class="btn btn-secondary btn-lg btn-block shadow-lg py-3">
                                            <i class="fas fa-times mr-3"></i>Cancel
                                        </a>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<style>
.card {
    border-radius: 15px;
    overflow: hidden;
}

.card-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
}

.form-control {
    border-radius: 10px;
    border: 1px solid #ddd;
    transition: all 0.3s ease;
}

.form-control:focus {
    border-color: #667eea;
    box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
}

.btn {
    border-radius: 10px;
    transition: all 0.3s ease;
}

.btn-primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border: none;
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 10px 25px rgba(102, 126, 234, 0.3);
}
</style>

<script>
$(document).ready(function() {
    // Clear form fields if password was changed successfully
    <?php if ($this->session->flashdata('success_message')): ?>
        $('input[type="password"]').val('');
    <?php endif; ?>
});
</script> 