<!--sidebar end-->
<!--main content start-->
<link href="common/extranal/css/patient/add_new.css" rel="stylesheet">

<div class="content-wrapper bg-light">
    <section class="content-header py-4 bg-white shadow-sm">
        <div class="container-fluid">
            <div class="row align-items-center">
                <div class="col-sm-6">
                    <h1 class="display-4 font-weight-black mb-0">
                        <i class="fas fa-user-plus mr-3 text-primary"></i>
                        <?php echo lang('new_patient_registration'); ?>
                    </h1>
                </div>
                <div class="col-sm-6">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb float-sm-right bg-transparent">
                            <li class="breadcrumb-item"><a href="home" class="text-primary"><?php echo lang('home'); ?></a></li>
                            <li class="breadcrumb-item"><a href="patient" class="text-primary"><?php echo lang('patients'); ?></a></li>
                            <li class="breadcrumb-item active font-weight-bold"><?php echo lang('new_registration'); ?></li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
    </section>

    <section class="content py-5">
        <div class="container-fluid">
            <div class="row justify-content-center">
                <div class="col-md-10">
                    <div class="card shadow-lg border-0">
                        <div class="card-header bg-gradient-primary py-4">
                            <h2 class="card-title mb-0 text-white display-6 font-weight-800"><?php echo lang('patient_enrollment_form'); ?></h2>
                        </div>
                        <div class="card-body bg-light p-4">
                            <form role="form" action="patient/addNew" method="post" enctype="multipart/form-data" id="patientForm">
                                <input type="hidden" name="id" id="patient_id" value="">

                                <!-- Personal Information -->
                                <div class="row mb-5">
                                    <div class="col-12 mb-4">
                                        <h3 class="border-bottom border-primary pb-3 text-uppercase font-weight-900">
                                            <i class="fas fa-user-circle mr-3 text-primary"></i><?php echo lang('personal_details'); ?>
                                        </h3>
                                    </div>

                                    <div class="col-md-6 mb-4">
                                        <div class="form-group">
                                            <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('full_name'); ?> <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control form-control-lg shadow-sm" name="name" placeholder="<?php echo lang('enter_patient_s_full_name'); ?>" required>
                                        </div>
                                    </div>

                                    <div class="col-md-6 mb-4">
                                        <div class="form-group">
                                            <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('mobile_number'); ?> <span class="text-danger">*</span></label>
                                            <div class="input-group">
                                                <input type="tel" class="form-control form-control-lg shadow-sm" name="phone" id="patient_phone" placeholder="+94 77 123 4567" required>
                                                <div class="input-group-append">
                                                    <button type="button" class="btn btn-info btn-lg" id="checkPhoneBtn">
                                                        <i class="fas fa-search"></i> Check
                                                    </button>
                                                </div>
                                            </div>
                                            <small class="text-muted">Enter mobile number and click "Check" to verify if patient exists.</small>
                                            <div id="phoneCheckResult" class="mt-2" style="display: none;"></div>
                                        </div>
                                    </div>

                                    <div class="col-md-6 mb-4">
                                        <div class="form-group">
                                            <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('email_address'); ?></label>
                                            <input type="email" class="form-control form-control-lg shadow-sm" name="email" placeholder="example@domain.com">
                                            <small class="text-muted">Email is optional and can be same for multiple patients</small>
                                        </div>
                                    </div>

                                    <div class="col-md-6 mb-4">
                                        <div class="form-group">
                                            <div class="alert alert-info">
                                                <i class="fas fa-key"></i>
                                                <strong>Auto-Generated Password:</strong> A 6-digit login password will be automatically generated and sent to the patient's mobile number.
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-6 mb-4">
                                        <div class="form-group">
                                            <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('date_of_birth'); ?></label>
                                            <input type="date" class="form-control form-control-lg shadow-sm" name="birthdate">
                                        </div>
                                    </div>

                                    <div class="col-md-4 mb-4">
                                        <div class="form-group">
                                            <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('national_id'); ?></label>
                                            <input type="text" class="form-control form-control-lg shadow-sm" name="national_id" placeholder="123456789V">
                                        </div>
                                    </div>

                                    <div class="col-md-4 mb-4">
                                        <div class="form-group">
                                            <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('passport_no'); ?></label>
                                            <input type="text" class="form-control form-control-lg shadow-sm" name="passport_no" placeholder="N1234567">
                                        </div>
                                    </div>

                                    <div class="col-md-4 mb-4">
                                        <div class="form-group">
                                            <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('preferred_language'); ?> <span class="text-danger">*</span></label>
                                            <select class="form-control form-control-lg shadow-sm" name="sms_language" required>
                                                <option value="english" selected><?php echo lang('english_lang'); ?></option>
                                                <option value="sinhala"><?php echo lang('sinhala'); ?></option>
                                                <option value="tamil"><?php echo lang('tamil'); ?></option>
                                            </select>
                                            <small class="text-muted">Language for SMS notifications</small>
                                        </div>
                                    </div>
                                </div>

                                <!-- Guardian & Dependent Information -->
                                <div class="row mb-5">
                                    <div class="col-12 mb-4">
                                        <h3 class="border-bottom border-info pb-3 text-uppercase font-weight-900">
                                            <i class="fas fa-users mr-3 text-info"></i>Guardian & Dependent Information
                                        </h3>
                                    </div>

                                    <div class="col-md-6 mb-4">
                                        <div class="form-group">
                                            <label class="text-uppercase font-weight-bold text-muted">Patient Type</label>
                                            <div class="custom-control custom-radio">
                                                <input type="radio" class="custom-control-input" id="independent_patient" name="patient_type" value="independent" checked>
                                                <label class="custom-control-label" for="independent_patient">
                                                    <strong>Independent Patient</strong>
                                                    <br><small class="text-muted">Patient manages their own account</small>
                                                </label>
                                            </div>
                                            <div class="custom-control custom-radio mt-3">
                                                <input type="radio" class="custom-control-input" id="dependent_patient" name="patient_type" value="dependent">
                                                <label class="custom-control-label" for="dependent_patient">
                                                    <strong>Dependent Patient</strong>
                                                    <br><small class="text-muted">Managed by a guardian (children, elderly, etc.)</small>
                                                </label>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-6 mb-4" id="guardian_section" style="display: none;">
                                        <div class="form-group">
                                            <label class="text-uppercase font-weight-bold text-muted">Select Guardian <span class="text-danger">*</span></label>
                                            <select class="form-control form-control-lg shadow-sm js-example-basic-single" name="guardian_patient_id" id="guardian_select">
                                                <option value="">-- Select Guardian --</option>
                                                <?php if (isset($eligible_guardians)) { ?>
                                                    <?php foreach ($eligible_guardians as $guardian) { ?>
                                                        <option value="<?php echo $guardian->id; ?>">
                                                            <?php echo $guardian->name; ?> - <?php echo $guardian->phone; ?> (Age: <?php echo $guardian->age; ?>)
                                                        </option>
                                                    <?php } ?>
                                                <?php } ?>
                                            </select>
                                            <small class="text-muted">Only adult patients (18+) can be guardians</small>
                                        </div>
                                    </div>

                                    <div class="col-md-6 mb-4" id="relationship_section" style="display: none;">
                                        <div class="form-group">
                                            <label class="text-uppercase font-weight-bold text-muted">Relationship to Guardian <span class="text-danger">*</span></label>
                                            <select class="form-control form-control-lg shadow-sm" name="relationship_to_guardian" id="relationship_select">
                                                <option value="">-- Select Relationship --</option>
                                                <option value="son">Son</option>
                                                <option value="daughter">Daughter</option>
                                                <option value="spouse">Spouse</option>
                                                <option value="parent">Parent</option>
                                                <option value="sibling">Sibling</option>
                                                <option value="grandchild">Grandchild</option>
                                                <option value="other">Other</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-6 mb-4" id="emergency_contact_section" style="display: none;">
                                        <div class="form-group">
                                            <label class="text-uppercase font-weight-bold text-muted">Emergency Contact</label>
                                            <input type="text" class="form-control form-control-lg shadow-sm" name="emergency_contact" placeholder="Will use guardian's phone if empty">
                                            <small class="text-muted">Optional: Leave empty to use guardian's phone number</small>
                                        </div>
                                    </div>

                                    <div class="col-md-12 mb-4" id="dependent_note_section" style="display: none;">
                                        <div class="alert alert-info">
                                            <i class="fas fa-info-circle mr-2"></i>
                                            <strong>Note:</strong> Dependent patients can login using their guardian's phone number. 
                                            The guardian will be able to view and manage appointments for this patient.
                                        </div>
                                    </div>
                                </div>

                                <!-- Medical Information -->
                                <div class="row mb-5">
                                    <div class="col-12 mb-4">
                                        <h3 class="border-bottom border-danger pb-3 text-uppercase font-weight-900">
                                            <i class="fas fa-heartbeat mr-3 text-danger"></i><?php echo lang('medical_profile'); ?>
                                        </h3>
                                    </div>

                                    <div class="col-md-3 mb-4">
                                        <div class="form-group">
                                            <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('blood_type'); ?></label>
                                            <select class="form-control form-control-lg shadow-sm" name="bloodgroup">
                                                <option value=""><?php echo lang('select_blood_group'); ?></option>
                                                <?php foreach ($groups as $group) { ?>
                                                    <option value="<?php echo $group->group; ?>"><?php echo $group->group; ?></option>
                                                <?php } ?>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-3 mb-4">
                                        <div class="form-group">
                                            <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('height'); ?> (cm)</label>
                                            <input type="number" class="form-control form-control-lg shadow-sm" name="height" placeholder="175">
                                        </div>
                                    </div>

                                    <div class="col-md-3 mb-4">
                                        <div class="form-group">
                                            <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('weight'); ?> (kg)</label>
                                            <input type="number" class="form-control form-control-lg shadow-sm" name="weight" placeholder="70">
                                        </div>
                                    </div>

                                    <div class="col-md-3 mb-4">
                                        <div class="form-group">
                                            <label class="text-uppercase font-weight-bold text-muted">Gender</label>
                                            <select class="form-control form-control-lg shadow-sm" name="sex">
                                                <option value="Male"><?php echo lang('male'); ?></option>
                                                <option value="Female"><?php echo lang('female'); ?></option>
                                                <option value="Other"><?php echo lang('other'); ?></option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-12 mb-4">
                                        <div class="form-group">
                                            <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('known_allergies'); ?></label>
                                            <textarea class="form-control shadow-sm" name="known_allergies" rows="3" placeholder="<?php echo lang('list_any_known_allergies_or_sensitivities'); ?>"></textarea>
                                        </div>
                                    </div>

                                    <div class="col-md-12 mb-4">
                                        <div class="form-group">
                                            <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('medical_history'); ?></label>
                                            <textarea class="form-control shadow-sm" name="medical_history" rows="3" placeholder="<?php echo lang('brief_medical_history_or_ongoing_conditions'); ?>"></textarea>
                                        </div>
                                    </div>
                                </div>

                                <!-- Contact Information -->
                                <div class="row mb-5">
                                    <div class="col-12 mb-4">
                                        <h3 class="border-bottom border-success pb-3 text-uppercase font-weight-900">
                                            <i class="fas fa-map-marked-alt mr-3 text-success"></i><?php echo lang('contact_information'); ?>
                                        </h3>
                                    </div>

                                    <div class="col-md-12 mb-4">
                                        <div class="form-group">
                                            <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('residential_address'); ?></label>
                                            <textarea class="form-control shadow-sm" name="address" rows="3" placeholder="<?php echo lang('complete_residential_address'); ?>"></textarea>
                                        </div>
                                    </div>

                                    <div class="col-md-6 mb-4">
                                        <div class="form-group">
                                            <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('emergency_contact_name'); ?></label>
                                            <input type="text" class="form-control form-control-lg shadow-sm" name="emergency_contact_name" placeholder="<?php echo lang('emergency_contact_person'); ?>">
                                        </div>
                                    </div>

                                    <div class="col-md-6 mb-4">
                                        <div class="form-group">
                                            <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('emergency_contact_number'); ?></label>
                                            <input type="tel" class="form-control form-control-lg shadow-sm" name="emergency_contact_number" placeholder="<?php echo lang('emergency_contact_number'); ?>">
                                        </div>
                                    </div>
                                </div>

                                <!-- Profile Image -->
                                <div class="row mb-5">
                                    <div class="col-12 mb-4">
                                        <h3 class="border-bottom border-info pb-3 text-uppercase font-weight-900">
                                            <i class="fas fa-camera mr-3 text-info"></i><?php echo lang('profile_photo'); ?>
                                        </h3>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" name="img_url" id="customFile">
                                            <label class="custom-file-label shadow-sm" for="customFile"><?php echo lang('choose_profile_picture'); ?></label>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-12">
                                        <button type="submit" class="btn btn-primary btn-lg btn-block shadow-lg py-3">
                                            <i class="fas fa-user-plus mr-3"></i><?php echo lang('register_patient'); ?>
                                        </button>
                                    </div>
                                </div>

                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!--main content end-->





<!-- Dependent Patient JavaScript -->
<script>
$(document).ready(function() {
    // Handle patient type radio button changes
    $('input[name="patient_type"]').change(function() {
        const isDependent = $(this).val() === 'dependent';
        
        if (isDependent) {
            $('#guardian_section').slideDown();
            $('#relationship_section').slideDown();
            $('#emergency_contact_section').slideDown();
            $('#dependent_note_section').slideDown();
            
            // Make guardian and relationship required
            $('#guardian_select').attr('required', true);
            $('#relationship_select').attr('required', true);
            
            // Optional: Clear phone requirement for dependents
            $('input[name="phone"]').attr('required', false);
            $('input[name="phone"]').closest('.form-group').find('label').html(
                $('input[name="phone"]').closest('.form-group').find('label').html().replace(' <span class="text-danger">*</span>', '')
            );
        } else {
            $('#guardian_section').slideUp();
            $('#relationship_section').slideUp();
            $('#emergency_contact_section').slideUp();
            $('#dependent_note_section').slideUp();
            
            // Remove required attributes
            $('#guardian_select').attr('required', false);
            $('#relationship_select').attr('required', false);
            
            // Make phone required for independent patients
            $('input[name="phone"]').attr('required', true);
            if ($('input[name="phone"]').closest('.form-group').find('label').html().indexOf('*') === -1) {
                $('input[name="phone"]').closest('.form-group').find('label').append(' <span class="text-danger">*</span>');
            }
        }
    });

    // Handle form submission validation
    $('form').submit(function(e) {
        const isDependent = $('input[name="patient_type"]:checked').val() === 'dependent';
        
        if (isDependent) {
            const guardianId = $('#guardian_select').val();
            const relationship = $('#relationship_select').val();
            
            if (!guardianId) {
                alert('Please select a guardian for the dependent patient.');
                e.preventDefault();
                return false;
            }
            
            if (!relationship) {
                alert('Please specify the relationship to the guardian.');
                e.preventDefault();
                return false;
            }
        }
    });

    // Auto-fill emergency contact when guardian is selected
    $('#guardian_select').change(function() {
        const selectedOption = $(this).find('option:selected');
        const guardianPhone = selectedOption.text().match(/- (\d+)/);
        
        if (guardianPhone && !$('input[name="emergency_contact"]').val()) {
            $('input[name="emergency_contact"]').val(guardianPhone[1]);
        }
    });

    // Phone number check functionality
    $('#checkPhoneBtn').click(function() {
        var phone = $('#patient_phone').val().trim();
        var $btn = $(this);
        var $result = $('#phoneCheckResult');
        
        if (!phone) {
            $result.html('<div class="alert alert-warning"><i class="fas fa-exclamation-triangle"></i> Please enter a mobile number first.</div>').show();
            return;
        }
        
        // Show loading state
        $btn.prop('disabled', true).html('<i class="fas fa-spinner fa-spin"></i> Checking...');
        $result.html('<div class="alert alert-info"><i class="fas fa-spinner fa-spin"></i> Checking phone number...</div>').show();
        
        $.ajax({
            url: '<?php echo base_url(); ?>patient/checkExistingPatientByPhone',
            type: 'POST',
            data: { phone: phone },
            dataType: 'json',
            success: function(response) {
                $btn.prop('disabled', false).html('<i class="fas fa-search"></i> Check');
                
                if (response.exists) {
                    if (response.is_patient) {
                        // Patient exists - populate form and switch to update mode
                        var patient = response.patient;
                        
                        // Show simple success message with patient info
                        $result.html(`
                            <div class="alert alert-success border-0 shadow">
                                <div class="row align-items-center">
                                    <div class="col-md-2 text-center">
                                        <i class="fas fa-user-check text-success" style="font-size: 2rem;"></i>
                                    </div>
                                    <div class="col-md-10">
                                        <h5 class="alert-heading mb-2">
                                            <i class="fas fa-check-circle mr-2"></i>Patient Found!
                                        </h5>
                                        <p class="mb-2">
                                            <strong>Name:</strong> ${patient.name}<br>
                                            <strong>Phone:</strong> ${patient.phone}<br>
                                            <strong>Patient ID:</strong> ${patient.patient_id || 'Not assigned'}
                                        </p>
                                        <hr class="my-2">
                                        <p class="mb-0 text-muted">
                                            <i class="fas fa-info-circle mr-1"></i>
                                            Form populated with existing data. You can update any information as needed.
                                        </p>
                                    </div>
                                </div>
                            </div>
                        `);
                        
                        // Simple form population without animations
                        populateForm(patient);
                        
                        function populateForm(patient) {
                            var fields = [
                                { selector: '#patient_id', value: patient.id },
                                { selector: 'input[name="name"]', value: patient.name || '', label: 'Patient Name' },
                                { selector: 'input[name="email"]', value: patient.email || '', label: 'Email' },
                                { selector: 'input[name="phone"]', value: patient.phone || '', label: 'Phone' },
                                { selector: 'textarea[name="address"]', value: patient.address || '', label: 'Address' },
                                { selector: 'input[name="birthdate"]', value: patient.birthdate || '', label: 'Date of Birth' },
                                { selector: 'select[name="sex"]', value: patient.sex || '', label: 'Gender' },
                                { selector: 'input[name="p_id"]', value: patient.patient_id || '', label: 'Patient ID' },
                                { selector: 'input[name="national_id"]', value: patient.national_id || '', label: 'National ID' },
                                { selector: 'input[name="passport_no"]', value: patient.passport_no || '', label: 'Passport No' },
                                { selector: 'select[name="sms_language"]', value: patient.sms_language || 'english', label: 'Language' },
                                { selector: 'select[name="bloodgroup"]', value: patient.blood_group || '', label: 'Blood Group' },
                                { selector: 'input[name="height"]', value: patient.height || '', label: 'Height' },
                                { selector: 'input[name="weight"]', value: patient.weight || '', label: 'Weight' },
                                { selector: 'textarea[name="known_allergies"]', value: patient.known_allergies || '', label: 'Allergies' },
                                { selector: 'textarea[name="medical_history"]', value: patient.medical_history || '', label: 'Medical History' },
                                { selector: 'input[name="emergency_contact_name"]', value: patient.emergency_contact_name || '', label: 'Emergency Contact Name' },
                                { selector: 'input[name="emergency_contact_number"]', value: patient.emergency_contact_number || '', label: 'Emergency Contact Number' }
                            ];
                            
                            var currentField = 0;
                            
                            function populateNextField() {
                                if (currentField < fields.length) {
                                    var field = fields[currentField];
                                    var $field = $(field.selector);
                                    
                                    if ($field.length && field.value) {
                                        // Dramatic highlight animation
                                        $field.addClass('border-warning shadow-lg animate__animated animate__pulse').css({
                                            'background-color': '#fff3cd',
                                            'transition': 'all 0.3s ease',
                                            'border-width': '3px',
                                            'transform': 'scale(1.02)'
                                        });
                                        
                                        // Add glow effect
                                        $field.parent().css({
                                            'box-shadow': '0 0 20px rgba(255, 193, 7, 0.5)',
                                            'border-radius': '8px'
                                        });
                                        
                                        // Populate the field with faster typing effect for text inputs
                                        if ($field.is('input[type="text"], input[type="email"], input[type="tel"]') && field.value.length > 0) {
                                            $field.val('');
                                            var chars = field.value.split('');
                                            var charIndex = 0;
                                            var typingInterval = setInterval(function() {
                                                $field.val($field.val() + chars[charIndex]);
                                                charIndex++;
                                                if (charIndex >= chars.length) {
                                                    clearInterval(typingInterval);
                                                }
                                            }, 15); // Faster typing
                                        } else {
                                            $field.val(field.value);
                                        }
                                        
                                        // Show field label in overlay with animation
                                        if (field.label) {
                                            $('#populationOverlay h3').addClass('animate__animated animate__bounceIn')
                                                                     .html(`<i class="fas fa-edit mr-2 animate__animated animate__spin"></i>Populating: ${field.label}`);
                                        }
                                        
                                        // Remove highlight after a shorter moment
                                        setTimeout(function() {
                                            $field.removeClass('border-warning animate__pulse').css({
                                                'background-color': '',
                                                'transition': 'all 0.3s ease',
                                                'border-width': '',
                                                'transform': ''
                                            });
                                            $field.parent().css({
                                                'box-shadow': '',
                                                'border-radius': ''
                                            });
                                            
                                            // Add success checkmark (faster)
                                            $field.parent().append('<i class="fas fa-check text-success position-absolute animate__animated animate__bounceIn" style="right: 10px; top: 50%; transform: translateY(-50%); z-index: 10;"></i>');
                                            setTimeout(function() {
                                                $field.parent().find('.fa-check').fadeOut(200, function() {
                                                    $(this).remove();
                                                });
                                            }, 400);
                                        }, 400);
                                    }
                                    
                                    currentField++;
                                    setTimeout(populateNextField, 150); // Faster delay between fields
                                } else {
                                    // All fields populated, handle dependent information
                                    if (patient.is_dependent === 'yes') {
                                        $('input[name="patient_type"][value="dependent"]').prop('checked', true);
                                        $('select[name="guardian_patient_id"]').val(patient.guardian_patient_id || '');
                                        $('select[name="relationship_to_guardian"]').val(patient.relationship_to_guardian || '');
                                        $('input[name="emergency_contact"]').val(patient.emergency_contact || '');
                                        
                                        // Show guardian sections with animation
                                        $('#guardian_section, #relationship_section, #emergency_contact_section, #dependent_note_section')
                                            .addClass('animate__animated animate__fadeInRight').show();
                                    } else {
                                        $('input[name="patient_type"][value="independent"]').prop('checked', true);
                                    }
                                    
                                    // Update form title and submit button with animation
                                    $('.card-title').addClass('animate__animated animate__pulse')
                                                   .html('<i class="fas fa-user-edit text-warning"></i> Update Patient Information');
                                    $('button[type="submit"]').addClass('animate__animated animate__heartBeat btn-warning')
                                                              .html('<i class="fas fa-save"></i> Update Patient');
                                    
                                    // Store original data for comparison
                                    $('#patientForm').data('originalData', patient);
                                    
                                    // Remove overlay with success message (faster)
                                    setTimeout(function() {
                                        $('#populationOverlay h3').html('<i class="fas fa-check-circle mr-2 text-success"></i>Population Complete!');
                                        $('#populationOverlay p').html('<strong class="text-success">All patient data has been loaded successfully!</strong>');
                                        $('.spinner-border').removeClass('text-warning').addClass('d-none');
                                        $('.progress').html('<div class="alert alert-success mb-0 py-2"><i class="fas fa-check mr-2"></i>Ready to Update</div>');
                                        
                                        setTimeout(function() {
                                            $('#populationOverlay').fadeOut(300, function() {
                                                $(this).remove();
                                            });
                                            
                                            // Final success message update
                                            $result.html(`
                                                <div class="alert alert-success border-0 shadow-lg animate__animated animate__pulse">
                                                    <div class="row align-items-center">
                                                        <div class="col-auto">
                                                            <div class="bg-white rounded-circle p-3 shadow-sm">
                                                                <i class="fas fa-user-edit text-success fa-2x"></i>
                                                            </div>
                                                        </div>
                                                        <div class="col">
                                                            <h5 class="mb-1 text-success font-weight-bold">
                                                                <i class="fas fa-check-circle mr-2"></i>Patient Data Loaded!
                                                            </h5>
                                                            <p class="mb-1"><strong>Name:</strong> ${patient.name}</p>
                                                            <p class="mb-0 text-muted">
                                                                <i class="fas fa-edit mr-1"></i>
                                                                <strong>Form is ready for updates. Make your changes and click "Update Patient".</strong>
                                                            </p>
                                                        </div>
                                                    </div>
                                                </div>
                                            `);
                                        }, 800);
                                    }, 500);
                                }
                            }
                            
                            populateNextField();
                        }
                        
                    } else {
                        // Phone belongs to other user type
                        $result.html('<div class="alert alert-danger"><i class="fas fa-exclamation-circle"></i> <strong>Phone Number Occupied!</strong> This mobile number is already registered by another type of user (Doctor, Admin, etc.). Please use a different number.</div>');
                        clearForm();
                    }
                } else {
                    // New patient - can proceed with registration
                    $result.html('<div class="alert alert-success"><i class="fas fa-plus-circle"></i> <strong>New Patient!</strong> This mobile number is available. You can proceed with registration.</div>');
                    clearForm();
                    $('.card-title').html('<i class="fas fa-user-plus"></i> <?php echo lang('patient_enrollment_form'); ?>');
                    $('button[type="submit"]').html('<i class="fas fa-save"></i> Register Patient');
                }
            },
            error: function() {
                $btn.prop('disabled', false).html('<i class="fas fa-search"></i> Check');
                $result.html('<div class="alert alert-danger"><i class="fas fa-exclamation-triangle"></i> Error checking phone number. Please try again.</div>');
            }
        });
    });
    
    // Function to clear form except phone number
    function clearForm() {
        $('#patient_id').val('');
        $('input[name="name"]').val('');
        $('input[name="email"]').val('');
        $('textarea[name="address"]').val('');
        $('input[name="birthdate"]').val('');
        $('select[name="sex"]').val('');
        $('input[name="p_id"]').val('');
        
        // Additional personal information
        $('input[name="national_id"]').val('');
        $('input[name="passport_no"]').val('');
        $('select[name="sms_language"]').val('english');
        
        // Medical information
        $('select[name="bloodgroup"]').val('');
        $('input[name="height"]').val('');
        $('input[name="weight"]').val('');
        $('textarea[name="known_allergies"]').val('');
        $('textarea[name="medical_history"]').val('');
        
        // Contact information
        $('input[name="emergency_contact_name"]').val('');
        $('input[name="emergency_contact_number"]').val('');
        
        // Guardian/Dependent information
        $('input[name="patient_type"][value="independent"]').prop('checked', true);
        $('select[name="guardian_patient_id"]').val('');
        $('select[name="relationship_to_guardian"]').val('');
        $('input[name="emergency_contact"]').val('');
        
        // Hide guardian sections
        $('#guardian_section').hide();
        $('#relationship_section').hide();
        $('#emergency_contact_section').hide();
        $('#dependent_note_section').hide();
        
        $('#patientForm').removeData('originalData');
    }
    
    // Handle form submission to check for changes and send SMS
    $('#patientForm').submit(function(e) {
        var originalData = $(this).data('originalData');
        var patientId = $('#patient_id').val();
        
        // If updating existing patient, check for changes
        if (patientId && originalData) {
            var currentData = {
                name: $('input[name="name"]').val(),
                email: $('input[name="email"]').val(),
                phone: $('input[name="phone"]').val(),
                address: $('textarea[name="address"]').val(),
                birthdate: $('input[name="birthdate"]').val(),
                sex: $('select[name="sex"]').val(),
                national_id: $('input[name="national_id"]').val(),
                passport_no: $('input[name="passport_no"]').val(),
                sms_language: $('select[name="sms_language"]').val(),
                blood_group: $('select[name="bloodgroup"]').val(),
                height: $('input[name="height"]').val(),
                weight: $('input[name="weight"]').val(),
                known_allergies: $('textarea[name="known_allergies"]').val(),
                medical_history: $('textarea[name="medical_history"]').val(),
                emergency_contact_name: $('input[name="emergency_contact_name"]').val(),
                emergency_contact_number: $('input[name="emergency_contact_number"]').val(),
                emergency_contact: $('input[name="emergency_contact"]').val(),
                guardian_patient_id: $('select[name="guardian_patient_id"]').val(),
                relationship_to_guardian: $('select[name="relationship_to_guardian"]').val()
            };
            
            // Check if any data has changed
            var hasChanges = false;
            for (var key in currentData) {
                if (currentData[key] != (originalData[key] || '')) {
                    hasChanges = true;
                    break;
                }
            }
            
            // Add a hidden field to indicate if SMS should be sent
            if (hasChanges) {
                $('<input>').attr({
                    type: 'hidden',
                    name: 'send_update_sms',
                    value: '1'
                }).appendTo(this);
            }
        }
        
        return true; // Allow form submission
    });
});
</script>

<!--footer start-->