<div class="content-wrapper">
    <section class="content-header">
        <h1><?php echo lang('otp_settings') ?: 'OTP Settings'; ?></h1>
        <ol class="breadcrumb">
            <li><a href="#"><i class="fa fa-dashboard"></i> <?php echo lang('home') ?: 'Home'; ?></a></li>
            <li class="active"><?php echo lang('otp_settings') ?: 'OTP Settings'; ?></li>
        </ol>
    </section>

    <section class="content">
        <div class="row">
            <div class="col-md-8">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title"><?php echo lang('otp_configuration') ?: 'OTP Configuration'; ?></h3>
                    </div>
                    
                    <?php echo form_open('otp/saveSettings', array('role' => 'form')); ?>
                    <div class="box-body">
                        
                        <div class="form-group">
                            <label>
                                <input type="checkbox" name="otp_enabled" value="1" <?php echo (!empty($otp_settings) && $otp_settings->otp_enabled) ? 'checked' : ''; ?>>
                                <?php echo lang('enable_otp_verification') ?: 'Enable OTP Verification'; ?>
                            </label>
                            <p class="help-block"><?php echo lang('otp_enable_help') ?: 'Enable or disable OTP verification for user registration and authentication'; ?></p>
                        </div>

                        <div class="form-group">
                            <label for="otp_length"><?php echo lang('otp_length') ?: 'OTP Length'; ?> <span class="text-red">*</span></label>
                            <input type="number" class="form-control" name="otp_length" id="otp_length" 
                                   value="<?php echo !empty($otp_settings) ? $otp_settings->otp_length : '6'; ?>"
                                   min="4" max="10" required>
                            <p class="help-block"><?php echo lang('otp_length_help') ?: 'Number of digits in OTP code (4-10)'; ?></p>
                        </div>

                        <div class="form-group">
                            <label for="otp_expiry_minutes"><?php echo lang('otp_expiry_minutes') ?: 'OTP Expiry (Minutes)'; ?> <span class="text-red">*</span></label>
                            <input type="number" class="form-control" name="otp_expiry_minutes" id="otp_expiry_minutes" 
                                   value="<?php echo !empty($otp_settings) ? $otp_settings->otp_expiry_minutes : '5'; ?>"
                                   min="1" max="60" required>
                            <p class="help-block"><?php echo lang('otp_expiry_help') ?: 'How long OTP remains valid (1-60 minutes)'; ?></p>
                        </div>

                        <div class="form-group">
                            <label for="max_attempts"><?php echo lang('max_attempts') ?: 'Maximum Attempts'; ?> <span class="text-red">*</span></label>
                            <input type="number" class="form-control" name="max_attempts" id="max_attempts" 
                                   value="<?php echo !empty($otp_settings) ? $otp_settings->max_attempts : '3'; ?>"
                                   min="1" max="10" required>
                            <p class="help-block"><?php echo lang('max_attempts_help') ?: 'Maximum number of OTP verification attempts allowed'; ?></p>
                        </div>

                        <div class="form-group">
                            <label for="resend_cooldown_seconds"><?php echo lang('resend_cooldown') ?: 'Resend Cooldown (Seconds)'; ?> <span class="text-red">*</span></label>
                            <input type="number" class="form-control" name="resend_cooldown_seconds" id="resend_cooldown_seconds" 
                                   value="<?php echo !empty($otp_settings) ? $otp_settings->resend_cooldown_seconds : '60'; ?>"
                                   min="10" max="300" required>
                            <p class="help-block"><?php echo lang('resend_cooldown_help') ?: 'Time to wait before allowing OTP resend (10-300 seconds)'; ?></p>
                        </div>

                        <div class="form-group">
                            <label for="message_template"><?php echo lang('message_template') ?: 'SMS Message Template'; ?> <span class="text-red">*</span></label>
                            <textarea class="form-control" name="message_template" id="message_template" rows="4" required><?php echo !empty($otp_settings) ? htmlspecialchars($otp_settings->message_template) : 'Your OTP verification code is: {otp_code}. Valid for {expiry_minutes} minutes. Do not share this code with anyone.'; ?></textarea>
                            <p class="help-block">
                                <?php echo lang('message_template_help') ?: 'Available placeholders: {otp_code}, {expiry_minutes}'; ?>
                            </p>
                        </div>

                    </div>
                    <div class="box-footer">
                        <button type="submit" class="btn btn-primary">
                            <i class="fa fa-save"></i> <?php echo lang('save_settings') ?: 'Save Settings'; ?>
                        </button>
                        <a href="<?php echo base_url('otp'); ?>" class="btn btn-default">
                            <i class="fa fa-arrow-left"></i> <?php echo lang('back') ?: 'Back'; ?>
                        </a>
                    </div>
                    <?php echo form_close(); ?>
                </div>
            </div>

            <div class="col-md-4">
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title"><?php echo lang('test_otp') ?: 'Test OTP'; ?></h3>
                    </div>
                    <div class="box-body">
                        <div class="form-group">
                            <label for="test_phone"><?php echo lang('phone_number') ?: 'Phone Number'; ?></label>
                            <input type="text" class="form-control" id="test_phone" placeholder="Enter phone number">
                        </div>
                        <button type="button" class="btn btn-info btn-block" onclick="sendTestOTP()">
                            <i class="fa fa-paper-plane"></i> <?php echo lang('send_test_otp') ?: 'Send Test OTP'; ?>
                        </button>
                        
                        <div id="verify_section" style="display: none; margin-top: 15px;">
                            <div class="form-group">
                                <label for="test_otp_code"><?php echo lang('otp_code') ?: 'OTP Code'; ?></label>
                                <input type="text" class="form-control" id="test_otp_code" placeholder="Enter OTP code">
                            </div>
                            <button type="button" class="btn btn-success btn-block" onclick="verifyTestOTP()">
                                <i class="fa fa-check"></i> <?php echo lang('verify_otp') ?: 'Verify OTP'; ?>
                            </button>
                        </div>
                        
                        <div id="test_result" style="margin-top: 15px;"></div>
                    </div>
                </div>

                <div class="box box-warning">
                    <div class="box-header with-border">
                        <h3 class="box-title"><?php echo lang('prerequisites') ?: 'Prerequisites'; ?></h3>
                    </div>
                    <div class="box-body">
                        <ul class="list-unstyled">
                            <li><i class="fa fa-check text-green"></i> SMS Gateway configured</li>
                            <li><i class="fa fa-check text-green"></i> OTP tables created</li>
                            <li><i class="fa fa-info-circle text-blue"></i> Test with a real phone number</li>
                        </ul>
                        <a href="<?php echo base_url('sms'); ?>" class="btn btn-sm btn-warning">
                            <i class="fa fa-cog"></i> <?php echo lang('sms_settings') ?: 'SMS Settings'; ?>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script>
function sendTestOTP() {
    const phone = document.getElementById('test_phone').value.trim();
    if (!phone) {
        toastr.error('Please enter a phone number');
        return;
    }
    
    const btn = event.target;
    btn.disabled = true;
    btn.innerHTML = '<i class="fa fa-spinner fa-spin"></i> Sending...';
    
    $.ajax({
        url: '<?php echo base_url('otp/testOTP'); ?>',
        method: 'POST',
        data: { phone: phone },
        dataType: 'json',
        success: function(response) {
            if (response.success) {
                toastr.success(response.message || 'Test OTP sent successfully');
                document.getElementById('verify_section').style.display = 'block';
                document.getElementById('test_result').innerHTML = 
                    '<div class="alert alert-success"><i class="fa fa-check"></i> OTP sent to ' + phone + '</div>';
            } else {
                toastr.error(response.message || 'Failed to send test OTP');
                document.getElementById('test_result').innerHTML = 
                    '<div class="alert alert-danger"><i class="fa fa-times"></i> ' + (response.message || 'Failed to send test OTP') + '</div>';
            }
        },
        error: function() {
            toastr.error('Network error occurred');
            document.getElementById('test_result').innerHTML = 
                '<div class="alert alert-danger"><i class="fa fa-times"></i> Network error occurred</div>';
        },
        complete: function() {
            btn.disabled = false;
            btn.innerHTML = '<i class="fa fa-paper-plane"></i> <?php echo lang('send_test_otp') ?: 'Send Test OTP'; ?>';
        }
    });
}

function verifyTestOTP() {
    const phone = document.getElementById('test_phone').value.trim();
    const otp_code = document.getElementById('test_otp_code').value.trim();
    
    if (!phone || !otp_code) {
        toastr.error('Please enter both phone number and OTP code');
        return;
    }
    
    const btn = event.target;
    btn.disabled = true;
    btn.innerHTML = '<i class="fa fa-spinner fa-spin"></i> Verifying...';
    
    $.ajax({
        url: '<?php echo base_url('otp/verifyTestOTP'); ?>',
        method: 'POST',
        data: { phone: phone, otp_code: otp_code },
        dataType: 'json',
        success: function(response) {
            if (response.success) {
                toastr.success(response.message || 'OTP verified successfully');
                document.getElementById('test_result').innerHTML = 
                    '<div class="alert alert-success"><i class="fa fa-check"></i> OTP verified successfully!</div>';
                document.getElementById('verify_section').style.display = 'none';
                document.getElementById('test_otp_code').value = '';
            } else {
                toastr.error(response.message || 'Invalid OTP code');
                document.getElementById('test_result').innerHTML = 
                    '<div class="alert alert-danger"><i class="fa fa-times"></i> ' + (response.message || 'Invalid OTP code') + '</div>';
            }
        },
        error: function() {
            toastr.error('Network error occurred');
            document.getElementById('test_result').innerHTML = 
                '<div class="alert alert-danger"><i class="fa fa-times"></i> Network error occurred</div>';
        },
        complete: function() {
            btn.disabled = false;
            btn.innerHTML = '<i class="fa fa-check"></i> <?php echo lang('verify_otp') ?: 'Verify OTP'; ?>';
        }
    });
}
</script>