<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Otp extends MX_Controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->model('otp_model');
        $this->load->library('otp_lib');
        
        // Check if user is logged in
        if (!$this->ion_auth->logged_in()) {
            redirect('auth/login');
        }
    }

    public function index()
    {
        $data = array();
        $data['settings'] = $this->settings_model->getSettings();
        $data['otp_settings'] = $this->otp_model->getOTPSettingsByHospitalId($this->session->userdata('hospital_id'));
        $data['otp_logs'] = $this->otp_model->getOTPLogs($this->session->userdata('hospital_id'), 50); // Last 50 logs
        
        $this->load->view('home/dashboard');
        $this->load->view('otp_settings', $data);
        $this->load->view('home/footer');
    }

    public function settings()
    {
        $data = array();
        $data['settings'] = $this->settings_model->getSettings();
        $data['otp_settings'] = $this->otp_model->getOTPSettingsByHospitalId($this->session->userdata('hospital_id'));
        
        $this->load->view('home/dashboard');
        $this->load->view('otp_settings_form', $data);
        $this->load->view('home/footer');
    }

    public function saveSettings()
    {
        $this->form_validation->set_rules('otp_enabled', 'OTP Enabled', 'trim|numeric');
        $this->form_validation->set_rules('otp_length', 'OTP Length', 'trim|required|numeric|greater_than[3]|less_than[11]');
        $this->form_validation->set_rules('otp_expiry_minutes', 'OTP Expiry Minutes', 'trim|required|numeric|greater_than[0]|less_than[61]');
        $this->form_validation->set_rules('max_attempts', 'Max Attempts', 'trim|required|numeric|greater_than[0]|less_than[11]');
        $this->form_validation->set_rules('resend_cooldown_seconds', 'Resend Cooldown', 'trim|required|numeric|greater_than[9]|less_than[301]');
        $this->form_validation->set_rules('message_template', 'Message Template', 'trim|required|min_length[10]');

        if ($this->form_validation->run() == FALSE) {
            $this->settings();
        } else {
            $hospital_id = $this->session->userdata('hospital_id');
            
            $data = array(
                'hospital_id' => $hospital_id,
                'otp_enabled' => $this->input->post('otp_enabled') ? 1 : 0,
                'otp_length' => $this->input->post('otp_length'),
                'otp_expiry_minutes' => $this->input->post('otp_expiry_minutes'),
                'max_attempts' => $this->input->post('max_attempts'),
                'resend_cooldown_seconds' => $this->input->post('resend_cooldown_seconds'),
                'message_template' => $this->input->post('message_template')
            );

            // Check if settings exist
            $existing_settings = $this->otp_model->getOTPSettingsByHospitalId($hospital_id);
            
            if ($existing_settings) {
                $this->otp_model->updateOTPSettings($hospital_id, $data);
                show_swal(lang('updated'), 'success', lang('updated'));
            } else {
                $this->otp_model->addOTPSettings($data);
                show_swal(lang('added'), 'success', lang('added'));
            }
            
            redirect('otp/settings');
        }
    }

    public function testOTP()
    {
        header('Content-Type: application/json');
        
        $phone = $this->input->post('phone');
        $purpose = 'admin_test';
        
        if (empty($phone)) {
            echo json_encode(array('success' => false, 'message' => 'Phone number is required'));
            return;
        }
        
        $hospital_id = $this->session->userdata('hospital_id');
        $result = $this->otp_lib->generateAndSendOTP($phone, $purpose, $hospital_id);
        
        echo json_encode($result);
    }

    public function verifyTestOTP()
    {
        header('Content-Type: application/json');
        
        $phone = $this->input->post('phone');
        $otp_code = $this->input->post('otp_code');
        $purpose = 'admin_test';
        
        if (empty($phone) || empty($otp_code)) {
            echo json_encode(array('success' => false, 'message' => 'Phone number and OTP code are required'));
            return;
        }
        
        $result = $this->otp_lib->verifyOTP($phone, $otp_code, $purpose);
        
        echo json_encode($result);
    }

    public function logs()
    {
        $data = array();
        $data['settings'] = $this->settings_model->getSettings();
        $data['otp_logs'] = $this->otp_model->getOTPLogs($this->session->userdata('hospital_id'), 100);
        
        $this->load->view('home/dashboard');
        $this->load->view('otp_logs', $data);
        $this->load->view('home/footer');
    }
}