<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Notice extends MX_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('notice_model');
        if (!$this->ion_auth->in_group(array('admin', 'Nurse', 'Accountant', 'Doctor','Receptionist', 'Laboratorist', 'im', 'Patient', 'Pharmacist'))) {
            redirect('home/permission');
        }
    }

    public function index() {
        if ($this->ion_auth->in_group(array('Patient'))) {
            $user_id = $this->ion_auth->user()->row()->id;
            $patient_id = $this->db->get_where('patient', array('ion_user_id' => $user_id))->row()->id;
            
            // Hospital selection logic
            $selected_hospital = $this->input->get('hospital_id');
            $data['hospitals'] = $this->db->get('hospital')->result();
            
            // Set default hospital if none selected
            if (empty($selected_hospital)) {
                $current_hospital_id = $this->session->userdata('hospital_id');
                if (empty($current_hospital_id)) {
                    $patient_data = $this->db->get_where('patient', array('ion_user_id' => $user_id))->row();
                    $current_hospital_id = $patient_data->hospital_id;
                    $this->session->set_userdata('hospital_id', $current_hospital_id);
                }
                $selected_hospital = $current_hospital_id;
            }
            $data['selected_hospital'] = $selected_hospital;
            
            // Set hospital context and get data
            if ($selected_hospital === 'consolidated') {
                $this->session->unset_userdata('hospital_id');
                $data['notices'] = $this->getConsolidatedNotices();
            } else {
                $this->session->set_userdata('hospital_id', $selected_hospital);
                $data['notices'] = $this->notice_model->getNotice();
            }
            
            $data['patient_id'] = $patient_id;
        } else {
            $data['notices'] = $this->notice_model->getNotice();
        }

        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data); 
        $this->load->view('notice', $data);
        $this->load->view('home/footer'); 
    }

    public function addNewView() {
        $data['notices'] = $this->notice_model->getNotice();
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard', $data); 
        $this->load->view('add_new');
        $this->load->view('home/footer'); 
    }

    public function addNew() {

        $id = $this->input->post('id');
        $title = $this->input->post('title');
        $description = $this->input->post('description');
        $date = $this->input->post('date');
        if (!empty($date)) {
            $date = strtotime($date);
        } else {
            $date = time();
        }
        $type = $this->input->post('type');
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');

        // Validating Title Field
        $this->form_validation->set_rules('title', 'Title', 'trim|required|min_length[5]|max_length[100]|xss_clean');
        // Validating Description Field
        $this->form_validation->set_rules('description', 'Description', 'trim|required|min_length[5]|max_length[100]|xss_clean');
        // Validating date Field
        $this->form_validation->set_rules('date', 'date', 'trim|required|min_length[5]|max_length[100]|xss_clean');


        if ($this->form_validation->run() == FALSE) {
            if (!empty($id)) {
                redirect("notice/editNotice?id=$id");
            } else {
                $this->load->view('home/dashboard'); 
                $this->load->view('add_new');
                $this->load->view('home/footer'); 
            }
        } else {

            
            $data = array();
            $data = array(
                'title' => $title,
                'description' => $description,
                'date' => $date,
                'type' => $type
            );



            if (empty($id)) {     // Adding New Notice
                $this->notice_model->insertNotice($data);
                show_swal(lang('added'), 'success', lang('added'));
            } else { // Updating Notice
                $this->notice_model->updateNotice($id, $data);
               show_swal(lang('updated'), 'success', lang('updated'));
            }
            // Loading View
            redirect('notice'); 
        }
    }

    function getNotice() {
        $data['notices'] = $this->notice_model->getNotice();
        $this->load->view('notice', $data);
    }

    function editNotice() {
        $data = array();
        $id = $this->input->get('id');
        $data['notice'] = $this->notice_model->getNoticeById($id);
        $this->load->view('home/dashboard'); 
        $this->load->view('add_new', $data);
        $this->load->view('home/footer'); 
    }

    function editNoticeByJason() {
        $id = $this->input->get('id');
        $data['notice'] = $this->notice_model->getNoticeById($id);
        echo json_encode($data);
    }

    function delete() {
        $data = array();
        $id = $this->input->get('id');
        $this->notice_model->delete($id);
       show_swal(lang('deleted'), 'warning', lang('deleted'));
        redirect('notice');
    }

    // Consolidated helper function for notices
    private function getConsolidatedNotices()
    {
        try {
            $this->db->select('notice.*, hospital.name as hospital_name');
            $this->db->from('notice');
            $this->db->join('hospital', 'notice.hospital_id = hospital.id', 'left');
            $this->db->order_by('notice.date', 'desc');
            return $this->db->get()->result();
        } catch (Exception $e) {
            log_message('error', 'Error fetching consolidated notices: ' . $e->getMessage());
            return array();
        }
    }
}

/* End of file notice.php */
/* Location: ./application/modules/notice/controllers/notice.php */
