<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Hospital_model extends CI_model {

    function __construct() {
        parent::__construct();
        $this->load->database();
    }

    function hospitalId() {
        if (!$this->ion_auth->in_group(array('superadmin'))) {
            if ($this->ion_auth->in_group(array('admin'))) {
                $current_user_id = $this->ion_auth->user()->row()->id;
                $hospital_id = $this->db->get_where('hospital', array('ion_user_id' => $current_user_id))->row()->id;
                return $hospital_id;
            } else {
                $current_user_id = $this->ion_auth->user()->row()->id;
                $group_id = $this->db->get_where('users_groups', array('user_id' => $current_user_id))->row()->group_id;
                $group_name = $this->db->get_where('groups', array('id' => $group_id))->row()->name;
                $group_name = strtolower($group_name);
                $hospital_id = $this->db->get_where($group_name, array('ion_user_id' => $current_user_id))->row()->hospital_id;
                return $hospital_id;
            }
        }
    }

    function modules() {
        if (!$this->ion_auth->in_group(array('superadmin'))) {
            if ($this->ion_auth->in_group(array('admin'))) {
                $current_user_id = $this->ion_auth->user()->row()->id;
                $modules = $this->db->get_where('hospital', array('ion_user_id' => $current_user_id))->row()->module;
                $module = explode(',', $modules);
                return $module;
            } else {
                $current_user_id = $this->ion_auth->user()->row()->id;
                $group_id = $this->db->get_where('users_groups', array('user_id' => $current_user_id))->row()->group_id;
                $group_name = $this->db->get_where('groups', array('id' => $group_id))->row()->name;
                $group_name = strtolower($group_name);
                $hospital_id = $this->db->get_where($group_name, array('ion_user_id' => $current_user_id))->row()->hospital_id;
                $modules = $this->db->get_where('hospital', array('id' => $hospital_id))->row()->module;
                $module = explode(',', $modules);
                return $module;
            }
        }
    }

    function addHospitalIdToIonUser($ion_user_id, $hospital_id) {
        $hospital_ion_id = $this->db->get_where('hospital', array('id' => $hospital_id))->row()->ion_user_id;
        $uptade_ion_user = array(
            'hospital_ion_id' => $hospital_ion_id,
        );
        $this->db->where('id', $ion_user_id);
        $this->db->update('users', $uptade_ion_user);
    }

    function insertHospital($data) {
        $this->db->insert('hospital', $data);
    }

    function getHospital() {
        $query = $this->db->get('hospital');
        return $query->result();
    }

    function getHospitalById($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('hospital');
        return $query->row();
    }

    function updateHospital($id, $data) {

        $this->db->where('id', $id);
        $this->db->update('hospital', $data);
    }

    function updateHospitalByIonId($id, $data) {
        $this->db->where('ion_user_id', $id);
        $this->db->update('hospital', $data);
    }

    function activate($id, $data) {
        $this->db->where('id', $id);
        $this->db->or_where('hospital_ion_id', $id);
        $this->db->update('users', $data);
    }

    function deactivate($id, $data) {
        $this->db->where('hospital_ion_id', $id);
        $this->db->or_where('id', $id);
        $this->db->update('users', $data);
    }

    function delete($id) {
        $this->db->where('id', $id);
        $this->db->delete('hospital');
    }

    function updateIonUser($username, $email, $password, $ion_user_id, $phone) {
        $uptade_ion_user = array(
            'username' => $username,
            'email' => $email,
            'password' => $password,
            'phone' => $phone,
        );
        $this->db->where('id', $ion_user_id);
        $this->db->update('users', $uptade_ion_user);
    }

    function getHospitalId($current_user_id) {
        $group_id = $this->db->get_where('users_groups', array('user_id' => $current_user_id))->row()->group_id;
        $group_name = $this->db->get_where('groups', array('id' => $group_id))->row()->name;
        $group_name = strtolower($group_name);
        $hospital_id = $this->db->get_where($group_name, array('ion_user_id' => $current_user_id))->row()->hospital_id;
        return $hospital_id;
    }

    function createAutoSmsTemplate($hospital_id) {
        $data = array();
        $data = array('0' => array(
                'name' => 'Payment successful sms to patient',
                'message' => 'Dear {name}, Your paying amount - Tk {amount} was successful. Thank You Please contact our support for further queries.',
                'type' => 'payment',
                'status' => 'Active',
                'language' => 'english'
            ),
            '1' => array(
                'name' => 'Appointment Confirmation sms to patient',
                'message' => 'Dear {name}, Your appointment with {doctorname} on {appoinmentdate} at {time_slot} is confirmed. For more information contact with {hospital_name} Regards',
                'type' => 'appoinment_confirmation',
                'status' => 'Active',
                'language' => 'english'
            ),
            '2' => array(
                'name' => 'Appointment creation sms to patient',
                'message' => 'Dear {name}, You have an appointment with {doctorname} on {appoinmentdate} at {time_slot} .Please confirm your appointment. For more information contact with {hospital_name} Regards',
                'type' => 'appoinment_creation',
                'status' => 'Active',
                'language' => 'english'
            ),
            '3' => array(
                'name' => 'Meeting Schedule Notification To Patient',
                'message' => 'Dear {patient_name}, You have a Live Video Meeting with {doctor_name} on {start_time}. For more information contact with {hospital_name} . Regards',
                'type' => 'meeting_creation',
                'status' => 'Active',
                'language' => 'english'
            ),
            '4' => array(
                'name' => 'send appoint confirmation to Doctor',
                'message' => 'Dear {name}, You are appointed as a doctor in {department} . Thank You {company}',
                'type' => 'doctor',
                'status' => 'Active',
                'language' => 'english'
            ),
            '5' => array(
                'name' => 'Patient Registration Confirmation',
                'message' => 'Dear {name}, You are registred to {company} as a patient to {doctor}. Regards',
                'type' => 'patient',
                'status' => 'Active',
                'language' => 'english'
            ),
            '6' => array(
                'name' => 'Appointment Remainder sms to patient',
                'message' => 'Dear {name}, REMAINDER!!<br> You have an appointment with {doctorname} on {appoinmentdate} at {time_slot} . For more information contact with {hospital_name} Regards',
                'type' => 'appoinment_remainder',
                'status' => 'Active',
                'language' => 'english'
            ),

            '7' => array(
                'name' => 'Patient Registration Welcome SMS',
                'message' => 'Dear {name}, Welcome to {hospital_name}! Your patient registration is successful. Your Patient ID: {patient_id}. For any queries, please contact us. Thank you!',
                'type' => 'patient_registration',
                'status' => 'Active',
                'language' => 'english'
            ),
            '8' => array(
                'name' => 'Patient Details Update SMS',
                'message' => 'Dear {name}, Your patient details have been successfully updated at {hospital_name}. Patient ID: {patient_id}. Thank you!',
                'type' => 'patient_update',
                'status' => 'Active',
                'language' => 'english'
            ),
            '9' => array(
                'name' => 'Doctor Registration Welcome SMS',
                'message' => 'Dear Dr. {name}, Welcome to {hospital_name}! Your doctor registration is successful. Department: {department}. Thank you for joining our medical team!',
                'type' => 'doctor_registration',
                'status' => 'Active',
                'language' => 'english'
            ),
            '10' => array(
                'name' => 'Doctor Details Update SMS',
                'message' => 'Dear Dr. {name}, Your doctor profile has been successfully updated at {hospital_name}. Department: {department}. Thank you!',
                'type' => 'doctor_update',
                'status' => 'Active',
                'language' => 'english'
            ),
            '11' => array(
                'name' => 'Online Appointment Booking SMS',
                'message' => 'Dear {name}, Your appointment has been successfully booked online at {hospital_name}. Doctor: Dr. {doctorname}, Date: {appoinmentdate}, Time: {time_slot}. Thank you!',
                'type' => 'online_appointment_booking',
                'status' => 'Active',
                'language' => 'english'
            ),
            '12' => array(
                'name' => 'Appointment Without Payment SMS',
                'message' => 'Dear {name}, Your appointment is confirmed at {hospital_name}. Doctor: Dr. {doctorname}, Date: {appoinmentdate}, Time: {time_slot}. Payment pending: Rs. {amount}. Please pay before your visit.',
                'type' => 'appointment_without_payment',
                'status' => 'Active',
                'language' => 'english'
            ),
            '13' => array(
                'name' => 'IVR Appointment Booking SMS',
                'message' => 'Dear {name}, Your appointment has been booked via phone at {hospital_name}. Doctor: Dr. {doctorname}, Date: {appoinmentdate}, Time: {time_slot}. Thank you!',
                'type' => 'ivr_appointment_booking',
                'status' => 'Active',
                'language' => 'english'
            ),
            '14' => array(
                'name' => 'SMS for session start notification to patient',
                'message' => 'Dear {name}, Your appointment session is going to start. Doctor: Dr. {doctorname}, Date: {appoinmentdate}, Time: {time_slot}. Thank you!',
                'type' => 'session_start_notification_patient',
                'status' => 'Active',
                'language' => 'english'
            ),


            '15' => array(
                'name' => 'Payment successful sms to patient',
                'message' => 'அன்புள்ள {name}, உங்கள் கட்டணம் - {amount} வெற்றிகரமாக செலுத்தப்பட்டது. நன்றி. மேலும் விவரங்களுக்கு எங்கள் ஆதரவைத் தொடர்பு கொள்ளவும்.',
                'type' => 'payment',
                'status' => 'Active',
                'language' => 'tamil'
            ),
            '16' => array(
                'name' => 'Appointment Confirmation sms to patient',
                'message' => 'அன்புள்ள {name}, {appoinmentdate} அன்று {time_slot} மணிக்கு {doctorname} உடனான உங்கள் சந்திப்பு உறுதி செய்யப்பட்டுள்ளது. மேலும் தகவலுக்கு {hospital_name} ஐ தொடர்பு கொள்ளவும்',
                'type' => 'appoinment_confirmation',
                'status' => 'Active',
                'language' => 'tamil'
            ),
            '17' => array(
                'name' => 'Appointment creation sms to patient',
                'message' => 'அன்புள்ள {name}, உங்களுக்கு {appoinmentdate} அன்று {time_slot} மணிக்கு {doctorname} உடன் சந்திப்பு உள்ளது. உங்கள் சந்திப்பை உறுதிப்படுத்தவும். மேலும் தகவலுக்கு {hospital_name} ஐ தொடர்பு கொள்ளவும்',
                'type' => 'appoinment_creation',
                'status' => 'Active',
                'language' => 'tamil'
            ),
            '18' => array(
                'name' => 'Meeting Schedule Notification To Patient',
                'message' => 'அன்புள்ள {patient_name}, உங்களுக்கு {start_time} அன்று {doctor_name} உடன் நேரடி வீடியோ கூட்டம் உள்ளது. மேலும் தகவலுக்கு {hospital_name} ஐ தொடர்பு கொள்ளவும்',
                'type' => 'meeting_creation',
                'status' => 'Active',
                'language' => 'tamil'
            ),
            '19' => array(
                'name' => 'send appoint confirmation to Doctor',
                'message' => 'அன்புள்ள {name}, நீங்கள் {department} இல் மருத்துவராக நியமிக்கப்பட்டுள்ளீர்கள். நன்றி {company}',
                'type' => 'doctor',
                'status' => 'Active',
                'language' => 'tamil'
            ),
            '20' => array(
                'name' => 'Patient Registration Confirmation',
                'message' => 'அன்புள்ள {name}, நீங்கள் {company} இல் {doctor} இடம் நோயாளியாக பதிவு செய்யப்பட்டுள்ளீர்கள். நன்றி',
                'type' => 'patient',
                'status' => 'Active',
                'language' => 'tamil'
            ),
            '21' => array(
                'name' => 'Appointment Remainder sms to patient',
                'message' => 'அன்புள்ள {name}, நினைவூட்டல்!! உங்களுக்கு {appoinmentdate} அன்று {time_slot} மணிக்கு {doctorname} உடன் சந்திப்பு உள்ளது. மேலும் தகவலுக்கு {hospital_name} ஐ தொடர்பு கொள்ளவும்',
                'type' => 'appoinment_remainder',
                'status' => 'Active',
                'language' => 'tamil'
            ),

            '22' => array(
                'name' => 'Patient Registration Welcome SMS',
                'message' => 'அன்புள்ள {name}, {hospital_name} இல் உங்களை வரவேற்கிறோம்! உங்கள் நோயாளி பதிவு வெற்றிகரமாக உள்ளது. நோயாளி எண்: {patient_id}. ஏதேனும் கேள்விகள் இருந்தால், எங்களை தொடர்பு கொள்ளவும். நன்றி!',
                'type' => 'patient_registration',
                'status' => 'Active',
                'language' => 'tamil'
            ),
            '23' => array(
                'name' => 'Patient Details Update SMS',
                'message' => 'அன்புள்ள {name}, உங்கள் நோயாளி விவரங்கள் {hospital_name} இல் வெற்றிகரமாக புதுப்பிக்கப்பட்டுள்ளது. நோயாளி எண்: {patient_id}. நன்றி!',
                'type' => 'patient_update',
                'status' => 'Active',
                'language' => 'tamil'
            ),
            '24' => array(
                'name' => 'Doctor Registration Welcome SMS',
                'message' => 'அன்புள்ள மருத்துவர் {name}, {hospital_name} இல் உங்களை வரவேற்கிறோம்! உங்கள் மருத்துவர் பதிவு வெற்றிகரமாக உள்ளது. துறை: {department}. எங்கள் மருத்துவ குழுவில் சேர்ந்தமைக்கு நன்றி!',
                'type' => 'doctor_registration',
                'status' => 'Active',
                'language' => 'tamil'
            ),
            '25' => array(
                'name' => 'Doctor Details Update SMS',
                'message' => 'அன்புள்ள மருத்துவர் {name}, உங்கள் மருத்துவர் சுயவிவரம் {hospital_name} இல் வெற்றிகரமாக புதுப்பிக்கப்பட்டுள்ளது. துறை: {department}. நன்றி!',
                'type' => 'doctor_update',
                'status' => 'Active',
                'language' => 'tamil'
            ),
            '26' => array(
                'name' => 'Online Appointment Booking SMS',
                'message' => 'அன்புள்ள {name}, உங்கள் ஆன்லைன் சந்திப்பு {hospital_name} இல் ஆன்லைன் வழியாக வெற்றிகரமாக பதிவு செய்யப்பட்டுள்ளது. மருத்துவர்: டாக்டர் {doctorname}, தேதி: {appoinmentdate}, நேரம்: {time_slot}. நன்றி!',
                'type' => 'online_appointment_booking',
                'status' => 'Active',
                'language' => 'tamil'
            ),
            '27' => array(
                'name' => 'Appointment Without Payment SMS',
                'message' => 'அன்புள்ள {name}, உங்கள் சந்திப்பு {hospital_name} இல் உறுதி செய்யப்பட்டுள்ளது. மருத்துவர்: டாக்டர் {doctorname}, தேதி: {appoinmentdate}, நேரம்: {time_slot}. நிலுவை தொகை: ரூ. {amount}. உங்கள் வருகைக்கு முன் கட்டணம் செலுத்தவும்.',
                'type' => 'appointment_without_payment',
                'status' => 'Active',
                'language' => 'tamil'
            ),
            '28' => array(
                'name' => 'IVR Appointment Booking SMS',
                'message' => 'அன்புள்ள {name}, உங்கள் சந்திப்பு {hospital_name} இல் தொலைபேசி வழியாக பதிவு செய்யப்பட்டுள்ளது. மருத்துவர்: டாக்டர் {doctorname}, தேதி: {appoinmentdate}, நேரம்: {time_slot}. நன்றி!',
                'type' => 'ivr_appointment_booking',
                'status' => 'Active',
                'language' => 'tamil'
            ),
            '29' => array(
                'name' => 'SMS for session start notification to patient',
                'message' => 'அன்புள்ள {name}, உங்கள் சந்திப்பு அமர்வு தொடங்கப் போகிறது. மருத்துவர்: டாக்டர். {doctorname}, தேதி: {appoinmentdate}, நேரம்: {time_slot}. நன்றி!',
                'type' => 'session_start_notification_patient',
                'status' => 'Active',
                'language' => 'tamil'
            ),

            '30' => array(
                'name' => 'Payment successful sms to patient',
                'message' => 'ආදරණීය {name}, ඔබේ ගෙවීමේ මුදල - {amount} සාර්ථක විය. ස්තුතියි. වැඩි විස්තර සඳහා අපගේ සහාය සමඟ සම්බන්ධ වන්න.',
                'type' => 'payment',
                'status' => 'Active',
                'language' => 'sinhala'
            ),
            '31' => array(
                'name' => 'Appointment Confirmation sms to patient',
                'message' => 'ආදරණීය {name}, {doctorname} සමඟ {appoinmentdate} දින {time_slot} ට ඔබේ හමුවීම තහවුරු කර ඇත. වැඩි විස්තර සඳහා {hospital_name} සමඟ සම්බන්ධ වන්න',
                'type' => 'appoinment_confirmation',
                'status' => 'Active',
                'language' => 'sinhala'
            ),
            '32' => array(
                'name' => 'Appointment creation sms to patient',
                'message' => 'ආදරණීය {name}, ඔබට {doctorname} සමඟ {appoinmentdate} දින {time_slot} ට හමුවීමක් ඇත. කරුණාකර ඔබේ හමුවීම තහවුරු කරන්න. වැඩි විස්තර සඳහා {hospital_name} සමඟ සම්බන්ධ වන්න',
                'type' => 'appoinment_creation',
                'status' => 'Active',
                'language' => 'sinhala'
            ),
            '33' => array(
                'name' => 'Meeting Schedule Notification To Patient',
                'message' => 'ආදරණීය {patient_name}, ඔබට {doctor_name} සමඟ {start_time} දින සජීවී වීඩියෝ සාකච්ඡාවක් ඇත. වැඩි විස්තර සඳහා {hospital_name} සමඟ සම්බන්ධ වන්න',
                'type' => 'meeting_creation',
                'status' => 'Active',
                'language' => 'sinhala'
            ),
            '34' => array(
                'name' => 'send appoint confirmation to Doctor',
                'message' => 'ආදරණීය {name}, ඔබ {department} හි වෛද්‍යවරයෙකු ලෙස පත් කර ඇත. ස්තුතියි {company}',
                'type' => 'doctor',
                'status' => 'Active',
                'language' => 'sinhala'
            ),
            '35' => array(
                'name' => 'Patient Registration Confirmation',
                'message' => 'ආදරණීය {name}, ඔබ {company} වෙත {doctor} සිට රෝගියෙකු ලෙස ලියාපදිංචි කර ඇත. ස්තුතියි',
                'type' => 'patient',
                'status' => 'Active',
                'language' => 'sinhala'
            ),
            '36' => array(
                'name' => 'Appointment Remainder sms to patient',
                'message' => 'ආදරණීය {name}, මතක් කිරීම!! ඔබට {doctorname} සමඟ {appoinmentdate} දින {time_slot} ට හමුවීමක් ඇත. වැඩි විස්තර සඳහා {hospital_name} සමඟ සම්බන්ධ වන්න',
                'type' => 'appoinment_remainder',
                'status' => 'Active',
                'language' => 'sinhala'
            ),

            '37' => array(
                'name' => 'Patient Registration Welcome SMS',
                'message' => 'ගරු {name}, {hospital_name} වෙත සාදරයෙන් පිළිගන්නවා! ඔබගේ රෝගී ලියාපදිංචිය සාර්ථකයි. රෝගී අංකය: {patient_id}. ඕනෑම විමසීමක් සඳහා අප සම්බන්ධ කරගන්න. ස්තූතියි!',
                'type' => 'patient_registration',
                'status' => 'Active',
                'language' => 'sinhala'
            ),
            '38' => array(
                'name' => 'Patient Details Update SMS',
                'message' => 'ගරු {name}, ඔබගේ රෝගී තොරතුරු {hospital_name} හිදී සාර්ථකව යාවත්කාලීන කර ඇත. රෝගී අංකය: {patient_id}. ස්තූතියි!',
                'type' => 'patient_update',
                'status' => 'Active',
                'language' => 'sinhala'
            ),
            '39' => array(
                'name' => 'Doctor Registration Welcome SMS',
                'message' => 'ගරු වෛද්‍ය {name}, {hospital_name} වෙත සාදරයෙන් පිළිගන්නවා! ඔබගේ වෛද්‍ය ලියාපදිංචිය සාර්ථකයි. අංශය: {department}. අපගේ වෛද්‍ය කණ්ඩායමට සම්බන්ධ වීම ගැන ස්තූතියි!',
                'type' => 'doctor_registration',
                'status' => 'Active',
                'language' => 'sinhala'
            ),
            '40' => array(
                'name' => 'Doctor Details Update SMS',
                'message' => 'ගරු වෛද්‍ය {name}, ඔබගේ වෛද්‍ය පැතිකඩ {hospital_name} හිදී සාර්ථකව යාවත්කාලීන කර ඇත. අංශය: {department}. ස්තූතියි!',
                'type' => 'doctor_update',
                'status' => 'Active',
                'language' => 'sinhala'
            ),
            '41' => array(
                'name' => 'Online Appointment Booking SMS',
                'message' => 'ගරු {name}, ඔබගේ හමුවීම {hospital_name} හිදී අන්තර්ජාලය හරහා සාර්ථකව වෙන් කර ඇත. වෛද්‍ය: වෛද්‍ය {doctorname}, දිනය: {appoinmentdate}, වේලාව: {time_slot}. ස්තූතියි!',
                'type' => 'online_appointment_booking',
                'status' => 'Active',
                'language' => 'sinhala'
            ),
            '42' => array(
                'name' => 'Appointment Without Payment SMS',
                'message' => 'ගරු {name}, ඔබගේ හමුවීම {hospital_name} හිදී තහවුරු කර ඇත. වෛද්‍ය: වෛද්‍ය {doctorname}, දිනය: {appoinmentdate}, වේලාව: {time_slot}. ගෙවිය යුතු මුදල: රු. {amount}. කරුණාකර ඔබගේ සංචාරයට පෙර ගෙවන්න.',
                'type' => 'appointment_without_payment',
                'status' => 'Active',
                'language' => 'sinhala'
            ),
            '43' => array(
                'name' => 'IVR Appointment Booking SMS',
                'message' => 'ගරු {name}, ඔබගේ හමුවීම {hospital_name} හිදී දුරකථනය හරහා වෙන් කර ඇත. වෛද්‍ය: වෛද්‍ය {doctorname}, දිනය: {appoinmentdate}, වේලාව: {time_slot}. ස්තූතියි!',
                'type' => 'ivr_appointment_booking',
                'status' => 'Active',
                'language' => 'sinhala'
            ),
            '44' => array(
                'name' => 'SMS for session start notification to patient',
                'message' => 'ආදරණීය {name}, ඔබගේ හමුවීමේ සැසිය ආරම්භ වීමට නියමිතයි. වෛද්‍යවරයා: වෛද්‍ය {doctorname}, දිනය: {appoinmentdate}, වේලාව: {time_slot}. ස්තූතියි!',
                'type' => 'session_start_notification_patient',
                'status' => 'Active',
                'language' => 'sinhala'
            ),
            
            );

        foreach ($data as $row) {
            $data1 = array();
            $data1 = array(
                'name' => $row['name'],
                'message' => $row['message'],
                'type' => $row['type'],
                'status' => $row['status'],
                'language' => $row['language'],
                'hospital_id' => $hospital_id
            );
            $this->db->insert('autosmstemplate', $data1);
        }
    }

    function createAutoEmailTemplate($hospital_id) {
        $data = array();
        $data = array('0' => array(
                'name' => 'Payment successful email to patient',
                'message' => 'Dear {name}, Your paying amount - Tk {amount} was successful. Thank You Please contact our support for further queries.',
                'type' => 'payment',
                'status' => 'Active',
            ),
            '1' => array(
                'name' => 'Appointment Confirmation email to patient',
                'message' => 'Dear {name}, Your appointment with {doctorname} on {appoinmentdate} at {time_slot} is confirmed. For more information contact with {hospital_name} Regards',
                'type' => 'appoinment_confirmation',
                'status' => 'Active',
            ),
            '2' => array(
                'name' => 'Appointment creation email to patient',
                'message' => 'Dear {name}, You have an appointment with {doctorname} on {appoinmentdate} at {time_slot} .Please confirm your appointment. For more information contact with {hospital_name} Regards',
                'type' => 'appoinment_creation',
                'status' => 'Active',
            ),
            '3' => array(
                'name' => 'Meeting Schedule Notification To Patient',
                'message' => 'Dear {patient_name}, You have a Live Video Meeting with {doctor_name} on {start_time}. For more information contact with {hospital_name} . Regards',
                'type' => 'meeting_creation',
                'status' => 'Active',
            ),
            '4' => array(
                'name' => 'Send Appointment confirmation to Doctor',
                'message' => 'Dear {name},<br> You are registered to {company} as a New Doctor in {department}.<br><br> Your Details:<br> Url Link: {base_url}<br> Username : {email}<br> Password: {password}<br><br> Thank You for registration.<br> Regards',
                'type' => 'doctor',
                'status' => 'Active',
            ),
            '5' => array(
                'name' => 'Patient Registration Confirmation',
                'message' => 'Dear {name},<br> You are registered to {company} as a New Patient to {doctor}.<br><br> Your Details:<br> Url Link: {base_url}<br> Username : {email}<br> Password: {password}<br><br> Thank You for registration.<br> Regards',
                'type' => 'patient',
                'status' => 'Active',
            ),
            '6' => array(
                'name' => 'Nurse Registration Confirmation',
                'message' => 'Dear {name},<br> You are registered to {company} as a New Nurse.<br><br> Your Details:<br> Url Link: {base_url}<br> Username : {email}<br> Password: {password}<br><br> Thank You for registration.<br> Regards',
                'type' => 'nurse',
                'status' => 'Active',
            ),
            '7' => array(
                'name' => 'Pharmacist Registration Confirmation',
                'message' => 'Dear {name},<br> You are registered to {company} as a New Pharmacist.<br><br> Your Details:<br> Url Link: {base_url}<br> Username : {email}<br> Password: {password}<br><br> Thank You for registration.<br> Regards',
                'type' => 'pharmacist',
                'status' => 'Active',
            ),
            '8' => array(
                'name' => 'Laboratorist Registration Confirmation',
                'message' => 'Dear {name},<br> You are registered to {company} as a New Laboratorist.<br><br> Your Details:<br> Url Link: {base_url}<br> Username : {email}<br> Password: {password}<br><br> Thank You for registration.<br> Regards',
                'type' => 'laboratorist',
                'status' => 'Active',
            ),
            '9' => array(
                'name' => 'Accountant Registration Confirmation',
                'message' => 'Dear {name},<br> You are registered to {company} as a New Accountant.<br><br> Your Details:<br> Url Link: {base_url}<br> Username : {email}<br> Password: {password}<br><br> Thank You for registration.<br> Regards',
                'type' => 'accountant',
                'status' => 'Active',
            ),
            '10' => array(
                'name' => 'Receptionist Registration Confirmation',
                'message' => 'Dear {name},<br> You are registered to {company} as a New Receptionist.<br><br> Your Details:<br> Url Link: {base_url}<br> Username : {email}<br> Password: {password}<br><br> Thank You for registration.<br> Regards',
                'type' => 'receptionist',
                'status' => 'Active',
            ),
            '11' => array(
                'name' => 'Appointment Remainder email to patient',
                'message' => 'Dear {name}, REMAINDER!!<br> You have an appointment with {doctorname} on {appoinmentdate} at {time_slot} . For more information contact with {hospital_name} Regards',
                'type' => 'appoinment_remainder',
                'status' => 'Active',
            ),
            '12' => array(
                'name' => 'Send Patient Appointment confirmation to Doctor',
                'message' => 'Dear {name}, <br> {patientname} creates a appointment  with you on {appoinmentdate} at {time_slot} . Please See details on your login panel. <br> Regards',
                'type' => 'appoinment_creation_to_doctor',
                'status' => 'Active',
            ),
            '13' => array(
                'name' => 'Appointment Cancellation',
                'message' => '<p>Dear {name}, Your appointment with {doctorname} on {appoinmentdate} at {time_slot} has been cancelled. For more information contact with {hospital_name} Regards</p>',
                'type' => 'appointment_cancel',
                'status' => 'Active',
            ),
            '14' => array(
                'name' => 'Appointment Update',
                'message' => '<p>Dear {name}, Your appointment with {doctorname} on {appoinmentdate} at {time_slot} has been updated. For more information contact with {hospital_name} Regards</p>',
                'type' => 'appointment_update',
                'status' => 'Active',
            ),
            '15' => array(
                'name' => 'Doctor Appointment Update',
                'message' => '<p>Dear {name}, Your appointment with {patientname} on {appoinmentdate} at {time_slot} has been updated. For more information contact with {hospital_name} Regards</p>',
                'type' => 'doctor_appointment_update',
                'status' => 'Active',
            )
            ,
            '16' => array(
                'name' => 'Doctor Appointment Cancellation',
                'message' => '<p>Dear {name}, Your appointment with {patientname} on {appoinmentdate} at {time_slot} has been cancelled. For more information contact with {hospital_name} Regards</p>',
                'type' => 'doctor_appointment_cancel',
                'status' => 'Active',
            )
        );

        foreach ($data as $row) {
            $data1 = array();
            $data1 = array(
                'name' => $row['name'],
                'message' => $row['message'],
                'type' => $row['type'],
                'status' => $row['status'],
                'hospital_id' => $hospital_id
            );
            $this->db->insert('autoemailtemplate', $data1);
        }
    }

    function getHospitalByIonId($id) {
        $this->db->where('ion_user_id', $id);
        $query = $this->db->get('hospital');
        return $query->row();
    }

    function getHospitalInfo($searchTerm) {
        if (!empty($searchTerm)) {
            $this->db->select('*');

            $this->db->where("name like '%" . $searchTerm . "%' OR id like '%" . $searchTerm . "%'");
            $fetched_records = $this->db->get('hospital');
            $users = $fetched_records->result_array();
        } else {
            $this->db->select('*');

            $this->db->limit(10);
            $fetched_records = $this->db->get('hospital');
            $users = $fetched_records->result_array();
        }

        $data = array();
        foreach ($users as $user) {
            $data[] = array("id" => $user['id'], "text" => $user['name'] . ' (' . lang('id') . ': ' . $user['id'] . ')');
        }
        return $data;
    }

    function addHospitalPayment($data) {
        $this->db->insert('hospital_payment', $data);
    }

    function addHospitalDeposit($data) {
        return $this->db->insert('hospital_deposit', $data);
    }

    function updateHospitalPayment($id, $data) {
        $this->db->where('id', $id);
        $this->db->update('hospital_payment', $data);
    }

    function updateHospitalPaymentByHospitalId($id, $data) {
        $this->db->where('hospital_user_id', $id);
        $this->db->update('hospital_payment', $data);
    }

    function getHospitalPaymentByHospitalId($id) {
        $this->db->where('hospital_user_id', $id);
        return $this->db->get('hospital_payment')->row();
    }

    function getHospitalPaymentById($id) {
        $this->db->where('id', $id);
        return $this->db->get('hospital_payment')->row();
    }

    function thisMonthlyDepositCount() {

        $query = $this->db->get('hospital_deposit')->result();
        $total = array();
        foreach ($query as $q) {
            if (date('m/Y', time()) == date('m/Y', $q->add_date_stamp)) {
                $hospital_payment = $this->db->get_where('hospital_payment', array('id' => $q->payment_id))->row();
                if ($hospital_payment->package_duration == 'monthly') {
                    $total[] = 1;
                }
            }
        }
        if (!empty($total)) {
            return array_sum($total);
        } else {
            return 0;
        }
    }

    function thisYearlyDepositCount() {

        $query = $this->db->get('hospital_deposit')->result();
        $total = array();
        foreach ($query as $q) {
            if (date('m/Y', time()) == date('m/Y', $q->add_date_stamp)) {
                $hospital_payment = $this->db->get_where('hospital_payment', array('id' => $q->payment_id))->row();
                if ($hospital_payment->package_duration == 'yearly') {
                    $total[] = 1;
                }
            }
        }
        if (!empty($total)) {
            return array_sum($total);
        } else {
            return 0;
        }
    }

    function getPaymentPerMonthThisYear() {


        $query = $this->db->get('hospital_deposit')->result();
        $total = array();
        foreach ($query as $q) {
            if (date('Y', time()) == date('Y', $q->add_date_stamp)) {

                if (date('m', $q->add_date_stamp) == '01') {
                    $total['january'][] = $q->deposited_amount;
                }
                if (date('m', $q->add_date_stamp) == '02') {
                    $total['february'][] = $q->deposited_amount;
                }
                if (date('m', $q->add_date_stamp) == '03') {
                    $total['march'][] = $q->deposited_amount;
                }
                if (date('m', $q->add_date_stamp) == '04') {
                    $total['april'][] = $q->deposited_amount;
                }
                if (date('m', $q->add_date_stamp) == '05') {
                    $total['may'][] = $q->deposited_amount;
                }
                if (date('m', $q->add_date_stamp) == '06') {
                    $total['june'][] = $q->deposited_amount;
                }
                if (date('m', $q->add_date_stamp) == '07') {
                    $total['july'][] = $q->deposited_amount;
                }
                if (date('m', $q->add_date_stamp) == '08') {
                    $total['august'][] = $q->deposited_amount;
                }
                if (date('m', $q->add_date_stamp) == '09') {
                    $total['september'][] = $q->deposited_amount;
                }
                if (date('m', $q->add_date_stamp) == '10') {
                    $total['october'][] = $q->deposited_amount;
                }
                if (date('m', $q->add_date_stamp) == '11') {
                    $total['november'][] = $q->deposited_amount;
                }
                if (date('m', $q->add_date_stamp) == '12') {
                    $total['december'][] = $q->deposited_amount;
                }
            }
        }


        if (!empty($total['january'])) {
            $total['january'] = array_sum($total['january']);
        } else {
            $total['january'] = 0;
        }
        if (!empty($total['february'])) {
            $total['february'] = array_sum($total['february']);
        } else {
            $total['february'] = 0;
        }
        if (!empty($total['march'])) {
            $total['march'] = array_sum($total['march']);
        } else {
            $total['march'] = 0;
        }
        if (!empty($total['april'])) {
            $total['april'] = array_sum($total['april']);
        } else {
            $total['april'] = 0;
        }
        if (!empty($total['may'])) {
            $total['may'] = array_sum($total['may']);
        } else {
            $total['may'] = 0;
        }
        if (!empty($total['june'])) {
            $total['june'] = array_sum($total['june']);
        } else {
            $total['june'] = 0;
        }
        if (!empty($total['july'])) {
            $total['july'] = array_sum($total['july']);
        } else {
            $total['july'] = 0;
        }
        if (!empty($total['august'])) {
            $total['august'] = array_sum($total['august']);
        } else {
            $total['august'] = 0;
        }
        if (!empty($total['september'])) {
            $total['september'] = array_sum($total['september']);
        } else {
            $total['september'] = 0;
        }
        if (!empty($total['october'])) {
            $total['october'] = array_sum($total['october']);
        } else {
            $total['october'] = 0;
        }
        if (!empty($total['november'])) {
            $total['november'] = array_sum($total['november']);
        } else {
            $total['november'] = 0;
        }
        if (!empty($total['december'])) {
            $total['december'] = array_sum($total['december']);
        } else {
            $total['december'] = 0;
        }

        return $total;
    }

    function thisMonthlyDeposit() {

        $query = $this->db->get('hospital_deposit')->result();
        $total = array();
        foreach ($query as $q) {
            if (date('m/Y', time()) == date('m/Y', $q->add_date_stamp)) {
                $hospital_payment = $this->db->get_where('hospital_payment', array('id' => $q->payment_id))->row();
                if ($hospital_payment->package_duration == 'monthly') {
                    $total[] = $q->deposited_amount;
                }
            }
        }
        if (!empty($total)) {
            return array_sum($total);
        } else {
            return 0;
        }
    }

    function thisYearlyDeposit() {

        $query = $this->db->get('hospital_deposit')->result();
        $total = array();
        foreach ($query as $q) {
            if (date('m/Y', time()) == date('m/Y', $q->add_date_stamp)) {
                $hospital_payment = $this->db->get_where('hospital_payment', array('id' => $q->payment_id))->row();
                if ($hospital_payment->package_duration == 'yearly') {
                    $total[] = $q->deposited_amount;
                }
            }
        }
        if (!empty($total)) {
            return array_sum($total);
        } else {
            return 0;
        }
    }

    function thisDayMonthlyPayment() {

        $query = $this->db->get('hospital_deposit')->result();
        $total = array();
        foreach ($query as $q) {
            if (date('d/m/Y', time()) == date('d/m/Y', $q->add_date_stamp)) {
                $hospital_payment = $this->db->get_where('hospital_payment', array('id' => $q->payment_id))->row();
                if ($hospital_payment->package_duration == 'monthly') {
                    $total[] = $q->deposited_amount;
                }
            }
        }
        if (!empty($total)) {
            return array_sum($total);
        } else {
            return 0;
        }
    }

    function thisDayYearlyPayment() {

        $query = $this->db->get('hospital_deposit')->result();
        $total = array();
        foreach ($query as $q) {
            if (date('d/m/Y', time()) == date('d/m/Y', $q->add_date_stamp)) {
                $hospital_payment = $this->db->get_where('hospital_payment', array('id' => $q->payment_id))->row();
                if ($hospital_payment->package_duration == 'yearly') {
                    $total[] = $q->deposited_amount;
                }
            }
        }
        if (!empty($total)) {
            return array_sum($total);
        } else {
            return 0;
        }
    }

    function thisYearYearlyPayment() {

        $query = $this->db->get('hospital_deposit')->result();
        $total = array();
        foreach ($query as $q) {
            if (date('Y', time()) == date('Y', $q->add_date_stamp)) {
                $hospital_payment = $this->db->get_where('hospital_payment', array('id' => $q->payment_id))->row();
                if (!empty($hospital_payment)) {
                    if ($hospital_payment->package_duration == 'yearly') {
                        $total[] = $q->deposited_amount;
                    }
                }
            }
        }
        if (!empty($total)) {
            return array_sum($total);
        } else {
            return 0;
        }
    }

    function thisYearMonthlyPayment() {

        $query = $this->db->get('hospital_deposit')->result();
        $total = array();
        foreach ($query as $q) {
            if (date('Y', time()) == date('Y', $q->add_date_stamp)) {
                $hospital_payment = $this->db->get_where('hospital_payment', array('id' => $q->payment_id))->row();
                if (!empty($hospital_payment)) {
                    if ($hospital_payment->package_duration == 'monthly') {
                        $total[] = $q->deposited_amount;
                    }
                }
            }
        }
        if (!empty($total)) {
            return array_sum($total);
        } else {
            return 0;
        }
    }

    function getHospitalDepositById($id) {
        return $this->db->where('id', $id)->get('hospital_deposit')->row();
    }

    function getHospitalPaymentDeposits() {
        return $this->db->order_by('date', 'desc')->get('hospital_deposit')->result();
    }
    function getHospitalPaymentDepositsReportBySubscription($subscription) {
        if($subscription=='new'){
            return $this->db->order_by('date', 'desc')->where('deposited_amount_id')->get('hospital_deposit')->result();
        }else{
            return $this->db->order_by('date', 'desc')->where('deposited_amount_id IS NOT NULL')->get('hospital_deposit')->result();
        }
        
    }
    function getHospitalPaymentDepositsReport() {
        return $this->db->order_by('date', 'desc')->get('hospital_deposit')->result();
    }
    function getHospitalDepositByDate($date_from, $date_to) {
        return $this->db->order_by('date', 'desc')->where('add_date_stamp >=', $date_from)
                        ->where('add_date_stamp <=', $date_to)
                        ->get('hospital_deposit')->result();
    }
    function getHospitalDepositByDateBySubscription($date_from, $date_to,$subscription) {
        if($subscription=='new'){
            return $this->db->order_by('date', 'desc')
                            ->where('add_date_stamp >=', $date_from) 
                            ->where('add_date_stamp <=', $date_to)
                            ->where('deposited_amount_id')
                            ->get('hospital_deposit')->result();
           
        }else{
            return $this->db->order_by('date', 'desc')
                            ->where('add_date_stamp >=', $date_from) 
                            ->where('add_date_stamp <=', $date_to)
                            ->where('deposited_amount_id IS NOT NULL')
                            ->get('hospital_deposit')->result();
           
        } 
       
    }
 
    function getHospitalDepositByDateByCountry($date_from, $date_to, $country) {

        return $this->db->select("*")
                        ->order_by('date', 'desc')
                        ->where('add_date_stamp >=', $date_from)
                        ->where('add_date_stamp <=', $date_to)
                        ->from('hospital_deposit')
                        ->where('country', $country)
                        ->join('hospital', 'hospital_deposit.hospital_user_id = hospital.id')->get()->result();
    }
    function getHospitalDepositByDateByCountryBySubscription($date_from, $date_to, $country,$subscription) {

        if($subscription=='new'){
            return $this->db->select("*")
                        ->order_by('date', 'desc')
                        ->where('add_date_stamp >=', $date_from)
                        ->where('add_date_stamp <=', $date_to)
                        ->where('deposited_amount_id')
                        ->from('hospital_deposit')
                        ->where('country', $country)
                        ->join('hospital', 'hospital_deposit.hospital_user_id = hospital.id')->get()->result();
           
        }else{
            return $this->db->select("*")
            ->order_by('date', 'desc')
            ->where('add_date_stamp >=', $date_from)
            ->where('add_date_stamp <=', $date_to)
            ->where('deposited_amount_id IS NOT NULL')
            ->from('hospital_deposit')
            ->where('country', $country)
            ->join('hospital', 'hospital_deposit.hospital_user_id = hospital.id')->get()->result();
           
        } 
       
        
    }

    function getHospitalDepositByCountry($country) {
        return $this->db->select("*")
                        ->order_by('date', 'desc')
                        ->from('hospital_deposit')
                        ->where('country', $country)
                        ->join('hospital', 'hospital_deposit.hospital_user_id = hospital.id')->get()->result();
    }
    
    function getHospitalDepositByCountryBySubscription($country,$subscription) {
        if($subscription=='new'){
            return $this->db->select("*")
                        ->order_by('date', 'desc')
                        ->where('deposited_amount_id')
                        ->from('hospital_deposit')
                        ->where('country', $country)
                        ->join('hospital', 'hospital_deposit.hospital_user_id = hospital.id')->get()->result();
        }else{
            return $this->db->select("*")
                        ->order_by('date', 'desc')
                        ->where('deposited_amount_id IS NOT NULL')
                        ->from('hospital_deposit')
                        ->where('country', $country)
                        ->join('hospital', 'hospital_deposit.hospital_user_id = hospital.id')->get()->result();
        }
        
    }
    
    
    function getHospitalFromWebsite() {
        $this->db->where('from_where', 'Website');
        $query = $this->db->get('hospital');
        return $query->result();
    }
    
    function updateUsers($id, $data) {

        $this->db->where('id', $id);
        $this->db->update('users', $data);
    }
    
    function deleteAutoSmsTemplateByHospitalId($id)
    {
        $this->db->where('hospital_id', $id);
        $this->db->delete('autosmstemplate');
    }
    

}
