<!--sidebar end-->
<!--main content start-->
<div class="content-wrapper bg-light">
    <section class="content-header py-4 bg-white shadow-sm">
        <div class="container-fluid">
            <div class="row align-items-center">
                <div class="col-sm-6">
                    <h1 class="display-4 font-weight-black mb-0">
                        <i class="fas fa-users text-primary mr-3"></i>
                        Patient Queue - Dr. <?php echo $doctor->name; ?>
                    </h1>
                    <p class="text-muted mb-0">
                        <i class="fas fa-calendar mr-2"></i><?php echo date('l, F j, Y', strtotime($selected_date)); ?>
                    </p>
                </div>
                <div class="col-sm-6 text-right">
                    <?php if ($this->ion_auth->in_group(array('Doctor')) && isset($hospitals)) { ?>
                        <select class="form-control form-control-sm d-inline-block mb-2 mr-2" id="doctor_hospital_select" name="hospital_id" 
                                style="width: 250px; border: 2px solid #007bff;">
                            <option value="consolidated" <?php echo ($selected_hospital === 'consolidated') ? 'selected' : ''; ?>>
                                📊 All Hospitals Data
                            </option>
                            <?php foreach ($hospitals as $hospital) { ?>
                                <option value="<?php echo $hospital->id; ?>"  
                                        <?php echo ($selected_hospital == $hospital->id) ? 'selected' : ''; ?>>
                                    🏥 <?php echo $hospital->name; ?>
                                </option>
                            <?php } ?>
                        </select>
                    <?php } ?>
                    <button onclick="refreshQueue()" class="btn btn-primary btn-sm">
                        <i class="fas fa-sync-alt mr-2"></i>Refresh Queue
                    </button>
                    <a href="doctor" class="btn btn-secondary btn-sm ml-2">
                        <i class="fas fa-arrow-left mr-2"></i>Back to Dashboard
                    </a>
                </div>
            </div>
        </div>
    </section>

    <!-- Queue Statistics -->
    <section class="content py-4">
        <div class="container-fluid">
            <div class="row mb-4">
                <div class="col-lg-3 col-md-6">
                    <div class="card bg-info text-white">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h3 class="mb-1" id="total-patients"><?php echo $queue_stats['total_patients']; ?></h3>
                                    <p class="mb-0">Total Patients</p>
                                </div>
                                <div class="align-self-center">
                                    <i class="fas fa-users fa-2x"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-lg-3 col-md-6">
                    <div class="card bg-warning text-white">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h3 class="mb-1" id="waiting-patients"><?php echo $queue_stats['waiting']; ?></h3>
                                    <p class="mb-0">Waiting</p>
                                </div>
                                <div class="align-self-center">
                                    <i class="fas fa-clock fa-2x"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-lg-3 col-md-6">
                    <div class="card bg-primary text-white">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h3 class="mb-1" id="in-progress-patients"><?php echo $queue_stats['in_progress']; ?></h3>
                                    <p class="mb-0">In Progress</p>
                                </div>
                                <div class="align-self-center">
                                    <i class="fas fa-user-md fa-2x"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-lg-3 col-md-6">
                    <div class="card bg-success text-white">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h3 class="mb-1" id="treated-patients"><?php echo $queue_stats['treated']; ?></h3>
                                    <p class="mb-0">Treated</p>
                                </div>
                                <div class="align-self-center">
                                    <i class="fas fa-check-circle fa-2x"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Current & Next Patient Cards -->
            <div class="row mb-4">
                <div class="col-md-6">
                    <div class="card border-primary">
                        <div class="card-header bg-primary text-white">
                            <h5 class="mb-0">
                                <i class="fas fa-user-md mr-2"></i>Currently Treating
                            </h5>
                        </div>
                        <div class="card-body" id="current-patient-card">
                            <?php if ($current_patient): ?>
                                <h6 class="text-primary">Queue #<?php echo $current_patient->queue_number; ?></h6>
                                <h5><?php echo $current_patient->patient_name; ?></h5>
                                <p class="text-muted mb-1">
                                    <i class="fas fa-phone mr-2"></i><?php echo $current_patient->patient_phone; ?>
                                </p>
                                <p class="text-muted mb-1">
                                    <i class="fas fa-clock mr-2"></i>Scheduled: <?php echo date('h:i A', strtotime($current_patient->time)); ?>
                                </p>
                                <button onclick="markTreated(<?php echo $current_patient->appointment_id; ?>)" 
                                        class="btn btn-success btn-sm mt-2">
                                    <i class="fas fa-check mr-1"></i>Mark as Treated
                                </button>
                            <?php else: ?>
                                <div class="text-center text-muted py-4">
                                    <i class="fas fa-user-slash fa-3x mb-3"></i>
                                    <p>No patient currently being treated</p>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-6">
                    <div class="card border-warning">
                        <div class="card-header bg-warning text-white">
                            <h5 class="mb-0">
                                <i class="fas fa-clock mr-2"></i>Next Patient
                            </h5>
                        </div>
                        <div class="card-body" id="next-patient-card">
                            <?php if ($next_patient): ?>
                                <h6 class="text-warning">Queue #<?php echo $next_patient->queue_number; ?></h6>
                                <h5><?php echo $next_patient->patient_name; ?></h5>
                                <p class="text-muted mb-1">
                                    <i class="fas fa-phone mr-2"></i><?php echo $next_patient->patient_phone; ?>
                                </p>
                                <p class="text-muted mb-1">
                                    <i class="fas fa-clock mr-2"></i>Scheduled: <?php echo date('h:i A', strtotime($next_patient->time)); ?>
                                </p>
                                <button onclick="startTreating(<?php echo $next_patient->appointment_id; ?>)" 
                                        class="btn btn-primary btn-sm mt-2 sendSmsNotification" data-id="<?php echo $next_patient->appointment_id ?>">
                                    <i class="fas fa-play mr-1"></i>Start Treatment
                                </button>
                            <?php else: ?>
                                <div class="text-center text-muted py-4">
                                    <i class="fas fa-check-circle fa-3x mb-3"></i>
                                    <p>No more patients in queue</p>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Queue List with Tabs -->
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mb-0">
                                <i class="fas fa-list mr-2"></i>Today's Queue
                            </h5>
                            <!-- Tab Navigation -->
                            <ul class="nav nav-tabs mt-3" id="queueTabs" role="tablist">
                                <li class="nav-item">
                                    <a class="nav-link active" id="active-queue-tab" data-toggle="tab" href="#active-queue" role="tab">
                                        <i class="fas fa-clock mr-1"></i>Active Queue 
                                        <span class="badge badge-primary ml-1" id="active-count"><?php echo count(array_filter($queue, function($item) { return $item->queue_status != 'treated'; })); ?></span>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" id="treated-queue-tab" data-toggle="tab" href="#treated-queue" role="tab">
                                        <i class="fas fa-check-circle mr-1"></i>Treated Patients
                                        <span class="badge badge-success ml-1" id="treated-count"><?php echo count(array_filter($queue, function($item) { return $item->queue_status == 'treated'; })); ?></span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                        <div class="card-body">
                            <!-- Tab Content -->
                            <div class="tab-content" id="queueTabContent">
                                <!-- Active Queue Tab -->
                                <div class="tab-pane fade show active" id="active-queue" role="tabpanel">
                            <div class="table-responsive">
                                        <table class="table table-striped" id="active-queue-table">
                                    <thead class="thead-dark">
                                        <tr>
                                            <th>Queue #</th>
                                            <th>Patient Name</th>
                                            <th>Phone</th>
                                            <th>Age/Gender</th>
                                            <th>Scheduled Time</th>
                                            <th>Problem</th>
                                            <th>Status</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                            <tbody id="active-queue-tbody">
                                        <?php foreach ($queue as $item): ?>
                                            <?php if ($item->queue_status != 'treated'): ?>
                                            <tr id="active-row-<?php echo $item->appointment_id; ?>" 
                                                class="<?php echo getRowClass($item->queue_status); ?>">
                                                <td>
                                                    <span class="badge badge-primary badge-lg">
                                                        #<?php echo $item->queue_number; ?>
                                                    </span>
                                                </td>
                                                <td>
                                                    <strong><?php echo $item->patient_name; ?></strong>
                                                    <br><small class="text-muted">ID: <?php echo $item->patient_id; ?></small>
                                                </td>
                                                <td><?php echo $item->patient_phone; ?></td>
                                                <td>
                                                    <?php echo $item->patient_age; ?> / <?php echo $item->patient_gender; ?>
                                                </td>
                                                <td>
                                                    <i class="fas fa-clock mr-1"></i>
                                                    <?php echo date('h:i A', strtotime($item->time)); ?>
                                                </td>
                                                <td><?php echo $item->problem ?: '-'; ?></td>
                                                <td>
                                                    <span class="badge <?php echo getStatusBadgeClass($item->queue_status); ?>">
                                                        <?php echo ucfirst($item->queue_status); ?>
                                                    </span>
                                                </td>
                                                <td>
                                                    <?php if ($item->queue_status == 'waiting'): ?>
                                                        <button onclick="startTreating(<?php echo $item->appointment_id; ?>)" 
                                                                class="btn btn-primary btn-sm">
                                                            <i class="fas fa-play mr-1"></i>Start
                                                        </button>
                                                    <?php elseif ($item->queue_status == 'in_progress'): ?>
                                                        <button onclick="markTreated(<?php echo $item->appointment_id; ?>)" 
                                                                class="btn btn-success btn-sm">
                                                            <i class="fas fa-check mr-1"></i>Complete
                                                        </button>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                            <?php endif; ?>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        
                        <!-- Treated Patients Tab -->
                        <div class="tab-pane fade" id="treated-queue" role="tabpanel">
                            <div class="table-responsive">
                                <table class="table table-striped" id="treated-queue-table">
                                    <thead class="thead-dark">
                                        <tr>
                                            <th>Queue #</th>
                                            <th>Patient Name</th>
                                            <th>Phone</th>
                                            <th>Age/Gender</th>
                                            <th>Scheduled Time</th>
                                            <th>Problem</th>
                                            <th>Treated At</th>
                                            <th>Status</th>
                                        </tr>
                                    </thead>
                                    <tbody id="treated-queue-tbody">
                                        <?php foreach ($queue as $item): ?>
                                            <?php if ($item->queue_status == 'treated'): ?>
                                            <tr id="treated-row-<?php echo $item->appointment_id; ?>" 
                                                class="<?php echo getRowClass($item->queue_status); ?>">
                                                <td>
                                                    <span class="badge badge-success badge-lg">
                                                        #<?php echo $item->queue_number; ?>
                                                    </span>
                                                </td>
                                                <td>
                                                    <strong><?php echo $item->patient_name; ?></strong>
                                                    <br><small class="text-muted">ID: <?php echo $item->patient_id; ?></small>
                                                </td>
                                                <td><?php echo $item->patient_phone; ?></td>
                                                <td>
                                                    <?php echo $item->patient_age; ?> / <?php echo $item->patient_gender; ?>
                                                </td>
                                                <td>
                                                    <i class="fas fa-clock mr-1"></i>
                                                    <?php echo date('h:i A', strtotime($item->time)); ?>
                                                </td>
                                                <td><?php echo $item->problem ?: '-'; ?></td>
                                                <td>
                                                    <?php if ($item->treated_at): ?>
                                                        <i class="fas fa-check-circle text-success mr-1"></i>
                                                        <?php echo date('h:i A', strtotime($item->treated_at)); ?>
                                                    <?php else: ?>
                                                        <span class="text-muted">-</span>
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <span class="badge badge-success">
                                                        <i class="fas fa-check-circle mr-1"></i>Treated
                                                    </span>
                                                </td>
                                            </tr>
                                            <?php endif; ?>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Auto-refresh notification -->
<div id="refresh-notification" class="alert alert-info alert-dismissible" style="position: fixed; top: 20px; right: 20px; z-index: 9999; display: none;">
    <button type="button" class="close" data-dismiss="alert">&times;</button>
    <i class="fas fa-sync-alt mr-2"></i>Queue updated automatically
</div>

<script>
let refreshInterval;

$(document).ready(function() {
    // Auto-refresh every 30 seconds
    refreshInterval = setInterval(refreshQueue, 30000);
    
    // Add visual feedback for actions
    $('[data-toggle="tooltip"]').tooltip();
});

function startTreating(appointmentId) {
    $.ajax({
        url: 'doctor/startTreatingPatient',
        type: 'POST',
        data: { appointment_id: appointmentId },
        dataType: 'json',
        success: function(response) {
            if (response.status === 'success') {
                showNotification('Patient treatment started!', 'success');
                refreshQueue();
            } else {
                showNotification(response.message, 'error');
            }
        },
        error: function() {
            showNotification('Error starting treatment', 'error');
        }
    });
}

function markTreated(appointmentId) {
    if (confirm('Mark this patient as treated?')) {
        $.ajax({
            url: 'doctor/markPatientTreated',
            type: 'POST',
            data: { appointment_id: appointmentId },
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    showNotification('Patient marked as treated!', 'success');
                    refreshQueue();
                } else {
                    showNotification(response.message, 'error');
                }
            },
            error: function() {
                showNotification('Error marking patient as treated', 'error');
            }
        });
    }
}

function refreshQueue() {
    $.ajax({
        url: 'doctor/getQueueData',
        type: 'GET',
        data: { 
            doctor_id: <?php echo $doctor->id; ?>,
            date: '<?php echo $selected_date; ?>'
        },
        dataType: 'json',
        success: function(response) {
            if (response.status === 'success') {
                updateQueueDisplay(response);
                $('#refresh-notification').fadeIn().delay(2000).fadeOut();
            }
        },
        error: function() {
            console.log('Error refreshing queue');
        }
    });
}

function updateQueueDisplay(data) {
    // Update statistics
    $('#total-patients').text(data.stats.total_patients);
    $('#waiting-patients').text(data.stats.waiting);
    $('#in-progress-patients').text(data.stats.in_progress);
    $('#treated-patients').text(data.stats.treated);
    
    // Update current patient card
    updateCurrentPatientCard(data.current_patient);
    
    // Update next patient card
    updateNextPatientCard(data.next_patient);
    
    // Update queue table
    updateQueueTable(data.queue);
}

function updateCurrentPatientCard(patient) {
    let html = '';
    if (patient) {
        html = `
            <h6 class="text-primary">Queue #${patient.queue_number}</h6>
            <h5>${patient.patient_name}</h5>
            <p class="text-muted mb-1">
                <i class="fas fa-phone mr-2"></i>${patient.patient_phone}
            </p>
            <p class="text-muted mb-1">
                <i class="fas fa-clock mr-2"></i>Scheduled: ${formatTime(patient.time)}
            </p>
            <button onclick="markTreated(${patient.appointment_id})" class="btn btn-success btn-sm mt-2">
                <i class="fas fa-check mr-1"></i>Mark as Treated
            </button>
        `;
    } else {
        html = `
            <div class="text-center text-muted py-4">
                <i class="fas fa-user-slash fa-3x mb-3"></i>
                <p>No patient currently being treated</p>
            </div>
        `;
    }
    $('#current-patient-card').html(html);
}

function updateNextPatientCard(patient) {
    let html = '';
    if (patient) {
        html = `
            <h6 class="text-warning">Queue #${patient.queue_number}</h6>
            <h5>${patient.patient_name}</h5>
            <p class="text-muted mb-1">
                <i class="fas fa-phone mr-2"></i>${patient.patient_phone}
            </p>
            <p class="text-muted mb-1">
                <i class="fas fa-clock mr-2"></i>Scheduled: ${formatTime(patient.time)}
            </p>
            <button onclick="startTreating(${patient.appointment_id})" class="btn btn-primary btn-sm mt-2">
                <i class="fas fa-play mr-1"></i>Start Treatment
            </button>
        `;
    } else {
        html = `
            <div class="text-center text-muted py-4">
                <i class="fas fa-check-circle fa-3x mb-3"></i>
                <p>No more patients in queue</p>
            </div>
        `;
    }
    $('#next-patient-card').html(html);
}

function updateQueueTable(queue) {
    let activeTbody = '';
    let treatedTbody = '';
    let activeCount = 0;
    let treatedCount = 0;
    
    queue.forEach(function(item) {
        let statusBadge = getStatusBadge(item.queue_status);
        let rowClass = getRowClass(item.queue_status);
        
        if (item.queue_status === 'treated') {
            treatedCount++;
            let treatedTime = item.treated_at ? formatTime(item.treated_at) : '-';
            treatedTbody += `
                <tr id="treated-row-${item.appointment_id}" class="${rowClass}">
                    <td><span class="badge badge-success badge-lg">#${item.queue_number}</span></td>
                    <td><strong>${item.patient_name}</strong><br><small class="text-muted">ID: ${item.patient_id}</small></td>
                    <td>${item.patient_phone}</td>
                    <td>${item.patient_age} / ${item.patient_gender}</td>
                    <td><i class="fas fa-clock mr-1"></i>${formatTime(item.time)}</td>
                    <td>${item.problem || '-'}</td>
                    <td><i class="fas fa-check-circle text-success mr-1"></i>${treatedTime}</td>
                    <td><span class="badge badge-success"><i class="fas fa-check-circle mr-1"></i>Treated</span></td>
                </tr>
            `;
        } else {
            activeCount++;
            let actions = getActionButtons(item);
            activeTbody += `
                <tr id="active-row-${item.appointment_id}" class="${rowClass}">
                <td><span class="badge badge-primary badge-lg">#${item.queue_number}</span></td>
                    <td><strong>${item.patient_name}</strong><br><small class="text-muted">ID: ${item.patient_id}</small></td>
                <td>${item.patient_phone}</td>
                <td>${item.patient_age} / ${item.patient_gender}</td>
                <td><i class="fas fa-clock mr-1"></i>${formatTime(item.time)}</td>
                <td>${item.problem || '-'}</td>
                <td>${statusBadge}</td>
                <td>${actions}</td>
            </tr>
        `;
        }
    });
    
    $('#active-queue-tbody').html(activeTbody);
    $('#treated-queue-tbody').html(treatedTbody);
    
    // Update tab counts
    $('#active-count').text(activeCount);
    $('#treated-count').text(treatedCount);
}

function getStatusBadge(status) {
    const badges = {
        'waiting': '<span class="badge badge-warning">Waiting</span>',
        'in_progress': '<span class="badge badge-primary">In Progress</span>',
        'treated': '<span class="badge badge-success">Treated</span>',
        'missed': '<span class="badge badge-danger">Missed</span>'
    };
    return badges[status] || '<span class="badge badge-secondary">Unknown</span>';
}

function getActionButtons(item) {
    if (item.queue_status === 'waiting') {
        return `<button onclick="startTreating(${item.appointment_id})" class="btn btn-primary btn-sm">
                    <i class="fas fa-play mr-1"></i>Start
                </button>`;
    } else if (item.queue_status === 'in_progress') {
        return `<button onclick="markTreated(${item.appointment_id})" class="btn btn-success btn-sm">
                    <i class="fas fa-check mr-1"></i>Complete
                </button>`;
    } else if (item.queue_status === 'treated') {
        let treatedTime = item.treated_at ? `<br><small>${formatTime(item.treated_at)}</small>` : '';
        return `<span class="text-success">
                    <i class="fas fa-check-circle mr-1"></i>Done${treatedTime}
                </span>`;
    }
    return '';
}

function getRowClass(status) {
    const classes = {
        'waiting': '',
        'in_progress': 'table-primary',
        'treated': 'table-success',
        'missed': 'table-danger'
    };
    return classes[status] || '';
}

function formatTime(timeStr) {
    if (!timeStr) return '';
    const time = new Date('2000-01-01 ' + timeStr);
    return time.toLocaleTimeString([], {hour: '2-digit', minute:'2-digit'});
}

function showNotification(message, type) {
    const alertType = type === 'success' ? 'alert-success' : 'alert-danger';
    const icon = type === 'success' ? 'fa-check-circle' : 'fa-exclamation-triangle';
    
    const notification = `
        <div class="alert ${alertType} alert-dismissible" style="position: fixed; top: 20px; right: 20px; z-index: 9999;">
            <button type="button" class="close" data-dismiss="alert">&times;</button>
            <i class="fas ${icon} mr-2"></i>${message}
        </div>
    `;
    
    $('body').append(notification);
    setTimeout(function() {
        $('.alert').fadeOut();
    }, 3000);
}

// Clear interval when leaving page
$(window).on('beforeunload', function() {
    if (refreshInterval) {
        clearInterval(refreshInterval);
    }
});
</script>

<?php
function getRowClass($status) {
    switch ($status) {
        case 'in_progress': return 'table-primary';
        case 'treated': return 'table-success';
        case 'missed': return 'table-danger';
        default: return '';
    }
}

function getStatusBadgeClass($status) {
    switch ($status) {
        case 'waiting': return 'badge-warning';
        case 'in_progress': return 'badge-primary';
        case 'treated': return 'badge-success';
        case 'missed': return 'badge-danger';
        default: return 'badge-secondary';
    }
}
?>

<style>
.badge-lg {
    font-size: 1rem;
    padding: 0.5rem 0.75rem;
}

.table-responsive {
    border-radius: 0.5rem;
}

.card {
    border-radius: 0.75rem;
    box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
}

.card-header {
    border-radius: 0.75rem 0.75rem 0 0 !important;
}

#refresh-notification {
    min-width: 250px;
}

.btn-sm {
    font-size: 0.8rem;
    padding: 0.25rem 0.5rem;
}

.table th {
    border-top: none;
    font-weight: 600;
}

/* Tab styling */
.nav-tabs {
    border-bottom: 2px solid #dee2e6;
}

.nav-tabs .nav-link {
    color: #495057;
    font-weight: 500;
    border: none;
    border-bottom: 3px solid transparent;
    margin-bottom: -2px;
}

.nav-tabs .nav-link:hover {
    border-color: transparent transparent #007bff;
    background-color: transparent;
}

.nav-tabs .nav-link.active {
    color: #007bff;
    border-color: transparent transparent #007bff;
    background-color: transparent;
    font-weight: 600;
}

.nav-tabs .nav-link .badge {
    font-size: 0.75rem;
}

/* Enhanced badge styling for better contrast */
.badge {
    color: #fff !important;
    font-weight: 500;
    text-shadow: 0 1px 2px rgba(0, 0, 0, 0.2);
}

.badge-primary {
    background: linear-gradient(45deg, #007bff, #0056b3) !important;
    border: 1px solid #0056b3;
}

.badge-warning {
    background: linear-gradient(45deg, #ffc107, #e0a800) !important;
    border: 1px solid #d39e00;
}

.badge-success {
    background: linear-gradient(45deg, #28a745, #1e7e34) !important;
    border: 1px solid #1c7430;
}

.badge-danger {
    background: linear-gradient(45deg, #dc3545, #c82333) !important;
    border: 1px solid #bd2130;
}

.badge-secondary {
    background: linear-gradient(45deg, #6c757d, #545b62) !important;
    border: 1px solid #4e555b;
}

.badge-lg {
    font-size: 1rem;
    padding: 0.5rem 0.75rem;
    font-weight: 600;
    letter-spacing: 0.5px;
}
</style>

<!-- Hospital Dropdown JavaScript -->
<?php if ($this->ion_auth->in_group(array('Doctor')) && isset($hospitals)) { ?>
<script>
$(document).ready(function() {
    // Doctor hospital selection dropdown change handler
    $('#doctor_hospital_select').change(function() {
        const selectedHospital = $(this).val();
        
        // Build URL with hospital parameter
        let url = '<?php echo base_url(); ?>doctor/queue';
        if (selectedHospital) {
            url += '?hospital_id=' + selectedHospital;
        }
        
        // Show loading feedback
        $(this).next('.loading-feedback').remove();
        $(this).after('<div class="loading-feedback ml-2"><i class="fas fa-spinner fa-spin mr-2"></i>Loading hospital queue data...</div>');
        
        // Redirect to reload page with selected hospital
        window.location.href = url;
    });
});
</script>
<?php } ?> 
<script>
    $(function () {
  $(document).on('click', '.sendSmsNotification', function (e) {
      // e.preventDefault(); // Removed as per instruction
      const $btn = $(this);
      const id = $btn.data("id");
      if (!id) {
          show_swal('Error', 'error', 'Invalid appointment ID');
          return;
      }
      
      $.ajax({
          url: "appointment/sendSmsNotification",
          method: "GET",
          data: { id: id },
          dataType: "json"
      })
      .done(function (response) {
          if (response && response.status === 'success') {
              show_swal('Success', 'success', response.message || 'SMS sent successfully');
          } else {
              show_swal('Error', 'error', response.message || 'Failed to send SMS');
          }
      })
      .fail(function (xhr) {
          show_swal('Error', 'error', 'An error occurred while sending SMS');
      })
      .always(function () {
          
      });
  });
});
</script>