<!--sidebar end-->
<!--main content start-->
<link href="common/extranal/css/doctor/doctor.css" rel="stylesheet">

<div class="content-wrapper bg-light">
    <section class="content-header py-4 bg-white shadow-sm">
        <div class="container-fluid">
            <div class="row align-items-center">
                <div class="col-sm-6">
                    <h1 class="display-4 font-weight-black mb-0">
                        <i class="fas fa-user text-primary mr-3"></i>
                        <?php echo lang('doctor'); ?>
                    </h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb bg-transparent mb-0">
                            <li class="breadcrumb-item"><a href="home"> <?php echo lang('home'); ?></a></li>
                            <li class="breadcrumb-item active"> <?php echo lang('doctor'); ?></li>
                        </ol>
                    </nav>
                </div>
                <div class="col-sm-6 text-right">
                    <a data-toggle="modal" href="#myModal" class="btn btn-primary btn-sm px-4 py-3">
                        <i class="fa fa-plus"></i> <?php echo lang('add_new'); ?> <?php echo lang('doctor'); ?>
                    </a>
                </div>
            </div>
        </div>
    </section>

    <section class="content py-5">
        <div class="container-fluid">
            <div class="row justify-content-center">
                <div class="col-md-12">
                    <div class="card shadow-lg border-0">
                        <div class="card-body bg-light p-4">
                            <table class="table table-bordered table-hover datatables" id="editable-sample" width="100%">
                                <thead>
                                    <tr>
                                        <th><?php echo lang('id'); ?></th>
                                        <th><?php echo lang('name'); ?></th>
                                        <th><?php echo lang('email'); ?></th>
                                        <th><?php echo lang('phone'); ?></th>
                                        <th><?php echo lang('department'); ?></th>
                                        <th><?php echo lang('hospital'); ?></th>
                                        <th><?php echo lang('profile'); ?></th>
                                        <th class="no-print"><?php echo lang('options'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Add Doctor Modal-->
<div class="modal fade" id="myModal" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <!-- <div class="modal-header  py-4">
                <h2 class="modal-title text-white display-6 font-weight-800"><?php echo lang('add_new_doctor'); ?></h2>
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div> -->
            <div class="modal-body bg-light p-4">
                <form action="doctor/addNew" method="post" enctype="multipart/form-data">
                    <div class="row mb-5">
                        <div class="col-12 mb-4">
                            <h3 class="border-bottom border-primary pb-3 text-uppercase font-weight-900">
                                <i class="fas fa-user-circle mr-3 text-primary"></i><?php echo lang('add_new_doctor'); ?>
                            </h3>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('name'); ?> <span class="text-danger">*</span></label>
                                <input type="text" class="form-control form-control-lg shadow-sm" name="name" required>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('email'); ?> <span class="text-danger">*</span></label>
                                <input type="email" class="form-control form-control-lg shadow-sm" name="email" required>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('password'); ?> <span class="text-danger">*</span></label>
                                <input type="password" class="form-control form-control-lg shadow-sm" name="password" required>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('address'); ?> <span class="text-danger">*</span></label>
                                <input type="text" class="form-control form-control-lg shadow-sm" name="address" required>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('phone'); ?> <span class="text-danger">*</span></label>
                                <input type="text" class="form-control form-control-lg shadow-sm" name="phone" required>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('department'); ?></label>
                                <select class="form-control form-control-lg shadow-sm" name="department">
                                    <?php foreach ($departments as $department) { ?>
                                        <option value="<?php echo $department->id; ?>"> <?php echo $department->name; ?> </option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('speciality'); ?></label>
                                <select class="form-control form-control-lg shadow-sm" name="speciality_id">
                                    <option value="">-- <?php echo lang('select'); ?> <?php echo lang('speciality'); ?> --</option>
                                    <?php foreach ($specialities as $speciality) { ?>
                                        <option value="<?php echo $speciality->id; ?>"> <?php echo $speciality->name; ?> </option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-12 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('qualification'); ?></label>
                                <input type="text" class="form-control form-control-lg shadow-sm" name="qualification" placeholder="<?php echo lang('qualification'); ?>">
                            </div>
                        </div>

                        <!-- Grouped Settings Section -->
                        <div class="col-md-12 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted">Doctor Settings</label>
                                <div class="card border border-primary">
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-group mb-0">
                                                    <label class="font-weight-bold text-muted"><?php echo lang('schedule_type'); ?></label>
                                                    <select class="form-control form-control-lg shadow-sm" name="schedule_type">
                                                        <option value="weekday" selected><?php echo lang('weekday_based'); ?></option>
                                                        <option value="date"><?php echo lang('date_based'); ?></option>
                                                    </select>
                                                    <small class="form-text text-muted">Schedule management type</small>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group mb-0">
                                                    <label class="font-weight-bold text-muted">Online Payment Setting</label>
                                                    <select class="form-control form-control-lg shadow-sm" name="online_payment_enabled">
                                                        <option value="disabled">Book Without Payment</option>
                                                        <option value="optional">Optional</option>
                                                        <option value="required">Payment Required</option>
                                                    </select>
                                                    <small class="form-text text-muted">Controls online payment requirements</small>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group mb-0">
                                                    <label class="font-weight-bold text-muted">Cancellation Permission</label>
                                                    <select class="form-control form-control-lg shadow-sm" name="cancellation_permission" id="cancellation_permission">
                                                        <option value="allow">Allow Cancellation</option>
                                                        <option value="disallow">Disallow Cancellation</option>
                                                    </select>
                                                    <small class="form-text text-muted">Controls patient cancellation rights</small>
                                                </div>
                                            </div>
                                            <div class="col-md-4" id="cancellation_type_container">
                                                <div class="form-group mb-0">
                                                    <label class="font-weight-bold text-muted">Cancellation Type</label>
                                                    <select class="form-control form-control-lg shadow-sm" name="cancellation_type">
                                                        <option value="both">Both Paid & Non-Paid</option>
                                                        <option value="paid_only">Paid Appointments Only</option>
                                                        <option value="non_paid_only">Non-Paid Appointments Only</option>
                                                    </select>
                                                    <small class="form-text text-muted">Which appointments can be cancelled</small>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <small class="form-text text-muted">
                                    Configure doctor's operational settings and policies
                                </small>
                            </div>
                        </div>

                        <div class="col-md-12 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted">SMS Notification Settings</label>
                                <div class="card border border-info">
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="custom-control custom-checkbox">
                                                    <input type="checkbox" class="custom-control-input" 
                                                           name="sms_advanced_paid_bookings" 
                                                           value="yes" 
                                                           id="add-sms-advanced-paid" 
                                                           checked>
                                                    <label class="custom-control-label" for="add-sms-advanced-paid">
                                                        <strong>Advanced Paid Bookings</strong>
                                                        <br><small class="text-muted">SMS for paid online bookings</small>
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="custom-control custom-checkbox">
                                                    <input type="checkbox" class="custom-control-input" 
                                                           name="sms_online_no_payment" 
                                                           value="yes" 
                                                           id="add-sms-online-no-payment" 
                                                           checked>
                                                    <label class="custom-control-label" for="add-sms-online-no-payment">
                                                        <strong>Online No Payment</strong>
                                                        <br><small class="text-muted">SMS for free online bookings</small>
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="custom-control custom-checkbox">
                                                    <input type="checkbox" class="custom-control-input" 
                                                           name="sms_ivr_bookings" 
                                                           value="yes" 
                                                           id="add-sms-ivr-bookings" 
                                                           checked>
                                                    <label class="custom-control-label" for="add-sms-ivr-bookings">
                                                        <strong>IVR Bookings</strong>
                                                        <br><small class="text-muted">SMS for phone bookings</small>
                                                    </label>
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="custom-control custom-checkbox">
                                                    <input type="checkbox" class="custom-control-input" 
                                                           name="sms_booking_confirmation_patient" 
                                                           value="yes" 
                                                           id="sms_booking_confirmation_patient" 
                                                           checked>
                                                    <label class="custom-control-label" for="sms_booking_confirmation_patient">
                                                        <strong>Bookings Confirmation Patient</strong>
                                                        <br><small class="text-muted">SMS for booking confirmation to patient</small>
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="custom-control custom-checkbox">
                                                    <input type="checkbox" class="custom-control-input" 
                                                           name="sms_session_start_notification_patient" 
                                                           value="yes" 
                                                           id="sms_session_start_notification_patient" 
                                                           checked>
                                                    <label class="custom-control-label" for="sms_session_start_notification_patient">
                                                        <strong>Session Start Notification Patient</strong>
                                                        <br><small class="text-muted">SMS for session start notification to patient</small>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <small class="form-text text-muted">
                                    Configure when SMS notifications should be sent to patients
                                </small>
                            </div>
                        </div>

                        <!-- Doctor Description - Moved to bottom -->
                        <div class="col-md-12 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('doctor'); ?> <?php echo lang('description'); ?></label>
                                <textarea class="form-control shadow-sm" id="editor1" name="profile" rows="5" placeholder="Enter doctor's professional description, experience, and specializations..."></textarea>
                                <small class="form-text text-muted">Provide a detailed description of the doctor's background and expertise</small>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('signature'); ?> <span class="text-danger">*</span></label>
                                <div class="custom-file">
                                    <input type="file" class="custom-file-input" name="signature">
                                    <label class="custom-file-label shadow-sm"><?php echo lang('choose_signature_image'); ?></label>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('image'); ?></label>
                                <div class="custom-file">
                                    <input type="file" class="custom-file-input" name="img_url">
                                    <label class="custom-file-label shadow-sm"><?php echo lang('choose_profile_picture'); ?></label>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <button type="submit" class="btn btn-primary btn-lg btn-block shadow-lg py-3">
                                <i class="fas fa-user-plus mr-3"></i><?php echo lang('submit'); ?>
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Edit Doctor Modal-->
<div class="modal fade" id="myModal2" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <!-- <div class="modal-header bg-gradient-primary py-4">
                <h2 class="modal-title text-white display-6 font-weight-800"><?php echo lang('edit_doctor'); ?></h2>
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div> -->
            <div class="modal-body bg-light p-4">
                <form id="editDoctorForm" action="doctor/addNew" method="post" enctype="multipart/form-data">
                    <div class="row mb-5">
                        <div class="col-12 mb-4">
                            <h3 class="border-bottom border-primary pb-3 text-uppercase font-weight-900">
                                <i class="fas fa-user-circle mr-3 text-primary"></i><?php echo lang('update_doctor_details'); ?>
                            </h3>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('name'); ?> <span class="text-danger">*</span></label>
                                <input type="text" class="form-control form-control-lg shadow-sm" name="name" required>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('email'); ?> <span class="text-danger">*</span></label>
                                <input type="email" class="form-control form-control-lg shadow-sm" name="email" required>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('password'); ?></label>
                                <input type="password" class="form-control form-control-lg shadow-sm" name="password" placeholder="********">
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('address'); ?> <span class="text-danger">*</span></label>
                                <input type="text" class="form-control form-control-lg shadow-sm" name="address" required>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('phone'); ?> <span class="text-danger">*</span></label>
                                <input type="text" class="form-control form-control-lg shadow-sm" name="phone" required>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('department'); ?></label>
                                <select class="form-control form-control-lg shadow-sm department" name="department">
                                    <?php foreach ($departments as $department) { ?>
                                        <option value="<?php echo $department->id; ?>" <?php
                                                                                        if (!empty($doctor->department)) {
                                                                                            if ($department->id == $doctor->department) {
                                                                                                echo 'selected';
                                                                                            }
                                                                                        }
                                                                                        ?>> <?php echo $department->name; ?> </option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('speciality'); ?></label>
                                <select class="form-control form-control-lg shadow-sm js-example-basic-single speciality" name="speciality_id">
                                    <option value="">-- <?php echo lang('select'); ?> <?php echo lang('speciality'); ?> --</option>
                                    <?php foreach ($specialities as $speciality) { ?>
                                        <option value="<?php echo $speciality->id; ?>"> <?php echo $speciality->name; ?> </option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-12 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('qualification'); ?></label>
                                <input type="text" class="form-control form-control-lg shadow-sm qualification" name="qualification" placeholder="<?php echo lang('qualification'); ?>">
                            </div>
                        </div>

                        <!-- Grouped Settings Section -->
                        <div class="col-md-12 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted">Doctor Settings</label>
                                <div class="card border border-primary">
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-group mb-0">
                                                    <label class="font-weight-bold text-muted"><?php echo lang('schedule_type'); ?></label>
                                                    <select class="form-control form-control-lg shadow-sm schedule_type" name="schedule_type">
                                                        <option value="weekday"><?php echo lang('weekday_based'); ?></option>
                                                        <option value="date"><?php echo lang('date_based'); ?></option>
                                                    </select>
                                                    <small class="form-text text-muted">Schedule management type</small>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group mb-0">
                                                    <label class="font-weight-bold text-muted">Online Payment Setting</label>
                                                    <select class="form-control form-control-lg shadow-sm online_payment_enabled" name="online_payment_enabled">
                                                        <option value="disabled">Book Without Payment</option>
                                                        <option value="optional">Optional</option>
                                                        <option value="required">Payment Required</option>
                                                    </select>
                                                    <small class="form-text text-muted">Controls online payment requirements</small>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group mb-0">
                                                    <label class="font-weight-bold text-muted">Cancellation Permission</label>
                                                    <select class="form-control form-control-lg shadow-sm cancellation_permission" name="cancellation_permission" id="edit_cancellation_permission">
                                                        <option value="allow">Allow Cancellation</option>
                                                        <option value="disallow">Disallow Cancellation</option>
                                                    </select>
                                                    <small class="form-text text-muted">Controls patient cancellation rights</small>
                                                </div>
                                            </div>
                                            <div class="col-md-4" id="edit_cancellation_type_container">
                                                <div class="form-group mb-0">
                                                    <label class="font-weight-bold text-muted">Cancellation Type</label>
                                                    <select class="form-control form-control-lg shadow-sm cancellation_type" name="cancellation_type" id="edit_cancellation_type">
                                                        <option value="both">Both Paid & Non-Paid</option>
                                                        <option value="paid_only">Paid Appointments Only</option>
                                                        <option value="non_paid_only">Non-Paid Appointments Only</option>
                                                    </select>
                                                    <small class="form-text text-muted">Which appointments can be cancelled</small>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <small class="form-text text-muted">
                                    Configure doctor's operational settings and policies
                                </small>
                            </div>
                        </div>

                        <div class="col-md-12 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted">SMS Notification Settings</label>
                                <div class="card border border-info">
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="custom-control custom-checkbox">
                                                    <input type="checkbox" class="custom-control-input sms_advanced_paid_bookings" 
                                                           name="sms_advanced_paid_bookings" 
                                                           value="yes" 
                                                           id="edit-sms-advanced-paid">
                                                    <label class="custom-control-label" for="edit-sms-advanced-paid">
                                                        <strong>Advanced Paid Bookings</strong>
                                                        <br><small class="text-muted">SMS for paid online bookings</small>
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="custom-control custom-checkbox">
                                                    <input type="checkbox" class="custom-control-input sms_online_no_payment" 
                                                           name="sms_online_no_payment" 
                                                           value="yes" 
                                                           id="edit-sms-online-no-payment">
                                                    <label class="custom-control-label" for="edit-sms-online-no-payment">
                                                        <strong>Online No Payment</strong>
                                                        <br><small class="text-muted">SMS for free online bookings</small>
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="custom-control custom-checkbox">
                                                    <input type="checkbox" class="custom-control-input sms_ivr_bookings" 
                                                           name="sms_ivr_bookings" 
                                                           value="yes" 
                                                           id="edit-sms-ivr-bookings">
                                                    <label class="custom-control-label" for="edit-sms-ivr-bookings">
                                                        <strong>IVR Bookings</strong>
                                                        <br><small class="text-muted">SMS for phone bookings</small>
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="custom-control custom-checkbox">
                                                    <input type="checkbox" class="custom-control-input sms_booking_confirmation_patient" 
                                                           name="sms_booking_confirmation_patient" 
                                                           value="yes" 
                                                           id="edit_sms_booking_confirmation_patient" 
                                                           checked>
                                                    <label class="custom-control-label" for="edit_sms_booking_confirmation_patient">
                                                        <strong>Bookings Confirmation Patient</strong>
                                                        <br><small class="text-muted">SMS for booking confirmation to patient</small>
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="custom-control custom-checkbox">
                                                    <input type="checkbox" class="custom-control-input sms_session_start_notification_patient" 
                                                           name="sms_session_start_notification_patient" 
                                                           value="yes" 
                                                           id="edit_sms_session_start_notification_patient" 
                                                           checked>
                                                    <label class="custom-control-label" for="edit_sms_session_start_notification_patient">
                                                        <strong>Session Start Notification Patient</strong>
                                                        <br><small class="text-muted">SMS for session start notification to patient</small>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <small class="form-text text-muted">
                                    Configure when SMS notifications should be sent to patients
                                </small>
                            </div>
                        </div>

                        <!-- Doctor Description - Moved to bottom -->
                        <div class="col-md-12 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('doctor'); ?> <?php echo lang('description'); ?></label>
                                <textarea class="form-control shadow-sm profile" id="editor3" name="profile" rows="5" placeholder="Enter doctor's professional description, experience, and specializations..."></textarea>
                                <small class="form-text text-muted">Provide a detailed description of the doctor's background and expertise</small>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('signature'); ?> <span class="text-danger">*</span></label>
                                <div class="custom-file">
                                    <input type="file" class="custom-file-input" name="signature">
                                    <label class="custom-file-label shadow-sm"><?php echo lang('choose_signature_image'); ?></label>
                                </div>
                                <div class="mt-2">
                                    <img src="" id="signature" height="100px" alt="" class="img-thumbnail" />
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6 mb-4">
                            <div class="form-group">
                                <label class="text-uppercase font-weight-bold text-muted"><?php echo lang('image'); ?></label>
                                <div class="custom-file">
                                    <input type="file" class="custom-file-input" name="img_url">
                                    <label class="custom-file-label shadow-sm"><?php echo lang('choose_profile_picture'); ?></label>
                                </div>
                                <div class="mt-2">
                                    <img src="" id="img" height="100px" alt="" class="img-thumbnail" />
                                </div>
                            </div>
                        </div>
                    </div>

                    <input type="hidden" name="id" id="id_value">
                    <div class="row">
                        <div class="col-md-12">
                            <button type="submit" class="btn btn-primary btn-lg btn-block shadow-lg py-3">
                                <i class="fas fa-user-edit mr-3"></i><?php echo lang('submit'); ?>
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Info Modal -->
<div class="modal fade" id="infoModal" role="dialog" aria-labelledby="modalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-gradient-primary py-4">
                <h2 class="modal-title text-white display-6 font-weight-800"><?php echo lang('doctor'); ?> <?php echo lang('info'); ?></h2>
                <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body bg-light p-4">
                <div class="row justify-content-center">
                    <div class="col-md-12 text-center mb-4">
                        <img src="" id="img1" class="img-thumbnail" height="200px" alt="" />
                    </div>

                    <div class="col-md-12">
                        <div class="card shadow-sm">
                            <div class="card-body">
                                <div class="row mb-3">
                                    <div class="col-md-4 text-uppercase font-weight-bold text-muted"><?php echo lang('name'); ?></div>
                                    <div class="col-md-8 nameClass"></div>
                                </div>

                                <div class="row mb-3">
                                    <div class="col-md-4 text-uppercase font-weight-bold text-muted"><?php echo lang('email'); ?></div>
                                    <div class="col-md-8 emailClass"></div>
                                </div>

                                <div class="row mb-3">
                                    <div class="col-md-4 text-uppercase font-weight-bold text-muted"><?php echo lang('address'); ?></div>
                                    <div class="col-md-8 addressClass"></div>
                                </div>

                                <div class="row mb-3">
                                    <div class="col-md-4 text-uppercase font-weight-bold text-muted"><?php echo lang('phone'); ?></div>
                                    <div class="col-md-8 phoneClass"></div>
                                </div>

                                <div class="row mb-3">
                                    <div class="col-md-4 text-uppercase font-weight-bold text-muted"><?php echo lang('department'); ?></div>
                                    <div class="col-md-8 departmentClass"></div>
                                </div>

                                <div class="row mb-3">
                                    <div class="col-md-4 text-uppercase font-weight-bold text-muted"><?php echo lang('speciality'); ?></div>
                                    <div class="col-md-8 specialityClass"></div>
                                </div>

                                <div class="row mb-3">
                                    <div class="col-md-4 text-uppercase font-weight-bold text-muted"><?php echo lang('qualification'); ?></div>
                                    <div class="col-md-8 qualificationClass"></div>
                                </div>

                                <div class="row">
                                    <div class="col-md-4 text-uppercase font-weight-bold text-muted"><?php echo lang('profile'); ?></div>
                                    <div class="col-md-8 profileClass"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="common/js/codearistos.min.js"></script>
<script type="text/javascript">
    var language = "<?php echo $this->language; ?>";
</script>

<script src="common/assets/tinymce/tinymce.min.js"></script>
<script src="common/extranal/js/doctor/doctor.js"></script>

<script>
$(document).ready(function() {
    // Initially hide/show cancellation type based on permission
    toggleCancellationType();
    
    // Listen for changes to cancellation permission (add form)
    $('#cancellation_permission').change(function() {
        toggleCancellationType();
    });
    
    // Listen for changes to cancellation permission (edit form)
    $('#edit_cancellation_permission').change(function() {
        toggleEditCancellationType();
    });
    
    function toggleCancellationType() {
        var permission = $('#cancellation_permission').val();
        if (permission === 'allow') {
            $('#cancellation_type_container').show();
        } else {
            $('#cancellation_type_container').hide();
        }
    }
    
    function toggleEditCancellationType() {
        var permission = $('#edit_cancellation_permission').val();
        if (permission === 'allow') {
            $('#edit_cancellation_type_container').show();
        } else {
            $('#edit_cancellation_type_container').hide();
        }
    }
    
    // Function to be called after edit data is loaded
    window.updateEditFormVisibility = function() {
        toggleEditCancellationType();
    };
});
</script>