<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

use Twilio\Rest\Client;

class Cronjobs extends MX_Controller
{

    function __construct()
    {
        parent::__construct();

        $this->load->model('cronjobs_model');
        $this->load->model('email/email_model');
        $this->load->model('doctor/doctor_model');
        $this->load->model('patient/patient_model');
    }

    public function index()
    {
    }

    public function appointmentRemainder()
    {
        $settings_superadmin = $this->cronjobs_model->getSettings('superadmin');
        $num_of_hours = $settings_superadmin->remainder_appointment;

        if (!empty($num_of_hours)) {
            $time = strtotime(date('d-m-Y'));

            $appointment_details = $this->cronjobs_model->getAppointment($time);

            if (!empty($appointment_details)) {
                foreach ($appointment_details as $appointment) {
                    $date = date('d-m-Y', $appointment->date) . ' ' . $appointment->s_time;

                    $date_stamp = strtotime($date);
                    if ($appointment->cron_job != '1' || empty($appointment->cron_job)) {

                        if (($date_stamp - time()) <= ($num_of_hours * 3600) && $date_stamp > time()) {
                            $hospital_id = $appointment->hospital_id;

                            $settings = $this->cronjobs_model->getSettings($hospital_id);

                            $autosms = $this->cronjobs_model->getAutoSmsByType($hospital_id, 'appoinment_remainder');
                            $autoemail = $this->cronjobs_model->getAutoEmailByType($hospital_id, 'appoinment_remainder');
                            $hospital_id = $appointment->hospital_id;
                            $patientdetails = $this->cronjobs_model->getPatientById($hospital_id, $appointment->patient);
                            $doctordetails = $this->cronjobs_model->getDoctorById($hospital_id, $appointment->doctor);

                            $message = $autosms->message;
                            $to = $patientdetails->phone;
                            $name1 = explode(' ', $patientdetails->name);
                            if (!isset($name1[1])) {
                                $name1[1] = null;
                            }
                            $data1 = array(
                                'firstname' => $name1[0],
                                'lastname' => $name1[1],
                                'name' => $patientdetails->name,
                                'doctorname' => $doctordetails->name,
                                'appoinmentdate' => date('d-m-Y', $appointment->date),
                                'time_slot' => $appointment->time_slot,
                                'hospital_name' => $settings->system_vendor
                            );
                            if ($autosms->status == 'Active') {
                                $messageprint = $this->parser->parse_string($message, $data1);

                                $data2[] = array($to => $messageprint);
                                $data_ret = $this->sendSms($hospital_id, $data2);
                            }

                            if ($autoemail->status == 'Active') {
                                $mail_provider = $this->cronjobs_model->getSettings($hospital_id)->emailtype;
                                $settngs_name = $this->cronjobs_model->getSettings($hospital_id)->system_vendor;
                                $email_Settings = $this->cronjobs_model->getEmailSettingsByType($hospital_id, $mail_provider);

                                $message1 = $autoemail->message;
                                $messageprint1 = $this->parser->parse_string($message1, $data1);
                                if ($mail_provider == 'Smtp') {
                                    $config['protocol'] = 'smtp';
                                    $config['mailpath'] = '/usr/sbin/sendmail';
                                    $config['smtp_host'] = $email_Settings->smtp_host;
                                    $config['smtp_port'] = number_format($email_Settings->smtp_port);
                                    $config['smtp_user'] = $email_Settings->user;
                                    $config['smtp_pass'] = base64_decode($email_Settings->password);
                                    $config['smtp_crypto'] = 'tls';
                                    $config['mailtype'] = 'html';
                                    $config['charset'] = 'utf-8';
                                    $config['wordwrap'] = TRUE;
                                    $config['send_multipart'] = TRUE;
                                    $config['newline'] = "\r\n";
                                    $this->load->library('email');
                                    $this->email->initialize($config);
                                    $this->load->library('email');
                                } else {
                                    $this->load->library('email');
                                }
                                if ($mail_provider == 'Domain Email') {
                                    $this->email->from($email_Settings->admin_email);
                                }
                                if ($mail_provider == 'Smtp') {
                                    $this->email->from($email_Settings->user, $settngs_name);
                                }
                                $this->email->to($patientdetails->email);
                                $this->email->subject(lang('appointment_remainder'));
                                $this->email->message($messageprint1);
                                if (function_exists('mail')) {
                                    $this->email->send();
                                }
                            }
                            $data_appointment = array();
                            $data_appointment = array(
                                'cron_job' => '1'
                            );
                            $this->cronjobs_model->updateAppointment($appointment->id, $data_appointment);
                        }
                    }
                }
            }
        }
    }

    public function sendSms($hospital_id, $data)
    {
        $sms_gateway = $this->cronjobs_model->getSettings($hospital_id)->sms_gateway;
        if (!empty($sms_gateway)) {
            $smsSettings = $this->cronjobs_model->getSmsSettingsByGatewayName($hospital_id, $sms_gateway);
        } else {
            return 0;
        }
        $j = sizeof($data);

        foreach ($data as $key2 => $value2) {

            if ($smsSettings->name == 'Clickatell') {
                $username = $smsSettings->username;
                $password = $smsSettings->password;
                $api_id = $smsSettings->api_id;

                $racepage[] = file_get_contents("https://api.clickatell.com/http/sendmsg?user=" . $username . "&password=" . $password . "&api_id=" . $api_id . "&to=" . $key2 . "&text=" . $value2);
                return $racepage;
            }

            if ($smsSettings->name == 'MSG91') {
                $authkey = $smsSettings->authkey;
                $sender = $smsSettings->sender;
                $value2 = urlencode($value2);

                $racepage[] = file_get_contents('http://world.msg91.com/api/v2/sendsms?authkey=' . $authkey . '&mobiles=' . $key2 . '&message=' . $value2 . '&sender=' . $sender . '&route=4&country=0');
                return $racepage;
            }
            
            if ($smsSettings->name == 'Hutch BSMS') {
                $username = $sms_settings->hutch_username; // your Hutch username
                $password = $sms_settings->hutch_password; // your Hutch password
                $mask     = $sms_settings->mask; // pre-approved sender ID
                $number   = $phone;
                $text  = $message;
                $campaign = "Hospital Campaign";
                // 1. Login to get access token
                $loginUrl = "https://bsms.hutch.lk/api/login";
                $loginData = [
                    "username" => $username,
                    "password" => $password
                ];

                $ch = curl_init($loginUrl);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_HTTPHEADER, [
                    "Content-Type: application/json",
                    "Accept: */*",
                    "X-API-VERSION: v1"
                ]);
                curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($loginData));
                $loginResponse = curl_exec($ch);
                curl_close($ch);

                $loginResult = json_decode($loginResponse, true);

                if (empty($loginResult['accessToken'])) {
                    echo "Login failed: " . $loginResponse;
                    return;
                }

                $accessToken = $loginResult['accessToken'];

                // 2. Send SMS using access token
                $smsUrl = "https://bsms.hutch.lk/api/sendsms";
                $smsData = [
                    "campaignName" => $campaign,
                    "mask" => $mask,
                    "numbers" => $number,
                    "content" => $text,
                    "deliveryReportRequest" => true
                ];

                $ch = curl_init($smsUrl);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_HTTPHEADER, [
                    "Content-Type: application/json",
                    "Accept: */*",
                    "X-API-VERSION: v1",
                    "Authorization: Bearer " . $accessToken
                ]);
                curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($smsData));
                $smsResponse = curl_exec($ch);
                $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                curl_close($ch);
                return array('success' => true, 'message' => 'SMS sent successfully');
            }
            
            if ($smsSettings->name == 'Twilio') {
                $sid = $smsSettings->sid;
                $token = $smsSettings->token;
                $sendername = $smsSettings->sendernumber;
                if (!empty($sid) && !empty($token) && !empty($sendername)) {
                    $client = new Client($sid, $token);
                    $client->messages->create(
                        $key2, // Text this number
                        array(
                            'from' => $sendername, // From a valid Twilio number
                            'body' => $value2
                        )
                    );
                    $racepage = array();
                    return $racepage;
                }
            }
            if ($smsSettings->name == '80Kobo') {
                $email = $smsSettings->email;
                $password = $smsSettings->password;
                $sender_name = $smsSettings->sender_name;

                $data = array("email" => $email, "password" => $password, "message" => $value2, "sender_name" => $sender_name, "recipients" => $key2);

                $data_string = json_encode($data);
                $ch = curl_init('https://api.80kobosms.com/v2/app/sms');
                curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
                curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json', 'Content-Length: ' . strlen($data_string)));
                $result = curl_exec($ch);
                $res_array = json_decode($result);
                return $res_array;
            }
        }
    }

    /**
     * Get Hutch BSMS OAuth 2.0 Access Token
     */
    private function getHutchAccessToken($username, $password)
    {
        $cacheKey = 'hutch_access_token_' . md5($username);
        $cacheFile = APPPATH . 'cache/hutch_tokens/' . $cacheKey . '.json';
        
        // Create cache directory if it doesn't exist
        if (!is_dir(APPPATH . 'cache/hutch_tokens/')) {
            mkdir(APPPATH . 'cache/hutch_tokens/', 0755, true);
        }
        
        // Check if we have a valid cached token
        if (file_exists($cacheFile)) {
            $tokenData = json_decode(file_get_contents($cacheFile), true);
            if ($tokenData && isset($tokenData['accessToken']) && isset($tokenData['expires'])) {
                // Check if token is still valid (with 5 minute buffer)
                if (time() < ($tokenData['expires'] - 300)) {
                    return $tokenData['accessToken'];
                }
                
                // Try to refresh the token
                if (isset($tokenData['refreshToken'])) {
                    $newToken = $this->refreshHutchAccessToken($tokenData['refreshToken']);
                    if ($newToken) {
                        return $newToken;
                    }
                }
            }
        }
        
        // Get new tokens via login
        return $this->loginHutchBSMS($username, $password);
    }
    
    /**
     * Login to Hutch BSMS and get tokens
     */
    private function loginHutchBSMS($username, $password)
    {
        $postData = array(
            'username' => $username,
            'password' => $password
        );
        
        $ch = curl_init('https://bsms.hutch.lk/api/login');
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
            'Accept: */*',
            'X-API-VERSION: v1'
        ));
        
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        
        if ($httpCode == 200 && $response) {
            $tokenData = json_decode($response, true);
            if (isset($tokenData['accessToken']) && isset($tokenData['refreshToken'])) {
                // Cache the tokens with expiry (assuming 1 hour validity)
                $cacheData = array(
                    'accessToken' => $tokenData['accessToken'],
                    'refreshToken' => $tokenData['refreshToken'],
                    'expires' => time() + 3600 // 1 hour from now
                );
                
                $cacheKey = 'hutch_access_token_' . md5($username);
                $cacheFile = APPPATH . 'cache/hutch_tokens/' . $cacheKey . '.json';
                file_put_contents($cacheFile, json_encode($cacheData));
                
                return $tokenData['accessToken'];
            }
        }
        
        return false;
    }
    
    /**
     * Refresh Hutch BSMS Access Token
     */
    private function refreshHutchAccessToken($refreshToken)
    {
        $ch = curl_init('https://bsms.hutch.lk/api/token/accessToken');
        curl_setopt($ch, CURLOPT_HTTPGET, true);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
            'Accept: */*',
            'X-API-VERSION: v1',
            'Authorization: Bearer ' . $refreshToken
        ));
        
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        
        if ($httpCode == 200 && $response) {
            $tokenData = json_decode($response, true);
            if (isset($tokenData['accessToken'])) {
                return $tokenData['accessToken'];
            }
        }
        
        return false;
    }
}
