<div class="content-wrapper bg-gradient-light" style="min-height: 2726.9px;">
    <section class="content-header py-4 bg-white shadow-sm">
        <div class="container-fluid">
            <div class="row align-items-center">
                <div class="col-sm-6">
                    <h1 class="display-4 font-weight-black mb-0">
                        <i class="fas fa-tags text-primary mr-3"></i>
                        <?php echo lang('inventory_categories') ?>
                    </h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb bg-transparent mb-0">
                            <li class="breadcrumb-item"><a href="home"><?php echo lang('home'); ?></a></li>
                            <li class="breadcrumb-item"><a href="inventory"><?php echo lang('inventory'); ?></a></li>
                            <li class="breadcrumb-item active"><?php echo lang('categories'); ?></li>
                        </ol>
                    </nav>
                </div>
                <div class="col-sm-6 text-right">
                    <a data-toggle="modal" href="#addCategoryModal" class="btn btn-success btn-sm px-4 py-3">
                        <i class="fa fa-plus-circle"></i> <?php echo lang('add_inventory_category'); ?>
                    </a>
                </div>
            </div>
        </div>
    </section>

    <section class="content py-5">
        <div class="container-fluid">
            <!-- Flash Messages -->
            <?php if ($this->session->flashdata('success')) { ?>
                <div class="alert alert-success alert-dismissible fade show">
                    <button type="button" class="close" data-dismiss="alert">&times;</button>
                    <?php echo $this->session->flashdata('success'); ?>
                </div>
            <?php } ?>
            
            <?php if ($this->session->flashdata('error')) { ?>
                <div class="alert alert-danger alert-dismissible fade show">
                    <button type="button" class="close" data-dismiss="alert">&times;</button>
                    <?php echo $this->session->flashdata('error'); ?>
                </div>
            <?php } ?>
            
         
            
            <div class="row justify-content-center">
                <div class="col-12">
                    <div class="card shadow-lg border-0">
                        <div class="card-header">
                            <h3 class="card-title text-black font-weight-800"><?php echo lang('all') . ' ' . lang('inventory_categories'); ?></h3>
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                    <i class="fas fa-minus"></i>
                                </button>
                            </div>
                        </div>

                        <div class="card-body bg-light">
                            <div class="table-responsive">
                                <table class="table table-hover" id="categoriesTable">
                                    <thead>
                                        <tr class="bg-light">
                                            <th class="font-weight-bold text-uppercase"><?php echo lang('name'); ?></th>
                                            <th class="font-weight-bold text-uppercase"><?php echo lang('description'); ?></th>
                                            <th class="font-weight-bold text-uppercase"><?php echo lang('parent_category'); ?></th>
                                            <th class="font-weight-bold text-uppercase"><?php echo lang('status'); ?></th>
                                            <th class="font-weight-bold text-uppercase"><?php echo lang('options'); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <!-- Server-side DataTables will populate this -->
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Add Category Modal -->
<div class="modal fade" id="addCategoryModal" role="dialog" aria-labelledby="addCategoryModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-md">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title font-weight-bold" id="addCategoryModalLabel"><?php echo lang('add_inventory_category'); ?></h4>
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
            </div>
            <div class="modal-body">
                <div class="card shadow-lg border-0">
                    <div class="card-body p-4">
                        <?php echo validation_errors('<div class="alert alert-danger">', '</div>'); ?>
                        
                        <form role="form" action="<?php echo base_url('inventory/add_category'); ?>" method="post" id="addCategoryForm">
                            <div class="form-group">
                                <label for="name"><?php echo lang('name'); ?> <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="name" id="name" required>
                            </div>
                            
                            <div class="form-group">
                                <label for="description"><?php echo lang('description'); ?></label>
                                <textarea class="form-control" name="description" id="description" rows="3"></textarea>
                            </div>
                            
                            <div class="form-group">
                                <label for="parent_id"><?php echo lang('parent_category'); ?></label>
                                <select class="form-control" name="parent_id" id="parent_id">
                                    <option value=""><?php echo lang('select') . ' ' . lang('parent_category'); ?></option>
                                    <?php if (!empty($categories)) { ?>
                                        <?php foreach ($categories as $category) { ?>
                                            <option value="<?php echo $category->id; ?>"><?php echo $category->name; ?></option>
                                        <?php } ?>
                                    <?php } ?>
                                </select>
                            </div>
                            
                            <div class="form-group">
                                <label for="status"><?php echo lang('status'); ?></label>
                                <select class="form-control" name="status" id="status">
                                    <option value="active">Active</option>
                                    <option value="inactive">Inactive</option>
                                </select>
                            </div>
                            
                            <!-- Hidden submit field -->
                            <input type="hidden" name="submit" value="1">
                        </form>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">
                    <i class="fas fa-times mr-2"></i><?php echo lang('cancel'); ?>
                </button>
                <button type="submit" form="addCategoryForm" name="submit" class="btn btn-success">
                    <i class="fas fa-save mr-2"></i><?php echo lang('save'); ?>
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Edit Category Modal -->
<div class="modal fade" id="editCategoryModal" role="dialog" aria-labelledby="editCategoryModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-md">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title font-weight-bold" id="editCategoryModalLabel"><?php echo lang('edit'); ?> <?php echo lang('inventory_category'); ?></h4>
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
            </div>
            <div class="modal-body">
                <div class="card shadow-lg border-0">
                    <div class="card-body p-4">
                        <form role="form" action="<?php echo base_url('inventory/edit_category'); ?>" method="post" id="editCategoryForm">
                            <div class="form-group">
                                <label for="edit_name"><?php echo lang('name'); ?> <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="name" id="edit_name" required>
                            </div>
                            
                            <div class="form-group">
                                <label for="edit_description"><?php echo lang('description'); ?></label>
                                <textarea class="form-control" name="description" id="edit_description" rows="3"></textarea>
                            </div>
                            
                            <div class="form-group">
                                <label for="edit_parent_id"><?php echo lang('parent_category'); ?></label>
                                <select class="form-control" name="parent_id" id="edit_parent_id">
                                    <option value=""><?php echo lang('select') . ' ' . lang('parent_category'); ?></option>
                                    <?php if (!empty($categories)) { ?>
                                        <?php foreach ($categories as $category) { ?>
                                            <option value="<?php echo $category->id; ?>"><?php echo $category->name; ?></option>
                                        <?php } ?>
                                    <?php } ?>
                                </select>
                            </div>
                            
                            <div class="form-group">
                                <label for="edit_status"><?php echo lang('status'); ?></label>
                                <select class="form-control" name="status" id="edit_status">
                                    <option value="active">Active</option>
                                    <option value="inactive">Inactive</option>
                                </select>
                            </div>
                            
                            <!-- Hidden fields -->
                            <input type="hidden" name="category_id" id="edit_category_id">
                            <input type="hidden" name="submit" value="1">
                        </form>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">
                    <i class="fas fa-times mr-2"></i><?php echo lang('cancel'); ?>
                </button>
                <button type="submit" form="editCategoryForm" name="submit" class="btn btn-primary">
                    <i class="fas fa-save mr-2"></i><?php echo lang('update'); ?>
                </button>
            </div>
        </div>
    </div>
</div>

<!-- JavaScript -->
<script>
$(document).ready(function() {
    var table = $('#categoriesTable').DataTable({
        "responsive": true,
        "processing": true,
        "serverSide": true,
        "searchable": true,
        "ajax": {
            "url": "inventory/getCategories",
            "type": "POST"
        },
        "scroller": {
            "loadingIndicator": true
        },
        "dom": "<'row mb-3'<'col-sm-3'l><'col-sm-5 text-center'B><'col-sm-4 text-right'f>>" +
               "<'row'<'col-sm-12'tr>>" +
               "<'row'<'col-sm-5'i><'col-sm-7'p>>",
        "buttons": [
            { "extend": "copyHtml5", "exportOptions": { "columns": [0, 1, 2, 3] } },
            { "extend": "excelHtml5", "exportOptions": { "columns": [0, 1, 2, 3] } },
            { "extend": "csvHtml5", "exportOptions": { "columns": [0, 1, 2, 3] } },
            { "extend": "pdfHtml5", "exportOptions": { "columns": [0, 1, 2, 3] } },
            { "extend": "print", "exportOptions": { "columns": [0, 1, 2, 3] } }
        ],
        "aLengthMenu": [
            [10, 25, 50, 100, -1],
            [10, 25, 50, 100, "All"]
        ],
        "iDisplayLength": 25,
        "order": [[ 0, "asc" ]],
        "language": {
            "lengthMenu": "_MENU_",
            "search": "_INPUT_",
            "searchPlaceholder": "Search categories..."
        }
    });
    table.buttons().container().appendTo('#categoriesTable_wrapper .col-md-6:eq(0)');
    
    // Initialize Select2 for dropdowns
    $('#parent_id').select2({
        placeholder: "Select Parent Category",
        allowClear: true,
        dropdownParent: $('#addCategoryModal')
    });
    
    $('#status').select2({
        minimumResultsForSearch: Infinity,
        dropdownParent: $('#addCategoryModal')
    });
    
    // Reset form when modal is closed
    $('#addCategoryModal').on('hidden.bs.modal', function () {
        $('#addCategoryForm')[0].reset();
        $('#parent_id').val(null).trigger('change');
        $('#status').val('active').trigger('change');
    });
    
    // Initialize Select2 for edit modal dropdowns
    $('#edit_parent_id').select2({
        placeholder: "Select Parent Category",
        allowClear: true,
        dropdownParent: $('#editCategoryModal')
    });
    
    $('#edit_status').select2({
        minimumResultsForSearch: Infinity,
        dropdownParent: $('#editCategoryModal')
    });
    
    // Reset edit form when modal is closed
    $('#editCategoryModal').on('hidden.bs.modal', function () {
        $('#editCategoryForm')[0].reset();
        $('#edit_parent_id').val(null).trigger('change');
        $('#edit_status').val('active').trigger('change');
    });
});

// Function to load category data for editing
function editCategory(categoryId) {
    $.ajax({
        url: '<?php echo base_url('inventory/get_category_data'); ?>',
        type: 'POST',
        data: { category_id: categoryId },
        dataType: 'json',
        success: function(response) {
            if (response.success) {
                $('#edit_category_id').val(response.data.id);
                $('#edit_name').val(response.data.name);
                $('#edit_description').val(response.data.description);
                $('#edit_parent_id').val(response.data.parent_id).trigger('change');
                $('#edit_status').val(response.data.status).trigger('change');
            } else {
                alert('Error loading category data: ' + (response.message || 'Unknown error'));
            }
        },
        error: function(xhr, status, error) {
            alert('Error loading category data. Please try again.');
            console.error('AJAX Error:', error);
        }
    });
}
</script>