<!DOCTYPE html>
<html lang="en">
<?php
$settings = $this->frontend_model->getSettings();
$title = explode(' ', $settings->title);
?>

<head>
  <base href="<?php echo base_url(); ?>" />
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title><?php echo $settings->title; ?></title>

    <!-- SEO Meta Tags -->
    <meta name="description" content="<?php echo $settings->description; ?>" />
    <meta name="keywords" content="hospital management system, HMS software, medical software, healthcare management, appointment booking, hospital software, medical appointment system" />
    <meta name="author" content="<?php echo $settings->title; ?>">
    <meta name="robots" content="index, follow">
    
    <!-- Open Graph Meta Tags -->
    <meta property="og:title" content="<?php echo $settings->title; ?>" />
    <meta property="og:description" content="<?php echo $settings->description; ?>" />
    <meta property="og:type" content="website">
    <meta property="og:url" content="<?php echo base_url(); ?>">
    <meta property="og:site_name" content="<?php echo $settings->title; ?>">
    
    <!-- Twitter Meta Tags -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="<?php echo $settings->title; ?>">
    <meta name="twitter:description" content="<?php echo $settings->description; ?>">
    
    <!-- Stylesheets -->
  <link rel="stylesheet" href="new-fnt/index.css" />
  <link rel="preconnect" href="https://fonts.googleapis.com" />
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
  <link href="https://fonts.googleapis.com/css2?family=Manrope:wght@400;500;600;700;800&family=Source+Serif+4:wght@400;500;600;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/country-select-js@2.1.0/build/css/countrySelect.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/flag-icon-css/3.5.0/css/flag-icon.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@8/swiper-bundle.min.css" />

    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: {
                            50: '#f0f9ff',
                            100: '#e0f2fe',
                            200: '#bae6fd',
                            300: '#7dd3fc',
                            400: '#38bdf8',
                            500: '#0ea5e9',
                            600: '#0284c7',
                            700: '#0369a1',
                            800: '#075985',
                            900: '#0c4a6e',
                        },
                        secondary: {
                            50: '#f8fafc',
                            900: '#0f172a',
                        }
                    },
                    boxShadow: {
                        'custom': '0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06)',
                        'custom-lg': '0 10px 25px -5px rgba(0, 0, 0, 0.1), 0 8px 10px -6px rgba(0, 0, 0, 0.1)',
                        'custom-2xl': '0 25px 50px -12px rgba(0, 0, 0, 0.25)',
                    },
                    animation: {
                        'float': 'float 6s ease-in-out infinite',
                    },
                    keyframes: {
                        float: {
                            '0%, 100%': { transform: 'translateY(0)' },
                            '50%': { transform: 'translateY(-20px)' },
                        }
                    }
                }
            }
        }
    </script>
    <style>
        :root {
            --ink: #0b1b2b;
            --slate: #3a4756;
            --mist: #e9f0f5;
            --aqua: #0ea5a8;
            --teal: #0f766e;
            --blue: #1d4ed8;
            --cloud: #f7fafc;
        }

        body {
            font-family: 'Manrope', sans-serif;
            color: var(--ink);
            background: #f8fafc;
        }

        .serif-head {
            font-family: 'Source Serif 4', serif;
        }
        
        .gradient-text {
            background: linear-gradient(135deg, #0f766e 0%, #1d4ed8 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }
        
        .hero-gradient {
            background:
                radial-gradient(circle at 10% 10%, rgba(14, 165, 168, 0.12) 0%, rgba(255, 255, 255, 0) 45%),
                radial-gradient(circle at 80% 20%, rgba(29, 78, 216, 0.12) 0%, rgba(255, 255, 255, 0) 45%),
                linear-gradient(180deg, #f8fbff 0%, #f2f6fb 100%);
        }
        
        .service-card {
            background: rgba(255, 255, 255, 0.9);
            backdrop-filter: blur(12px);
        }
        
        @keyframes blob {
            0% { transform: translate(0px, 0px) scale(1); }
            33% { transform: translate(30px, -50px) scale(1.1); }
            66% { transform: translate(-20px, 20px) scale(0.9); }
            100% { transform: translate(0px, 0px) scale(1); }
        }
        
        .animate-blob {
            animation: blob 8s infinite;
        }
        
        .animation-delay-2000 {
            animation-delay: 2.5s;
        }
        
        .animation-delay-4000 {
            animation-delay: 4.5s;
        }

        body{
            overflow-x: hidden;
        }

        @media (max-width: 640px) {
            body {
                overflow-x: hidden;
            }
        }

        /* Hide horizontal scrollbar on mobile */
        html, body {
            max-width: 100%;
            overflow-x: hidden;
            position: relative;
        }

        /* Ensure content stays within viewport width */
        .container {
            width: 100%;
            max-width: 100vw;
            margin: 0 auto;
            padding-left: 1rem;
            padding-right: 1rem;
            box-sizing: border-box;
        }

        /* Handle overflow on grid layouts */
        .grid {
            width: 100%;
            margin: 0;
            padding: 0;
        }

        @media (max-width: 640px) {
            .grid {
                margin-left: 0;
                margin-right: 0;
            }
        }

        .glass {
            background: rgba(255, 255, 255, 0.7);
            border: 1px solid rgba(15, 118, 110, 0.12);
            box-shadow: 0 18px 40px -22px rgba(15, 23, 42, 0.35);
            backdrop-filter: blur(16px);
        }

        .market-card {
            border: 1px solid rgba(148, 163, 184, 0.35);
            background: #ffffff;
            box-shadow: 0 16px 30px -24px rgba(15, 23, 42, 0.3);
        }

        .grid-lines {
            background-image: linear-gradient(90deg, rgba(148, 163, 184, 0.15) 1px, transparent 1px),
                              linear-gradient(180deg, rgba(148, 163, 184, 0.15) 1px, transparent 1px);
            background-size: 64px 64px;
        }

        .premium-card {
            border: 1px solid rgba(148, 163, 184, 0.35);
            background: #ffffff;
            box-shadow: 0 18px 36px -28px rgba(15, 23, 42, 0.45);
        }

        .premium-topline {
            height: 3px;
            width: 100%;
            border-radius: 999px;
            background: linear-gradient(90deg, rgba(15, 118, 110, 0.9), rgba(29, 78, 216, 0.9));
        }

        .icon-ring {
            width: 52px;
            height: 52px;
            border-radius: 16px;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            background: linear-gradient(135deg, rgba(14, 165, 168, 0.12), rgba(29, 78, 216, 0.12));
            border: 1px solid rgba(14, 116, 144, 0.18);
            color: #0f766e;
        }

    </style>
</head>

<body class="font-sans antialiased text-secondary-900 selection:bg-primary-200 selection:text-primary-900">
    <!-- Navbar -->
    <nav class="bg-white/80 backdrop-blur-md shadow-custom fixed w-full z-50 border-b border-gray-200/50">
        <div class="max-w-7xl mx-auto px-6">
            <div class="flex justify-between items-center h-20">
                <div class="flex-shrink-0">
                    <a href="#" class="flex items-center space-x-3">
                        <div class="relative w-10 h-10">
                            <div class="absolute inset-0 bg-gradient-to-r from-primary-600 to-primary-500 rounded-lg transform rotate-6 transition-transform group-hover:rotate-12"></div>
                            <div class="absolute inset-0 bg-white rounded-lg shadow-sm flex items-center justify-center">
                                <span class="text-xl font-bold text-primary-600">
                                    <?php echo substr($settings->title, 0, 1); ?>
                                </span>
                            </div>
                        </div>
                        <div>
                            <span class="text-2xl font-extrabold">
                                <span class="text-secondary-900"><?php echo $title[0]; ?></span><span class="text-primary-600"><?php echo isset($title[1]) ? $title[1] : ''; ?></span>
                            </span>
                            <span class="hidden lg:block text-xs text-gray-500 -mt-1">Healthcare Management Solutions</span>
                        </div>
                    </a>
                </div>
                
                <!-- Desktop Menu -->
                <div class="hidden md:flex items-center space-x-8">
                    
                    <?php if ($this->ion_auth->logged_in() == '1') { ?>
                        <a href="home" target="_blank" class="inline-flex items-center px-4 py-2 bg-green-600 text-white font-medium rounded-lg hover:bg-green-700 transition duration-300">
                            <i class="fas fa-user mr-2"></i>
                            <?php
                            $current_user = $this->ion_auth->get_user_id();
                            $username = $this->db->get_where('users', array('id' => $current_user))->row()->username;
                            echo $username;
                            ?>
                        </a>
                    <?php } else { ?>
                        <a href="auth/login" target="_blank" class="inline-flex items-center px-4 py-2 bg-green-600 text-white font-medium rounded-lg hover:bg-green-700 transition duration-300">
                            <i class="fas fa-sign-in-alt mr-2"></i>
                            <?php echo lang('login'); ?>
                        </a>
                    <?php } ?>

                    <a href="#register" class="inline-flex items-center px-6 py-2.5 bg-primary-600 text-white font-medium rounded-lg hover:bg-primary-700 transition duration-300 shadow-sm">
                        <?php echo lang('book_appointment'); ?>
                    </a>
                </div>

                <!-- Mobile Menu Button -->
                <div class="md:hidden">
                    <button id="mobile-menu-button" class="w-10 h-10 flex items-center justify-center text-gray-700 hover:bg-gray-100 rounded-lg transition-colors">
                        <svg class="w-6 h-6 text-gray-900" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path>
                        </svg>
                    </button>
                </div>
            </div>
        </div>

        <!-- Mobile Menu -->
        <div id="mobile-menu" class="hidden md:hidden bg-white border-b border-gray-200 py-4">
            <div class="px-4 space-y-3">
                 
                <?php if ($this->ion_auth->logged_in() == '1') { ?>
                    <a href="home" target="_blank" class="block px-4 py-2 text-white bg-green-600 hover:bg-green-700 rounded-lg transition-colors">
                        <i class="fas fa-user mr-2"></i>
                        <?php
                        $current_user = $this->ion_auth->get_user_id();
                        $username = $this->db->get_where('users', array('id' => $current_user))->row()->username;
                        echo $username;
                        ?>
                    </a>
                <?php } else { ?>
                    <a href="auth/login" target="_blank" class="block px-4 py-2 text-white bg-green-600 hover:bg-green-700 rounded-lg transition-colors">
                        <i class="fas fa-sign-in-alt mr-2"></i>
                        <?php echo lang('login'); ?>
                    </a>
                <?php } ?>

                <a href="#register" class="block px-4 py-2 text-white bg-primary-600 hover:bg-primary-700 rounded-lg transition-colors font-medium">
                    <?php echo lang('book_appointment'); ?>
                </a>
            </div>
        </div>
    </nav>



    <style>
    .text1 {
        display: none;
    }
</style>

    <!-- Premium Hero -->
    <section class="relative pt-28 pb-16 hero-gradient overflow-hidden">
        <div class="absolute inset-0 grid-lines opacity-30"></div>
        <div class="absolute -top-40 -left-32 w-[420px] h-[420px] bg-teal-200 rounded-full mix-blend-multiply blur-3xl opacity-70 animate-blob"></div>
        <div class="absolute -top-32 -right-24 w-[420px] h-[420px] bg-blue-200 rounded-full mix-blend-multiply blur-3xl opacity-70 animate-blob animation-delay-2000"></div>
        <div class="absolute bottom-0 left-40 w-[360px] h-[360px] bg-cyan-200 rounded-full mix-blend-multiply blur-3xl opacity-60 animate-blob animation-delay-4000"></div>

        <div class="max-w-7xl mx-auto px-6 relative z-10">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
                <div>
                    <span class="inline-flex items-center text-xs font-semibold tracking-widest text-teal-700 uppercase bg-teal-50 border border-teal-100 px-3 py-1 rounded-full">
                        Premium Healthcare Experience
                    </span>
                    <h1 class="text-4xl md:text-6xl font-extrabold mt-6 leading-tight serif-head">
                        Care delivery that feels
                        <span class="gradient-text">effortless</span>
                    </h1>
                    <p class="text-lg md:text-xl text-slate-600 mt-6 max-w-xl">
                        Discover specialists, schedule in minutes, and manage your care journey in one elegant, secure platform.
                    </p>
                    <div class="mt-8 flex flex-col sm:flex-row gap-4">
                        <a href="#register" class="inline-flex items-center justify-center px-6 py-3 bg-teal-700 text-white font-semibold rounded-xl hover:bg-teal-800 transition-all duration-300 shadow-lg">
                            <i class="fas fa-calendar-plus mr-2"></i>
                            Book an Appointment
                        </a>
                        <a href="#features" class="inline-flex items-center justify-center px-6 py-3 bg-white text-teal-800 font-semibold rounded-xl border border-teal-200 hover:border-teal-300 hover:text-teal-900 transition-all duration-300">
                            View Services
                        </a>
                    </div>
                    <div class="mt-8 flex items-center gap-6 text-sm text-slate-600">
                        <div class="flex items-center gap-2">
                            <i class="fas fa-shield-alt text-teal-700"></i>
                            HIPAA + SOC2 Ready
                        </div>
                        <div class="flex items-center gap-2">
                            <i class="fas fa-check-circle text-blue-700"></i>
                            Verified Providers
                        </div>
                        <div class="flex items-center gap-2">
                            <i class="fas fa-clock text-emerald-700"></i>
                            24/7 Access
                        </div>
                    </div>
                </div>

                <div class="glass rounded-3xl p-8 lg:p-10">
                    <div class="flex items-center justify-between mb-6">
                        <div>
                            <p class="text-sm font-semibold text-slate-500">Today at a glance</p>
                            <h3 class="text-2xl font-bold text-slate-900">Appointment availability</h3>
                        </div>
                        <span class="text-xs font-semibold text-emerald-700 bg-emerald-50 px-3 py-1 rounded-full">Live</span>
                    </div>
                    <div class="space-y-4">
                        <div class="market-card rounded-2xl p-4 flex items-center justify-between">
                            <div>
                                <p class="text-sm text-slate-500">Primary Care</p>
                                <p class="font-semibold text-slate-900">Same-day slots</p>
                            </div>
                            <span class="text-sm font-semibold text-emerald-600">12 open</span>
                        </div>
                        <div class="market-card rounded-2xl p-4 flex items-center justify-between">
                            <div>
                                <p class="text-sm text-slate-500">Specialists</p>
                                <p class="font-semibold text-slate-900">Cardiology, Ortho</p>
                            </div>
                            <span class="text-sm font-semibold text-blue-600">Next 48h</span>
                        </div>
                        <div class="market-card rounded-2xl p-4 flex items-center justify-between">
                            <div>
                                <p class="text-sm text-slate-500">Diagnostics</p>
                                <p class="font-semibold text-slate-900">Lab + Imaging</p>
                            </div>
                            <span class="text-sm font-semibold text-amber-600">Fast-track</span>
                        </div>
                    </div>
                    <div class="mt-6 border-t border-slate-200 pt-5 grid grid-cols-2 gap-4 text-sm text-slate-600">
                        <div>
                            <p class="text-xs uppercase tracking-widest text-slate-400">Providers</p>
                            <p class="text-lg font-semibold text-slate-900">2,500+</p>
                        </div>
                        <div>
                            <p class="text-xs uppercase tracking-widest text-slate-400">Facilities</p>
                            <p class="text-lg font-semibold text-slate-900">1,000+</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Appointment Booking Section -->
    <section class="relative py-24 hero-gradient overflow-hidden" id="register">
        <div class="absolute inset-0 grid-lines opacity-30"></div>
        <div class="absolute top-0 -left-64 w-96 h-96 bg-teal-200 rounded-full mix-blend-multiply filter blur-3xl opacity-70 animate-blob"></div>
        <div class="absolute top-0 -right-64 w-96 h-96 bg-blue-200 rounded-full mix-blend-multiply filter blur-3xl opacity-70 animate-blob animation-delay-2000"></div>
        <div class="absolute -bottom-64 left-64 w-96 h-96 bg-cyan-200 rounded-full mix-blend-multiply filter blur-3xl opacity-70 animate-blob animation-delay-4000"></div>

        <div class="max-w-7xl mx-auto px-4 relative z-10">
            <div class="max-w-3xl mx-auto text-center mb-16">
                <span class="text-xs font-semibold tracking-widest text-teal-700 uppercase mb-4 block">
                    BOOK YOUR APPOINTMENT
                </span>
                <h2 class="text-4xl md:text-5xl font-extrabold mb-6 text-gray-900 serif-head">
                    <span class="gradient-text">Schedule Your</span>
                    <span class="block mt-2">Medical Appointment</span>
                </h2>
                <p class="text-xl text-slate-600 max-w-2xl mx-auto">
                    Find the right doctor, choose your preferred time, and get the healthcare you need - all online.
                </p>
            </div>

            <div class="max-w-4xl mx-auto">
                <div class="glass rounded-3xl shadow-2xl p-8 md:p-12">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-12 items-center">
                        <div>
                            <h3 class="text-2xl font-bold text-gray-900 mb-6">Simple 3-Step Process</h3>
                            
                            <div class="space-y-6">
                                <div class="flex items-start space-x-4">
                                    <div class="flex-shrink-0 w-12 h-12 bg-teal-50 rounded-xl flex items-center justify-center">
                                        <span class="text-xl font-bold text-teal-700">1</span>
                                    </div>
                                    <div>
                                        <h4 class="font-semibold text-gray-900 mb-1">Choose Hospital & Speciality</h4>
                                        <p class="text-slate-600">Select from our network of trusted hospitals and medical specialities.</p>
                                    </div>
                                </div>
                                
                                <div class="flex items-start space-x-4">
                                    <div class="flex-shrink-0 w-12 h-12 bg-blue-50 rounded-xl flex items-center justify-center">
                                        <span class="text-xl font-bold text-blue-700">2</span>
                                    </div>
                                    <div>
                                        <h4 class="font-semibold text-gray-900 mb-1">Select Doctor & Date</h4>
                                        <p class="text-slate-600">Choose your preferred doctor and available appointment date.</p>
                                    </div>
                                </div>
                                
                                <div class="flex items-start space-x-4">
                                    <div class="flex-shrink-0 w-12 h-12 bg-emerald-50 rounded-xl flex items-center justify-center">
                                        <span class="text-xl font-bold text-emerald-700">3</span>
                                    </div>
                                    <div>
                                        <h4 class="font-semibold text-gray-900 mb-1">Confirm & Receive</h4>
                                        <p class="text-slate-600">Get instant confirmation and appointment details via email.</p>
                                    </div>
                                </div>
                            </div>

                            <div class="mt-8 p-4 bg-teal-50 rounded-xl border border-teal-100">
                                <div class="flex items-center">
                                    <i class="fas fa-shield-alt text-teal-700 text-xl mr-3"></i>
                                    <p class="text-teal-900 font-medium">Your information is secure and HIPAA compliant</p>
                                </div>
                            </div>
                        </div>
                        
                        <div class="bg-gradient-to-br from-white to-gray-50 rounded-2xl p-8 shadow-lg border border-gray-200">
                            <div class="text-center mb-8">
                                <div class="w-16 h-16 bg-gradient-to-r from-teal-600 to-blue-700 rounded-full flex items-center justify-center mx-auto mb-4">
                                    <i class="fas fa-calendar-check text-white text-2xl"></i>
                                </div>
                                <h3 class="text-2xl font-bold text-gray-900 mb-2">Ready to Book?</h3>
                                <p class="text-slate-600">Get started with your appointment in seconds</p>
                            </div>
                            
                            <div class="space-y-4 mb-8">
                                <div class="flex items-center text-slate-700">
                                    <i class="fas fa-hospital text-teal-700 mr-3"></i>
                                    <span>Access to 1000+ healthcare facilities</span>
                                </div>
                                <div class="flex items-center text-slate-700">
                                    <i class="fas fa-user-md text-blue-700 mr-3"></i>
                                    <span>2500+ specialist doctors available</span>
                                </div>
                                <div class="flex items-center text-slate-700">
                                    <i class="fas fa-clock text-emerald-700 mr-3"></i>
                                    <span>Real-time availability checking</span>
                                </div>
                                <div class="flex items-center text-slate-700">
                                    <i class="fas fa-bell text-slate-700 mr-3"></i>
                                    <span>Appointment reminders included</span>
                                </div>
                            </div>
                            
                            <a href="<?php echo base_url(); ?>frontend/book_appointment" 
                               class="w-full block text-center px-6 py-4 bg-gradient-to-r from-teal-600 to-blue-700 text-white font-semibold rounded-xl hover:from-teal-700 hover:to-blue-800 transition-all duration-300 transform hover:scale-[1.02] shadow-lg">
                                <i class="fas fa-calendar-plus mr-2"></i>
                                Book Your Appointment Now
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Enterprise Capabilities -->
    <section class="py-20 bg-white" id="features">
        <div class="max-w-7xl mx-auto px-6">
            <div class="flex flex-col lg:flex-row lg:items-end lg:justify-between gap-6 mb-12">
                <div>
                    <span class="text-xs font-semibold tracking-widest text-teal-600 uppercase">Enterprise Capabilities</span>
                    <h2 class="text-3xl md:text-4xl font-extrabold mt-4 serif-head">Built for health systems, GPOs, and multi-site networks</h2>
                </div>
                <p class="text-lg text-slate-600 max-w-xl">
                    Automate sourcing, control spend, and standardize vendor governance with a platform designed for complex healthcare operations.
                </p>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                <div class="premium-card rounded-2xl p-6">
                    <div class="premium-topline mb-6"></div>
                    <div class="icon-ring mb-5">
                        <i class="fas fa-file-signature text-xl"></i>
                    </div>
                    <h3 class="text-xl font-semibold mb-2">Contract Intelligence</h3>
                    <p class="text-slate-600">Centralize contract terms, auto-flag expirations, and align pricing across facilities.</p>
                    <div class="mt-5 text-xs font-semibold text-teal-700 uppercase tracking-widest">Governance</div>
                </div>
                <div class="premium-card rounded-2xl p-6">
                    <div class="premium-topline mb-6"></div>
                    <div class="icon-ring mb-5">
                        <i class="fas fa-sitemap text-xl"></i>
                    </div>
                    <h3 class="text-xl font-semibold mb-2">Multi-Entity Controls</h3>
                    <p class="text-slate-600">Role-based workflows, approval routing, and budget guardrails across regions.</p>
                    <div class="mt-5 text-xs font-semibold text-blue-700 uppercase tracking-widest">Operations</div>
                </div>
                <div class="premium-card rounded-2xl p-6">
                    <div class="premium-topline mb-6"></div>
                    <div class="icon-ring mb-5">
                        <i class="fas fa-chart-line text-xl"></i>
                    </div>
                    <h3 class="text-xl font-semibold mb-2">Spend Analytics</h3>
                    <p class="text-slate-600">Benchmark utilization, identify leakage, and forecast supply risk in real time.</p>
                    <div class="mt-5 text-xs font-semibold text-emerald-700 uppercase tracking-widest">Insights</div>
                </div>
            </div>
        </div>
    </section>

    <!-- Marketplace Categories -->
    <section class="py-20 bg-slate-50" id="marketplace">
        <div class="max-w-7xl mx-auto px-6">
            <div class="max-w-3xl mb-12">
                <span class="text-xs font-semibold tracking-widest text-blue-600 uppercase">Marketplace</span>
                <h2 class="text-3xl md:text-4xl font-extrabold mt-4 serif-head">Everything a modern medical enterprise needs</h2>
                <p class="text-lg text-slate-600 mt-4">Curated categories with verified suppliers, quality audits, and real-time inventory signals.</p>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                <div class="premium-card rounded-2xl p-6">
                    <div class="flex items-start justify-between mb-4">
                        <div class="icon-ring">
                            <i class="fas fa-stethoscope text-xl"></i>
                        </div>
                        <span class="text-xs font-semibold text-teal-700 bg-teal-50 px-3 py-1 rounded-full">Devices</span>
                    </div>
                    <h3 class="text-lg font-semibold mb-2">Medical Devices</h3>
                    <p class="text-slate-600">Imaging, cardiology, ICU, surgical, and specialty device procurement.</p>
                </div>
                <div class="premium-card rounded-2xl p-6">
                    <div class="flex items-start justify-between mb-4">
                        <div class="icon-ring">
                            <i class="fas fa-pills text-xl"></i>
                        </div>
                        <span class="text-xs font-semibold text-blue-700 bg-blue-50 px-3 py-1 rounded-full">Pharmacy</span>
                    </div>
                    <h3 class="text-lg font-semibold mb-2">Pharmacy & Biologics</h3>
                    <p class="text-slate-600">Specialty drugs, biosimilars, cold-chain management, and recalls tracking.</p>
                </div>
                <div class="premium-card rounded-2xl p-6">
                    <div class="flex items-start justify-between mb-4">
                        <div class="icon-ring">
                            <i class="fas fa-flask text-xl"></i>
                        </div>
                        <span class="text-xs font-semibold text-emerald-700 bg-emerald-50 px-3 py-1 rounded-full">Diagnostics</span>
                    </div>
                    <h3 class="text-lg font-semibold mb-2">Diagnostics & Labs</h3>
                    <p class="text-slate-600">Reference labs, imaging networks, and rapid test sourcing.</p>
                </div>
                <div class="premium-card rounded-2xl p-6">
                    <div class="flex items-start justify-between mb-4">
                        <div class="icon-ring">
                            <i class="fas fa-video text-xl"></i>
                        </div>
                        <span class="text-xs font-semibold text-indigo-700 bg-indigo-50 px-3 py-1 rounded-full">Services</span>
                    </div>
                    <h3 class="text-lg font-semibold mb-2">Clinical Services</h3>
                    <p class="text-slate-600">Telehealth coverage, staffing, and specialty consult access.</p>
                </div>
                <div class="premium-card rounded-2xl p-6">
                    <div class="flex items-start justify-between mb-4">
                        <div class="icon-ring">
                            <i class="fas fa-truck text-xl"></i>
                        </div>
                        <span class="text-xs font-semibold text-amber-700 bg-amber-50 px-3 py-1 rounded-full">Logistics</span>
                    </div>
                    <h3 class="text-lg font-semibold mb-2">Supply Chain</h3>
                    <p class="text-slate-600">Consumables, PPE, sterile packs, and distribution partners.</p>
                </div>
                <div class="premium-card rounded-2xl p-6">
                    <div class="flex items-start justify-between mb-4">
                        <div class="icon-ring">
                            <i class="fas fa-network-wired text-xl"></i>
                        </div>
                        <span class="text-xs font-semibold text-slate-700 bg-slate-100 px-3 py-1 rounded-full">Infrastructure</span>
                    </div>
                    <h3 class="text-lg font-semibold mb-2">Facilities & IT</h3>
                    <p class="text-slate-600">Biomedical services, cybersecurity, and facility modernization.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Compliance & Trust -->
    <section class="py-20 bg-white" id="package">
        <div class="max-w-7xl mx-auto px-6">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
                <div>
                    <span class="text-xs font-semibold tracking-widest text-emerald-600 uppercase">Compliance & Trust</span>
                    <h2 class="text-3xl md:text-4xl font-extrabold mt-4 serif-head">Enterprise-grade governance baked in</h2>
                    <p class="text-lg text-slate-600 mt-4">
                        Align procurement with regulatory requirements and internal policies. Our marketplace verifies vendors, tracks credentials, and maintains audit-ready records.
                    </p>
                    <div class="mt-8 grid grid-cols-1 gap-4">
                        <div class="premium-card rounded-2xl p-5 flex items-start gap-4">
                            <div class="icon-ring">
                                <i class="fas fa-check-circle text-lg"></i>
                            </div>
                            <div>
                                <h4 class="font-semibold text-slate-900">Credentialing Workflows</h4>
                                <p class="text-slate-600">Supplier, lab, and partner verification with automated renewals.</p>
                            </div>
                        </div>
                        <div class="premium-card rounded-2xl p-5 flex items-start gap-4">
                            <div class="icon-ring">
                                <i class="fas fa-shield-alt text-lg"></i>
                            </div>
                            <div>
                                <h4 class="font-semibold text-slate-900">Regulatory Monitoring</h4>
                                <p class="text-slate-600">HIPAA, SOC2, and regional standards tracked in real time.</p>
                            </div>
                        </div>
                        <div class="premium-card rounded-2xl p-5 flex items-start gap-4">
                            <div class="icon-ring">
                                <i class="fas fa-clipboard-check text-lg"></i>
                            </div>
                            <div>
                                <h4 class="font-semibold text-slate-900">Audit-Ready Reporting</h4>
                                <p class="text-slate-600">Immutable logs, approvals, and risk scorecards in one view.</p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="glass rounded-3xl p-8">
                    <div class="flex items-center justify-between mb-6">
                        <div>
                            <p class="text-xs font-semibold tracking-widest text-teal-600 uppercase">Marketplace Assurance</p>
                            <h3 class="text-2xl font-bold text-slate-900">Trust metrics at a glance</h3>
                        </div>
                        <span class="text-xs font-semibold text-emerald-700 bg-emerald-50 px-3 py-1 rounded-full">Audited</span>
                    </div>
                    <div class="space-y-6">
                        <div>
                            <div class="flex items-center justify-between text-sm">
                                <span class="text-slate-600">Vendor Verification</span>
                                <span class="font-semibold text-teal-700">99.7%</span>
                            </div>
                            <div class="w-full h-2 bg-slate-100 rounded-full mt-2">
                                <div class="h-2 bg-gradient-to-r from-teal-600 to-blue-600 rounded-full" style="width: 99%"></div>
                            </div>
                        </div>
                        <div>
                            <div class="flex items-center justify-between text-sm">
                                <span class="text-slate-600">Quality Audit Pass Rate</span>
                                <span class="font-semibold text-blue-700">98.4%</span>
                            </div>
                            <div class="w-full h-2 bg-slate-100 rounded-full mt-2">
                                <div class="h-2 bg-gradient-to-r from-blue-600 to-emerald-600 rounded-full" style="width: 98%"></div>
                            </div>
                        </div>
                        <div>
                            <div class="flex items-center justify-between text-sm">
                                <span class="text-slate-600">On-time Delivery</span>
                                <span class="font-semibold text-emerald-700">96.1%</span>
                            </div>
                            <div class="w-full h-2 bg-slate-100 rounded-full mt-2">
                                <div class="h-2 bg-gradient-to-r from-emerald-600 to-teal-600 rounded-full" style="width: 96%"></div>
                            </div>
                        </div>
                    </div>
                    <div class="mt-8 text-sm text-slate-500">
                        Continuously monitored by our compliance operations center.
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Social Proof -->
    <section class="py-20 bg-slate-50" id="review">
        <div class="max-w-7xl mx-auto px-6">
            <div class="flex flex-col lg:flex-row lg:items-end lg:justify-between gap-6 mb-12">
                <div>
                    <span class="text-xs font-semibold tracking-widest text-teal-600 uppercase">Trusted by Leaders</span>
                    <h2 class="text-3xl md:text-4xl font-extrabold mt-4 serif-head">Healthcare executives rely on this marketplace</h2>
                </div>
                <p class="text-lg text-slate-600 max-w-xl">
                    From IDNs to specialty networks, teams use our platform to deliver better outcomes with controlled spend.
                </p>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                <div class="premium-card rounded-2xl p-6">
                    <div class="flex items-center gap-3 mb-4">
                        <div class="icon-ring">
                            <i class="fas fa-quote-left text-lg"></i>
                        </div>
                        <span class="text-xs font-semibold text-teal-700 bg-teal-50 px-3 py-1 rounded-full">Supply Chain</span>
                    </div>
                    <p class="text-slate-600">"We consolidated 14 vendor systems and cut our procurement cycle time by 38%."</p>
                    <p class="mt-4 font-semibold text-slate-900">VP Supply Chain, Regional Health System</p>
                </div>
                <div class="premium-card rounded-2xl p-6">
                    <div class="flex items-center gap-3 mb-4">
                        <div class="icon-ring">
                            <i class="fas fa-quote-left text-lg"></i>
                        </div>
                        <span class="text-xs font-semibold text-blue-700 bg-blue-50 px-3 py-1 rounded-full">Compliance</span>
                    </div>
                    <p class="text-slate-600">"The compliance dashboard keeps us audit-ready across every facility."</p>
                    <p class="mt-4 font-semibold text-slate-900">Director of Compliance, Multi-Hospital Network</p>
                </div>
                <div class="premium-card rounded-2xl p-6">
                    <div class="flex items-center gap-3 mb-4">
                        <div class="icon-ring">
                            <i class="fas fa-quote-left text-lg"></i>
                        </div>
                        <span class="text-xs font-semibold text-emerald-700 bg-emerald-50 px-3 py-1 rounded-full">Finance</span>
                    </div>
                    <p class="text-slate-600">"We finally have a single view of spend and supplier performance."</p>
                    <p class="mt-4 font-semibold text-slate-900">CFO, Specialty Care Group</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="bg-secondary-900 text-white py-16">
        <div class="max-w-7xl mx-auto px-6">
            <div class="grid grid-cols-1 md:grid-cols-4 gap-12">
                <div>
                    <div class="flex items-center space-x-3 mb-6">
                        <div class="relative w-10 h-10">
                            <div class="absolute inset-0 bg-gradient-to-r from-primary-600 to-primary-500 rounded-lg transform rotate-6">
                            </div>
                            <div class="absolute inset-0 bg-white rounded-lg shadow-sm flex items-center justify-center">
                                <span class="text-xl font-bold text-primary-600">
                                    <?php echo substr($settings->title, 0, 1); ?>
                                </span>
                            </div>
                        </div>
                        <div>
                            <span class="text-2xl font-extrabold">
                                <span class="text-white"><?php echo $title[0]; ?></span>
                                <span class="text-primary-600"><?php echo isset($title[1]) ? $title[1] : ''; ?></span>
                            </span>
                        </div>
                    </div>
                    <p class="text-gray-400 leading-relaxed">
                        Transforming healthcare through innovative management solutions.
                    </p>
                </div>

                <div>
                    <h4 class="text-xl font-bold mb-6">Quick Links</h4>
                    <ul class="space-y-4">
                        <li><a href="#features" class="text-gray-400 hover:text-white transition-colors duration-200"><?php echo lang('service'); ?></a></li>
                        <li><a href="#package" class="text-gray-400 hover:text-white transition-colors duration-200"><?php echo lang('package'); ?></a></li>
                        <li><a href="#review" class="text-gray-400 hover:text-white transition-colors duration-200"><?php echo lang('review'); ?></a></li>
                    </ul>
                </div>

                

                <div>
                    <h4 class="text-xl font-bold mb-6">Newsletter</h4>
                    <p class="text-gray-400 mb-6">Subscribe to our newsletter for updates</p>
                    <form class="flex">
                        <input type="email" 
                               placeholder="Enter your email" 
                               class="px-4 py-3 rounded-l-lg w-full focus:outline-none text-gray-900">
                        <button class="bg-primary-600 px-6 py-3 rounded-r-lg hover:bg-primary-700 transition-colors duration-200">
                            <i class="fas fa-paper-plane"></i>
                        </button>
                    </form>
                </div>
            </div>

            <div class="border-t border-gray-800 mt-12 pt-8 text-center">
                <p class="text-gray-400">&copy; <?php echo date('Y'); ?> <?php echo $settings->title; ?>. <?php echo lang('all_rights_reserved'); ?></p>
            </div>
        </div>
    </footer>

<?php
            $googleReCaptchaSiteKey =  $this->settings_model->getGoogleReCaptchaSettings()->site_key;
            ?>
    <!-- Scroll to Top Button -->
    <button id="scrollToTopBtn" style="margin-right:50px;" class="fixed bottom-8 right-8 bg-primary-600 text-white p-3 rounded-full shadow-lg transition-opacity duration-300 opacity-0 hover:bg-primary-700 focus:outline-none focus:ring-2 focus:ring-primary-500 focus:ring-offset-2">
      <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 10l7-7m0 0l7 7m-7-7v18"></path>
      </svg>
    </button>

    <!-- Scripts -->
    <script src="https://kit.fontawesome.com/0257e3c208.js" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/swiper@8/swiper-bundle.min.js"></script>
    <script type="text/javascript" src="new-fnt/index.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/country-select-js@2.1.0/build/js/countrySelect.min.js"></script>
    <script type="text/javascript" src="common/assets/ckeditor/ckeditor.js"></script>
    <script src="common/js/codearistos.min.js"></script>
    <script type="text/javascript" src="https://js.stripe.com/v2/"></script>
    
 
<script src="common/extranal/js/frontend/front_end.js"></script>
    <script type="text/javascript">
        // Initialize Swiper
        const swiper = new Swiper('.hero-slider', {
            // Optional parameters
            loop: true,
            effect: 'fade',
            autoplay: {
                delay: 5000,
                disableOnInteraction: false,
            },
            
            // Navigation arrows
            navigation: {
                nextEl: '.swiper-button-next',
                prevEl: '.swiper-button-prev',
            },
            
            // Pagination
            pagination: {
                el: '.swiper-pagination',
                clickable: true,
            },
        });

        var payment_gateway = "<?php echo $settings1->payment_gateway; ?>";
        var publish = "<?php echo $gateway->publish; ?>";

      // Scroll to Top functionality
      const scrollToTopBtn = document.getElementById('scrollToTopBtn');

      window.addEventListener('scroll', () => {
        if (window.pageYOffset > 300) {
          scrollToTopBtn.style.opacity = '1';
        } else {
          scrollToTopBtn.style.opacity = '0';
        }
      });

      scrollToTopBtn.addEventListener('click', () => {
        window.scrollTo({
          top: 0,
          behavior: 'smooth'
        });
      });

        // Mobile Menu Toggle
        const mobileMenuButton = document.getElementById('mobile-menu-button');
        const mobileMenu = document.getElementById('mobile-menu');

        mobileMenuButton.addEventListener('click', () => {
            mobileMenu.classList.toggle('hidden');
        });

        // Close mobile menu when clicking menu items
        const mobileMenuItems = mobileMenu.querySelectorAll('a');
        mobileMenuItems.forEach(item => {
            item.addEventListener('click', () => {
                mobileMenu.classList.add('hidden');
            });
        });

        // Close mobile menu when clicking outside
        document.addEventListener('click', (event) => {
            if (!mobileMenu.contains(event.target) && !mobileMenuButton.contains(event.target)) {
                mobileMenu.classList.add('hidden');
            }
        });

        // Language Dropdown
  document.getElementById('dropdownButton').addEventListener('click', function() {
    var dropdownMenu = document.getElementById('dropdownMenu');
    dropdownMenu.classList.toggle('hidden');
  });

  document.addEventListener('click', function(event) {
    var isClickInside = document.getElementById('dropdownButton').contains(event.target);
    if (!isClickInside) {
      var dropdownMenu = document.getElementById('dropdownMenu');
      if (!dropdownMenu.classList.contains('hidden')) {
        dropdownMenu.classList.add('hidden');
      }
    }
  });

        // Country Select
  $("#country").countrySelect();

        // Package Toggle
        // $(document).ready(function() {
           
        //     $("#yearly").click(function() {
                
        //     });
        //     $("#monthly").click(function() {
                
        //     });
        // });

        // Add this to your existing JavaScript
        document.addEventListener('DOMContentLoaded', function() {
            // FAQ Toggle functionality
            // const faqItems = document.querySelectorAll('.parent');
            // faqItems.forEach(item => {
            //     item.addEventListener('click', function() {
            //         const content = this.querySelector('.child');
            //         const icon = this.querySelector('.toggle-icon svg');
                    
            //         // Toggle content
            //         content.classList.toggle('hidden');
                    
            //         // Rotate icon
            //         if (content.classList.contains('hidden')) {
            //             icon.style.transform = 'rotate(0deg)';
            //         } else {
            //             icon.style.transform = 'rotate(45deg)';
            //         }
            //     });
            // });

            // // Pricing Toggle functionality
            // const yearlyBtn = document.getElementById('yearly');
            // const monthlyBtn = document.getElementById('monthly');
            // const yearlyPrices = document.querySelectorAll('.text2');
            // const monthlyPrices = document.querySelectorAll('.text1');

            // function togglePricing(showYearly) {
            //     if (showYearly) {
            //         yearlyBtn.classList.add('bg-indigo-600', 'text-white');
            //         monthlyBtn.classList.remove('bg-indigo-600', 'text-white');
            //         yearlyPrices.forEach(price => price.style.display = 'block');
            //         monthlyPrices.forEach(price => price.style.display = 'none');
            //     } else {
            //         monthlyBtn.classList.add('bg-indigo-600', 'text-white');
            //         yearlyBtn.classList.remove('bg-indigo-600', 'text-white');
            //         monthlyPrices.forEach(price => price.style.display = 'block');
            //         yearlyPrices.forEach(price => price.style.display = 'none');
            //     }
            // }

            // yearlyBtn.addEventListener('click', () => togglePricing(true));
            // monthlyBtn.addEventListener('click', () => togglePricing(false));

            // // Initialize with yearly prices
            // togglePricing(true);
        });

        // Style all select dropdowns
        document.querySelectorAll('select').forEach(select => {
            select.addEventListener('mousedown', (e) => {
                e.preventDefault();
                const select = e.target;
                const scroll = select.scrollTop;
                e.target.blur();
                setTimeout(() => {
                    select.focus();
                    select.scrollTop = scroll;
                }, 0);
            });
        });
</script>
   <script>
function toggleChild(element) {
    const child = element.querySelector('.cc');
    child.classList.toggle('hidden');
}
</script>
    <script>
function switchPlan(plan) {
    $(".text1").hide();
    const yearlyButton = document.getElementById('yearly');
    const monthlyButton = document.getElementById('monthly');
   
    if (plan === 'yearly') {
        $(".text1").hide();
                $(".text2").show();
        yearlyButton.classList.add('bg-indigo-600', 'text-white');
        yearlyButton.classList.remove('text-gray-700', 'hover:bg-indigo-50');
        monthlyButton.classList.add('text-gray-700', 'hover:bg-indigo-50');
        monthlyButton.classList.remove('bg-indigo-600', 'text-white');
    } else {
        $(".text1").show();
                $(".text2").hide();
        monthlyButton.classList.add('bg-indigo-600', 'text-white');
        monthlyButton.classList.remove('text-gray-700', 'hover:bg-indigo-50');
        yearlyButton.classList.add('text-gray-700', 'hover:bg-indigo-50');
        yearlyButton.classList.remove('bg-indigo-600', 'text-white');
    }
}
</script>

    <?php if (!empty($settings->chat_js)) { 
        $this->db->where('hospital_id', 'superadmin');
        // $settings1 = $this->db->get('settings')->row()->show_tawkto_in_website;
        if ($settings->tawk_to_status == 'yes') {
        ?>
    <!-- Chat Widget -->
    <script type="text/javascript">
        var Tawk_API = Tawk_API || {}, Tawk_LoadStart = new Date();
        var chat_js = <?php echo json_encode($settings->chat_js, JSON_UNESCAPED_SLASHES); ?>;
        (function() {
            var s1 = document.createElement("script"),
                s0 = document.getElementsByTagName("script")[0];
            s1.async = true;
            s1.src = chat_js;
            s1.charset = "UTF-8";
            s1.setAttribute("crossorigin", "*");
            s1.onerror = function() {
                console.error("Failed to load chat script from:", chat_js);
            };
            s0.parentNode.insertBefore(s1, s0);
        })();
    </script>
    <?php } }?>
    
<script src="https://www.google.com/recaptcha/api.js?render=<?php echo $googleReCaptchaSiteKey; ?>"></script>
        <script>
            grecaptcha.ready(function() {
                // document.getElementById('addNewHospital').addEventListener('submit', function(event) {
                document.getElementById('recap').addEventListener('input', function(event) {
                    event.preventDefault();
                    var form = this;
                    grecaptcha.execute('<?php echo $googleReCaptchaSiteKey; ?>', {
                        action: 'submit'
                    }).then(function(token) {
                        document.getElementById('recaptchaResponse').value = token;
                        // form.submit(); // Submit the form after setting the token
                    });
                });
            });
            grecaptcha.ready(function() {
                document.getElementById('sendEmail').addEventListener('submit', function(event) {
                    event.preventDefault();
                    var form = this;
                    grecaptcha.execute('<?php echo $googleReCaptchaSiteKey; ?>', {
                        action: 'submit'
                    }).then(function(token) {
                        document.getElementById('recaptchaResponse1').value = token;
                        form.submit();
                    });
                });
            });
        </script>
            <script>
  $(document).ready(function() {
    // Ensure base_url is defined
    const base_url  = "<?php echo base_url(); ?>";

    // Function to update the web link
    function updateWebLink() {
        const val = $("#username").val();
       
            const url = base_url + 'site/' + val;
            const final_url = '<a style="color:#0cb8b6;" target="_blank" href="' + url + '">' + url + '</a>';
            $("#web_link").html(final_url);
      
    }

    // Initial update on page load
    updateWebLink();

    // Update on keyup event
    $("#username").on("keyup", function() {
        updateWebLink();
    });
});
    </script>
    <script>
         $("#username").keyup(function() {
        $("#web_link").html("");
        var val = $("#username").val();
        $.ajax({
            url: "frontend/checkIfUsernameAvailable?username=" + val,
            method: "GET",
            data: "",
            dataType: "json"

        }).done(function(response) {
            if (response.check == 1) {
                var url = base_url + 'site/' + val;
                var final_url = '<a style="color:#0cb8b6;" target="_blank" href="' + url + '">' + url + '</a>';
                $("#web_link").html(final_url);
            } else {
                $("#web_link").html("<span style='color: #0cb8b6;'>This link is not available!</span>");
            }
        });
    });
    

    </script>
</body>
</html>
