<?php
$settings = $this->frontend_model->getSettings();
$title = explode(' ', $settings->title);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <base href="<?php echo base_url(); ?>" />
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Appointment Confirmation - <?php echo $settings->title; ?></title>
    
    <!-- SEO Meta Tags -->
    <meta name="description" content="Your medical appointment has been confirmed successfully." />
    <meta name="keywords" content="appointment confirmation, medical appointment, booking confirmed" />
    <meta name="author" content="<?php echo $settings->title; ?>">
    
    <!-- Stylesheets -->
    <link rel="stylesheet" href="new-fnt/index.css" />
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: {
                            50: '#f0f9ff',
                            100: '#e0f2fe',
                            200: '#bae6fd',
                            300: '#7dd3fc',
                            400: '#38bdf8',
                            500: '#0ea5e9',
                            600: '#0284c7',
                            700: '#0369a1',
                            800: '#075985',
                            900: '#0c4a6e',
                        },
                        secondary: {
                            50: '#f8fafc',
                            900: '#0f172a',
                        }
                    },
                    boxShadow: {
                        'custom': '0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06)',
                        'custom-lg': '0 10px 25px -5px rgba(0, 0, 0, 0.1), 0 8px 10px -6px rgba(0, 0, 0, 0.1)',
                    }
                }
            }
        }
    </script>
    <style>
        body {
            font-family: 'Inter', sans-serif;
        }
        
        .gradient-text {
            background: linear-gradient(135deg, #0ea5e9 0%, #3b82f6 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }
        
        .confirmation-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
        }
        
        @keyframes float {
            0%, 100% { transform: translateY(0px); }
            50% { transform: translateY(-10px); }
        }
        
        .floating {
            animation: float 3s ease-in-out infinite;
        }
    </style>
</head>

<body class="font-sans antialiased bg-gradient-to-br from-green-50 to-blue-100 min-h-screen">
    <!-- Navbar -->
    <nav class="bg-white/80 backdrop-blur-md shadow-custom sticky top-0 z-50 border-b border-gray-200/50">
        <div class="max-w-7xl mx-auto px-6">
            <div class="flex justify-between items-center h-20">
                <div class="flex-shrink-0">
                    <a href="<?php echo base_url(); ?>frontend" class="flex items-center space-x-3">
                        <div class="relative w-10 h-10">
                            <div class="absolute inset-0 bg-gradient-to-r from-primary-600 to-primary-500 rounded-lg transform rotate-6"></div>
                            <div class="absolute inset-0 bg-white rounded-lg shadow-sm flex items-center justify-center">
                                <span class="text-xl font-bold text-primary-600">
                                    <?php echo substr($settings->title, 0, 1); ?>
                                </span>
                            </div>
                        </div>
                        <div>
                            <span class="text-2xl font-extrabold">
                                <span class="text-secondary-900"><?php echo $title[0]; ?></span><span class="text-primary-600"><?php echo isset($title[1]) ? $title[1] : ''; ?></span>
                            </span>
                        </div>
                    </a>
                </div>
                
                <div class="hidden md:flex items-center space-x-6">
                    <a href="<?php echo base_url(); ?>frontend" class="text-gray-700 hover:text-primary-600 transition-colors duration-200 font-medium">
                        <i class="fas fa-arrow-left mr-2"></i>Back to Home
                    </a>
                </div>
            </div>
        </div>
    </nav>

    <!-- Main Content -->
    <div class="container mx-auto px-4 py-12">
        <div class="max-w-2xl mx-auto">
            <!-- Success Icon -->
            <div class="text-center mb-8">
                <div class="w-24 h-24 bg-green-100 rounded-full flex items-center justify-center mx-auto mb-6 floating">
                    <i class="fas fa-check text-4xl text-green-600"></i>
                </div>
                <h1 class="text-4xl font-bold text-gray-900 mb-4">Appointment Confirmed!</h1>
                <p class="text-xl text-gray-600">Your medical appointment has been successfully booked</p>
            </div>

            <!-- Confirmation Details Card -->
            <div class="confirmation-card rounded-2xl shadow-xl p-8 mb-8">
                <div class="text-center mb-8">
                    <h2 class="text-2xl font-bold text-gray-900 mb-2">Appointment Details</h2>
                    <p class="text-gray-600">Please review your appointment information below</p>
                </div>

                <div class="space-y-6">
                    <!-- Patient Information -->
                    <div class="border-b border-gray-200 pb-6">
                        <h3 class="text-lg font-semibold text-gray-900 mb-4 flex items-center">
                            <i class="fas fa-user text-primary-600 mr-3"></i>
                            Patient Information
                        </h3>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <span class="text-sm text-gray-500">Name</span>
                                <p class="font-medium text-gray-900"><?php echo $appointment->patientname; ?></p>
                            </div>
                            <div>
                                <span class="text-sm text-gray-500">Email</span>
                                <p class="font-medium text-gray-900"><?php echo $appointment->email; ?></p>
                            </div>
                            <div>
                                <span class="text-sm text-gray-500">Phone</span>
                                <p class="font-medium text-gray-900"><?php echo $appointment->patient_phone; ?></p>
                            </div>
                            <?php if($appointment->address): ?>
                            <div>
                                <span class="text-sm text-gray-500">Address</span>
                                <p class="font-medium text-gray-900"><?php echo $appointment->address; ?></p>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <!-- Appointment Details -->
                    <div class="border-b border-gray-200 pb-6">
                        <h3 class="text-lg font-semibold text-gray-900 mb-4 flex items-center">
                            <i class="fas fa-calendar-check text-primary-600 mr-3"></i>
                            Appointment Information
                        </h3>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <span class="text-sm text-gray-500">Doctor</span>
                                <p class="font-medium text-gray-900"><?php echo $doctor ? $doctor->name : 'Doctor'; ?></p>
                                <?php if($doctor && $doctor->department_name): ?>
                                <p class="text-sm text-gray-600"><?php echo $doctor->department_name; ?></p>
                                <?php endif; ?>
                            </div>
                            <div>
                                <span class="text-sm text-gray-500">Hospital</span>
                                <p class="font-medium text-gray-900"><?php echo $hospital ? $hospital->name : 'Hospital'; ?></p>
                            </div>
                            <div>
                                <span class="text-sm text-gray-500">Date</span>
                                <p class="font-medium text-gray-900"><?php echo date('F j, Y', $appointment->date); ?></p>
                            </div>
                            <div>
                                <span class="text-sm text-gray-500">Time Slot</span>
                                <p class="font-medium text-gray-900"><?php echo $appointment->time_slot; ?></p>
                            </div>
                            <?php if($appointment->remarks): ?>
                            <div class="md:col-span-2">
                                <span class="text-sm text-gray-500">Visit Description</span>
                                <p class="font-medium text-gray-900"><?php echo $appointment->remarks; ?></p>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <!-- Appointment ID -->
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center justify-between">
                            <div>
                                <span class="text-sm text-gray-500">Appointment ID</span>
                                <p class="font-mono font-bold text-gray-900 text-lg">#<?php echo $appointment->id; ?></p>
                            </div>
                            <div class="text-right">
                                <span class="text-sm text-gray-500">Status</span>
                                <p class="font-medium text-yellow-600">
                                    <i class="fas fa-clock mr-1"></i>
                                    <?php echo $appointment->status; ?>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Important Information -->
            <div class="bg-blue-50 border border-blue-200 rounded-2xl p-6 mb-8">
                <h3 class="text-lg font-semibold text-blue-900 mb-4 flex items-center">
                    <i class="fas fa-info-circle text-blue-600 mr-3"></i>
                    Important Information
                </h3>
                <ul class="space-y-2 text-blue-800">
                    <li class="flex items-start">
                        <i class="fas fa-check-circle text-green-500 mt-1 mr-3"></i>
                        <span>Please arrive 15 minutes before your scheduled appointment time</span>
                    </li>
                    <li class="flex items-start">
                        <i class="fas fa-check-circle text-green-500 mt-1 mr-3"></i>
                        <span>Bring your valid ID and any relevant medical documents</span>
                    </li>
                    <li class="flex items-start">
                        <i class="fas fa-check-circle text-green-500 mt-1 mr-3"></i>
                        <span>If you need to reschedule or cancel, please contact the hospital</span>
                    </li>
                    <li class="flex items-start">
                        <i class="fas fa-check-circle text-green-500 mt-1 mr-3"></i>
                        <span>For emergencies, please visit the hospital directly</span>
                    </li>
                </ul>
            </div>

            <!-- Action Buttons -->
            <div class="flex flex-col sm:flex-row gap-4 justify-center">
                <button onclick="window.print()" class="px-6 py-3 bg-primary-600 text-white rounded-lg hover:bg-primary-700 transition-colors duration-200 flex items-center justify-center">
                    <i class="fas fa-print mr-2"></i>Print Confirmation
                </button>
                <a href="<?php echo base_url(); ?>frontend" class="px-6 py-3 bg-white text-gray-700 border border-gray-300 rounded-lg hover:bg-gray-50 transition-colors duration-200 flex items-center justify-center">
                    <i class="fas fa-home mr-2"></i>Back to Home
                </a>
                <a href="<?php echo base_url(); ?>frontend/book_appointment" class="px-6 py-3 bg-green-600 text-white rounded-lg hover:bg-green-700 transition-colors duration-200 flex items-center justify-center">
                    <i class="fas fa-calendar-plus mr-2"></i>Book Another
                </a>
            </div>
        </div>
    </div>

    <!-- Footer Note -->
    <div class="text-center py-8 text-gray-600">
        <p>Thank you for choosing our healthcare services</p>
        <p class="text-sm mt-2">If you have any questions, please contact our support team</p>
    </div>

    <script>
        // Add print functionality
        window.addEventListener('beforeprint', function() {
            // Hide buttons during print
            document.querySelectorAll('button, a').forEach(el => {
                el.style.display = 'none';
            });
        });
        
        window.addEventListener('afterprint', function() {
            // Show buttons after print
            document.querySelectorAll('button, a').forEach(el => {
                el.style.display = '';
            });
        });
    </script>
</body>
</html>